package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPathBase;

import net.ibizsys.central.dataentity.ds.DEDQJoinTypes;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSFormulaDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.runtime.dataentity.der.DERTypes;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.DataTypes;

public abstract class QuerydslDataEntityBase<T> extends  RelationalPathBase<T> implements IQuerydslDataEntity<T>{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(QuerydslDataEntityBase.class);
	
	
	private IQuerydslSession iQuerydslSession = null;
	private int nAliasIndex = -1;
	private String strTag = null;
	private IPSDataEntity iPSDataEntity = null;
	
	private Map<String, SimpleExpression<?>> psDEFieldExpressionMap = new LinkedHashMap<>();
	
	private Map<String, IPSDEField> psDEFieldMap = new HashMap<String, IPSDEField>();
	
	private List<Predicate> predicateList = new ArrayList<Predicate>();
	private Map<String, IQuerydslDEJoin> querydslDEJoinMap = new LinkedHashMap<String, IQuerydslDEJoin>();
	
	public QuerydslDataEntityBase(Class<? extends T> type, IQuerydslSession iQuerydslSession, IPSDataEntity iPSDataEntity, String strTag) {
		super(type, iQuerydslSession.getAlias(strTag), "", iPSDataEntity.getTableName());
		this.iQuerydslSession = iQuerydslSession;
		this.iPSDataEntity = iPSDataEntity;
		this.strTag = strTag;
		this.nAliasIndex = iQuerydslSession.getAliasIndex(strTag);
		
		List<IPSDEField> psDEFields = iPSDataEntity.getAllPSDEFields();
		if(!ObjectUtils.isEmpty(psDEFields)) {
			for(IPSDEField iPSDEField : psDEFields) {
				psDEFieldMap.put(iPSDEField.getName().toUpperCase(), iPSDEField);
			}
		}
				
	}

	
	protected IQuerydslSession getQuerydslSession() {
		return this.iQuerydslSession;
	}

	public IPSDataEntity getPSDataEntity() {
		return this.iPSDataEntity;
	}
	
	public String getTag() {
		return this.strTag;
	}

	
	protected SimpleExpression<?> createPSDEFieldExpression(IPSDEField iPSDEField) throws Exception{
		int nStdDataType = iPSDEField.getStdDataType();
		if(iPSDEField.isFormulaDEField()) {
			IPSFormulaDEField iPSFormulaDEField = (IPSFormulaDEField)iPSDEField;
			String strFunc = iPSFormulaDEField.getFormulaFormat();
			String strColumns = iPSFormulaDEField.getFormulaColumns();
			
			strFunc = strFunc.replace("%1$s", "{0}")
					.replace("%2$s", "{1}")
					.replace("%3$s", "{2}")
					.replace("%4$s", "{3}")
					.replace("%5$s", "{4}")
					.replace("%6$s", "{5}")
					.replace("%7$s", "{6}")
					.replace("%8$s", "{7}");
			
			java.util.List<Expression<?>> expressionList = new ArrayList<Expression<?>>();
			if(StringUtils.hasLength(strColumns)) {
				String[] columns = strColumns.replace(",", ";").split("[;]");
				for(String strColumn : columns) {
					strColumn = strColumn.trim();
					expressionList.add(this.getExpression(strColumn));
				}
			}
			
			if(DataTypeUtils.isStringDataType(nStdDataType)) {
				return  Expressions.stringTemplate(strFunc, expressionList);
			}
			
			if(DataTypeUtils.isDateTimeDataType(nStdDataType)) {
				return  Expressions.dateTimeTemplate(java.sql.Timestamp.class, strFunc, expressionList);
			}
			
			if(DataTypeUtils.isBigDecimalDataType(nStdDataType)) {
				return  Expressions.numberTemplate(BigDecimal.class, strFunc, expressionList);
			}
			
			if(DataTypeUtils.isBigIntDataType(nStdDataType)) {
				return  Expressions.numberTemplate(BigInteger.class, strFunc, expressionList);
			}
			
			if(DataTypeUtils.isIntDataType(nStdDataType)) {
				return  Expressions.numberTemplate(Integer.class, strFunc, expressionList);
			}
			
			if(DataTypeUtils.isNumberDataType(nStdDataType)) {
				return  Expressions.numberTemplate(Double.class, strFunc, expressionList);
			}
		
		
			
		}
		else {
			if(DataTypeUtils.isStringDataType(nStdDataType)) {
				return createString(iPSDEField.getName());
			}
			
			if(DataTypeUtils.isDateTimeDataType(nStdDataType)) {
				return createDateTime(iPSDEField.getName(), java.sql.Timestamp.class);
			}
			
			if(DataTypeUtils.isBigDecimalDataType(nStdDataType)) {
				return this.createNumber(iPSDEField.getName(), BigDecimal.class);
			}
			
			if(DataTypeUtils.isBigIntDataType(nStdDataType)) {
				return this.createNumber(iPSDEField.getName(), BigInteger.class);
			}
			
			if(DataTypeUtils.isIntDataType(nStdDataType)) {
				return this.createNumber(iPSDEField.getName(), Integer.class);
			}
			
			if(DataTypeUtils.isNumberDataType(nStdDataType)) {
				return this.createNumber(iPSDEField.getName(), Double.class);
			}
		
			if(DataTypeUtils.isBinaryType(nStdDataType)) {
				return this.createArray(iPSDEField.getName(), Byte.class);
			}
		}
		
		
		
		throw new Exception(String.format("无法识别的属性[%1$s][%2$s]", iPSDEField.getName(), DataTypes.toString(nStdDataType)));
		
	}
	
	@Override
	public IPSDEField getPSDEField(String strPSDEFieldName, boolean bTryMode) throws Exception {
		IPSDEField iPSDEField = this.psDEFieldMap.get(strPSDEFieldName.toUpperCase());
		if(iPSDEField != null || bTryMode) {
			return iPSDEField;
		}
		throw new Exception(String.format("无法获取指定属性[%1$s]", strPSDEFieldName));
	}

	@Override
	public SimpleExpression<?> getExpression(String strPSDEFieldName) throws Exception{
		return this.getExpression(getPSDEField(strPSDEFieldName, false));
	}

	@Override
	public SimpleExpression<?> getExpression(IPSDEField iPSDEField) throws Exception{
		SimpleExpression<?> expression = this.psDEFieldExpressionMap.get(iPSDEField.getName());
		if(expression == null) {
			//判断是否为连接属性
			if(iPSDEField.isPhisicalDEField()) {
				expression = this.createPSDEFieldExpression(iPSDEField);
				this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
			}
			else
				if(iPSDEField.isLinkDEField()) {
					IPSLinkDEField iPSLinkDEField = (IPSLinkDEField)iPSDEField;
					//判断连接类型
					IPSDERBase iPSDERBase = iPSLinkDEField.getPSDERMust();
					String strJoinType = null;
					switch(iPSDERBase.getDERType()) {
					case DERTypes.DER1N:
						strJoinType = DEDQJoinTypes.TYPE_N1;
						break;
					case DERTypes.DER11:
						strJoinType = DEDQJoinTypes.TYPE_11;
						break;
					case DERTypes.DERINDEX:
					case DERTypes.DERINHERIT:
						strJoinType = DEDQJoinTypes.TYPE_INDEX;
						break;
					default:
						throw new Exception(String.format("无法识别的关系类型[%1$s]", iPSDERBase.getDERType()));
					}
					
					IQuerydslDataEntity refQuerydslDataEntity = getJoinQuerydslDataEntity(strJoinType, iPSDERBase);
					expression = (SimpleExpression<?>)refQuerydslDataEntity.getExpression(iPSLinkDEField.getRelatedPSDEFieldMust()); 
					this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
				}
				else
					if(iPSDEField.isFormulaDEField()) {
						expression = this.createPSDEFieldExpression(iPSDEField);
						this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
					}
					else
						throw new Exception(String.format("未支持的属性[%1$s:%2$s]", iPSDEField.getName(), iPSDEField.getDataType()));
		}
		return expression;
	}
	
	@Override
	public IQuerydslDataEntity getJoinQuerydslDataEntity(String strJoinType, IPSDERBase iPSDERBase) throws Exception{
		String strJoinTag = String.format("%1$s:%2$s", strJoinType, iPSDERBase.getId());
		IQuerydslDEJoin iQuerydslDEJoin = querydslDEJoinMap.get(strJoinTag);
		if(iQuerydslDEJoin == null) {
			IPSDataEntity realPSDataEntity = null;
			switch (strJoinType) {
			case DEDQJoinTypes.TYPE_N1:
				realPSDataEntity = iPSDERBase.getMajorPSDataEntityMust();
				break;
			case DEDQJoinTypes.TYPE_1N:
				realPSDataEntity = iPSDERBase.getMinorPSDataEntityMust();
				break;
			case DEDQJoinTypes.TYPE_1NNOT:
				realPSDataEntity = iPSDERBase.getMinorPSDataEntityMust();
				break;
			default:
				throw new Exception(String.format("无法识别的连接类型[%1$s]", strJoinType));
			}
			
			String strFullTag = String.format("%1$s|%2$s", this.getTag(), strJoinTag);
			IQuerydslDataEntity iQuerydslDataEntity = this.getQuerydslSession().getQuerydslDataEntity(realPSDataEntity, strFullTag);
			
			switch (strJoinType) {
			case DEDQJoinTypes.TYPE_N1:
			{
				IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
				ForeignKey<?> foreignKey = this.createForeignKey((Path)this.getExpression(iPSDER1N.getPSPickupDEFieldMust()), realPSDataEntity.getKeyPSDEFieldMust().getName());
				iQuerydslDEJoin = new QuerydslDEJoin(this, IQuerydslDEJoin.JOINTYPE_LEFTJOIN, iPSDERBase, foreignKey, iQuerydslDataEntity);
				this.querydslDEJoinMap.put(strJoinTag, iQuerydslDEJoin);
				break;
			}
				
				
			case DEDQJoinTypes.TYPE_1N:
			{
				IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
				BooleanBuilder booleanBuilder = new BooleanBuilder();
				SimpleExpression<?> expression = this.getExpression(this.getPSDataEntity().getKeyPSDEFieldMust());
				iQuerydslDataEntity.getPredicates().add(expression.eq(iQuerydslDataEntity.getExpression(iPSDER1N.getPSPickupDEFieldMust())));
				
				iQuerydslDEJoin = new QuerydslDEJoin(this, IQuerydslDEJoin.JOINTYPE_EXISTS, iPSDERBase, null, iQuerydslDataEntity);
				this.querydslDEJoinMap.put(strJoinTag, iQuerydslDEJoin);
				break;
			}
			case DEDQJoinTypes.TYPE_1NNOT:
			{
				IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
				BooleanBuilder booleanBuilder = new BooleanBuilder();
				SimpleExpression<?> expression = this.getExpression(this.getPSDataEntity().getKeyPSDEFieldMust());
				iQuerydslDataEntity.getPredicates().add(expression.eq(iQuerydslDataEntity.getExpression(iPSDER1N.getPSPickupDEFieldMust())));
				
				iQuerydslDEJoin = new QuerydslDEJoin(this, IQuerydslDEJoin.JOINTYPE_NOTEXISTS, iPSDERBase, null, iQuerydslDataEntity);
				this.querydslDEJoinMap.put(strJoinTag, iQuerydslDEJoin);
				break;
			}
			default:
				throw new Exception(String.format("无法识别的连接类型[%1$s]", strJoinType));
			}
		}
		
		return iQuerydslDEJoin.getJoinQuerydslDataEntity();
	}



	@Override
	public Collection<IQuerydslDEJoin> getQuerydslDEJoins() {
		return querydslDEJoinMap.values();
	}


	@Override
	public Collection<Predicate> getPredicates() {
		return this.predicateList;
	}
	
	
}
