/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ibizsys.central.plugin.querydsl.dataentity.ds.IQuerydslDataEntity;
import net.ibizsys.central.plugin.querydsl.dataentity.ds.IQuerydslSession;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEFGroupDetail;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQJoin;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.runtime.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class QuerydslDEDataQueryBase {
    private static final Log log = LogFactory.getLog(QuerydslDEDataQueryBase.class);
    private IQuerydslSession iQuerydslSession = null;
    private IPSDEDataQuery iPSDEDataQuery = null;
    private List<IPSDEField> selectPSDEFieldList = null;
    private List<? extends QuerydslDEDataQueryBase> unionQuerydslDEDataQueryList = null;
    private Map<String, Expression<?>> psDEFieldExpressionMap = new LinkedHashMap();
    private IQuerydslDataEntity iQuerydslDataEntity = null;

    public QuerydslDEDataQueryBase(IQuerydslSession iQuerydslSession, IPSDEDataQuery iPSDEDataQuery) throws Exception {
        this(iQuerydslSession, iPSDEDataQuery, null);
    }

    public QuerydslDEDataQueryBase(IQuerydslSession iQuerydslSession, IPSDEDataQuery iPSDEDataQuery, List<IPSDEField> selectPSDEFieldList) throws Exception {
        this.iQuerydslSession = iQuerydslSession;
        this.iPSDEDataQuery = iPSDEDataQuery;
        this.selectPSDEFieldList = selectPSDEFieldList;
        this.initMetadata();
    }

    public IPSDEDataQuery getPSDEDataQuery() {
        return this.iPSDEDataQuery;
    }

    public IPSDataEntity getPSDataEntity() {
        return (IPSDataEntity)this.getPSDEDataQuery().getParentPSModelObject(IPSDataEntity.class, false);
    }

    public List<IPSDEField> getSelectPSDEFields() {
        return this.selectPSDEFieldList;
    }

    protected void initMetadata() throws Exception {
        this.onInitMetadata();
    }

    protected IQuerydslSession getQuerydslSession() {
        return this.iQuerydslSession;
    }

    public IQuerydslDataEntity getQuerydslDataEntity() {
        return this.iQuerydslDataEntity;
    }

    protected void onInitMetadata() throws Exception {
        List psDEFGroupDetails;
        this.iQuerydslDataEntity = this.getQuerydslSession().getQuerydslDataEntity(this.getPSDataEntity(), "");
        TreeMap<String, Integer> selectedPSDEFieldMap = new TreeMap<String, Integer>();
        if (!ObjectUtils.isEmpty(this.getSelectPSDEFields())) {
            for (IPSDEField iPSDEField : this.getSelectPSDEFields()) {
                selectedPSDEFieldMap.put(iPSDEField.getName(), 1);
            }
        } else if (this.getPSDEDataQuery().getViewLevel() == PSModelEnums.DEDataQueryViewLevel.DEFGROUP.value && this.getPSDEDataQuery().getPSDEFGroup() != null && !ObjectUtils.isEmpty((Object)(psDEFGroupDetails = this.getPSDEDataQuery().getPSDEFGroup().getPSDEFGroupDetails()))) {
            for (IPSDEFGroupDetail iPSDEFGroupDetail : psDEFGroupDetails) {
                selectedPSDEFieldMap.put(iPSDEFGroupDetail.getPSDEFieldMust().getName(), 1);
            }
        }
        boolean bSelectPSDEField = selectedPSDEFieldMap.size() > 0;
        List list = this.getPSDataEntity().getAllPSDEFields();
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (IPSDEField iPSDEField : list) {
                IPSLinkDEField iPSLinkDEField;
                if (iPSDEField.isDynaStorageDEField() || iPSDEField.isUIAssistDEField()) continue;
                if (!iPSDEField.isPhisicalDEField() && iPSDEField.isLinkDEField() && !(iPSLinkDEField = (IPSLinkDEField)iPSDEField).getRealPSDataEntityMust().isEnableSQLStorage()) {
                    log.warn((Object)String.format("\u5c5e\u6027[%1$s]\u5b9e\u9645\u5f15\u7528\u5b9e\u4f53[%2$s]\u4e0d\u652f\u6301SQL\u5b58\u50a8\uff0c\u5ffd\u7565", iPSLinkDEField.getName(), iPSLinkDEField.getRealPSDataEntity().getName()));
                    continue;
                }
                if (!(bSelectPSDEField && selectedPSDEFieldMap.containsKey(iPSDEField.getName()) || this.testSelectPSDEField(iPSDEField, this.getPSDEDataQuery().getViewLevel()) && !bSelectPSDEField || iPSDEField.isQueryColumn() && selectedPSDEFieldMap.containsKey(iPSDEField.getName()) || iPSDEField.isPhisicalDEField()) && !iPSDEField.isInheritDEField()) continue;
                if (iPSDEField.getStringLength() != -1 && iPSDEField.getStringLength() > 8000) {
                    log.error((Object)String.format("\u957f\u6587\u672c\u5c5e\u6027[%1$s]\u653e\u5165\u67e5\u8be2\u4e2d\uff0c\u4f1a\u5f71\u54cd\u68c0\u7d22\u6027\u80fd", iPSDEField.getName()));
                }
                Expression<?> expression = this.getQuerydslDataEntity().getExpression(iPSDEField);
                this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
            }
        }
        this.buildPSDEDQJoin((IPSDEDQJoin)this.getPSDEDataQuery().getPSDEDQMainMust(), this.getQuerydslDataEntity());
    }

    protected void buildPSDEDQJoin(IPSDEDQJoin iPSDEDQJoin, IQuerydslDataEntity iQuerydslDataEntity) throws Exception {
        List childPSDEDQJoinList;
        Predicate predicate;
        IPSDEDQGroupCondition iPSDEDQGroupCondition = iPSDEDQJoin.getPSDEDQGroupCondition();
        if (iPSDEDQGroupCondition != null && (predicate = this.buildPSDEDQGroupCondition(iPSDEDQGroupCondition, iQuerydslDataEntity)) != null) {
            iQuerydslDataEntity.getPredicates().add(predicate);
        }
        if (!ObjectUtils.isEmpty((Object)(childPSDEDQJoinList = iPSDEDQJoin.getChildPSDEDQJoins()))) {
            for (IPSDEDQJoin childPSDEDQJoin : childPSDEDQJoinList) {
                IQuerydslDataEntity joinQuerydslDataEntity = iQuerydslDataEntity.getJoinQuerydslDataEntity(childPSDEDQJoin.getJoinType(), childPSDEDQJoin.getJoinPSDERMust());
                this.buildPSDEDQJoin(childPSDEDQJoin, joinQuerydslDataEntity);
            }
        }
    }

    protected Predicate buildPSDEDQGroupCondition(IPSDEDQGroupCondition iPSDEDQGroupCondition, IQuerydslDataEntity iQuerydslDataEntity) throws Exception {
        if (ObjectUtils.isEmpty((Object)iPSDEDQGroupCondition.getPSDEDQConditions())) {
            return null;
        }
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        for (IPSDEDQCondition iPSDEDQCondition : iPSDEDQGroupCondition.getPSDEDQConditions()) {
            Predicate predicate;
            if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
                predicate = this.buildPSDEDQFieldCondition((IPSDEDQFieldCondition)iPSDEDQCondition, iQuerydslDataEntity);
                if (predicate == null) continue;
                if ("AND".equalsIgnoreCase(iPSDEDQGroupCondition.getCondOp())) {
                    booleanBuilder.and(predicate);
                    continue;
                }
                booleanBuilder.or(predicate);
                continue;
            }
            if (!(iPSDEDQCondition instanceof IPSDEDQGroupCondition) || (predicate = this.buildPSDEDQGroupCondition((IPSDEDQGroupCondition)iPSDEDQCondition, iQuerydslDataEntity)) == null) continue;
            if ("AND".equalsIgnoreCase(iPSDEDQGroupCondition.getCondOp())) {
                booleanBuilder.and(predicate);
                continue;
            }
            booleanBuilder.or(predicate);
        }
        if (iPSDEDQGroupCondition.isNotMode()) {
            return booleanBuilder.not();
        }
        return booleanBuilder;
    }

    protected Predicate buildPSDEDQFieldCondition(IPSDEDQFieldCondition iPSDEDQFieldCondition, IQuerydslDataEntity iQuerydslDataEntity) throws Exception {
        IPSDEField iPSDEField = iQuerydslDataEntity.getPSDEField(iPSDEDQFieldCondition.getFieldName(), false);
        Expression<?> expression = iQuerydslDataEntity.getExpression(iPSDEField);
        SimpleExpression simpleExpression = (SimpleExpression)expression;
        int nStdDataType = iPSDEField.getStdDataType();
        String strCondOp = iPSDEDQFieldCondition.getCondOp();
        if ("ISNULL".equals(strCondOp)) {
            return simpleExpression.isNull();
        }
        if ("ISNOTNULL".equals(strCondOp)) {
            return simpleExpression.isNotNull();
        }
        String strPSVarType = iPSDEDQFieldCondition.getPSVARTypeId();
        if (StringUtils.hasLength((String)strPSVarType)) {
            throw new Exception(String.format("\u672a\u652f\u6301\u7684\u53d8\u91cf\u7c7b\u578b[%1$s]", strPSVarType));
        }
        String strCondValue = iPSDEDQFieldCondition.getCondValue();
        strCondValue = StringUtils.hasLength((String)strCondValue) ? String.format("%1$s", strCondValue.replace("'", "\\'")) : "";
        if (DataTypeUtils.isStringDataType((int)nStdDataType)) {
            StringExpression stringExpression = (StringExpression)expression;
            if ("EQ".equals(strCondOp)) {
                return stringExpression.eq((Expression)Expressions.stringTemplate((String)String.format("'%1$s'", strCondValue), (Object[])new Object[0]));
            }
            if ("NOTEQ".equals(strCondOp)) {
                return stringExpression.ne((Expression)Expressions.stringTemplate((String)String.format("'%1$s'", strCondValue), (Object[])new Object[0]));
            }
            if ("LIKE".equals(strCondOp)) {
                return stringExpression.like((Expression)Expressions.stringTemplate((String)String.format("'%%%1$s%%'", strCondValue), (Object[])new Object[0]));
            }
            if ("LEFTLIKE".equals(strCondOp)) {
                return stringExpression.like((Expression)Expressions.stringTemplate((String)String.format("'%1$s%%'", strCondValue), (Object[])new Object[0]));
            }
            if ("RIGHTLIKE".equals(strCondOp)) {
                return stringExpression.like((Expression)Expressions.stringTemplate((String)String.format("'%%%1$s'", strCondValue), (Object[])new Object[0]));
            }
            throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6761\u4ef6\u64cd\u4f5c[%1$s]", strCondOp));
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6761\u4ef6\u64cd\u4f5c[%1$s][%2$s]", nStdDataType, strCondOp));
    }

    protected boolean testSelectPSDEField(IPSDEField iPSDEField, int nViewColLevel) {
        if (iPSDEField.isDynaStorageDEField() || iPSDEField.isUIAssistDEField()) {
            return false;
        }
        if (nViewColLevel == -1) {
            return iPSDEField.isQueryColumn();
        }
        if (iPSDEField.isKeyDEField()) {
            return true;
        }
        if ("LOGICVALID".equalsIgnoreCase(iPSDEField.getPredefinedType())) {
            return true;
        }
        return iPSDEField.getViewLevel() >= nViewColLevel;
    }

    public Collection<String> getExpressionNames() {
        return this.psDEFieldExpressionMap.keySet();
    }

    public Expression<?> getExpression(String strName, boolean bTryMode) throws Exception {
        Expression<?> expression = this.psDEFieldExpressionMap.get(strName);
        if (expression != null || bTryMode) {
            return expression;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u8868\u8fbe\u5f0f[%1$s]", strName));
    }
}

