package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;

import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.der.IPSDERBase;

public interface IQuerydslDataEntity<T> extends RelationalPath<T> {

	
	IPSDataEntity getPSDataEntity();
	
	
	/**
	 * 获取指定属性
	 * @param strPSDEFieldName
	 * @param bTryMode
	 * @return
	 * @throws Exception
	 */
	IPSDEField getPSDEField(String strPSDEFieldName, boolean bTryMode) throws Exception;
	
	
	Expression<?> getExpression(IPSDEField iPSDEField) throws Exception;
	
	
	
	Expression<?> getExpression(String strPSDEFieldName) throws Exception;
	
	
	
	
	/**
	 * 获取查询实体
	 * @param strJoinType
	 * @param iPSDERBase
	 * @return
	 * @throws Exception
	 */
	IQuerydslDataEntity getJoinQuerydslDataEntity(String strJoinType, IPSDERBase iPSDERBase) throws Exception;
	
	
	
	
	/**
	 * 获取条件
	 * @return
	 */
	Collection<Predicate> getPredicates();
	
	
	
	/**
	 * 获取查询连接
	 * @return
	 */
	Collection<IQuerydslDEJoin> getQuerydslDEJoins();
	
}
