/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.poi.util;

import fr.opensagres.poi.xwpf.converter.core.AbstractXWPFConverter;
import fr.opensagres.poi.xwpf.converter.core.IXWPFConverter;
import fr.opensagres.poi.xwpf.converter.core.XWPFConverterException;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net.ibizsys.central.plugin.poi.util.PdfMapperEx;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class PdfConverterEx
extends AbstractXWPFConverter<PdfOptions> {
    private static final IXWPFConverter<PdfOptions> INSTANCE = new PdfConverterEx();

    public static IXWPFConverter<PdfOptions> getInstance() {
        return INSTANCE;
    }

    protected void doConvert(XWPFDocument document, OutputStream out, Writer writer, PdfOptions options) throws XWPFConverterException, IOException {
        try {
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            PdfMapperEx mapper = new PdfMapperEx(document, tempOut, options, null);
            mapper.start();
            if (mapper.useTotalPageField()) {
                Integer actualPageCount = mapper.getPageCount();
                mapper = new PdfMapperEx(document, out, options, actualPageCount);
                mapper.start();
            } else {
                out.write(tempOut.toByteArray());
            }
        }
        catch (Exception e) {
            throw new XWPFConverterException((Throwable)e);
        }
    }
}

