/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.poi.util;

import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.plugin.poi.util.DefaultFontProvider;

public class FontProviderHolder {
    private static IFontProvider fontProvider = null;
    private static String strFontFolder = null;
    private static Map<String, String> fontFilePathMap = new ConcurrentHashMap<String, String>();

    public static IFontProvider getFontProvider() {
        if (fontProvider == null) {
            fontProvider = new DefaultFontProvider();
        }
        return fontProvider;
    }

    public static void setFontProvider(IFontProvider fontProvider) {
        FontProviderHolder.fontProvider = fontProvider;
    }

    public static String getFontFolder() {
        return strFontFolder;
    }

    public static void setFontFolder(String strFontFolder) {
        FontProviderHolder.strFontFolder = strFontFolder;
    }

    public static void registerFontFilePath(String strFontName, int nFontStyle, String strFilePath) {
        String strKey = String.format("%1$s|%2$s", strFontName, nFontStyle);
        fontFilePathMap.put(strKey, strFilePath);
    }

    public static String getFontFilePath(String strFontName, int nFontStyle, boolean bIncludeStyle) {
        for (Map.Entry<String, String> entry : fontFilePathMap.entrySet()) {
            String strKey = entry.getKey();
            String[] items = strKey.split("[|]");
            if (items.length != 2 || !items[0].equals(strFontName)) continue;
            int nStyle = Integer.parseInt(items[1]);
            if (nStyle == nFontStyle) {
                return entry.getValue();
            }
            if (!bIncludeStyle) continue;
            if ((nStyle & nFontStyle) == nFontStyle) {
                return entry.getValue();
            }
            if (nFontStyle != 0 && nStyle != 0) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        FontProviderHolder.registerFontFilePath("\u5b8b\u4f53", 0, "simsun.ttc,1;simsun.ttf");
        FontProviderHolder.registerFontFilePath("\u7b49\u7ebf", 0, "Deng.ttf");
        FontProviderHolder.registerFontFilePath("\u7b49\u7ebf", 1, "Dengb.ttf");
        FontProviderHolder.registerFontFilePath("\u4eff\u5b8b", 0, "simfang.ttf");
        FontProviderHolder.registerFontFilePath("\u4eff\u5b8b\u4f53", 0, "simfang.ttf");
        FontProviderHolder.registerFontFilePath("\u9ed1\u4f53", 0, "simhei.ttf");
    }
}

