/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.poi.util;

import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.awt.Color;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.plugin.poi.util.FontProviderHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class DefaultFontProvider
implements IFontProvider {
    private static final Log log = LogFactory.getLog(DefaultFontProvider.class);
    private Map<String, Font> fontMap = new ConcurrentHashMap<String, Font>();
    private static String[] defaultFonts = new String[]{"simsun.ttc,1", "simsun.ttf"};

    public Font getFont(String familyName, String encoding, float size, int style, Color color) {
        try {
            String strKey = String.format("%1$s|%2$s", familyName, style);
            Font font = this.fontMap.get(strKey);
            if (font != null || (font = this.createFont(familyName, encoding, size, style, color)) != null) {
                // empty if block
            }
            return font;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    protected Font createFont(String familyName, String encoding, float size, int style, Color color) throws Exception {
        int n;
        if (!StringUtils.hasLength((String)FontProviderHolder.getFontFolder())) {
            throw new Exception("\u672a\u5b9a\u4e49\u5b57\u4f53\u76ee\u5f55");
        }
        String strPath = FontProviderHolder.getFontFilePath(familyName, style, false);
        if (!StringUtils.hasLength((String)strPath)) {
            strPath = FontProviderHolder.getFontFilePath(familyName, style, true);
        }
        if (StringUtils.hasLength((String)strPath)) {
            String[] paths;
            String[] stringArray = paths = strPath.split("[;]");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String path = stringArray[i];
                String[] items = path.split("[,]");
                String strFullPath = String.format("%1$s%2$s%3$s", FontProviderHolder.getFontFolder(), File.separator, items[0]);
                if (!new File(strFullPath).exists()) continue;
                if (items.length == 2) {
                    strFullPath = strFullPath + "," + items[1];
                }
                BaseFont bfChinese = BaseFont.createFont((String)strFullPath, (String)encoding, (boolean)false);
                Font fontChinese = new Font(bfChinese, size, style, color);
                if (familyName != null) {
                    fontChinese.setFamily(familyName);
                }
                return fontChinese;
            }
        }
        String[] stringArray = defaultFonts;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String path;
            strPath = path = stringArray[n];
            String[] items = strPath.split("[,]");
            String strFullPath = String.format("%1$s%2$s%3$s", FontProviderHolder.getFontFolder(), File.separator, items[0]);
            if (!new File(strFullPath).exists()) continue;
            if (items.length == 2) {
                strFullPath = strFullPath + "," + items[1];
            }
            BaseFont bfChinese = BaseFont.createFont((String)strFullPath, (String)encoding, (boolean)false);
            Font fontChinese = new Font(bfChinese, size, style, color);
            if (familyName != null) {
                fontChinese.setFamily(familyName);
            }
            return fontChinese;
        }
        return null;
    }
}

