/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.poi.dataentity.print;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.plugin.table.LoopRowTableRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.print.DEPrintRuntime;
import net.ibizsys.central.plugin.poi.util.FontProviderHolder;
import net.ibizsys.central.plugin.poi.util.PdfConverterEx;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.util.StringUtils;

public class POIDEPrintRuntime
extends DEPrintRuntime {
    private static final Log log = LogFactory.getLog(POIDEPrintRuntime.class);
    public static final String PARAM_DETAILS = "details";
    public static final String PARAM_ROWNO = "srfrowno";

    protected void onInit() throws Exception {
        super.onInit();
    }

    protected void onOutput(OutputStream outputStream, IEntityBase[] list, String strType) throws Throwable {
        if (!StringUtils.hasLength((String)FontProviderHolder.getFontFolder())) {
            FontProviderHolder.setFontFolder(this.getSystemRuntime().getFontFolder());
        }
        for (IEntityBase iEntityBase : list) {
            List detailList;
            Entity iEntity = null;
            if (iEntityBase instanceof IEntityDTO) {
                iEntity = new Entity();
                ((IEntityDTO)iEntityBase).copyTo((IEntity)iEntity);
            } else if (iEntityBase instanceof IEntity) {
                iEntity = (IEntity)iEntityBase;
            } else {
                throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u5bf9\u8c61", new Object[0]));
            }
            HashMap model = new HashMap();
            Map map = iEntity.any();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    Object objValue = entry.getValue();
                    model.put(entry.getKey(), objValue);
                }
            }
            if (!model.containsKey(PARAM_DETAILS) && (detailList = this.selectDetails((IEntity)iEntity)) != null) {
                ArrayList mapList = new ArrayList();
                int nRowNo = 1;
                for (IEntity detailEntity : detailList) {
                    Entity temp = new Entity();
                    detailEntity.copyTo((IEntity)temp);
                    HashMap<String, Integer> detailMap = new HashMap<String, Integer>();
                    if (temp.any() != null) {
                        detailMap.putAll(temp.any());
                    }
                    if (!detailMap.containsKey(PARAM_ROWNO)) {
                        detailMap.put(PARAM_ROWNO, nRowNo);
                    }
                    mapList.add(detailMap);
                    ++nRowNo;
                }
                model.put(PARAM_DETAILS, mapList);
            }
            LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
            Configure config = Configure.builder().bind(PARAM_DETAILS, (RenderPolicy)policy).bind("details2", (RenderPolicy)policy).bind("details3", (RenderPolicy)policy).bind("details4", (RenderPolicy)policy).build();
            XWPFTemplate template = null;
            String strReportModel = this.getReportModel();
            if (StringUtils.hasLength((String)strReportModel)) {
                byte[] bytes = Base64.getDecoder().decode(strReportModel);
                ByteArrayInputStream sbs = new ByteArrayInputStream(bytes);
                template = XWPFTemplate.compile((InputStream)sbs, (Configure)config);
            } else {
                template = XWPFTemplate.compile((String)this.getReportFilePath(), (Configure)config);
            }
            template.render(model);
            PdfOptions options = PdfOptions.create();
            options.fontProvider(this.getFontProvider());
            options.fontEncoding(PdfOptions.getDefault().getFontEncoding());
            PdfConverterEx.getInstance().convert((XWPFDocument)template.getXWPFDocument(), outputStream, (Options)options);
        }
    }

    protected String getDefaultReportFileSuffix() {
        return ".docx";
    }

    protected IFontProvider getFontProvider() {
        return FontProviderHolder.getFontProvider();
    }

    public static void main(String[] args) {
        try {
            FontProviderHolder.setFontFolder("C:/Windows/Fonts");
            XWPFTemplate template = null;
            File tempFile2 = new File("d:\\att_template1.1.docx");
            FileInputStream sbs = new FileInputStream(tempFile2);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("ormdeptname", "\u90e8\u95e8\u540d\u79f02");
            LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
            Configure config = Configure.builder().bind(PARAM_DETAILS, (RenderPolicy)policy).bind("labors", (RenderPolicy)policy).build();
            template = XWPFTemplate.compile((InputStream)sbs, (Configure)config);
            ArrayList list = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("pimpersonname", String.format("\u540d\u79f0%1$s", i));
                item.put("personno", String.format("N%1$s", i));
                list.add(item);
            }
            model.put(PARAM_DETAILS, list);
            template.render(model);
            PdfOptions options = PdfOptions.create();
            options.fontProvider(FontProviderHolder.getFontProvider());
            options.fontEncoding(PdfOptions.getDefault().getFontEncoding());
            File tempFile = File.createTempFile("bbb", ".pdf");
            File tempFile3 = File.createTempFile("ccc", ".docx");
            template.getXWPFDocument().write((OutputStream)new FileOutputStream(tempFile3));
            PdfConverterEx.getInstance().convert((XWPFDocument)template.getXWPFDocument(), (OutputStream)new FileOutputStream(tempFile), (Options)options);
            System.out.print("\u6d4b\u8bd5");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

