/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.poi.dataentity.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.dataimport.DEDataImportRuntime;
import net.ibizsys.central.dataentity.dataimport.IDEDataImportRuntime2;
import net.ibizsys.central.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.central.util.domain.ImportDataResult;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImportItem;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.EntityError;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.domain.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;

public class POIDEDataImportRuntime
extends DEDataImportRuntime
implements IDEDataImportRuntime2 {
    private static final Log log = LogFactory.getLog(POIDEDataImportRuntime.class);

    public void getImportTemplate(String strImportTag, OutputStream outputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        try {
            IUserContext iUserContext = this.getUserContext();
            List importItems = this.getPSDEDataImport().getPSDEDataImportItems();
            if (ObjectUtils.isEmpty((Object)importItems)) {
                throw new RuntimeException("\u672a\u914d\u7f6e\u5bfc\u5165\u5217\u4fe1\u606f");
            }
            XSSFWorkbook workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet(this.getDataEntityRuntime().getPSDataEntity().getLogicName());
            CellStyle style = workbook.createCellStyle();
            DataFormat format = workbook.createDataFormat();
            style.setDataFormat(format.getFormat("@"));
            for (IPSDEDataImportItem importItem : importItems) {
                IPSCodeList iPSCodeList = importItem.getPSCodeList();
                if (iPSCodeList == null || workbook.getSheet(iPSCodeList.getCodeName()) != null) continue;
                Sheet codelistSheet = workbook.createSheet(iPSCodeList.getCodeName());
                workbook.setSheetHidden(workbook.getSheetIndex(codelistSheet), true);
                sheet.setDefaultColumnStyle(0, style);
                ICodeListRuntime codeListRuntime = this.getSystemRuntime().getCodeListRuntime(iPSCodeList);
                List iPSCodeItems = codeListRuntime.getPSCodeItems();
                for (int i = 0; i < iPSCodeItems.size(); ++i) {
                    IPSCodeItem iPSCodeItem = (IPSCodeItem)iPSCodeItems.get(i);
                    Row row = codelistSheet.createRow(i);
                    Cell cell = row.createCell(0);
                    cell.setCellValue(iPSCodeItem.getText());
                }
            }
            Row row = sheet.createRow(0);
            for (int i = 0; i < importItems.size(); ++i) {
                IPSDEDataImportItem iPSDEDataImportItem = (IPSDEDataImportItem)importItems.get(i);
                Cell cell0 = row.createCell(i);
                String strCaption = iPSDEDataImportItem.getCaption();
                if (iPSDEDataImportItem.getCapPSLanguageRes() != null) {
                    strCaption = iUserContext.getLocalization(iPSDEDataImportItem.getCapPSLanguageRes().getLanResTag(), iPSDEDataImportItem.getCaption());
                }
                cell0.setCellValue(strCaption);
                sheet.setColumnWidth(cell0.getColumnIndex(), strCaption.getBytes().length * 256);
                sheet.setDefaultColumnStyle(i, style);
                if (iPSDEDataImportItem.getPSCodeList() == null) continue;
                DataValidationHelper dataValidationHelper = sheet.getDataValidationHelper();
                String strFormula = iPSDEDataImportItem.getPSCodeList().getCodeName() + "!$A$1:$A$65535";
                DataValidationConstraint dataValidationConstraint = dataValidationHelper.createFormulaListConstraint(strFormula);
                CellRangeAddressList regions = new CellRangeAddressList(1, 65535, i, i);
                DataValidation dataValidation = dataValidationHelper.createValidation(dataValidationConstraint, regions);
                sheet.addValidationData(dataValidation);
            }
            workbook.write(outputStream);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u751f\u6210\u5bfc\u5165\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }

    public Map<Integer, EntityError> importStream(IEntity baseEntity, InputStream inputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        List<Map<String, Object>> data = this.resolveData(baseEntity, inputStream);
        return this.importData(baseEntity, data, bTestPriv, parentDataEntityRuntime, strParentKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Map<String, Object>> resolveData(IEntity baseEntity, InputStream inputStream) {
        try (Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            List<Map<String, Object>> list = this.doResolveData(baseEntity, workbook);
            return list;
        }
        catch (Throwable e) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u89e3\u6790\u5bfc\u5165Excel\u53d1\u751f\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }

    protected List<Map<String, Object>> doResolveData(IEntity baseEntity, Workbook wb) throws Throwable {
        int i;
        ArrayList<Map<String, Object>> importDatas = new ArrayList<Map<String, Object>>();
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        Sheet sheet = wb.getSheetAt(0);
        if (sheet.getPhysicalNumberOfRows() == 0) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u672a\u5b9a\u4e49\u5bfc\u5165\u6807\u8bc6", new Object[0]));
        }
        HashMap<Integer, String> captionMap = new HashMap<Integer, String>();
        Row captionRow = sheet.getRow(0);
        for (i = 0; i < captionRow.getPhysicalNumberOfCells(); ++i) {
            captionMap.put(i, captionRow.getCell(i).getStringCellValue());
        }
        for (i = 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            HashMap data = new HashMap();
            for (int j = 0; j < captionMap.size(); ++j) {
                data.put(captionMap.get(j), this.getCellValue(row.getCell(j), evaluator));
            }
            importDatas.add(data);
        }
        return importDatas;
    }

    protected String getCellValue(Cell cell, FormulaEvaluator eva) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                if (eva == null) {
                    return cell.getCellFormula();
                }
                CellValue cellVal = eva.evaluate(cell);
                if (cellVal.getCellType() == CellType.NUMERIC) {
                    return String.valueOf(cellVal.getNumberValue());
                }
                return cellVal.getStringValue();
            }
            case NUMERIC: {
                boolean b = DateUtil.isCellDateFormatted((Cell)cell);
                if (b) {
                    Date date = cell.getDateCellValue();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return df.format(date);
                }
                cell.setCellType(CellType.STRING);
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImportDataResult importStream2(IEntity baseEntity, InputStream inputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        try (Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            ImportDataResult importDataResult = this.onImportStream2(baseEntity, workbook, bTestPriv, parentDataEntityRuntime, strParentKey);
            return importDataResult;
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u5bfc\u5165\u6570\u636e\u6d41\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ImportDataResult onImportStream2(IEntity baseEntity, Workbook workbook, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        ImportDataResult dataImportResult = new ImportDataResult();
        List<Map<String, Object>> data = this.doResolveData(baseEntity, workbook);
        Map ret = this.importData(baseEntity, data, bTestPriv, parentDataEntityRuntime, strParentKey);
        Sheet sheet = workbook.getSheetAt(0);
        int totalRow = sheet.getLastRowNum();
        dataImportResult.setTotal(Long.valueOf(totalRow));
        dataImportResult.setSuccess(Long.valueOf(totalRow));
        if (!ObjectUtils.isEmpty((Object)ret)) {
            dataImportResult.setErrorInfo(ret);
            dataImportResult.setSuccess(Long.valueOf(totalRow - ret.size()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Row row = sheet.getRow(0);
            String strHead = "\u9519\u8bef\u4fe1\u606f";
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            if (this.isIgnoreError()) {
                void var18_20;
                Workbook errorWorkbook = WorkbookFactory.create((boolean)true);
                Sheet errorSheet = errorWorkbook.createSheet(sheet.getSheetName());
                Row errorHeadRow = errorSheet.createRow(0);
                boolean bl = false;
                while (var18_20 < row.getLastCellNum()) {
                    Cell headCell = errorHeadRow.createCell((int)var18_20);
                    headCell.setCellValue(this.getCellValue(row.getCell((int)var18_20), evaluator));
                    errorSheet.setColumnWidth((int)var18_20, sheet.getColumnWidth((int)var18_20));
                    ++var18_20;
                }
                short s = row.getLastCellNum();
                Cell errorHeadCell = errorHeadRow.createCell((int)s);
                errorHeadCell.setCellValue(strHead);
                errorSheet.setColumnWidth(errorHeadCell.getColumnIndex(), strHead.getBytes().length * 5 * 256);
                int nErrorRow = 1;
                for (Map.Entry entry : ret.entrySet()) {
                    Row dataRow = sheet.getRow((Integer)entry.getKey() + 1);
                    Row errorRow = errorSheet.createRow(nErrorRow);
                    for (int i = 0; i < row.getLastCellNum(); ++i) {
                        Cell cell = errorRow.createCell(i);
                        cell.setCellValue(this.getCellValue(dataRow.getCell(i), evaluator));
                    }
                    Cell errorInfoCell = errorRow.createCell((int)s);
                    errorInfoCell.setCellValue(((EntityError)entry.getValue()).getErrorInfo());
                    ++nErrorRow;
                }
                errorWorkbook.write((OutputStream)out);
            } else {
                short errorIndex = row.getLastCellNum();
                Cell errorHeadCell = row.createCell((int)errorIndex);
                errorHeadCell.setCellValue(strHead);
                sheet.setColumnWidth(errorHeadCell.getColumnIndex(), strHead.getBytes().length * 5 * 256);
                for (Map.Entry entry : ret.entrySet()) {
                    Cell errorInfoCell = sheet.getRow((Integer)entry.getKey() + 1).createCell((int)errorIndex);
                    errorInfoCell.setCellValue(((EntityError)entry.getValue()).getErrorInfo());
                }
                workbook.write((OutputStream)out);
            }
            java.io.File tempFile = java.io.File.createTempFile("\u5bfc\u5165\u9519\u8bef", ".xlsx");
            byte[] bookByteAry = out.toByteArray();
            ByteArrayInputStream errorInputStream = new ByteArrayInputStream(bookByteAry);
            FileCopyUtils.copy((InputStream)errorInputStream, (OutputStream)Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));
            ISysOSSUtilRuntime iSysOSSUtilRuntime = (ISysOSSUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysOSSUtilRuntime.class, false);
            File ossFile = iSysOSSUtilRuntime.createOSSFile(tempFile, "temp");
            dataImportResult.setErrorFile(ossFile);
        }
        return dataImportResult;
    }
}

