/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.poi.dataentity.dataexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.dataexport.DEDataExportRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExportGroup;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExportItem;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;

public class POIDEDataExportRuntime
extends DEDataExportRuntime {
    private static final Log log = LogFactory.getLog(POIDEDataExportRuntime.class);
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File exportFile(Object objData, String strMethodName, Object objBody, String strKey, Object objTag, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List exportItems = this.getPSDEDataExport().getPSDEDataExportItems();
            if (ObjectUtils.isEmpty((Object)exportItems)) {
                throw new RuntimeException("\u672a\u6307\u5b9a\u5bfc\u51fa\u5217");
            }
            Sheet sheet = workbook.createSheet();
            int nGroupLevel = this.getPSDEDataExport().getGroupLevel();
            for (int i = 0; i < nGroupLevel; ++i) {
                sheet.createRow(i);
            }
            Row row = sheet.createRow(nGroupLevel);
            HashMap<String, List<Cell>> mergedCellMap = new HashMap<String, List<Cell>>();
            for (int i = 0; i < exportItems.size(); ++i) {
                IPSDEDataExportItem iPSDEDataExportItem = (IPSDEDataExportItem)exportItems.get(i);
                Cell cell0 = row.createCell(i);
                cell0.setCellValue(iPSDEDataExportItem.getCaption());
                if (nGroupLevel <= 0) continue;
                this.fillMergedCellMap(mergedCellMap, iPSDEDataExportItem.getName(), cell0, iPSDEDataExportItem, null);
            }
            if (mergedCellMap.size() > 0) {
                this.addMergedRegions(sheet, mergedCellMap);
            }
            if (!(objData instanceof Page)) {
                if (!(objData instanceof IEntityDTO)) {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u5bf9\u8c61[%1$s]", objData));
                }
                IEntityDTO entityDTO = (IEntityDTO)objData;
                Row dataRow = sheet.createRow(1 + nGroupLevel);
                for (int k = 0; k < exportItems.size(); ++k) {
                    IPSDEDataExportItem iPSDEDataExportItem = (IPSDEDataExportItem)exportItems.get(k);
                    Object objValue = entityDTO.get(iPSDEDataExportItem.getName());
                    Cell cell0 = dataRow.createCell(k);
                    if (objValue == null) continue;
                    cell0.setCellValue(this.convertValue(iPSDEDataExportItem, objValue));
                }
            } else {
                List data = ((Page)objData).getContent();
                for (int i = 0; i < data.size(); ++i) {
                    IEntityDTO entityDTO = (IEntityDTO)data.get(i);
                    Row dataRow = sheet.createRow(i + 1 + nGroupLevel);
                    for (int k = 0; k < exportItems.size(); ++k) {
                        IPSDEDataExportItem iPSDEDataExportItem = (IPSDEDataExportItem)exportItems.get(k);
                        Object objValue = entityDTO.get(iPSDEDataExportItem.getName());
                        Cell cell0 = dataRow.createCell(k);
                        if (objValue == null) continue;
                        cell0.setCellValue(this.convertValue(iPSDEDataExportItem, objValue));
                    }
                }
            }
            File file = File.createTempFile("EXPORTDATA", ".xlsx");
            FileOutputStream fos = new FileOutputStream(file);
            workbook.write((OutputStream)fos);
            File file2 = file;
            return file2;
        }
        catch (Throwable e) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5bfc\u51fa\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }

    protected void onExportStream(Object objData, OutputStream outputStram) throws Throwable {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List exportItems = this.getPSDEDataExport().getPSDEDataExportItems();
            if (ObjectUtils.isEmpty((Object)exportItems)) {
                throw new Exception("\u672a\u6307\u5b9a\u5bfc\u51fa\u5217");
            }
            Sheet sheet = workbook.createSheet();
            int nGroupLevel = this.getPSDEDataExport().getGroupLevel();
            for (int i = 0; i < nGroupLevel; ++i) {
                sheet.createRow(i);
            }
            Row row = sheet.createRow(nGroupLevel);
            HashMap<String, List<Cell>> mergedCellMap = new HashMap<String, List<Cell>>();
            for (int i = 0; i < exportItems.size(); ++i) {
                IPSDEDataExportItem iPSDEDataExportItem = (IPSDEDataExportItem)exportItems.get(i);
                Cell cell0 = row.createCell(i);
                cell0.setCellValue(iPSDEDataExportItem.getCaption());
                if (nGroupLevel <= 0) continue;
                this.fillMergedCellMap(mergedCellMap, iPSDEDataExportItem.getName(), cell0, iPSDEDataExportItem, null);
            }
            if (mergedCellMap.size() > 0) {
                this.addMergedRegions(sheet, mergedCellMap);
            }
            if (objData instanceof Page) {
                List data = ((Page)objData).getContent();
                for (int i = 0; i < data.size(); ++i) {
                    IEntityDTO entityDTO = (IEntityDTO)data.get(i);
                    Row dataRow = sheet.createRow(i + 1 + nGroupLevel);
                    for (int k = 0; k < exportItems.size(); ++k) {
                        IPSDEDataExportItem iPSDEDataExportItem = (IPSDEDataExportItem)exportItems.get(k);
                        Object objValue = entityDTO.get(iPSDEDataExportItem.getName());
                        Cell cell0 = dataRow.createCell(k);
                        if (objValue == null) continue;
                        cell0.setCellValue(this.convertValue(iPSDEDataExportItem, objValue));
                    }
                }
            } else if (objData instanceof IEntityDTO) {
                IEntityDTO entityDTO = (IEntityDTO)objData;
                Row dataRow = sheet.createRow(1 + nGroupLevel);
                for (int k = 0; k < exportItems.size(); ++k) {
                    IPSDEDataExportItem iPSDEDataExportItem = (IPSDEDataExportItem)exportItems.get(k);
                    Object objValue = entityDTO.get(iPSDEDataExportItem.getName());
                    Cell cell0 = dataRow.createCell(k);
                    if (objValue == null) continue;
                    cell0.setCellValue(this.convertValue(iPSDEDataExportItem, objValue));
                }
            } else {
                throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u5bf9\u8c61[%1$s]", objData));
            }
            workbook.write(outputStram);
        }
    }

    protected void fillMergedCellMap(Map<String, List<Cell>> mergedCellMap, String strGroupTag, Cell cell, IPSDEDataExportItem iPSDEDataExportItem, IPSDEDataExportGroup iPSDEDataExportGroup) throws Throwable {
        List<Cell> list = mergedCellMap.get(strGroupTag);
        if (list == null) {
            list = new ArrayList<Cell>();
            mergedCellMap.put(strGroupTag, list);
        }
        list.add(cell);
        int nRowIndex = cell.getRowIndex();
        if (--nRowIndex < 0) {
            return;
        }
        int nColumnIndex = cell.getColumnIndex();
        IPSDEDataExportGroup parentPSDEDataExportGroup = null;
        if (iPSDEDataExportGroup != null) {
            parentPSDEDataExportGroup = iPSDEDataExportGroup.getParentPSDEDataExportGroup();
        } else if (iPSDEDataExportItem != null) {
            parentPSDEDataExportGroup = iPSDEDataExportItem.getPSDEDataExportGroup();
        }
        Cell groupCell = cell.getRow().getSheet().getRow(nRowIndex).createCell(nColumnIndex);
        if (parentPSDEDataExportGroup != null) {
            strGroupTag = parentPSDEDataExportGroup.getName();
            groupCell.setCellValue(parentPSDEDataExportGroup.getCaption());
        } else {
            groupCell.setCellValue(cell.getStringCellValue());
        }
        this.fillMergedCellMap(mergedCellMap, strGroupTag, groupCell, null, parentPSDEDataExportGroup);
    }

    protected void addMergedRegions(Sheet sheet, Map<String, List<Cell>> mergedCellMap) throws Throwable {
        for (List<Cell> list : mergedCellMap.values()) {
            if (list.size() <= 1) continue;
            int firstRow = -1;
            int lastRow = -1;
            int firstCol = -1;
            int lastCol = -1;
            for (Cell cell : list) {
                if (firstRow == -1 || cell.getRowIndex() < firstRow) {
                    firstRow = cell.getRowIndex();
                }
                if (lastRow == -1 || cell.getRowIndex() > lastRow) {
                    lastRow = cell.getRowIndex();
                }
                if (firstCol == -1 || cell.getColumnIndex() < firstCol) {
                    firstCol = cell.getColumnIndex();
                }
                if (lastCol != -1 && cell.getColumnIndex() <= lastCol) continue;
                lastCol = cell.getColumnIndex();
            }
            if (firstRow == -1 || lastRow == -1 || firstCol == -1 || lastCol == -1) continue;
            CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
            sheet.addMergedRegion(region);
        }
    }

    protected String convertValue(IPSDEDataExportItem iPSDEDataExportItem, Object objValue) {
        IPSDEField iPSDEField = iPSDEDataExportItem.getPSDEField();
        if (iPSDEField == null) {
            iPSDEField = this.getDataEntityRuntime().getPSDEField(iPSDEDataExportItem.getName(), true);
        }
        if (objValue != null) {
            if (iPSDEDataExportItem.getPSCodeList() != null) {
                ICodeListRuntime iCodeListRuntime = this.getSystemRuntime().getCodeListRuntime(iPSDEDataExportItem.getPSCodeList());
                String strText = null;
                try {
                    strText = iCodeListRuntime.getText(objValue);
                    return strText;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            } else {
                if (iPSDEField == null) {
                    return String.valueOf(objValue);
                }
                switch (iPSDEField.getDataType()) {
                    case "DATE": {
                        if (objValue instanceof Date) {
                            return dateFormat.format(objValue);
                        }
                        return String.valueOf(objValue);
                    }
                    case "TIME": {
                        if (objValue instanceof Date) {
                            return timeFormat.format(objValue);
                        }
                        return String.valueOf(objValue);
                    }
                    case "DATETIME": {
                        if (objValue instanceof Date) {
                            return dateTimeFormat.format(objValue);
                        }
                        return String.valueOf(objValue);
                    }
                    case "YESNO": {
                        try {
                            return DataTypeUtils.getIntegerValue((Object)objValue, (Integer)0) == 1 ? "\u662f" : "\u5426";
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
        }
        return String.valueOf(objValue);
    }

    public static void main(String[] args) {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            int i;
            Sheet sheet = workbook.createSheet();
            Row row0 = sheet.createRow(0);
            Row row1 = sheet.createRow(1);
            for (i = 0; i < 10; ++i) {
                Cell cell0 = row0.createCell(i);
                cell0.setCellValue(String.format("lie[%1$s]", i + 1));
                Cell cell1 = row1.createCell(i);
                cell1.setCellValue(String.format("\u5217[%1$s]", i + 1));
            }
            for (i = 0; i < 10; ++i) {
                CellRangeAddress region = new CellRangeAddress(0, 1, i, i);
                sheet.addMergedRegion(region);
            }
            File file = File.createTempFile("EXPORTDATA", ".xlsx");
            FileOutputStream fos = new FileOutputStream(file);
            workbook.write((OutputStream)fos);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }
}

