/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.neo4j.dataentity.ds;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.ds.DEDataSetRuntimeBase;
import net.ibizsys.central.plugin.neo4j.ba.INeo4jBDSchemeRuntime;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Neo4jDEDataSetRuntimeBase
extends DEDataSetRuntimeBase {
    private static final Log log = LogFactory.getLog(Neo4jDEDataSetRuntimeBase.class);
    private INeo4jBDSchemeRuntime iNeo4jBDSchemeRuntime = null;
    private Map<String, IPSDEField> psDEFieldMap = new HashMap<String, IPSDEField>();
    public static final String FIELDTAG_NODE = "NODE_LABLES";
    public static final String FIELDTAG_RELATIONSHIP = "RELATIONSHIP_TYPE";
    public static final String FIELDTAG_RELATIONSHIP_SOURCE = "SOURCE_LABLES";
    public static final String FIELDTAG_RELATIONSHIP_TARGET = "TARGET_LABLES";

    protected void onInit() throws Exception {
        this.psDEFieldMap.put(FIELDTAG_NODE, null);
        this.psDEFieldMap.put(FIELDTAG_RELATIONSHIP, null);
        this.psDEFieldMap.put(FIELDTAG_RELATIONSHIP_SOURCE, null);
        this.psDEFieldMap.put(FIELDTAG_RELATIONSHIP_TARGET, null);
        List psDEFieldList = ((IPSDataEntity)this.getPSDEDataSet().getParentPSModelObject(IPSDataEntity.class)).getAllPSDEFields();
        if (!ObjectUtils.isEmpty((Object)psDEFieldList)) {
            for (IPSDEField iPSDEField : psDEFieldList) {
                if (!this.psDEFieldMap.containsKey(iPSDEField.getName())) continue;
                this.psDEFieldMap.put(iPSDEField.getName(), iPSDEField);
            }
            for (IPSDEField iPSDEField : psDEFieldList) {
                String strFieldTag = iPSDEField.getFieldTag();
                if (!StringUtils.hasLength((String)strFieldTag) || !this.psDEFieldMap.containsKey(strFieldTag = strFieldTag.toUpperCase())) continue;
                this.psDEFieldMap.put(strFieldTag, iPSDEField);
            }
        }
        super.onInit();
    }

    protected IPSDEField getPSDEFieldByTag(String strTag, boolean bTryMode) throws Exception {
        IPSDEField iPSDEField = this.psDEFieldMap.get(strTag);
        if (iPSDEField != null || bTryMode) {
            return iPSDEField;
        }
        throw new Exception(String.format("\u672a\u5b9a\u4e49\u6307\u5b9a\u6807\u8bb0[%1$s]\u5c5e\u6027", strTag));
    }

    protected String getPSDEFieldTag(String strName, boolean bTryMode) throws Exception {
        for (Map.Entry<String, IPSDEField> entry : this.psDEFieldMap.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().getName().equalsIgnoreCase(strName)) continue;
            return entry.getKey();
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception(String.format("\u672a\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%1$s]\u6807\u8bb0", strName));
    }

    protected INeo4jBDSchemeRuntime getNeo4jBDSchemeRuntime() throws Exception {
        if (this.iNeo4jBDSchemeRuntime == null) {
            if (this.getDataEntityRuntime().getSysBDSchemeRuntime() instanceof INeo4jBDSchemeRuntime) {
                this.iNeo4jBDSchemeRuntime = (INeo4jBDSchemeRuntime)this.getDataEntityRuntime().getSysBDSchemeRuntime();
            }
            if (this.iNeo4jBDSchemeRuntime == null) {
                throw new Exception("Neo4j\u6570\u636e\u5e93\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
            }
        }
        return this.iNeo4jBDSchemeRuntime;
    }
}

