/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.neo4j.dataentity.ds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.ibizsys.central.plugin.neo4j.dataentity.ds.Neo4jDEDataSetRuntimeBase;
import net.ibizsys.central.util.EntityDTO;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Neo4jDEDataSetRuntime
extends Neo4jDEDataSetRuntimeBase {
    private static final Log log = LogFactory.getLog(Neo4jDEDataSetRuntimeBase.class);

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    protected Object onFetch(ISearchContext iSearchContext) throws Throwable {
        String strTargetIn;
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        List searchCondList = iSearchContext.getSearchConds();
        if (!ObjectUtils.isEmpty((Object)searchCondList)) {
            for (ISearchCond iSearchCond : searchCondList) {
                ISearchFieldCond iSearchFieldCond;
                String strTag;
                if (!(iSearchCond instanceof ISearchFieldCond) || !StringUtils.hasLength((String)(strTag = this.getPSDEFieldTag((iSearchFieldCond = (ISearchFieldCond)iSearchCond).getFieldName(), true))) || !"IN".equals(iSearchFieldCond.getCondOp())) continue;
                if (iSearchFieldCond.isParamMode()) {
                    conditionMap.put(strTag, (String)iSearchContext.get((String)iSearchFieldCond.getValue()));
                    continue;
                }
                conditionMap.put(strTag, (String)iSearchFieldCond.getValue());
            }
        }
        String strNodeIn = (String)conditionMap.get("NODE_LABLES");
        String strRelationshipIn = (String)conditionMap.get("RELATIONSHIP_TYPE");
        String strSourceIn = (String)conditionMap.get("SOURCE_LABLES");
        if (!StringUtils.hasLength((String)strSourceIn)) {
            strSourceIn = strNodeIn;
        }
        if (!StringUtils.hasLength((String)(strTargetIn = (String)conditionMap.get("TARGET_LABLES")))) {
            strTargetIn = strNodeIn;
        }
        ArrayList<EntityDTO> entityDTOList = new ArrayList<EntityDTO>();
        int nTotal = 0;
        try (Session session = this.getNeo4jBDSchemeRuntime().getDriver().session();){
            int i;
            EntityDTO entityDTO = new EntityDTO();
            HashMap<String, Map<String, Object>> sourceMap = new HashMap<String, Map<String, Object>>();
            HashMap<String, Map<String, Object>> targetMap = new HashMap<String, Map<String, Object>>();
            HashMap<String, Map<String, Object>> relationshipMap = new HashMap<String, Map<String, Object>>();
            entityDTOList.add(entityDTO);
            String query = "match result = (source)-[relationship]->(target) %s return result";
            String where = "";
            if (StringUtils.hasLength((String)strSourceIn)) {
                where = StringUtils.hasLength((String)where) ? where + " and (" : where + " where (";
                for (i = 0; i < strSourceIn.split(",|;").length; ++i) {
                    if (i > 0) {
                        where = where + " or ";
                    }
                    where = where + String.format("source:%s", strSourceIn.split(",|;")[i]);
                }
                where = where + ") ";
            }
            if (StringUtils.hasLength((String)strRelationshipIn)) {
                where = StringUtils.hasLength((String)where) ? where + " and (" : where + " where (";
                for (i = 0; i < strRelationshipIn.split(",|;").length; ++i) {
                    if (i > 0) {
                        where = where + " or ";
                    }
                    where = where + String.format("relationship:%s", strRelationshipIn.split(",|;")[i]);
                }
                where = where + ") ";
            }
            if (StringUtils.hasLength((String)strTargetIn)) {
                where = StringUtils.hasLength((String)where) ? where + " and (" : where + " where (";
                for (i = 0; i < strTargetIn.split(",|;").length; ++i) {
                    if (i > 0) {
                        where = where + " or ";
                    }
                    where = where + String.format("target:%s", strTargetIn.split(",|;")[i]);
                }
                where = where + ") ";
            }
            if (!ObjectUtils.isEmpty((Object)searchCondList)) {
                for (ISearchCond iSearchCond : searchCondList) {
                    ISearchFieldCond iSearchFieldCond;
                    if (!(iSearchCond instanceof ISearchFieldCond) || !(iSearchFieldCond = (ISearchFieldCond)iSearchCond).getCondOp().equals("EQ") || !"EQ".equals(iSearchFieldCond.getCondOp())) continue;
                    Object condValue = null;
                    condValue = iSearchFieldCond.isParamMode() ? iSearchContext.get((String)iSearchFieldCond.getValue()) : iSearchFieldCond.getValue();
                    if (condValue == null) continue;
                    where = StringUtils.hasLength((String)where) ? where + " and (" : where + " where (";
                    where = where + String.format("source.%1$s='%2$s' and relationship.%1$s='%2$s' and target.%1$s='%2$s'", iSearchFieldCond.getFieldName(), condValue);
                    where = where + ") ";
                }
            }
            query = String.format(query, where);
            Result result = session.run(query);
            while (result.hasNext()) {
                Record record = result.next();
                for (Value value : record.values()) {
                    String key;
                    Path path = value.asPath();
                    if (path.relationships() == null || !path.relationships().iterator().hasNext()) continue;
                    Node source = path.start();
                    Iterable labels = source.labels();
                    for (String label : labels) {
                        key = label + source.id();
                        if (sourceMap.containsKey(key)) continue;
                        Map<String, Object> sourceValue = source.asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
                        sourceValue.put("SOURCE_LABLES".toLowerCase(), label);
                        sourceMap.put(key, sourceValue);
                    }
                    Node target = path.end();
                    labels = target.labels();
                    for (String label : labels) {
                        key = label + target.id();
                        if (targetMap.containsKey(key)) continue;
                        Map<String, Object> targetValue = target.asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
                        targetValue.put("TARGET_LABLES".toLowerCase(), label);
                        targetMap.put(key, targetValue);
                    }
                    for (Relationship relationship : path.relationships()) {
                        String key2;
                        if (relationshipMap.containsKey(relationship.type()) || targetMap.containsKey(key2 = relationship.type() + relationship.id())) continue;
                        Map<String, Object> relationshipValue = relationship.asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
                        relationshipValue.put("SOURCE_LABLES".toLowerCase(), path.start().labels().iterator().next());
                        relationshipValue.put("TARGET_LABLES".toLowerCase(), path.end().labels().iterator().next());
                        relationshipValue.put("RELATIONSHIP_TYPE".toLowerCase(), relationship.type());
                        relationshipMap.put(key2, relationshipValue);
                    }
                }
            }
            entityDTO.put("source", sourceMap.values());
            entityDTO.put("target", targetMap.values());
            entityDTO.put("relationship", relationshipMap.values());
        }
        return new PageImpl(entityDTOList, iSearchContext.getPageable(), (long)nTotal);
    }
}

