/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.neo4j.ba;

import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.plugin.neo4j.ba.INeo4jBDSchemeRuntime;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.springframework.util.StringUtils;

public class Neo4jBDSchemeRuntime
extends SysBDSchemeRuntime
implements INeo4jBDSchemeRuntime {
    private static final Log log = LogFactory.getLog(Neo4jBDSchemeRuntime.class);
    public static final String BDTYPE_NEO4J = "NEO4J";
    private Driver driver = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getDriver(true) == null) {
            this.prepareDriver();
        }
    }

    @Override
    public Driver getDriver() {
        return this.getDriver(false);
    }

    public Driver getDriver(boolean bTryMode) {
        if (this.driver != null || bTryMode) {
            return this.driver;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("Neo4j\u8fde\u63a5\u6c60\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setDriver(Driver driver) {
        this.driver = driver;
    }

    protected void prepareDriver() throws Exception {
        if (!StringUtils.hasLength((String)this.getServiceUrl())) {
            throw new Exception("\u672a\u5b9a\u4e49\u670d\u52a1\u5730\u5740");
        }
        AuthToken authToken = AuthTokens.basic((String)this.getClientId(), (String)this.getClientSecret());
        Driver driver = GraphDatabase.driver((String)this.getServiceUrl(), (AuthToken)authToken);
        this.setDriver(driver);
    }

    protected void closeDriver() throws Exception {
        Driver driver = this.getDriver(true);
        if (driver != null) {
            driver.close();
            this.setDriver(null);
        }
    }

    protected void onShutdown() throws Exception {
        try {
            this.closeDriver();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u5173\u95ed\u8fde\u63a5\u6c60\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        super.onShutdown();
    }
}

