package net.ibizsys.central.plugin.mybatisplus.util;

import javax.sql.DataSource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;


/**
 * 动态数据源配置
 */
public class DynaDataSource extends DynamicRoutingDataSource {

    @Autowired
    DataSourceCreator dataSourceCreator;

    private ApplicationContext applicationContext = null;
    
    public void setApplicationContext(ApplicationContext applicationContext) {
    	this.applicationContext = applicationContext;
    }
    
    protected ApplicationContext getApplicationContext() {
    	return this.applicationContext;
    }
    
    @Override
    public DataSource getDataSource(String rsinterface) {
        if (StringUtils.isNotBlank(rsinterface)) {
            if (this.getCurrentDataSources().containsKey(rsinterface)) {
                return super.getDataSource(rsinterface);
            }
            
            if(this.getApplicationContext() != null) {
            	String strBeanName = "dynadatasource_" + rsinterface;
            	if(this.getApplicationContext().containsBean(strBeanName)) {
            		Object objDataSource = this.getApplicationContext().getBean(strBeanName);
                	if(objDataSource instanceof DataSource) {
                		this.addDataSource(rsinterface, (DataSource)objDataSource);
                	}
            	}
            	
            }
           
            //根据rs查询数据库配置
//            IRSInterfaceService rsInterfaceService = SpringContextHolder.getBean(IRSInterfaceService.class);
//            RSInterface rsInterface = rsInterfaceService.get(rsinterface);
//            DataSourceProperty dataSourceProperty = new DataSourceProperty();
//            dataSourceProperty.setUrl(rsInterface.getDburl());
//            dataSourceProperty.setUsername(rsInterface.getDbuser());
//            dataSourceProperty.setPassword(rsInterface.getDbpassword());
//            dataSourceProperty.setDriverClassName("org.postgresql.Driver");
//            dataSourceProperty.setSchema(rsInterface.getDbschema());
//            DataSource dataSource = dataSourceCreator.createDataSource(dataSourceProperty);
//            this.addDataSource(rsinterface, dataSource);
            //根据ds查询数据库配置
//            if (rsinterface.equals("aibizhi")) {
//                DataSourceProperty dataSourceProperty = new DataSourceProperty();
//                dataSourceProperty.setUrl("jdbc:mysql://172.16.186.185:3306/a_LAB01_b45378959?autoReconnect=true&useUnicode=true&characterEncoding=UTF-8&useOldAliasMetadataBehavior=true&serverTimezone=GMT%2B8&allowMultiQueries=true&serverTimezone=GMT%2B8");
//                dataSourceProperty.setUsername("a_LAB01_b45378959");
//                dataSourceProperty.setPassword("67c@@3Af");
//                dataSourceProperty.setDriverClassName("com.mysql.jdbc.Driver");
//                dataSourceProperty.setSchema("a_LAB01_b45378959");
//                DataSource dataSource = dataSourceCreator.createDataSource(dataSourceProperty);
//                this.addDataSource(rsinterface, dataSource);
//                return dataSource;
//            } else if (rsinterface.equals("admin")) {
//                DataSourceProperty dataSourceProperty = new DataSourceProperty();
//                dataSourceProperty.setUrl("jdbc:mysql://172.16.186.185:3306/a_LAB01_e4dd45b74?autoReconnect=true&useUnicode=true&characterEncoding=UTF-8&useOldAliasMetadataBehavior=true&allowMultiQueries=true");
//                dataSourceProperty.setUsername("a_LAB01_e4dd45b74");
//                dataSourceProperty.setPassword("@E6@@96a");
//                dataSourceProperty.setDriverClassName("com.mysql.jdbc.Driver");
//                dataSourceProperty.setSchema("a_LAB01_e4dd45b74");
//                DataSource dataSource = dataSourceCreator.createDataSource(dataSourceProperty);
//                this.addDataSource(rsinterface, dataSource);
//                return dataSource;
//            }

        }

        return super.getDataSource(rsinterface);
    }

}