/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.mybatisplus.util;

import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import java.util.List;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;

public class TenantSqlParser
extends com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser {
    public SqlInfo processParser(Statement statement) {
        if (statement instanceof Insert) {
            this.processInsert((Insert)statement);
        } else if (statement instanceof Select) {
            this.processSelectBody(((Select)statement).getSelectBody());
        } else if (statement instanceof Update) {
            this.processUpdate((Update)statement);
        } else if (statement instanceof Delete) {
            this.processDelete((Delete)statement);
        } else if (statement instanceof Replace) {
            this.processReplace((Replace)statement);
        }
        this.logger.debug("parser sql: " + statement.toString());
        String strSql = statement.toString();
        if (StringUtils.startsWithIgnoreCase((CharSequence)strSql, (CharSequence)"BEGIN") && StringUtils.endsWithIgnoreCase((CharSequence)strSql, (CharSequence)"END")) {
            strSql = strSql + ";";
        }
        return SqlInfo.newInstance().setSql(strSql);
    }

    public void processReplace(Replace replace) {
        if (this.getTenantHandler().doTableFilter(replace.getTable().getName())) {
            return;
        }
        replace.getColumns().add(new Column(this.getTenantHandler().getTenantIdColumn()));
        if (replace.getItemsList() != null) {
            ItemsList itemsList = replace.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExprList().forEach(el -> el.getExpressions().add(this.getTenantHandler().getTenantId(false)));
            } else {
                ((ExpressionList)replace.getItemsList()).getExpressions().add(this.getTenantHandler().getTenantId(false));
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        this.processSelectItem(plainSelect);
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.getTenantHandler().doTableFilter(fromTable.getName())) {
                plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
                if (addColumn) {
                    if (fromItem.getAlias() != null) {
                        plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column(fromItem.getAlias().getName() + "." + this.getTenantHandler().getTenantIdColumn())));
                    } else {
                        plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column(this.getTenantHandler().getTenantIdColumn())));
                    }
                }
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
        this.processExcepression(plainSelect.getWhere());
    }

    protected void processExcepression(Expression exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof AndExpression) {
            this.processExcepression(((AndExpression)exception).getLeftExpression());
            this.processExcepression(((AndExpression)exception).getRightExpression());
        } else if (exception instanceof OrExpression) {
            this.processExcepression(((OrExpression)exception).getLeftExpression());
            this.processExcepression(((OrExpression)exception).getRightExpression());
        } else if (exception instanceof Parenthesis) {
            this.processExcepression(((Parenthesis)exception).getExpression());
        } else if (exception instanceof NotExpression) {
            this.processExcepression(((NotExpression)exception).getExpression());
        } else if (exception instanceof InExpression) {
            this.processExcepression(((InExpression)exception).getLeftExpression());
            if (((InExpression)exception).getRightItemsList() instanceof SubSelect) {
                this.processSelectBody(((SubSelect)((InExpression)exception).getRightItemsList()).getSelectBody());
            }
        } else if (exception instanceof EqualsTo) {
            this.processExcepression(((EqualsTo)exception).getLeftExpression());
            this.processExcepression(((EqualsTo)exception).getRightExpression());
        } else if (exception instanceof ExistsExpression) {
            this.processExcepression(((ExistsExpression)exception).getRightExpression());
        } else if (exception instanceof GreaterThan) {
            this.processExcepression(((GreaterThan)exception).getLeftExpression());
            this.processExcepression(((GreaterThan)exception).getRightExpression());
        } else if (exception instanceof GreaterThanEquals) {
            this.processExcepression(((GreaterThanEquals)exception).getLeftExpression());
            this.processExcepression(((GreaterThanEquals)exception).getRightExpression());
        } else if (exception instanceof MinorThan) {
            this.processExcepression(((MinorThan)exception).getLeftExpression());
            this.processExcepression(((MinorThan)exception).getRightExpression());
        } else if (exception instanceof MinorThanEquals) {
            this.processExcepression(((MinorThanEquals)exception).getLeftExpression());
            this.processExcepression(((MinorThanEquals)exception).getRightExpression());
        } else if (exception instanceof NotEqualsTo) {
            this.processExcepression(((NotEqualsTo)exception).getLeftExpression());
            this.processExcepression(((NotEqualsTo)exception).getRightExpression());
        } else if (exception instanceof IsBooleanExpression) {
            this.processExcepression(((IsBooleanExpression)exception).getLeftExpression());
        } else if (exception instanceof IsNullExpression) {
            this.processExcepression(((IsNullExpression)exception).getLeftExpression());
        } else if (exception instanceof LikeExpression) {
            this.processExcepression(((LikeExpression)exception).getLeftExpression());
            this.processExcepression(((LikeExpression)exception).getRightExpression());
        } else if (exception instanceof Between) {
            this.processExcepression(((Between)exception).getLeftExpression());
            this.processExcepression(((Between)exception).getBetweenExpressionStart());
            this.processExcepression(((Between)exception).getBetweenExpressionEnd());
        } else if (exception instanceof Function) {
            if (null != ((Function)exception).getParameters()) {
                for (Expression e : ((Function)exception).getParameters().getExpressions()) {
                    this.processExcepression(e);
                }
            }
        } else if (exception instanceof CaseExpression) {
            CaseExpression caseExpression = (CaseExpression)exception;
            this.processExcepression(caseExpression.getElseExpression());
            this.processExcepression(caseExpression.getSwitchExpression());
            for (WhenClause whenClause : caseExpression.getWhenClauses()) {
                this.processExcepression(whenClause.getWhenExpression());
                this.processExcepression(whenClause.getThenExpression());
            }
        } else if (exception instanceof Subtraction) {
            this.processExcepression(((Subtraction)exception).getLeftExpression());
            this.processExcepression(((Subtraction)exception).getRightExpression());
        } else if (exception instanceof Multiplication) {
            this.processExcepression(((Multiplication)exception).getLeftExpression());
            this.processExcepression(((Multiplication)exception).getRightExpression());
        } else if (exception instanceof Addition) {
            this.processExcepression(((Addition)exception).getLeftExpression());
            this.processExcepression(((Addition)exception).getRightExpression());
        } else if (exception instanceof Division) {
            this.processExcepression(((Division)exception).getLeftExpression());
            this.processExcepression(((Division)exception).getRightExpression());
        } else if (exception instanceof SubSelect) {
            this.processSelectBody(((SubSelect)exception).getSelectBody());
        }
    }

    protected void processSelectItem(PlainSelect plainSelect) {
        List selectItems = plainSelect.getSelectItems();
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem instanceof SelectExpressionItem)) continue;
            Expression selectExcepression = ((SelectExpressionItem)selectItem).getExpression();
            this.processExcepression(selectExcepression);
        }
    }
}

