/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.mybatisplus.util;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.ibizsys.central.database.DBDialectUtils;
import net.ibizsys.central.database.IDBDataService;
import net.ibizsys.central.database.ISysDBSchemeRuntimeContext;
import net.ibizsys.central.dataentity.der.IDERAggDataDEFMapRuntime;
import net.ibizsys.central.dataentity.der.IDERAggDataRuntime;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.plugin.mybatisplus.spring.service.MybatisDbDataService;
import net.ibizsys.central.plugin.mybatisplus.util.GroupQuery;
import net.ibizsys.central.plugin.mybatisplus.util.Page;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEFSearchMode;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERAggData;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeCond;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeExp;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.ds.IPSDEDataSetGroupParam;
import net.ibizsys.model.dataentity.ds.PSDEDataSetGroupParamImpl;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchCustomCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import net.ibizsys.runtime.util.SearchGroupCond;
import net.ibizsys.runtime.util.SearchPredefinedCond;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.builder.xml.XMLStatementBuilder;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.tools.ant.filters.StringInputStream;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class MybatisSqlUtil {
    private static final Log log = LogFactory.getLog(MybatisSqlUtil.class);
    private static Pattern bracketPattern = Pattern.compile("\\[(.*?)]");
    private static Pattern conditionPattern = Pattern.compile("\\'\\|\\'|\\'\\&\\'|\\([^\\)]+\\)");
    private static Pattern DYNAMIC_TAG_PATTERN = Pattern.compile("<\\s*(if|choose|when|otherwise)\\s*[\\s\\S]*>");
    private static boolean searchIgnoreCase = false;
    public static String OPERATION_AND = "'&'";
    public static String OPERATION_OR = "'|'";
    public static String TERM_OPERATOR_EQ = "'='";
    public static String TERM_OPERATOR_NE = "'!='";
    public static String TERM_OPERATOR_GT = "'>'";
    public static String TERM_OPERATOR_GE = "'>='";
    public static String TERM_OPERATOR_LT = "'<'";
    public static String TERM_OPERATOR_LE = "'<='";
    public static String TERM_OPERATOR_IN = "'in'";
    public static String TERM_OPERATOR_NOTIN = "'not in'";
    public static String TERM_OPERATOR_LIKE = "'like'";
    public static String TERM_OPERATOR_NOTLIKE = "'not like'";

    public static GroupQuery getGroupQuery(MybatisDbDataService service, ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, String strDBType, ISearchContext iSearchContext) throws Throwable {
        GroupQuery groupQuery = new GroupQuery();
        List minorDEDataQueryList = null;
        net.ibizsys.central.dataentity.IDataEntityRuntime minorDataEntityRuntime = null;
        if (iPSDEDataSet.getGroupMode() == 1) {
            minorDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
            minorDataEntityRuntime = iDataEntityRuntime;
        } else if (iPSDEDataSet.getGroupMode() == 2) {
            minorDEDataQueryList = iPSDEDataSet.getPSDERAggDataMust().getSourcePSDEDataSetMust().getPSDEDataQueries();
            minorDataEntityRuntime = iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(iPSDEDataSet.getPSDERAggDataMust().getMinorPSDataEntityMust().getName());
        }
        ArrayList<String> minorDataSqls = new ArrayList<String>();
        for (IPSDEDataQuery iPSDEDataQuery : minorDEDataQueryList) {
            IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = minorDataEntityRuntime.getDEDataQueryCodeRuntime(iPSDEDataQuery, iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType(), false);
            StringBuilder sb = new StringBuilder();
            IPSDEDataQueryCode curDBPSDEDataQueryCode = iDEDataQueryCodeRuntime.getPSDEDataQueryCode();
            sb.append(curDBPSDEDataQueryCode.getQueryCode());
            if (curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds() != null) {
                boolean bOutputWhere = false;
                boolean bCondFirst = true;
                for (IPSDEDataQueryCodeCond queryCodeCond : curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds()) {
                    String strCondition = queryCodeCond.getCustomCond();
                    if (!StringUtils.hasLength((String)strCondition)) continue;
                    if (!bOutputWhere) {
                        sb.append(" WHERE ");
                        bOutputWhere = true;
                    }
                    if (bCondFirst) {
                        bCondFirst = false;
                    } else {
                        sb.append(" AND ");
                    }
                    sb.append(String.format("(%1$s)", strCondition));
                }
            }
            minorDataSqls.add(sb.toString());
        }
        String strDataSql = String.join((CharSequence)" UNION ", minorDataSqls);
        groupQuery.setDatasql(strDataSql);
        String strDrillDownCond = null;
        HashMap<String, String> drillDownCondMap = null;
        String strDrillDownField = null;
        boolean bDrillDownMetric = false;
        boolean bDrillDownMode = false;
        if (iSearchContext != null) {
            strDrillDownCond = iSearchContext.getDrillDownCond();
        }
        if (StringUtils.hasLength(strDrillDownCond)) {
            String[] items = strDrillDownCond.split("[$]");
            if (items.length == 2) {
                strDrillDownField = items[0];
                strDrillDownCond = items[1];
            } else {
                strDrillDownCond = items[0];
            }
            if (StringUtils.hasLength((String)strDrillDownCond)) {
                items = strDrillDownCond.split("[,]");
                drillDownCondMap = new HashMap<String, String>();
                for (Iterator iterator : items) {
                    String[] groupconds = ((String)((Object)iterator)).split("[|]");
                    if (groupconds.length != 2) continue;
                    drillDownCondMap.put(groupconds[0], groupconds[1]);
                }
                if (drillDownCondMap.size() == 0) {
                    drillDownCondMap = null;
                } else {
                    bDrillDownMode = true;
                }
            }
            if (StringUtils.hasLength((String)strDrillDownField)) {
                bDrillDownMetric = true;
            }
        }
        HashMap<String, IPSDEDataSetGroupParam> psDEDataSetGroupParamMap = null;
        if (iPSDEDataSet != null && iPSDEDataSet.getPSDEDataSetGroupParams() != null && iPSDEDataSet.getPSDEDataSetGroupParams().size() > 0) {
            psDEDataSetGroupParamMap = new HashMap<String, IPSDEDataSetGroupParam>();
            for (IPSDEDataSetGroupParam item : iPSDEDataSet.getPSDEDataSetGroupParams()) {
                psDEDataSetGroupParamMap.put(item.getName().toLowerCase(), item);
            }
        }
        if (iPSDEDataSet.getGroupMode() == 1) {
            for (Map.Entry psDEDataSetGroupParam : psDEDataSetGroupParamMap.entrySet()) {
                PSDEDataSetGroupParamImpl imp = (PSDEDataSetGroupParamImpl)psDEDataSetGroupParam.getValue();
                if (imp.getPSDEField() != null) {
                    if (imp.getPSDEField().getDEFType() == 1 || imp.getPSDEField().getDEFType() == 2 || imp.getPSDEField().getDEFType() == 3) {
                        groupQuery.getDatafield().add(imp.getPSDEField().getName());
                    } else if (iPSDEDataSet.getPSDEDataQueries().stream().anyMatch(query -> query.isCustomCode())) {
                        groupQuery.getDatafield().add(imp.getPSDEField().getName());
                    } else {
                        groupQuery.getDatafield().add(String.format("NULL AS %1$s", imp.getPSDEField().getName()));
                    }
                }
                if (imp.isEnableGroup()) {
                    if (StringUtils.hasLength((String)imp.getGroupCode())) {
                        groupQuery.getDatafield().add(String.format("%1$s AS %2$s", imp.getGroupCode(), imp.getName()));
                    }
                    groupQuery.getResultfield().add(imp.getName());
                    groupQuery.getGroup().add(imp.getName());
                    continue;
                }
                if (StringUtils.hasLength((String)imp.getGroupCode())) {
                    groupQuery.getResultfield().add(String.format("%1$s AS %2$s", imp.getGroupCode(), imp.getName()));
                    continue;
                }
                groupQuery.getResultfield().add(imp.getName());
            }
            List conds = iSearchContext.getSearchCondsIf();
            if (CollectionUtils.isNotEmpty((Collection)conds)) {
                StringBuffer strCond = new StringBuffer();
                for (int i = 0; i < conds.size(); ++i) {
                    if (i > 0) {
                        strCond.append(" AND ");
                    }
                    MybatisSqlUtil.genGroupCondition(strCond, iDataEntityRuntime, strDBType, iSearchContext, (ISearchCond)conds.get(i));
                }
                if (!StringUtils.isEmpty((Object)strCond.toString())) {
                    groupQuery.dataConditions.add(strCond.toString());
                }
            }
            return groupQuery;
        }
        if (iPSDEDataSet.getGroupMode() == 2) {
            String strFuncCode;
            String strMajorFieldName;
            IPSDERAggData iPSDERAggData = iPSDEDataSet.getPSDERAggData();
            if (iPSDERAggData == null) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u6570\u636e\u96c6\u5408[%s]\u672a\u6307\u5b9a\u5206\u7ec4\u805a\u5408\u6570\u636e\u5173\u7cfb", iPSDEDataSet.getName()));
            }
            net.ibizsys.central.dataentity.IDataEntityRuntime iMinorDataEntityRuntime = iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(iPSDERAggData.getMinorPSDataEntity().getName());
            IDERAggDataRuntime iDERAggRuntime = (IDERAggDataRuntime)iMinorDataEntityRuntime.getDERRuntime((IPSDERBase)iPSDERAggData, false);
            List list = iDERAggRuntime.getDERAggDataDEFMapRuntimes();
            if (list == null || list.size() == 0) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u805a\u5408\u6570\u636e\u5173\u7cfb[%s]\u672a\u5b9a\u4e49\u4efb\u4f55\u805a\u5408\u5c5e\u6027", iPSDEDataSet.getPSDERAggData().getName()));
            }
            TreeMap<String, String> biAggDataDEFMapRuntimeMap = new TreeMap<String, String>();
            for (IDERAggDataDEFMapRuntime iDERAggDataDEFMapRuntime : list) {
                String strMapType = iDERAggDataDEFMapRuntime.getMapType();
                strMajorFieldName = iDERAggDataDEFMapRuntime.getPSDERAggDataDEFieldMap().getMajorPSDEFieldMust().getLowerCaseName();
                if (psDEDataSetGroupParamMap != null && !psDEDataSetGroupParamMap.containsKey(strMajorFieldName)) continue;
                String strMinorFieldName = null;
                if (iDERAggDataDEFMapRuntime.getPSDERAggDataDEFieldMap().getMinorPSDEField() != null) {
                    strMinorFieldName = iDERAggDataDEFMapRuntime.getPSDERAggDataDEFieldMap().getMinorPSDEField().getLowerCaseName();
                    if ("TIMESTAMP".equals(iDERAggDataDEFMapRuntime.getPSDERAggDataDEFieldMap().getMinorPSDEField().getPredefinedType())) {
                        strMinorFieldName = "__time";
                    }
                }
                if (MybatisSqlUtil.isDimension(iDERAggDataDEFMapRuntime)) {
                    strFuncCode = null;
                    if (!strMapType.equals("GROUPBY")) {
                        strFuncCode = DBDialectUtils.getInstance().get(strDBType).getDBFunction(strMapType.replace("GROUPBY_", "")).getFuncSQL(new String[]{strMinorFieldName});
                    }
                    if (StringUtils.hasLength(strFuncCode)) {
                        biAggDataDEFMapRuntimeMap.put(strMajorFieldName, strFuncCode);
                        continue;
                    }
                    if (!StringUtils.hasLength((String)strMinorFieldName)) continue;
                    biAggDataDEFMapRuntimeMap.put(strMajorFieldName, strMinorFieldName);
                    continue;
                }
                if (StringUtils.hasLength((String)iDERAggDataDEFMapRuntime.getFormulaFormat(strDBType))) {
                    biAggDataDEFMapRuntimeMap.put(strMajorFieldName, iDERAggDataDEFMapRuntime.getFormulaFormat(strDBType));
                    continue;
                }
                if (!StringUtils.hasLength((String)strMinorFieldName)) continue;
                biAggDataDEFMapRuntimeMap.put(strMajorFieldName, strMinorFieldName);
            }
            if (!bDrillDownMode) {
                for (Map.Entry entry : biAggDataDEFMapRuntimeMap.entrySet()) {
                    if (StringUtils.hasLength((String)((String)entry.getValue()))) {
                        groupQuery.getDatafield().add(String.format("%1$s AS %2$s", entry.getValue(), entry.getKey()));
                        continue;
                    }
                    groupQuery.getDatafield().add(String.format("%1$s", entry.getKey()));
                }
            }
            ArrayList<ISearchCond> dataSearchConds = new ArrayList<ISearchCond>();
            if (iSearchContext.getSearchConds() != null) {
                for (ISearchCond item : iSearchContext.getSearchConds()) {
                    ISearchCond condition = MybatisSqlUtil.getQueryCondition(strDBType, item, true, iSearchContext, biAggDataDEFMapRuntimeMap, list);
                    if (condition == null) continue;
                    if (condition instanceof ISearchGroupCond) {
                        ISearchGroupCond searchGroupCond = (ISearchGroupCond)condition;
                        if (searchGroupCond.getSearchCondsIf().size() <= 0) continue;
                        dataSearchConds.add(condition);
                        continue;
                    }
                    dataSearchConds.add(condition);
                }
            }
            for (ISearchCond cond : dataSearchConds) {
                if (!(cond instanceof ISearchFieldCond)) continue;
                SearchFieldCond searchFieldCond = (SearchFieldCond)cond;
                String condition = DBDialectUtils.getInstance().get(strDBType).getConditionSQL(searchFieldCond.getFieldName(), iMinorDataEntityRuntime.getPSDEField(searchFieldCond.getFieldName()).getStdDataType(), searchFieldCond.getCondOp(), (Object)String.format("#{ctx.datacontext.%s}", searchFieldCond.getValue()), true, iSearchContext);
                groupQuery.dataConditions.add(condition);
            }
            for (ISearchCond item : list) {
                strMajorFieldName = item.getPSDERAggDataDEFieldMap().getMajorPSDEField().getLowerCaseName();
                if (psDEDataSetGroupParamMap != null && !psDEDataSetGroupParamMap.containsKey(strMajorFieldName)) continue;
                String strMapType = item.getMapType();
                if (MybatisSqlUtil.isDimension((IDERAggDataDEFMapRuntime)item)) {
                    groupQuery.getResultfield().add(strMajorFieldName);
                    continue;
                }
                strFuncCode = DBDialectUtils.getInstance().get(strDBType).getDBFunction(strMapType.replace("GROUPBY_", "")).getFuncSQL(new String[]{strMajorFieldName});
                if (StringUtils.hasLength((String)strFuncCode) && !bDrillDownMode) {
                    groupQuery.getResultfield().add(String.format("%1$s AS %2$s", strFuncCode, strMajorFieldName));
                    continue;
                }
                groupQuery.getResultfield().add(strMajorFieldName);
            }
            if (!bDrillDownMode) {
                for (ISearchCond item : list) {
                    strMajorFieldName = item.getPSDERAggDataDEFieldMap().getMajorPSDEField().getLowerCaseName();
                    if (psDEDataSetGroupParamMap != null && !psDEDataSetGroupParamMap.containsKey(strMajorFieldName) || !MybatisSqlUtil.isDimension((IDERAggDataDEFMapRuntime)item)) continue;
                    groupQuery.getGroup().add(strMajorFieldName);
                }
            }
            ArrayList<ISearchCond> arrayList = new ArrayList<ISearchCond>();
            List majorDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
            for (IPSDEDataQuery iPSDEDataQuery : majorDEDataQueryList) {
                IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = iDataEntityRuntime.getDEDataQueryCodeRuntime(iPSDEDataQuery, iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType(), false);
                IPSDEDataQueryCode curDBPSDEDataQueryCode = iDEDataQueryCodeRuntime.getPSDEDataQueryCode();
                if (curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds() == null) continue;
                for (IPSDEDataQueryCodeCond queryCodeCond : curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds()) {
                    groupQuery.resultConditions.add(queryCodeCond.getCustomCond());
                }
            }
            if (iSearchContext.getSearchConds() != null) {
                for (ISearchCond item : iSearchContext.getSearchConds()) {
                    ISearchCond condition = MybatisSqlUtil.getQueryCondition(strDBType, item, false, iSearchContext, biAggDataDEFMapRuntimeMap, list);
                    if (condition == null) continue;
                    if (condition instanceof ISearchGroupCond) {
                        ISearchGroupCond searchGroupCond = (ISearchGroupCond)condition;
                        if (searchGroupCond.getSearchCondsIf().size() <= 0) continue;
                        arrayList.add(condition);
                        continue;
                    }
                    arrayList.add(condition);
                }
            }
            for (ISearchCond cond : arrayList) {
                if (!(cond instanceof ISearchFieldCond)) continue;
                SearchFieldCond searchFieldCond = (SearchFieldCond)cond;
                String condition = DBDialectUtils.getInstance().get(strDBType).getConditionSQL(searchFieldCond.getFieldName(), iDataEntityRuntime.getPSDEField(searchFieldCond.getFieldName()).getStdDataType(), searchFieldCond.getCondOp(), (Object)String.format("#{ctx.datacontext.%s}", searchFieldCond.getValue()), true, iSearchContext);
                groupQuery.resultConditions.add(condition);
            }
        }
        return groupQuery;
    }

    public static boolean isDimension(IDERAggDataDEFMapRuntime iPSDERAggDataDEFieldMap) {
        return iPSDERAggDataDEFieldMap.getMapType().indexOf("GROUPBY") != -1 || iPSDERAggDataDEFieldMap.getMapType().indexOf("USER") != -1;
    }

    private static ISearchCond getQueryCondition(String strDBType, ISearchCond iSearchCond, boolean bSourceMode, ISearchContext iSearchContext, Map<String, String> biAggDataDEFMapRuntimeMap, List<IDERAggDataDEFMapRuntime> iPSDERAggDataDEFieldMapRuntimes) throws Throwable {
        if (iSearchCond instanceof ISearchGroupCond) {
            ISearchGroupCond searchGroupCond = (ISearchGroupCond)iSearchCond;
            SearchGroupCond newSearchGroupCond = new SearchGroupCond();
            for (ISearchCond childSearchCond : searchGroupCond.getSearchConds()) {
                ISearchCond cond = MybatisSqlUtil.getQueryCondition(strDBType, childSearchCond, bSourceMode, iSearchContext, biAggDataDEFMapRuntimeMap, iPSDERAggDataDEFieldMapRuntimes);
                if (cond == null) continue;
                newSearchGroupCond.getSearchCondsIf().add(cond);
            }
            return newSearchGroupCond;
        }
        if (iSearchCond instanceof ISearchFieldCond) {
            if (bSourceMode) {
                ISearchFieldCond searchFieldCond = (ISearchFieldCond)iSearchCond;
                String strMajorFieldName = searchFieldCond.getFieldName();
                for (IDERAggDataDEFMapRuntime item : iPSDERAggDataDEFieldMapRuntimes) {
                    if (!strMajorFieldName.equals(item.getPSDERAggDataDEFieldMap().getMajorPSDEField().getName()) || !MybatisSqlUtil.isDimension(item) || !item.getMapType().equals("GROUPBY")) continue;
                    String minorFieldName = null;
                    minorFieldName = item.getMapType().equals("GROUPBY") ? item.getPSDERAggDataDEFieldMap().getMinorPSDEField().getName() : DBDialectUtils.getInstance().get(strDBType).getDBFunction(item.getMapType().replace("GROUPBY_", "")).getFuncSQL(new String[]{item.getPSDERAggDataDEFieldMap().getMinorPSDEField().getName()});
                    SearchFieldCond minorSearchFiledCond = new SearchFieldCond();
                    minorSearchFiledCond.setFieldName(minorFieldName);
                    minorSearchFiledCond.setCondOp(searchFieldCond.getCondOp());
                    minorSearchFiledCond.setValue(searchFieldCond.getValue());
                    minorSearchFiledCond.setParamMode(true);
                    return minorSearchFiledCond;
                }
                return null;
            }
            ISearchFieldCond searchFieldCond = (ISearchFieldCond)iSearchCond;
            String strMajorFieldName = searchFieldCond.getFieldName();
            for (IDERAggDataDEFMapRuntime item : iPSDERAggDataDEFieldMapRuntimes) {
                if (!strMajorFieldName.equals(item.getPSDERAggDataDEFieldMap().getMajorPSDEField().getName()) || MybatisSqlUtil.isDimension(item) && item.getMapType().equals("GROUPBY")) continue;
                SearchFieldCond minorSearchFiledCond = new SearchFieldCond();
                minorSearchFiledCond.setFieldName(strMajorFieldName);
                minorSearchFiledCond.setCondOp(searchFieldCond.getCondOp());
                minorSearchFiledCond.setValue(searchFieldCond.getValue());
                minorSearchFiledCond.setParamMode(true);
                return minorSearchFiledCond;
            }
            return null;
        }
        return null;
    }

    public static String composeDataSet(IDBDataService service, net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, String strDBType, ISearchContext iSearchContext, QueryWrapper<Object> query) throws Throwable {
        List psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
        if (psDEDataQueryList == null || psDEDataQueryList.size() == 0) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53\u6570\u636e\u96c6\u672a\u5305\u542b\u4efb\u4f55\u67e5\u8be2", new Object[0]));
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
            IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = iDataEntityRuntime.getDEDataQueryCodeRuntime(iPSDEDataQuery, strDBType, false);
            String str = MybatisSqlUtil.composeDataQuery(service, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query);
            sqlList.add(str);
        }
        return String.join((CharSequence)" UNION ", sqlList);
    }

    public static String composeDataQuery(IDBDataService service, net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, QueryWrapper<Object> query) throws Throwable {
        String condSql;
        if (query.isEmptyOfWhere()) {
            MybatisSqlUtil.calcSearchCond(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query);
        }
        StringBuilder sb = new StringBuilder();
        IPSDEDataQueryCode curDBPSDEDataQueryCode = iDEDataQueryCodeRuntime.getPSDEDataQueryCode();
        sb.append(curDBPSDEDataQueryCode.getQueryCode());
        boolean bOutputWhere = false;
        boolean bCondFirst = true;
        List psDEDataQueryCodeCondList = curDBPSDEDataQueryCode.getPSDEDataQueryCodeConds();
        if (psDEDataQueryCodeCondList != null) {
            for (IPSDEDataQueryCodeCond iPSDEDataQueryCodeCond : psDEDataQueryCodeCondList) {
                String strCondition = iPSDEDataQueryCodeCond.getCustomCond();
                if (!StringUtils.hasLength((String)strCondition)) continue;
                if (!bOutputWhere) {
                    sb.append(" WHERE ");
                    bOutputWhere = true;
                }
                if (bCondFirst) {
                    bCondFirst = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(String.format("(%1$s)", strCondition));
            }
        }
        if (query != null && (condSql = query.getSqlSegment()) != null && !ObjectUtils.isEmpty((Object)condSql)) {
            if (!bOutputWhere) {
                sb.append(" WHERE ");
                bOutputWhere = true;
            }
            if (bCondFirst) {
                bCondFirst = false;
            } else {
                sb.append(" AND ");
            }
            sb.append(condSql);
        }
        return sb.toString();
    }

    public static Page<?> composePage(ISearchContext iSearchContext) throws Throwable {
        Sort sort;
        Pageable pageable = iSearchContext.getPageable();
        Page page = new Page();
        page.setSearchCount(iSearchContext.isCount());
        if (pageable != null && Pageable.unpaged() != pageable) {
            page.setSize(pageable.getPageSize());
            page.setCurrent(pageable.getPageNumber() + 1);
            page.offset(pageable.getOffset());
        }
        if ((sort = iSearchContext.getPageSort()) != null && Sort.unsorted() != sort) {
            List items = sort.toList();
            for (Sort.Order order : items) {
                if (order.getDirection().isAscending()) {
                    page.addOrder(new OrderItem[]{OrderItem.asc((String)order.getProperty())});
                    continue;
                }
                page.addOrder(new OrderItem[]{OrderItem.desc((String)order.getProperty())});
            }
        }
        return page;
    }

    protected static String calcSearchCond(net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, QueryWrapper<Object> query) {
        List items = iSearchContext.getSearchConds();
        if (items != null) {
            List predefinedConds = items.stream().filter(searchCond -> searchCond instanceof SearchPredefinedCond).collect(Collectors.toList());
            predefinedConds.stream().forEach(searchCond -> {
                ISearchCond predefinedCond;
                if (searchCond instanceof SearchPredefinedCond && (predefinedCond = MybatisSqlUtil.parsePredefinedCond((IDataEntityRuntime)iDataEntityRuntime, ((SearchPredefinedCond)searchCond).getPredefinedCond())) != null) {
                    items.add(predefinedCond);
                }
            });
            MybatisSqlUtil.calcSearchCondRootItems(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query, "AND", items);
        }
        return query.getSqlSegment();
    }

    public static String calcSqlSearchCond(net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, QueryWrapper<Object> query, List params) {
        String strSql = MybatisSqlUtil.calcSearchCond(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query);
        Pattern bracketPattern = Pattern.compile("(\\#\\{.*?\\})");
        Matcher matcher = bracketPattern.matcher(strSql);
        while (matcher.find()) {
            String key = matcher.group();
            strSql = strSql.replace(key, "?");
            key = key.substring(key.indexOf(".MPGENVAL")).replace(".", "").replace("}", "");
            if (query.getParamNameValuePairs() != null && query.getParamNameValuePairs().containsKey(key)) {
                params.add(query.getParamNameValuePairs().get(key));
                continue;
            }
            params.add(null);
        }
        return strSql;
    }

    protected static void calcSearchCondRootItems(net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, QueryWrapper<Object> query, String groupMode, List<ISearchCond> items) {
        int i = 0;
        for (ISearchCond iSearchCond : items) {
            switch (iSearchCond.getCondType()) {
                case "GROUP": {
                    MybatisSqlUtil.searchCondGroup(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query, (ISearchGroupCond)iSearchCond);
                    break;
                }
                case "DEFIELD": {
                    MybatisSqlUtil.searchDEField(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query, (ISearchFieldCond)iSearchCond);
                    break;
                }
                case "CUSTOM": {
                    query.apply(((ISearchCustomCond)iSearchCond).getCustomCond(), new Object[0]);
                    break;
                }
            }
            ++i;
        }
    }

    protected static void calcSearchCondItems(net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, QueryWrapper<Object> query, String groupMode, List<ISearchCond> items) {
        int i = 0;
        for (ISearchCond iSearchCond : items) {
            if (i > 0 && groupMode.equals("OR")) {
                query.or();
            }
            switch (iSearchCond.getCondType()) {
                case "GROUP": {
                    MybatisSqlUtil.searchCondGroup(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query, (ISearchGroupCond)iSearchCond);
                    break;
                }
                case "DEFIELD": {
                    MybatisSqlUtil.searchDEField(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, query, (ISearchFieldCond)iSearchCond);
                    break;
                }
                case "CUSTOM": {
                    query.apply(((ISearchCustomCond)iSearchCond).getCustomCond(), new Object[0]);
                    break;
                }
            }
            ++i;
        }
    }

    public static ISearchCond parsePredefinedCond(IDataEntityRuntime dataEntityRuntime, String strPredefinedCond) {
        ISearchCond searchCond = null;
        Stack<Object> conditions_in = new Stack<Object>();
        Pattern bracketPattern = Pattern.compile("\\[(.*?)]");
        Matcher matcher = bracketPattern.matcher(strPredefinedCond);
        if (!matcher.find()) {
            throw new RuntimeException(String.format("scope\u89e3\u6790\u9519\u8bef:%s", strPredefinedCond));
        }
        strPredefinedCond = matcher.group().substring(1, matcher.group().length() - 1);
        Stack<String> conditions = new Stack<String>();
        Pattern conditionPattern = Pattern.compile("\\'\\|\\'|\\'\\&\\'|\\([^\\)]+\\)");
        matcher = conditionPattern.matcher(strPredefinedCond);
        while (matcher.find()) {
            conditions.push(matcher.group());
        }
        if (conditions.size() >= 3) {
            searchCond = MybatisSqlUtil.convertPredefinedCond(dataEntityRuntime, conditions, conditions_in);
        }
        if (conditions.size() == 1) {
            searchCond = MybatisSqlUtil.parseTerm(dataEntityRuntime, conditions.pop());
        }
        return searchCond;
    }

    private static ISearchCond convertPredefinedCond(IDataEntityRuntime dataEntityRuntime, Stack<String> operations, Stack<Object> conditions) {
        while (operations.size() > 0) {
            String operation = operations.pop();
            if (operation.equals(OPERATION_AND) || operation.equals(OPERATION_OR)) {
                ISearchCond terms = MybatisSqlUtil.parseTerms(dataEntityRuntime, operation, conditions.pop(), conditions.pop());
                conditions.add(0, terms);
                if (operations.size() != 0) continue;
                return terms;
            }
            conditions.push(operation);
        }
        return null;
    }

    private static ISearchCond parseTerms(IDataEntityRuntime dataEntityRuntime, String operation, Object condition, Object condition2) {
        SearchGroupCond groupCond = new SearchGroupCond();
        if (operation.equals(OPERATION_OR)) {
            groupCond.setCondOp("OR");
        }
        if (operation.equals(OPERATION_AND)) {
            groupCond.setCondOp("AND");
        }
        ArrayList<ISearchCond> childSearchConds = new ArrayList<ISearchCond>();
        if (condition instanceof String) {
            childSearchConds.add(MybatisSqlUtil.parseTerm(dataEntityRuntime, condition.toString()));
        } else if (condition instanceof ISearchCond) {
            childSearchConds.add((ISearchCond)condition);
        }
        if (condition2 instanceof String) {
            childSearchConds.add(MybatisSqlUtil.parseTerm(dataEntityRuntime, condition2.toString()));
        } else if (condition2 instanceof ISearchCond) {
            childSearchConds.add((ISearchCond)condition2);
        }
        groupCond.setSearchConds(childSearchConds);
        return groupCond;
    }

    private static ISearchCond parseTerm(IDataEntityRuntime iDataEntityRuntime, String condition) {
        String[] args;
        Pattern p1 = Pattern.compile("'(.*?)'");
        Matcher m = p1.matcher(condition);
        ArrayList<String> argList = new ArrayList<String>();
        while (m.find()) {
            argList.add(m.group());
        }
        if (argList.size() == 1) {
            argList.add(0, condition.split(",")[0].replace("(", ""));
        }
        if (argList.size() == 2) {
            argList.add(condition.split(",")[2].replace(")", ""));
        }
        if ((args = argList.toArray(new String[argList.size()])).length != 3) {
            throw new RuntimeException(String.format("\u5b57\u6bb5\u6761\u4ef6\u89e3\u6790\u9519\u8bef:%s", args.toString()));
        }
        String strFieldQueryExp = args[0].replace("'", "").trim();
        String fieldValue = args[2].replace("'", "").trim();
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldQueryExp);
        searchFieldCond.setValue((Object)fieldValue);
        if (String.valueOf(fieldValue).startsWith("#{")) {
            searchFieldCond.setParamMode(true);
        }
        if (args[1].trim().equals(TERM_OPERATOR_EQ)) {
            if ("false".equalsIgnoreCase(args[2].trim().replace("'", ""))) {
                searchFieldCond.setCondOp("ISNULL");
            } else if ("true".equalsIgnoreCase(args[2].trim().replace("'", ""))) {
                searchFieldCond.setCondOp("ISNOTNULL");
            } else {
                searchFieldCond.setCondOp("EQ");
            }
        } else if (args[1].trim().equals(TERM_OPERATOR_NE)) {
            if ("false".equalsIgnoreCase(args[2].trim().replace("'", ""))) {
                searchFieldCond.setCondOp("ISNOTNULL");
            }
            if ("true".equalsIgnoreCase(args[2].trim().replace("'", ""))) {
                searchFieldCond.setCondOp("ISNULL");
            } else {
                searchFieldCond.setCondOp("NOTEQ");
            }
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_GT)) {
            searchFieldCond.setCondOp("GT");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_GE)) {
            searchFieldCond.setCondOp("GTANDEQ");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_LT)) {
            searchFieldCond.setCondOp("LT");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_LE)) {
            searchFieldCond.setCondOp("LTANDEQ");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_IN)) {
            searchFieldCond.setCondOp("IN");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_NOTIN)) {
            searchFieldCond.setCondOp("NOTIN");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_LIKE)) {
            searchFieldCond.setCondOp("LIKE");
        } else if (args[1].trim().equalsIgnoreCase(TERM_OPERATOR_NOTLIKE)) {
            // empty if block
        }
        return searchFieldCond;
    }

    protected static void searchCondGroup(final net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, final IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, final ISearchContext iSearchContext, QueryWrapper<Object> query, final ISearchGroupCond cond) {
        final List items = cond.getSearchConds();
        if (!ObjectUtils.isEmpty((Object)items)) {
            query.and((Consumer)new Consumer<QueryWrapper<Object>>(){

                @Override
                public void accept(QueryWrapper<Object> objectQueryWrapper) {
                    switch (cond.getCondOp()) {
                        case "AND": {
                            objectQueryWrapper.and((Consumer)new Consumer<QueryWrapper<Object>>(){

                                @Override
                                public void accept(QueryWrapper<Object> subQuery) {
                                    MybatisSqlUtil.calcSearchCondItems(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, subQuery, "AND", items);
                                }
                            });
                            break;
                        }
                        case "OR": {
                            objectQueryWrapper.or((Consumer)new Consumer<QueryWrapper<Object>>(){

                                @Override
                                public void accept(QueryWrapper<Object> subQuery) {
                                    MybatisSqlUtil.calcSearchCondItems(iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, subQuery, "OR", items);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    protected static void searchDEField(net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext, QueryWrapper<Object> query, ISearchFieldCond cond) {
        String column = cond.getFieldName();
        IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(column, true);
        if (iPSDEField == null) {
            if (ObjectUtils.isEmpty((Object)cond.getValue())) {
                log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u6761\u4ef6[%1$s %2$s]", column, cond.getCondOp()));
            } else {
                log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u6761\u4ef6[%1$s %2$s %3$s]", column, cond.getCondOp(), cond.getValue()));
            }
            return;
        }
        boolean bExistsCond = "EXISTS".equals(cond.getCondOp()) || "NOTEXISTS".equals(cond.getCondOp());
        int nDEFType = iPSDEField.getDEFType();
        if (nDEFType != 1 && nDEFType != 2 && nDEFType != 3 && !bExistsCond) {
            return;
        }
        IPSDEFSearchMode existPSDEFSearchMode = null;
        if (!bExistsCond) {
            if (iDEDataQueryCodeRuntime != null) {
                IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(column, true);
                if (iPSDEDataQueryCodeExp != null) {
                    column = iPSDEDataQueryCodeExp.getExpression();
                } else if (!ObjectUtils.isEmpty((Object)iDataEntityRuntime.getFieldQueryExp(column))) {
                    column = iDataEntityRuntime.getFieldQueryExp(column);
                }
            } else if (!ObjectUtils.isEmpty((Object)iDataEntityRuntime.getFieldQueryExp(column))) {
                column = iDataEntityRuntime.getFieldQueryExp(column);
            }
        } else {
            List psDEFSearchModes = iPSDEField.getAllPSDEFSearchModes();
            if (!ObjectUtils.isEmpty((Object)psDEFSearchModes)) {
                for (IPSDEFSearchMode iPSDEFSearchMode : psDEFSearchModes) {
                    if (!cond.getCondOp().equals(iPSDEFSearchMode.getValueOP())) continue;
                    existPSDEFSearchMode = iPSDEFSearchMode;
                    break;
                }
            }
            if (existPSDEFSearchMode == null) {
                log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u641c\u7d22\u6a21\u5f0f[%2$s]\u4e0d\u5b58\u5728", column, cond.getCondOp()));
                return;
            }
            if (existPSDEFSearchMode.getPSDER() == null) {
                log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u641c\u7d22\u6a21\u5f0f[%2$s]\u672a\u6307\u5b9a\u8fde\u63a5\u5173\u7cfb", column, cond.getCondOp()));
                return;
            }
            if (existPSDEFSearchMode.getPSDER() instanceof IPSDER1N) {
                if (((IPSDER1N)existPSDEFSearchMode.getPSDER()).getPSPickupDEField() == null) {
                    log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u641c\u7d22\u6a21\u5f0f[%2$s]\u672a\u6307\u5b9a\u8fde\u63a5\u5c5e\u6027", column, cond.getCondOp()));
                    return;
                }
            } else if (existPSDEFSearchMode.getPSDER() instanceof IPSDERCustom && ((IPSDERCustom)existPSDEFSearchMode.getPSDER()).getPickupPSDEField() == null) {
                log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u641c\u7d22\u6a21\u5f0f[%2$s]\u672a\u6307\u5b9a\u8fde\u63a5\u5c5e\u6027", column, cond.getCondOp()));
                return;
            }
            if (existPSDEFSearchMode.getDstPSDEField() == null) {
                log.warn((Object)String.format("\u6307\u5b9a\u5c5e\u6027[%1$s]\u641c\u7d22\u6a21\u5f0f[%2$s]\u672a\u6307\u5b9a\u6761\u4ef6\u5c5e\u6027", column, cond.getCondOp()));
                return;
            }
        }
        Object val = cond.getValue();
        if (cond.isParamMode()) {
            if (String.valueOf(val).startsWith("#{ctx.session") || String.valueOf(val).startsWith("#{srf.session")) {
                val = String.valueOf(val).replace("#", "").replace("{", "").replace("}", "");
                val = UserContext.getCurrent().getSessionParam(String.valueOf(val).split("\\.")[2].trim());
            } else if (iPSDEField != null && !"IN".equals(cond.getCondOp()) && !"NOTIN".equals(cond.getCondOp())) {
                try {
                    val = iDataEntityRuntime.getSystemRuntime().convertValue(iPSDEField.getStdDataType(), String.valueOf(iSearchContext.get((String)val)));
                }
                catch (Exception e) {
                    val = iSearchContext.get((String)val);
                }
            } else {
                val = iSearchContext.get((String)val);
            }
        }
        switch (cond.getCondOp()) {
            case "EQ": {
                query.eq((Object)column, val);
                break;
            }
            case "NOTEQ": {
                query.ne((Object)column, val);
                break;
            }
            case "GT": {
                query.gt((Object)column, val);
                break;
            }
            case "GTANDEQ": {
                query.ge((Object)column, val);
                break;
            }
            case "LT": {
                query.lt((Object)column, val);
                break;
            }
            case "LTANDEQ": {
                query.le((Object)column, val);
                break;
            }
            case "ISNULL": {
                query.isNull((Object)column);
                break;
            }
            case "ISNOTNULL": {
                query.isNotNull((Object)column);
                break;
            }
            case "LIKE": 
            case "USERLIKE": {
                if (MybatisSqlUtil.isSearchIgnoreCase()) {
                    column = String.format("UPPER(%s)", column);
                    if (val != null) {
                        val = String.valueOf(val).toUpperCase();
                    }
                }
                query.like((Object)column, val);
                break;
            }
            case "IN": {
                if (cond.isParamMode()) {
                    query.in((Object)column, MybatisSqlUtil.formatINorNotInParam(cond, val));
                    break;
                }
                query.inSql((Object)column, String.valueOf(val));
                break;
            }
            case "NOTIN": {
                if (cond.isParamMode()) {
                    query.notIn((Object)column, MybatisSqlUtil.formatINorNotInParam(cond, val));
                    break;
                }
                query.notInSql((Object)column, String.valueOf(val));
                break;
            }
            case "LEFTLIKE": {
                if (MybatisSqlUtil.isSearchIgnoreCase()) {
                    column = String.format("UPPER(%s)", column);
                    if (val != null) {
                        val = String.valueOf(val).toUpperCase();
                    }
                }
                query.likeRight((Object)column, val);
                break;
            }
            case "RIGHTLIKE": {
                if (MybatisSqlUtil.isSearchIgnoreCase()) {
                    column = String.format("UPPER(%s)", column);
                    if (val != null) {
                        val = String.valueOf(val).toUpperCase();
                    }
                }
                query.likeLeft((Object)column, val);
                break;
            }
            case "EXISTS": 
            case "NOTEXISTS": {
                String strKeyExpCode = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(iDataEntityRuntime.getKeyPSDEField().getName(), true).getExpression();
                IPSDataEntity minorPSDataEntity = existPSDEFSearchMode.getPSDERMust().getMinorPSDataEntityMust();
                IPSPickupDEField pickupPSDEField = null;
                if (existPSDEFSearchMode.getPSDERMust() instanceof IPSDER1N) {
                    pickupPSDEField = ((IPSDER1N)existPSDEFSearchMode.getPSDERMust()).getPSPickupDEFieldMust();
                } else if (existPSDEFSearchMode.getPSDERMust() instanceof IPSDERCustom) {
                    pickupPSDEField = ((IPSDERCustom)existPSDEFSearchMode.getPSDERMust()).getPickupPSDEFieldMust();
                }
                net.ibizsys.central.dataentity.IDataEntityRuntime minorDataEntityRuntime = iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(minorPSDataEntity.getId(), false);
                String strSql = String.format("SELECT 1 FROM %1$s WHERE %2$s = %1$s.%3$s and %1$s.%4$s ", minorDataEntityRuntime.getTableName(), strKeyExpCode, pickupPSDEField.getName(), existPSDEFSearchMode.getDstPSDEFieldMust().getName());
                List<String> list = null;
                if (cond.isParamMode()) {
                    val = MybatisSqlUtil.formatINorNotInParam(cond, val);
                }
                if (val instanceof String && !StringUtils.isEmpty((Object)val)) {
                    list = Arrays.asList(((String)val).split("[,|;|\\|]"));
                } else if (val instanceof List) {
                    list = (List<String>)val;
                }
                if (ObjectUtils.isEmpty(list)) {
                    strSql = strSql + " IS NOT NULL";
                } else {
                    strSql = strSql + " IN (";
                    boolean bFirst = true;
                    boolean bVarchar = DataTypeUtils.isStringDataType((int)existPSDEFSearchMode.getDstPSDEFieldMust().getStdDataType());
                    for (String item : list) {
                        if (bFirst) {
                            bFirst = false;
                        } else {
                            strSql = strSql + ",";
                        }
                        if (item == null) {
                            strSql = strSql + "NULL";
                            continue;
                        }
                        if (bVarchar) {
                            strSql = strSql + String.format("'%1$s'", item.toString().replace("'", "''"));
                            continue;
                        }
                        strSql = strSql + item.toString();
                    }
                    strSql = strSql + ")";
                }
                if ("EXISTS".equals(cond.getCondOp())) {
                    query.exists(true, strSql);
                    break;
                }
                query.notExists(true, strSql);
            }
        }
    }

    protected static Collection formatINorNotInParam(ISearchFieldCond cond, Object val) {
        if (val instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)val))) {
            return (Collection)val;
        }
        if (val instanceof String && !StringUtils.isEmpty((Object)val)) {
            String[] list = ((String)val).split("[,|;|\\|]");
            return Arrays.asList(list);
        }
        ArrayList<Object> empty = new ArrayList<Object>();
        empty.add(null);
        return empty;
    }

    public static void genGroupCondition(StringBuffer strCond, net.ibizsys.central.dataentity.IDataEntityRuntime iDataEntityRuntime, String strDBType, ISearchContext iSearchContext, ISearchCond cond) throws Throwable {
        if (cond instanceof ISearchFieldCond) {
            SearchFieldCond searchFieldCond = (SearchFieldCond)cond;
            String condition = DBDialectUtils.getInstance().get(strDBType).getConditionSQL(searchFieldCond.getFieldName(), iDataEntityRuntime.getPSDEField(searchFieldCond.getFieldName()).getStdDataType(), searchFieldCond.getCondOp(), searchFieldCond.isParamMode() ? iSearchContext.get(String.valueOf(searchFieldCond.getValue())) : searchFieldCond.getValue(), false, iSearchContext);
            strCond.append(condition);
        } else if (cond instanceof ISearchGroupCond) {
            ISearchGroupCond searchGroupCond = (ISearchGroupCond)cond;
            List childConds = searchGroupCond.getSearchCondsIf();
            if (CollectionUtils.isNotEmpty((Collection)childConds)) {
                strCond.append("(");
                for (int i = 0; i < childConds.size(); ++i) {
                    if (i > 0) {
                        strCond.append(" " + searchGroupCond.getCondOp() + " ");
                    }
                    MybatisSqlUtil.genGroupCondition(strCond, iDataEntityRuntime, strDBType, iSearchContext, (ISearchCond)childConds.get(i));
                }
                strCond.append(")");
            }
        } else if (cond instanceof ISearchCustomCond) {
            ISearchCustomCond customCond = (ISearchCustomCond)cond;
            strCond.append(customCond.getCustomCond());
        }
    }

    public static boolean isSearchIgnoreCase() {
        return searchIgnoreCase;
    }

    public static void setSearchIgnoreCase(boolean searchIgnoreCase) {
        MybatisSqlUtil.searchIgnoreCase = searchIgnoreCase;
    }

    public static String convertSQL(String sql, Map<String, Object> parameter, SqlSession sqlSession) throws Exception {
        String sqlstr;
        parameter.put("ctx", parameter);
        try {
            MappedStatement mappedStatement;
            sql = MybatisSqlUtil.hasDynamicTag(sql) ? MybatisSqlUtil.convertDynamicSQL(sql) : StringEscapeUtils.escapeXml11((String)sql);
            String sqlmd5 = DigestUtils.md5DigestAsHex((byte[])sql.getBytes());
            Configuration configuration = sqlSession.getConfiguration();
            String mappedStatementName = String.format("DynamicSqlConvert.%1$s", sqlmd5);
            StringInputStream inputStream = new StringInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" ?> <!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\" > <mapper> <select id=\"" + sqlmd5 + "\" resultType=\"java.util.Map\">" + sql + "</select> </mapper>");
            XPathParser parser = new XPathParser((InputStream)inputStream, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
            XNode node = (XNode)parser.evalNode("/mapper").evalNodes("select").get(0);
            if (configuration.getMappedStatementNames().contains(mappedStatementName)) {
                mappedStatement = configuration.getMappedStatement(mappedStatementName, false);
            } else {
                MapperBuilderAssistant mapperBuilderAssistant = new MapperBuilderAssistant(configuration, inputStream.toString());
                mapperBuilderAssistant.setCurrentNamespace("DynamicSqlConvert");
                XMLStatementBuilder xmlStatementBuilder = new XMLStatementBuilder(configuration, mapperBuilderAssistant, node, null);
                xmlStatementBuilder.parseStatementNode();
                mappedStatement = configuration.getMappedStatement(mappedStatementName, false);
            }
            SqlSource sqlSource = mappedStatement.getSqlSource();
            boolean dynamic = MybatisSqlUtil.isDynamicSql(node);
            if (dynamic) {
                Field rootSqlNode = DynamicSqlSource.class.getDeclaredField("rootSqlNode");
                rootSqlNode.setAccessible(true);
                SqlNode sqlNode = (SqlNode)rootSqlNode.get(sqlSource);
                DynamicContext context = new DynamicContext(configuration, parameter);
                sqlNode.apply(context);
                sqlstr = context.getSql();
            } else {
                sqlstr = sql;
            }
            sqlstr = StringEscapeUtils.unescapeXml((String)sqlstr);
        }
        catch (Exception e) {
            log.error((Object)String.format("sql\u8f6c\u5316\u9519\u8bef\uff0c%1$s", e.getMessage()), (Throwable)e);
            throw new Exception("sql\u8f6c\u5316\u9519\u8bef");
        }
        return sqlstr;
    }

    public static boolean isDynamicSql(XNode node) {
        boolean isDynamic = false;
        NodeList children = node.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = node.newXNode(children.item(i));
            if (child.getNode().getNodeType() == 4 || child.getNode().getNodeType() == 3) {
                String data = child.getStringBody("");
                TextSqlNode textSqlNode = new TextSqlNode(data);
                if (!textSqlNode.isDynamic()) continue;
                isDynamic = true;
                continue;
            }
            if (child.getNode().getNodeType() != 1) continue;
            isDynamic = true;
        }
        return isDynamic;
    }

    public static boolean hasDynamicTag(String text) {
        return DYNAMIC_TAG_PATTERN.matcher(text).find();
    }

    public static String convertDynamicSQL(String sql) {
        String[] keys = new String[]{"___SRF001___", "___SRF002___", "___SRF003___", "___SRF004___", "___SRF005___", "___SRF006___", "___SRF007___"};
        String[] values = new String[]{"<choose>", "<otherwise>", "<if>", "</choose>", "</when>", "</otherwise>", "</if>"};
        Pattern mybatiswhenpattern = Pattern.compile("(<when.*?>)");
        sql = org.apache.commons.lang3.StringUtils.replaceEach((String)sql, (String[])values, (String[])keys);
        Matcher matcher = mybatiswhenpattern.matcher(sql);
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String match = matcher.group(1);
            int hash = match.hashCode();
            hashMap.put("___SRF" + hash + "___", match);
        }
        String[] WhenStrMatchkeys = hashMap.keySet().toArray(new String[0]);
        String[] WhenStrMatchValues = hashMap.values().toArray(new String[0]);
        sql = org.apache.commons.lang3.StringUtils.replaceEach((String)sql, (String[])WhenStrMatchValues, (String[])WhenStrMatchkeys);
        sql = StringEscapeUtils.escapeXml11((String)sql);
        sql = org.apache.commons.lang3.StringUtils.replaceEach((String)sql, (String[])WhenStrMatchkeys, (String[])WhenStrMatchValues);
        sql = org.apache.commons.lang3.StringUtils.replaceEach((String)sql, (String[])keys, (String[])values);
        return sql;
    }
}

