/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.mybatisplus.spring.typehandler;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.BIGINT})
public class BigIntegerTypeHandle
extends BaseTypeHandler<Object> {
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        ps.setObject(i, parameter);
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object result = rs.getObject(columnName);
        return rs.wasNull() ? null : this.dealResult(result);
    }

    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object result = rs.getObject(columnIndex);
        return rs.wasNull() ? null : this.dealResult(result);
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object result = cs.getObject(columnIndex);
        return cs.wasNull() ? null : this.dealResult(result);
    }

    private Object dealResult(Object result) throws SQLException {
        if (result instanceof BigInteger) {
            return ((BigInteger)result).longValue();
        }
        return result;
    }
}

