/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.mybatisplus.spring.service;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import net.ibizsys.central.database.IDBDataService;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.database.ISysDBColumnRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntimeContext;
import net.ibizsys.central.database.ISysDBTableRuntime;
import net.ibizsys.central.database.SysDBSchemeRuntime;
import net.ibizsys.central.database.SysDBSchemeRuntimeException;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.plugin.mybatisplus.spring.mapper.MybatisDbDataMapper;
import net.ibizsys.central.plugin.mybatisplus.util.DBSchemeContextHolder;
import net.ibizsys.central.plugin.mybatisplus.util.GroupQuery;
import net.ibizsys.central.plugin.mybatisplus.util.MybatisSqlUtil;
import net.ibizsys.central.plugin.mybatisplus.util.oldsql.SqlCodeUtil;
import net.ibizsys.central.security.IUserContextRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.SqlCommandParam;
import net.ibizsys.runtime.util.SqlParam;
import net.ibizsys.runtime.util.SystemContextUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="DBDataService")
public class MybatisDbDataService
implements IDBDataService {
    private Log log = LogFactory.getLog(MybatisDbDataService.class);
    private String regex = "\\?";
    private Pattern pattern = Pattern.compile(this.regex);
    @Autowired
    private MybatisDbDataMapper dbDataMapper;
    @Value(value="${ibiz.db.batchsize:1000}")
    private int batchSize;
    @Value(value="${ibiz.db.batchmode:MULTISQL}")
    private String batchMode;
    @Value(value="${ibiz.db.createbatchmode:}")
    private String createBatchMode;
    @Value(value="${ibiz.db.updatebatchmode:}")
    private String updateBatchMode;
    @Autowired
    SqlSession sqlSession;

    @PostConstruct
    public void postConstruct() {
        SysDBSchemeRuntime.setDefaultDBDataService((IDBDataService)this);
    }

    public int insert(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, List args) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            if (!StringUtils.isEmpty((Object)args)) {
                int size = args.size();
                if (size == 1) {
                    Object arg2 = args.get(0);
                    int n = this.insert(iSysDBSchemeRuntimeContext, iSysDBTableRuntime, (SqlCommandParam)arg2);
                    return n;
                }
                int ret = 0;
                Long cur = System.currentTimeMillis();
                ArrayList<SqlCommandParam> batchData = new ArrayList<SqlCommandParam>();
                for (int i = 0; i < args.size(); ++i) {
                    batchData.add((SqlCommandParam)args.get(i));
                    if (this.batchSize != batchData.size() && i != args.size() - 1) continue;
                    int num = 0;
                    if ("SINGLESQL".equals(StringUtils.isEmpty((Object)this.createBatchMode) ? this.batchMode : this.createBatchMode)) {
                        ArrayList<List<SqlParam>> batchDataList = new ArrayList<List<SqlParam>>();
                        ArrayList<String> includeColumns = new ArrayList<String>();
                        for (String string : iSysDBTableRuntime.getColumns().keySet()) {
                            if (!batchData.stream().anyMatch(arg -> {
                                SqlCommandParam sqlCommandParam = (SqlCommandParam)arg;
                                for (SqlParam value : sqlCommandParam.getValues()) {
                                    if (!value.getName().equals(((ISysDBColumnRuntime)iSysDBTableRuntime.getColumns().get(column)).getStandardName())) continue;
                                    return true;
                                }
                                return false;
                            })) continue;
                            includeColumns.add(((ISysDBColumnRuntime)iSysDBTableRuntime.getColumns().get(string)).getStandardName());
                        }
                        for (Object object : batchData) {
                            ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
                            for (String column : includeColumns) {
                                SqlCommandParam sqlCommandParam = (SqlCommandParam)object;
                                boolean has = false;
                                for (SqlParam value : sqlCommandParam.getValues()) {
                                    if (!value.getName().equals(column)) continue;
                                    has = true;
                                    sqlParamList.add(value);
                                    break;
                                }
                                if (has) continue;
                                sqlParamList.add(null);
                            }
                            batchDataList.add(sqlParamList);
                        }
                        num = this.dbDataMapper.batchInsertDataSingleSQL(iSysDBTableRuntime, includeColumns, batchDataList);
                    } else if ("MULTISQL".equals(StringUtils.isEmpty((Object)this.createBatchMode) ? this.batchMode : this.createBatchMode)) {
                        num = this.dbDataMapper.batchInsertData(iSysDBTableRuntime, batchData);
                    } else {
                        throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u672a\u652f\u6301\u7684\u6279\u5904\u7406\u6a21\u5f0f\uff1a" + (StringUtils.isEmpty((Object)this.createBatchMode) ? this.batchMode : this.createBatchMode));
                    }
                    ret += num;
                    batchData.clear();
                }
                this.log.debug((Object)String.format("\u6279\u5904\u7406\u521b\u5efa[%1$s]\u8017\u65f6[%2$s]ms", args.size(), System.currentTimeMillis() - cur));
                int n = ret;
                return n;
            }
            int size = 0;
            return size;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public int update(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, List args) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            if (!StringUtils.isEmpty((Object)args)) {
                int size = args.size();
                if (size == 1) {
                    Object arg = args.get(0);
                    int n = this.update(iSysDBSchemeRuntimeContext, iSysDBTableRuntime, (SqlCommandParam)arg);
                    return n;
                }
                int ret = 0;
                Long cur = System.currentTimeMillis();
                ArrayList<SqlCommandParam> batchData = new ArrayList<SqlCommandParam>();
                for (int i = 0; i < args.size(); ++i) {
                    batchData.add((SqlCommandParam)args.get(i));
                    if (this.batchSize != batchData.size() && i != args.size() - 1) continue;
                    int num = 0;
                    if ("SINGLESQL".equals(StringUtils.isEmpty((Object)this.updateBatchMode) ? this.batchMode : this.updateBatchMode)) {
                        HashMap<String, Map<Object, SqlParam>> sqlParamMap = new HashMap<String, Map<Object, SqlParam>>();
                        ArrayList<Object> keys = new ArrayList<Object>();
                        for (Object e : batchData) {
                            SqlCommandParam sqlCommandParam = (SqlCommandParam)e;
                            for (SqlParam value : sqlCommandParam.getValues()) {
                                if (iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType().equals("ORACLE") && iSysDBTableRuntime.getColumns().containsKey(value.getName())) {
                                    value.setDataType(((ISysDBColumnRuntime)iSysDBTableRuntime.getColumns().get(value.getName())).getStdDataType());
                                }
                                if (!sqlParamMap.containsKey(value.getName())) {
                                    sqlParamMap.put(value.getName(), new HashMap());
                                }
                                Object key = null;
                                for (SqlParam condition : sqlCommandParam.getConditions()) {
                                    key = condition.getValue();
                                }
                                if (key == null || ((Map)sqlParamMap.get(value.getName())).containsKey(key)) continue;
                                if (!keys.contains(key)) {
                                    keys.add(key);
                                }
                                ((Map)sqlParamMap.get(value.getName())).put(key, value);
                            }
                        }
                        num = this.dbDataMapper.batchUpdateDataSingleSQL(iSysDBTableRuntime, keys, sqlParamMap);
                    } else if ("MULTISQL".equals(StringUtils.isEmpty((Object)this.updateBatchMode) ? this.batchMode : this.updateBatchMode)) {
                        num = this.dbDataMapper.batchUpdateData(iSysDBTableRuntime, batchData);
                    } else {
                        throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u672a\u652f\u6301\u7684\u6279\u5904\u7406\u6a21\u5f0f\uff1a" + (StringUtils.isEmpty((Object)this.updateBatchMode) ? this.batchMode : this.updateBatchMode));
                    }
                    ret += num;
                    batchData.clear();
                }
                this.log.debug((Object)String.format("\u6279\u5904\u7406\u66f4\u65b0[%1$s]\u8017\u65f6[%2$s]ms", args.size(), System.currentTimeMillis() - cur));
                int n = ret;
                return n;
            }
            int size = 0;
            return size;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public int delete(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, List args) throws Throwable {
        int retSize = 0;
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            if (!StringUtils.isEmpty((Object)args)) {
                int size = args.size();
                if (size == 1) {
                    Object arg = args.get(0);
                    int n = this.delete(iSysDBSchemeRuntimeContext, iSysDBTableRuntime, (SqlCommandParam)arg);
                    return n;
                }
                int ret = 0;
                Long cur = System.currentTimeMillis();
                ArrayList<Object> batchRemoveData = new ArrayList<Object>();
                for (int i = 0; i < args.size(); ++i) {
                    SqlCommandParam sqlCommandParam = (SqlCommandParam)args.get(i);
                    for (SqlParam value : sqlCommandParam.getConditions()) {
                        batchRemoveData.add(value.getValue());
                    }
                    if (this.batchSize != batchRemoveData.size() && i != args.size() - 1) continue;
                    int num = 0;
                    num = this.dbDataMapper.batchRemoveData(iSysDBTableRuntime, batchRemoveData);
                    ret += num;
                    batchRemoveData.clear();
                }
                this.log.debug((Object)String.format("\u6279\u5220\u9664[%1$s]\u8017\u65f6[%2$s]ms", args.size(), System.currentTimeMillis() - cur));
                int n = ret;
                return n;
            }
            int size = retSize;
            return size;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public int insert(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, SqlCommandParam arg) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            int n = this.dbDataMapper.insertData(iSysDBTableRuntime, arg);
            return n;
        }
        catch (DataIntegrityViolationException e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public int update(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, SqlCommandParam arg) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            int n = this.dbDataMapper.updateData(iSysDBTableRuntime, arg);
            return n;
        }
        catch (DataIntegrityViolationException e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public int delete(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, SqlCommandParam arg) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            int n = this.dbDataMapper.removeData(iSysDBTableRuntime, arg);
            return n;
        }
        catch (DataIntegrityViolationException e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 8, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public Page<?> select(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext) throws Throwable {
        try {
            PageImpl newPage;
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            QueryWrapper query = new QueryWrapper();
            if (iPSDEDataSet.getGroupMode() == 1 || iPSDEDataSet.getGroupMode() == 2) {
                Page<?> page = this.selectGroup(iSysDBSchemeRuntimeContext, iDataEntityRuntime, iPSDEDataSet, iSearchContext);
                return page;
            }
            String sql = MybatisSqlUtil.composeDataSet(this, iDataEntityRuntime, iPSDEDataSet, iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType(), iSearchContext, (QueryWrapper<Object>)query);
            sql = sql.replace("#{srf.", "#{ctx.");
            if ((sql = sql.replace("${srf.", "#{ctx.")).indexOf("${srf") != -1) {
                sql = SqlCodeUtil.parse(sql);
            }
            net.ibizsys.central.plugin.mybatisplus.util.Page<?> page = MybatisSqlUtil.composePage(iSearchContext);
            CaseInsensitiveMap dataMap = new CaseInsensitiveMap();
            if (iSearchContext.any() != null) {
                dataMap.putAll(iSearchContext.any());
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("datacontext", dataMap);
            data.put("globalcontext", new HashMap());
            IUserContext iUserContext = UserContext.getCurrent();
            if (iUserContext != null && iUserContext instanceof IUserContextRuntime) {
                IUserContextRuntime iUserContextRuntime = (IUserContextRuntime)iUserContext;
                data.put("sessioncontext", iUserContextRuntime.getSessionParams());
            }
            data.put("systemcontext", SystemContextUtils.getInstance().getParams(null));
            data.put("webcontext", dataMap);
            sql = MybatisSqlUtil.convertSQL(sql, data, this.sqlSession);
            com.baomidou.mybatisplus.extension.plugins.pagination.Page<Map<String, Object>> resultPage = this.dbDataMapper.queryData((IPage<?>)page, (Wrapper<?>)query, sql, data);
            PageImpl pageImpl = newPage = new PageImpl(resultPage.getRecords(), (Pageable)(iSearchContext.getPageable() != null ? iSearchContext.getPageable() : PageRequest.of((int)0, (int)10)), resultPage.getTotal());
            return pageImpl;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public Page<?> selectGroup(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext) throws Throwable {
        QueryWrapper query = new QueryWrapper();
        CaseInsensitiveMap dataMap = new CaseInsensitiveMap();
        if (iSearchContext.any() != null) {
            dataMap.putAll(iSearchContext.any());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("datacontext", dataMap);
        data.put("globalcontext", new HashMap());
        IUserContext iUserContext = UserContext.getCurrent();
        if (iUserContext != null && iUserContext instanceof IUserContextRuntime) {
            IUserContextRuntime iUserContextRuntime = (IUserContextRuntime)iUserContext;
            data.put("sessioncontext", iUserContextRuntime.getSessionParams());
        }
        data.put("systemcontext", new HashMap());
        data.put("webcontext", dataMap);
        net.ibizsys.central.plugin.mybatisplus.util.Page<?> page = MybatisSqlUtil.composePage(iSearchContext);
        GroupQuery groupQuery = MybatisSqlUtil.getGroupQuery(this, iSysDBSchemeRuntimeContext, iDataEntityRuntime, iPSDEDataSet, iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType(), iSearchContext);
        groupQuery.setDatasql(MybatisSqlUtil.convertSQL(groupQuery.getDatasql(), data, this.sqlSession));
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Map<String, Object>> resultPage = this.dbDataMapper.queryGroupData((IPage<?>)page, (Wrapper<?>)query, groupQuery, data);
        PageImpl newPage = new PageImpl(resultPage.getRecords(), (Pageable)(iSearchContext.getPageable() != null ? iSearchContext.getPageable() : PageRequest.of((int)0, (int)10)), resultPage.getTotal());
        return newPage;
    }

    public List<?> select(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext) throws Throwable {
        try {
            List items;
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            QueryWrapper query = new QueryWrapper();
            net.ibizsys.central.plugin.mybatisplus.util.Page<?> page = MybatisSqlUtil.composePage(iSearchContext);
            page.setSearchCount(false);
            CaseInsensitiveMap dataMap = new CaseInsensitiveMap();
            if (iSearchContext.any() != null) {
                dataMap.putAll(iSearchContext.any());
            }
            IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = iDataEntityRuntime.getDEDataQueryCodeRuntime(iPSDEDataQuery, iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType(), false);
            String sql = MybatisSqlUtil.composeDataQuery(this, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, (QueryWrapper<Object>)query);
            sql = sql.replace("#{srf.", "#{ctx.");
            if ((sql = sql.replace("${srf.", "#{ctx.")).indexOf("${srf") != -1) {
                sql = SqlCodeUtil.parse(sql);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("datacontext", dataMap);
            data.put("globalcontext", new HashMap());
            IUserContext iUserContext = UserContext.getCurrent();
            if (iUserContext != null && iUserContext instanceof IUserContextRuntime) {
                IUserContextRuntime iUserContextRuntime = (IUserContextRuntime)iUserContext;
                data.put("sessioncontext", iUserContextRuntime.getSessionParams());
            }
            data.put("systemcontext", SystemContextUtils.getInstance().getParams(null));
            data.put("webcontext", dataMap);
            sql = MybatisSqlUtil.convertSQL(sql, data, this.sqlSession);
            List list = items = this.dbDataMapper.queryData((IPage<?>)page, (Wrapper<?>)query, sql, data).getRecords();
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public Page<?> select2(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext) throws Throwable {
        try {
            PageImpl newPage;
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            QueryWrapper query = new QueryWrapper();
            net.ibizsys.central.plugin.mybatisplus.util.Page<?> page = MybatisSqlUtil.composePage(iSearchContext);
            CaseInsensitiveMap dataMap = new CaseInsensitiveMap();
            if (iSearchContext.any() != null) {
                dataMap.putAll(iSearchContext.any());
            }
            IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = iDataEntityRuntime.getDEDataQueryCodeRuntime(iPSDEDataQuery, iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDBType(), false);
            String sql = MybatisSqlUtil.composeDataQuery(this, iDataEntityRuntime, iDEDataQueryCodeRuntime, iSearchContext, (QueryWrapper<Object>)query);
            sql = sql.replace("#{srf.", "#{ctx.");
            if ((sql = sql.replace("${srf.", "#{ctx.")).indexOf("${srf") != -1) {
                sql = SqlCodeUtil.parse(sql);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("datacontext", dataMap);
            data.put("globalcontext", new HashMap());
            IUserContext iUserContext = UserContext.getCurrent();
            if (iUserContext != null && iUserContext instanceof IUserContextRuntime) {
                IUserContextRuntime iUserContextRuntime = (IUserContextRuntime)iUserContext;
                data.put("sessioncontext", iUserContextRuntime.getSessionParams());
            }
            data.put("systemcontext", SystemContextUtils.getInstance().getParams(null));
            data.put("webcontext", dataMap);
            sql = MybatisSqlUtil.convertSQL(sql, data, this.sqlSession);
            com.baomidou.mybatisplus.extension.plugins.pagination.Page<Map<String, Object>> resultPage = this.dbDataMapper.queryData((IPage<?>)page, (Wrapper<?>)query, sql, data);
            PageImpl pageImpl = newPage = new PageImpl(resultPage.getRecords(), (Pageable)(iSearchContext.getPageable() != null ? iSearchContext.getPageable() : PageRequest.of((int)0, (int)10)), resultPage.getTotal());
            return pageImpl;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public List<?> select(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, SqlCommandParam arg) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            List<Map<String, Object>> list = this.dbDataMapper.selectData(iSysDBTableRuntime, arg);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public Object selectOne(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, ISysDBTableRuntime iSysDBTableRuntime, SqlCommandParam arg) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            Object var4_4 = null;
            return var4_4;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SysDBSchemeRuntimeException(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    private Map<String, Object> convertListParam(List<Object> params) {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                mapParams.put(String.valueOf(i), params.get(i));
            }
        }
        return mapParams;
    }

    public List<?> executeSelectSQL(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, String strSQL, List<Object> params) throws Throwable {
        try {
            List<Map<String, Object>> datas;
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            Matcher m = this.pattern.matcher(strSQL);
            int i = 0;
            while (m.find()) {
                strSQL = strSQL.replaceFirst(this.regex, String.format("#{ctx.%s}", i));
                ++i;
            }
            List<Map<String, Object>> list = datas = this.dbDataMapper.queryData(null, strSQL, this.convertListParam(params));
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SystemRuntimeException((ISystemRuntimeBase)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getSystemRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public int executeSQL(ISysDBSchemeRuntimeContext iSysDBSchemeRuntimeContext, String strSQL, List<Object> params) throws Throwable {
        try {
            DBSchemeContextHolder.push(iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime());
            DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getDataSourceTag()));
            Matcher m = this.pattern.matcher(strSQL);
            int i = 0;
            while (m.find()) {
                strSQL = strSQL.replaceFirst(this.regex, String.format("#{ctx.%s}", i));
                ++i;
            }
            int n = this.dbDataMapper.updateBySQL(strSQL, this.convertListParam(params));
            return n;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new SystemRuntimeException((ISystemRuntimeBase)iSysDBSchemeRuntimeContext.getSysDBSchemeRuntime().getSystemRuntime(), "\u6570\u636e\u5e93\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", 1, (Throwable)e);
        }
        finally {
            DBSchemeContextHolder.poll();
            DynamicDataSourceContextHolder.poll();
        }
    }

    public String getConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext, IDBDialect iDBDialect) throws Throwable {
        return iDBDialect.getConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
    }

    public void push(ISysDBSchemeRuntime iSysDBSchemeRuntime) {
        DBSchemeContextHolder.push(iSysDBSchemeRuntime);
        DynamicDataSourceContextHolder.push((String)((String)iSysDBSchemeRuntime.getDataSourceTag()));
    }

    public void poll() {
        DBSchemeContextHolder.poll();
        DynamicDataSourceContextHolder.poll();
    }

    public ISysDBSchemeRuntime current() {
        return DBSchemeContextHolder.peek();
    }
}

