/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.mybatisplus.autoconfigure;

import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import net.ibizsys.central.plugin.mybatisplus.util.DynaDataSource;
import net.ibizsys.central.plugin.mybatisplus.util.MapKeyUpperWrapperFactory;
import net.ibizsys.central.plugin.mybatisplus.util.MybatisSqlUtil;
import net.ibizsys.central.plugin.mybatisplus.util.TenantSqlParser;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class})
@ComponentScan(value={"net.ibizsys.central.plugin.mybatisplus.spring"})
@MapperScan(value={"net.ibizsys.central.plugin.mybatisplus.spring"})
public class IBizMyBatisPlusPluginAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext = null;
    @Value(value="${ibiz.db.search.ignorecase:false}")
    private boolean searchIgnoreCase;
    @Autowired
    private DynamicDataSourceProperties properties;

    @Bean
    public ConfigurationCustomizer mybatisConfigurationCustomizer() {
        return configuration -> configuration.setObjectWrapperFactory((ObjectWrapperFactory)new MapKeyUpperWrapperFactory());
    }

    @Bean
    public DatabaseIdProvider getDatabaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties p = new Properties();
        p.setProperty("Oracle", "oracle");
        p.setProperty("MySQL", "mysql");
        p.setProperty("PostgreSQL", "postgresql");
        p.setProperty("DM", "oracle");
        p.setProperty("H2", "mysql");
        databaseIdProvider.setProperties(p);
        return databaseIdProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ibiz.tenant"}, havingValue="true", matchIfMissing=false)
    public net.ibizsys.central.plugin.mybatisplus.util.TenantHandler tenantHandler() {
        net.ibizsys.central.plugin.mybatisplus.util.TenantHandler tenantHandler = new net.ibizsys.central.plugin.mybatisplus.util.TenantHandler();
        return tenantHandler;
    }

    @Bean
    @ConditionalOnMissingBean
    public PaginationInterceptor paginationInterceptor(@Autowired(required=false) net.ibizsys.central.plugin.mybatisplus.util.TenantHandler tenantHandler) {
        MybatisSqlUtil.setSearchIgnoreCase((boolean)this.searchIgnoreCase);
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLimit(-1L);
        if (tenantHandler != null) {
            ArrayList<TenantSqlParser> sqlParserList = new ArrayList<TenantSqlParser>();
            TenantSqlParser tenantSqlParser = new TenantSqlParser();
            tenantSqlParser.setTenantHandler((TenantHandler)tenantHandler);
            sqlParserList.add(tenantSqlParser);
            paginationInterceptor.setSqlParserList(sqlParserList);
            paginationInterceptor.setSqlParserFilter(this.ignoreParserFilter());
        }
        paginationInterceptor.setCountSqlParser((ISqlParser)new JsqlParserCountOptimize(true));
        return paginationInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public ISqlParserFilter ignoreParserFilter() {
        return metaObject -> {
            MappedStatement ms = SqlParserHelper.getMappedStatement((MetaObject)metaObject);
            return false;
        };
    }

    @Bean
    public DataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider) {
        DynaDataSource dataSource = new DynaDataSource();
        dataSource.setPrimary(this.properties.getPrimary());
        dataSource.setStrategy(this.properties.getStrategy());
        dataSource.setProvider(dynamicDataSourceProvider);
        dataSource.setP6spy(this.properties.getP6spy());
        dataSource.setStrict(this.properties.getStrict());
        dataSource.setSeata(this.properties.getSeata());
        dataSource.setApplicationContext(this.applicationContext);
        return dataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

