/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.mongodb.ba;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntimeException;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.plugin.mongodb.util.codecs.BigIntegerCodec;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.codecs.BigDecimalCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoDBSchemeRuntime
extends SysBDSchemeRuntime {
    private static final Log log = LogFactory.getLog(MongoDBSchemeRuntime.class);
    public static final String BDTYPE_MONGODB = "MONGODB";
    public static final String UNIQUEKEY = "_id";
    private MongoClient mongoClient = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getMongoClient(true) == null) {
            this.prepareMongoClient();
        }
    }

    public MongoClient getMongoClient() {
        return this.getMongoClient(false);
    }

    public MongoClient getMongoClient(boolean bTryMode) {
        if (this.mongoClient != null || bTryMode) {
            return this.mongoClient;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("Mongo\u5ba2\u6237\u7aef\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    protected void prepareMongoClient() throws Exception {
        if (!StringUtils.hasLength((String)this.getServiceUrl())) {
            throw new Exception("\u672a\u5b9a\u4e49\u6570\u636e\u5e93\u5730\u5740");
        }
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new BigDecimalCodec(), new BigIntegerCodec()}), MongoClientSettings.getDefaultCodecRegistry()});
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().codecRegistry(codecRegistry).applyConnectionString(new ConnectionString(this.getServiceUrl())).build());
        this.setMongoClient(mongoClient);
    }

    protected void closeMongoClient() throws Exception {
        MongoClient mongoClient = this.getMongoClient(true);
        if (mongoClient != null) {
            mongoClient.close();
            this.setMongoClient(null);
        }
    }

    public MongoDatabase getMongoDatabase() {
        return this.getMongoClient().getDatabase(this.getDBName());
    }

    protected Object onInsert(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        MongoDatabase db;
        MongoCollection collection;
        Document document;
        String strId = null;
        Object objId = arg.get(UNIQUEKEY);
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            strId = this.getAutoId();
        }
        if ((document = (Document)(collection = (db = this.getMongoDatabase()).getCollection(this.getRealDBObjName(strTableName))).find(Filters.eq((String)UNIQUEKEY, (Object)strId)).first()) != null) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "", 6);
        }
        document = new Document();
        for (Map.Entry<String, Object> entry : arg.entrySet()) {
            document.put(this.getRealDBObjName(entry.getKey()), entry.getValue());
        }
        if (extParamMap != null) {
            for (Map.Entry<String, Object> entry : extParamMap.entrySet()) {
                document.put(this.getRealDBObjName(entry.getKey()), entry.getValue());
            }
        }
        document.remove((Object)this.getRealDBObjName(UNIQUEKEY));
        document.put(UNIQUEKEY, (Object)strId);
        String _id2 = null;
        try {
            _id2 = collection.insertOne((Object)document).getInsertedId().asString().getValue();
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5efa\u7acb\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (!strId.equals(_id2)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u5efa\u7acb\u6570\u636e\u5931\u8d25");
        }
        return _id2;
    }

    protected Object onUpdate(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        String strId = null;
        Object objId = arg.get(UNIQUEKEY);
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u66f4\u65b0\u6570\u636e\u672a\u6307\u5b9a\u952e\u503c");
        }
        MongoDatabase db = this.getMongoDatabase();
        MongoCollection collection = db.getCollection(this.getRealDBObjName(strTableName));
        Document document = new Document();
        for (Map.Entry<String, Object> entry : arg.entrySet()) {
            document.put(this.getRealDBObjName(entry.getKey()), entry.getValue());
        }
        if (extParamMap != null) {
            for (Map.Entry<String, Object> entry : extParamMap.entrySet()) {
                document.put(this.getRealDBObjName(entry.getKey()), entry.getValue());
            }
        }
        document.remove((Object)this.getRealDBObjName(UNIQUEKEY));
        document.put(UNIQUEKEY, (Object)strId);
        try {
            if (!bAppendMode) {
                collection.findOneAndDelete(Filters.eq((String)UNIQUEKEY, (Object)strId));
                String _id2 = collection.insertOne((Object)document).getInsertedId().asString().getValue();
                if (!strId.equals(_id2)) {
                    throw new Exception("\u6570\u636e\u4e0d\u4e00\u81f4");
                }
            } else {
                UpdateResult updateResult = collection.updateOne(Filters.eq((String)UNIQUEKEY, (Object)strId), (Bson)new Document("$set", (Object)document));
                if (updateResult.getMatchedCount() == 0L && updateResult.getModifiedCount() == 0L) {
                    throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6570\u636e\u4e0d\u5b58\u5728");
                }
            }
            return 1;
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected Object onDelete(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        String strId = null;
        Object objId = arg.get(UNIQUEKEY);
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u5220\u9664\u6570\u636e\u672a\u6307\u5b9a\u952e\u503c");
        }
        MongoDatabase db = this.getMongoDatabase();
        MongoCollection collection = db.getCollection(this.getRealDBObjName(strTableName));
        try {
            DeleteResult deleteResult = collection.deleteOne(Filters.eq((String)UNIQUEKEY, (Object)strId));
            if (deleteResult.getDeletedCount() == 0L) {
                throw new Exception("\u6570\u636e\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        return 1;
    }

    protected List onQuery(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        MongoCursor it;
        Bson bson;
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        Document sortInfo = null;
        int nSkip = 0;
        int nLimit = Integer.MAX_VALUE;
        ArrayList<Bson> andlist = new ArrayList<Bson>();
        if (iSearchContext != null) {
            List searchConds;
            Iterator orders;
            if (iSearchContext.getPageSort() != null && iSearchContext.getPageSort().isSorted() && (orders = iSearchContext.getPageSort().iterator()).hasNext()) {
                Sort.Order order = (Sort.Order)orders.next();
                sortInfo = new Document(this.getRealDBObjName(order.getProperty()), (Object)(order.isAscending() ? 1 : -1));
            }
            if (iSearchContext.getPageable() != null && iSearchContext.getPageable().isPaged()) {
                nLimit = iSearchContext.getPageable().getPageSize();
                nSkip = (iSearchContext.getPageable().getPageNumber() - 0) * nLimit;
            }
            if ((searchConds = iSearchContext.getSearchConds()) != null) {
                for (ISearchCond item : searchConds) {
                    Bson bson2 = this.getBson(item, iSearchContext, iDataEntityRuntime);
                    if (bson2 == null) continue;
                    andlist.add(bson2);
                }
            }
        }
        if (iDataEntityRuntime.isEnableLogicValid() && (bson = this.getBson(this.getRealDBObjName(iDataEntityRuntime.getLogicValidPSDEField().getName()), "EQ", iDataEntityRuntime.getValidLogicValue(), iDataEntityRuntime)) != null) {
            andlist.add(bson);
        }
        if (iPSDEDataQuery.getPSDEDQMain() != null && iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() != null && (bson = this.getBson((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) != null) {
            andlist.add(bson);
        }
        if (sortInfo == null) {
            sortInfo = new Document(UNIQUEKEY, (Object)-1);
        }
        List selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(UNIQUEKEY);
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(this.getRealDBObjName(t.getName())));
        }
        MongoDatabase db = this.getMongoDatabase();
        MongoCollection collection = db.getCollection(this.getRealDBObjName(strTableName));
        FindIterable documents = null;
        try {
            documents = andlist.size() > 0 ? collection.find(Filters.and(andlist)).projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit) : collection.find().projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit);
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (documents != null && (it = documents.iterator()) != null) {
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                Document doc = (Document)it.next();
                HashMap map = new HashMap();
                map.putAll(doc);
                list.add(map);
            }
            return list;
        }
        return null;
    }

    protected Page onQuery2(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        MongoCursor it;
        Bson bson;
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        Document sortInfo = null;
        int nSkip = 0;
        int nLimit = Integer.MAX_VALUE;
        ArrayList<Bson> andlist = new ArrayList<Bson>();
        if (iSearchContext != null) {
            List searchConds;
            Iterator orders;
            if (iSearchContext.getPageSort() != null && iSearchContext.getPageSort().isSorted() && (orders = iSearchContext.getPageSort().iterator()).hasNext()) {
                Sort.Order order = (Sort.Order)orders.next();
                sortInfo = new Document(this.getRealDBObjName(order.getProperty()), (Object)(order.isAscending() ? 1 : -1));
            }
            if (iSearchContext.getPageable() != null && iSearchContext.getPageable().isPaged()) {
                nLimit = iSearchContext.getPageable().getPageSize();
                nSkip = (iSearchContext.getPageable().getPageNumber() - 0) * nLimit;
            }
            if ((searchConds = iSearchContext.getSearchConds()) != null) {
                for (ISearchCond item : searchConds) {
                    Bson bson2 = this.getBson(item, iSearchContext, iDataEntityRuntime);
                    if (bson2 == null) continue;
                    andlist.add(bson2);
                }
            }
        }
        if (iDataEntityRuntime.isEnableLogicValid() && (bson = this.getBson(this.getRealDBObjName(iDataEntityRuntime.getLogicValidPSDEField().getName()), "EQ", iDataEntityRuntime.getValidLogicValue(), iDataEntityRuntime)) != null) {
            andlist.add(bson);
        }
        if (iPSDEDataQuery.getPSDEDQMain() != null && iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() != null && (bson = this.getBson((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) != null) {
            andlist.add(bson);
        }
        if (sortInfo == null) {
            sortInfo = new Document(UNIQUEKEY, (Object)-1);
        }
        List selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(UNIQUEKEY);
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(this.getRealDBObjName(t.getName())));
        }
        MongoDatabase db = this.getMongoDatabase();
        MongoCollection collection = db.getCollection(this.getRealDBObjName(strTableName));
        FindIterable documents = null;
        try {
            documents = andlist.size() > 0 ? collection.find(Filters.and(andlist)).projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit) : collection.find().projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit);
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        ArrayList list = new ArrayList();
        if (documents != null && (it = documents.iterator()) != null) {
            while (it.hasNext()) {
                Document doc = (Document)it.next();
                HashMap map = new HashMap();
                map.putAll(doc);
                list.add(map);
            }
        }
        long nTotal = list == null ? 0 : list.size();
        nTotal = iSearchContext.isCount() ? (nTotal >= (long)nLimit ? (andlist.size() > 0 ? collection.countDocuments(Filters.and(andlist)) : collection.countDocuments()) : (nTotal += (long)nSkip)) : (nTotal += (long)nSkip);
        return new PageImpl(list, iSearchContext != null && iSearchContext.getPageable() != null ? iSearchContext.getPageable() : Pageable.unpaged(), nTotal);
    }

    protected Page onFetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        MongoCursor it;
        Bson bson;
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        Document sortInfo = null;
        int nSkip = 0;
        int nLimit = 1000;
        ArrayList<Bson> andlist = new ArrayList<Bson>();
        if (iSearchContext != null) {
            List searchConds;
            Iterator orders;
            if (iSearchContext.getPageSort() != null && iSearchContext.getPageSort().isSorted() && (orders = iSearchContext.getPageSort().iterator()).hasNext()) {
                Sort.Order order = (Sort.Order)orders.next();
                sortInfo = new Document(this.getRealDBObjName(order.getProperty()), (Object)(order.isAscending() ? 1 : -1));
            }
            if (iSearchContext.getPageable() != null && iSearchContext.getPageable().isPaged()) {
                nLimit = iSearchContext.getPageable().getPageSize();
                nSkip = (iSearchContext.getPageable().getPageNumber() - 0) * nLimit;
            }
            if ((searchConds = iSearchContext.getSearchConds()) != null) {
                for (ISearchCond item : searchConds) {
                    Bson bson2 = this.getBson(item, iSearchContext, iDataEntityRuntime);
                    if (bson2 == null) continue;
                    andlist.add(bson2);
                }
            }
        }
        if (iDataEntityRuntime.isEnableLogicValid() && (bson = this.getBson(this.getRealDBObjName(iDataEntityRuntime.getLogicValidPSDEField().getName()), "EQ", iDataEntityRuntime.getValidLogicValue(), iDataEntityRuntime)) != null) {
            andlist.add(bson);
        }
        List selectedPSDEFieldList = null;
        List psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
        if (!ObjectUtils.isEmpty((Object)psDEDataQueryList)) {
            ArrayList<Bson> orlist = new ArrayList<Bson>();
            for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
                Bson bson3;
                if (selectedPSDEFieldList == null) {
                    selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
                }
                if (iPSDEDataQuery.getPSDEDQMain() == null || iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() == null || (bson3 = this.getBson((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) == null) continue;
                orlist.add(bson3);
            }
            if (!ObjectUtils.isEmpty(orlist)) {
                andlist.add(Filters.or(orlist));
            }
        }
        if (sortInfo == null) {
            sortInfo = new Document(UNIQUEKEY, (Object)-1);
        }
        if (selectedPSDEFieldList == null) {
            selectedPSDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(UNIQUEKEY);
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(this.getRealDBObjName(t.getName())));
        }
        MongoDatabase db = this.getMongoDatabase();
        MongoCollection collection = db.getCollection(this.getRealDBObjName(strTableName));
        FindIterable documents = null;
        try {
            documents = andlist.size() > 0 ? collection.find(Filters.and(andlist)).projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit) : collection.find().projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit);
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u83b7\u53d6\u7ed3\u679c\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        ArrayList list = new ArrayList();
        if (documents != null && (it = documents.iterator()) != null) {
            while (it.hasNext()) {
                Document doc = (Document)it.next();
                HashMap map = new HashMap();
                map.putAll(doc);
                list.add(map);
            }
        }
        long nTotal = list == null ? 0 : list.size();
        nTotal = iSearchContext.isCount() ? (nTotal >= (long)nLimit ? (andlist.size() > 0 ? collection.countDocuments(Filters.and(andlist)) : collection.countDocuments()) : (nTotal += (long)nSkip)) : (nTotal += (long)nSkip);
        return new PageImpl(list, iSearchContext != null && iSearchContext.getPageable() != null ? iSearchContext.getPageable() : Pageable.unpaged(), nTotal);
    }

    protected Page onFetch(String strTableName, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        MongoCursor it;
        Document sortInfo = null;
        int nSkip = 0;
        int nLimit = 1000;
        ArrayList<Bson> andlist = new ArrayList<Bson>();
        if (iSearchContext != null) {
            List searchConds;
            Iterator orders;
            if (iSearchContext.getPageSort() != null && iSearchContext.getPageSort().isSorted() && (orders = iSearchContext.getPageSort().iterator()).hasNext()) {
                Sort.Order order = (Sort.Order)orders.next();
                sortInfo = new Document(this.getRealDBObjName(order.getProperty()), (Object)(order.isAscending() ? 1 : -1));
            }
            if (iSearchContext.getPageable() != null && iSearchContext.getPageable().isPaged()) {
                nLimit = iSearchContext.getPageable().getPageSize();
                nSkip = (iSearchContext.getPageable().getPageNumber() - 0) * nLimit;
            }
            if ((searchConds = iSearchContext.getSearchConds()) != null) {
                for (ISearchCond item : searchConds) {
                    Bson bson = this.getBson(item, iSearchContext);
                    if (bson == null) continue;
                    andlist.add(bson);
                }
            }
        }
        if (sortInfo == null) {
            sortInfo = new Document(UNIQUEKEY, (Object)-1);
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        if (!ObjectUtils.isEmpty((Object[])outputFields)) {
            fieldList.add(UNIQUEKEY);
            for (Sort.Order strField : outputFields) {
                fieldList.add((String)strField);
            }
        }
        MongoDatabase db = this.getMongoDatabase();
        MongoCollection collection = db.getCollection(this.getRealDBObjName(strTableName));
        FindIterable documents = null;
        try {
            documents = !ObjectUtils.isEmpty(fieldList) ? (andlist.size() > 0 ? collection.find(Filters.and(andlist)).projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit) : collection.find().projection(Projections.include(fieldList)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit)) : (andlist.size() > 0 ? collection.find(Filters.and(andlist)).skip(nSkip).sort((Bson)sortInfo).limit(nLimit) : collection.find().skip(nSkip).sort((Bson)sortInfo).limit(nLimit));
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        ArrayList list = new ArrayList();
        if (documents != null && (it = documents.iterator()) != null) {
            while (it.hasNext()) {
                Document doc = (Document)it.next();
                HashMap map = new HashMap();
                map.putAll(doc);
                list.add(map);
            }
        }
        long nTotal = list == null ? 0 : list.size();
        nTotal = iSearchContext.isCount() ? (nTotal >= (long)nLimit ? (andlist.size() > 0 ? collection.countDocuments(Filters.and(andlist)) : collection.countDocuments()) : (nTotal += (long)nSkip)) : (nTotal += (long)nSkip);
        return new PageImpl(list, iSearchContext != null && iSearchContext.getPageable() != null ? iSearchContext.getPageable() : Pageable.unpaged(), nTotal);
    }

    protected Bson getBson(IPSDEDQCondition iPSDEDQCondition, Map<String, Object> params, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
            ArrayList<Bson> bsonList = new ArrayList<Bson>();
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            List psDEDQConditions = iPSDEDQGroupCondition.getPSDEDQConditions();
            if (psDEDQConditions != null) {
                for (IPSDEDQCondition item : psDEDQConditions) {
                    Bson bson = this.getBson(item, params, iDataEntityRuntime);
                    if (bson == null) continue;
                    bsonList.add(bson);
                }
            }
            if (bsonList.size() > 0) {
                if (iPSDEDQGroupCondition.isNotMode()) {
                    if ("AND".equals(iPSDEDQGroupCondition.getCondOp())) {
                        return Filters.not((Bson)Filters.and(bsonList));
                    }
                    return Filters.not((Bson)Filters.or(bsonList));
                }
                if ("AND".equals(iPSDEDQGroupCondition.getCondOp())) {
                    return Filters.and(bsonList);
                }
                return Filters.or(bsonList);
            }
            return null;
        }
        if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            String strVarType = iPSDEDQFieldCondition.getPSVARTypeId();
            if (StringUtils.hasLength((String)strVarType)) {
                Object objValue = null;
                if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getCondValue())) {
                    objValue = params == null ? null : params.get(iPSDEDQFieldCondition.getCondValue().toLowerCase());
                }
                return this.getBson(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue, iDataEntityRuntime);
            }
            Object objValue = iPSDEDQFieldCondition.getCondValue();
            IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(iPSDEDQFieldCondition.getFieldName(), true);
            if (iPSDEField != null) {
                objValue = iDataEntityRuntime.convertValue(iPSDEField.getStdDataType(), (String)objValue);
            }
            return this.getBson(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue, iDataEntityRuntime);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iPSDEDQCondition.getCondType()));
    }

    protected Bson getBson(ISearchCond iSearchCond, ISearchContext iSearchContext) throws Throwable {
        return this.getBson(iSearchCond, iSearchContext, null);
    }

    protected Bson getBson(ISearchCond iSearchCond, ISearchContext iSearchContext, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (iSearchCond instanceof ISearchGroupCond) {
            ArrayList<Bson> bsonList = new ArrayList<Bson>();
            ISearchGroupCond iSearchGroupCond = (ISearchGroupCond)iSearchCond;
            List searchConds = iSearchGroupCond.getSearchConds();
            if (searchConds != null) {
                for (ISearchCond item : searchConds) {
                    Bson bson = this.getBson(item, iSearchContext, iDataEntityRuntime);
                    if (bson == null) continue;
                    bsonList.add(bson);
                }
            }
            if (bsonList.size() > 0) {
                if (iSearchGroupCond.isNotMode()) {
                    if ("AND".equals(iSearchGroupCond.getCondOp())) {
                        return Filters.not((Bson)Filters.and(bsonList));
                    }
                    return Filters.not((Bson)Filters.or(bsonList));
                }
                if ("AND".equals(iSearchGroupCond.getCondOp())) {
                    return Filters.and(bsonList);
                }
                return Filters.or(bsonList);
            }
            return null;
        }
        if (iSearchCond instanceof ISearchFieldCond) {
            ISearchFieldCond iSearchFieldCond = (ISearchFieldCond)iSearchCond;
            Object objValue = iSearchFieldCond.getValue();
            if (objValue == null) {
                return null;
            }
            if (iSearchFieldCond.isParamMode()) {
                objValue = iSearchContext.get(objValue.toString());
            }
            return this.getBson(iSearchFieldCond.getFieldName(), iSearchFieldCond.getCondOp(), objValue, iDataEntityRuntime);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iSearchCond.getCondType()));
    }

    protected Bson getBson(String strFieldName, String strCondition, Object objValue, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (StringUtils.hasLength((String)strFieldName)) {
            IPSDEField iPSDEField;
            strFieldName = this.getRealDBObjName(strFieldName);
            if (iDataEntityRuntime != null && (iPSDEField = iDataEntityRuntime.getPSDEField(strFieldName, true)) != null && iPSDEField.isKeyDEField()) {
                strFieldName = UNIQUEKEY;
            }
        } else {
            throw new Exception("\u672a\u6307\u5b9a\u5c5e\u6027\u6807\u8bc6");
        }
        if ("EQ".equals(strCondition) || "ABSEQ".equals(strCondition)) {
            return Filters.eq((String)strFieldName, (Object)objValue);
        }
        if ("GT".equals(strCondition)) {
            return Filters.gt((String)strFieldName, (Object)objValue);
        }
        if ("GTANDEQ".equals(strCondition)) {
            return Filters.gte((String)strFieldName, (Object)objValue);
        }
        if ("LT".equals(strCondition)) {
            return Filters.lt((String)strFieldName, (Object)objValue);
        }
        if ("LTANDEQ".equals(strCondition)) {
            return Filters.lte((String)strFieldName, (Object)objValue);
        }
        if ("NOTEQ".equals(strCondition)) {
            return Filters.ne((String)strFieldName, (Object)objValue);
        }
        if ("ISNULL".equals(strCondition)) {
            return Filters.eq((String)strFieldName, null);
        }
        if ("ISNOTNULL".equals(strCondition)) {
            return Filters.ne((String)strFieldName, null);
        }
        if ("LIKE".equals(strCondition)) {
            if (objValue != null && objValue instanceof String) {
                return Filters.regex((String)strFieldName, (String)((String)objValue), (String)"i");
            }
            if (objValue != null) {
                return Filters.regex((String)strFieldName, (String)objValue.toString(), (String)"i");
            }
            return null;
        }
        if ("LEFTLIKE".equals(strCondition)) {
            if (objValue != null && objValue instanceof String) {
                return Filters.regex((String)strFieldName, (String)("^" + (String)objValue), (String)"i");
            }
            if (objValue != null) {
                return Filters.regex((String)strFieldName, (String)("^" + objValue.toString()), (String)"i");
            }
            return null;
        }
        if ("RIGHTLIKE".equals(strCondition)) {
            if (objValue != null && objValue instanceof String) {
                return Filters.regex((String)strFieldName, (String)((String)objValue + "^"), (String)"i");
            }
            if (objValue != null) {
                return Filters.regex((String)strFieldName, (String)(objValue.toString() + "^"), (String)"i");
            }
            return null;
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6761\u4ef6\u64cd\u4f5c[%1$s]", strCondition));
    }

    protected String getAutoId() {
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS%2$s", new Date(), KeyValueUtils.genUniqueId());
    }

    protected void onShutdown() throws Exception {
        try {
            this.closeMongoClient();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u5173\u95ed\u5ba2\u6237\u7aef\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        super.onShutdown();
    }
}

