/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.liquibase.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.core.EmptyChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.core.database.ISysDBSchemeSyncAdapter;
import net.ibizsys.central.cloud.core.util.domain.DataSource;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.plugin.liquibase.util.DiffToChangeLogEx;
import net.ibizsys.model.database.IPSSysDBColumn;
import net.ibizsys.model.database.IPSSysDBIndex;
import net.ibizsys.model.database.IPSSysDBIndexColumn;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.database.IPSSysDBTable;
import net.ibizsys.model.res.IPSSysContent;
import net.ibizsys.model.res.IPSSysContentCat;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.DataTypes;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class LiquibaseTool
implements ISysDBSchemeSyncAdapter {
    private static final Log log = LogFactory.getLog(LiquibaseTool.class);
    private static Map<String, String> dataTypeMap = new HashMap<String, String>();
    public static final String LIQUIBASE_CHANGELOGS_PREFIX = "LIQUIBASE_CHANGELOGS__";
    public static final String SNAPSHOTID = "iBizCloud";

    public static void registerDataType(String strKey, String strDataType) {
        dataTypeMap.put(strKey, strDataType);
    }

    public static String getDataType(String strKey) {
        return dataTypeMap.get(strKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(ISystemRuntime iSystemRuntime, ISysDBSchemeRuntime iSysDBSchemeRuntime, DataSource dataSource, Object objTag) throws Throwable {
        String strChangelogFile;
        List psSysContentList;
        String strModelTag;
        IPSSysDBScheme iPSSysDBScheme = iSysDBSchemeRuntime.getPSSysDBScheme();
        if (!iSysDBSchemeRuntime.isUpdateSchema()) {
            log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u6570\u636e\u5e93[%2$s]\u672a\u542f\u7528\u6a21\u578b\u66f4\u65b0", iSystemRuntime.getDeploySystemId(), iSysDBSchemeRuntime.getDSLink()));
            return;
        }
        List psSysDBTableList = iPSSysDBScheme.getAllPSSysDBTables();
        if (ObjectUtils.isEmpty((Object)psSysDBTableList)) {
            log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u6570\u636e\u5e93[%2$s]\u672a\u5305\u542b\u4efb\u4f55\u6570\u636e\u8868", iSystemRuntime.getDeploySystemId(), iSysDBSchemeRuntime.getDSLink()));
            return;
        }
        String strFolder = String.format("%1$s%2$schangelogs", iSystemRuntime.getFileFolder(), File.separator);
        File folder = new File(strFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        LinkedHashMap<String, String> changeLogFileMap = new LinkedHashMap<String, String>();
        FileSystemResourceAccessor resourceAccessor = new FileSystemResourceAccessor();
        String strDefaultModelTag = null;
        String strModelDigest = KeyValueUtils.genUniqueId((Object)iPSSysDBScheme.getObjectNode().toString());
        strDefaultModelTag = strModelTag = String.format("%1$s-%2$s-%3$s", iSystemRuntime.getDeploySystemId(), iPSSysDBScheme.getDSLink(), strModelDigest).toLowerCase();
        String strChangelogFile2 = String.format("%1$s%2$s%3$s.xml", strFolder, File.separator, strModelTag);
        changeLogFileMap.put(strChangelogFile2, strModelTag);
        Iterator file = new File(strChangelogFile2);
        if (((File)((Object)file)).exists()) {
            Database targetDatabase = null;
            try (Liquibase liquibase = new Liquibase(strChangelogFile2, (ResourceAccessor)resourceAccessor, targetDatabase);){
                if (ObjectUtils.isEmpty((Object)liquibase.getDatabaseChangeLog()) || ObjectUtils.isEmpty((Object)liquibase.getDatabaseChangeLog().getChangeSets())) {
                    log.debug((Object)String.format("\u53d8\u66f4\u6587\u4ef6[%1$s]\u672a\u5305\u542b\u4efb\u4f55\u64cd\u4f5c\uff0c\u5ffd\u7565", strChangelogFile2));
                    changeLogFileMap.remove(strChangelogFile2);
                }
            }
        }
        String strContentCatTag = String.format("%1$s%2$s", LIQUIBASE_CHANGELOGS_PREFIX, iPSSysDBScheme.getDSLink());
        IPSSysContentCat iPSSysContentCat = iSystemRuntime.getPSSystemService().getPSSysContentCat(strContentCatTag, true);
        if (iPSSysContentCat != null && !ObjectUtils.isEmpty((Object)(psSysContentList = iPSSysContentCat.getPSSysContents()))) {
            for (IPSSysContent iPSSysContent : psSysContentList) {
                if (!StringUtils.hasLength((String)iPSSysContent.getCodeName())) {
                    log.warn((Object)String.format("\u9884\u7f6e\u5185\u5bb9\u9879[%1$s]\u672a\u5b9a\u4e49\u4ee3\u7801\u6807\u8bc6\uff0c\u5ffd\u7565", iPSSysContent.getName()));
                    continue;
                }
                String strModelTag2 = String.format("%1$s-%2$s-user-%3$s", iSystemRuntime.getDeploySystemId(), iPSSysDBScheme.getDSLink(), iPSSysContent.getCodeName()).toLowerCase();
                strChangelogFile = String.format("%1$s%2$s%3$s.xml", strFolder, File.separator, strModelTag2);
                File file2 = new File(strChangelogFile);
                if (!file2.exists()) {
                    String strContent = iPSSysContent.getContent();
                    if (!StringUtils.hasLength((String)strContent)) {
                        log.warn((Object)String.format("\u9884\u7f6e\u5185\u5bb9\u9879[%1$s]\u672a\u5b9a\u4e49\u5185\u5bb9\uff0c\u5ffd\u7565", iPSSysContent.getName()));
                        continue;
                    }
                    FileUtils.writeStringToFile((File)file2, (String)strContent, (String)"UTF-8");
                }
                changeLogFileMap.put(strChangelogFile, strModelTag2);
            }
        }
        if (changeLogFileMap.size() == 0) {
            log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u6570\u636e\u5e93[%2$s]\u672a\u5b9a\u4e49\u53d8\u66f4\u6587\u4ef6", iSystemRuntime.getDeploySystemId(), iSysDBSchemeRuntime.getDSLink()));
            return;
        }
        HashMap<Object, Boolean> tagExistsMap = new HashMap<Object, Boolean>();
        for (Map.Entry entry : changeLogFileMap.entrySet()) {
            tagExistsMap.put(entry.getValue(), false);
        }
        boolean bFirst = true;
        for (Map.Entry entry : changeLogFileMap.entrySet()) {
            boolean bHasTag;
            strChangelogFile = (String)entry.getKey();
            String strModelTag3 = (String)entry.getValue();
            if (!bFirst && (bHasTag = ((Boolean)tagExistsMap.get(strModelTag3)).booleanValue())) {
                log.debug((Object)String.format("\u53d8\u66f4\u6587\u4ef6[%1$s]\u6807\u8bb0\u5df2\u64cd\u4f5c[%2$s]\uff0c\u5ffd\u7565", strChangelogFile, strModelTag3));
                continue;
            }
            File file3 = new File(strChangelogFile);
            if (!file3.exists() && !strDefaultModelTag.equals(strModelTag3)) {
                log.warn((Object)String.format("\u53d8\u66f4\u6587\u4ef6[%1$s]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565", strChangelogFile));
                continue;
            }
            Database targetDatabase = CommandLineUtils.createDatabaseObject((ResourceAccessor)resourceAccessor, (String)dataSource.getJdbcUrl(), (String)dataSource.getUsername(), (String)dataSource.getPassword(), (String)dataSource.getDriverClassName(), (String)"", (String)"", (boolean)false, (boolean)false, null, null, null, null, null, null, null);
            try {
                Liquibase liquibase = new Liquibase(strChangelogFile, (ResourceAccessor)resourceAccessor, targetDatabase);
                Throwable throwable = null;
                try {
                    boolean bHasTag2;
                    if (bFirst) {
                        bFirst = false;
                        for (String strTag : tagExistsMap.keySet()) {
                            boolean bExists = liquibase.tagExists(strTag);
                            tagExistsMap.put(strTag, bExists);
                        }
                    }
                    if (!(bHasTag2 = ((Boolean)tagExistsMap.get(strModelTag3)).booleanValue())) {
                        DatabaseChangeLog databaseChangeLog;
                        if (!file3.exists()) {
                            String strTypes = "Column,Table";
                            String strTypes2 = "Column,Table,Index,ForeignKey,Index,PrimaryKey";
                            SnapshotControl snapshotControl = new SnapshotControl(targetDatabase, strTypes);
                            ObjectQuotingStrategy originalStrategy = targetDatabase.getObjectQuotingStrategy();
                            DatabaseSnapshot databaseSnapshot = null;
                            try {
                                targetDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
                                databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(CatalogAndSchema.DEFAULT, targetDatabase, snapshotControl);
                                Set tables = databaseSnapshot.get(Table.class);
                                Set columns = databaseSnapshot.get(Column.class);
                                HashMap<String, Object> tableMap = new HashMap<String, Object>();
                                if (!ObjectUtils.isEmpty((Object)tables)) {
                                    for (Object table : tables) {
                                        tableMap.put(table.getName().toUpperCase(), table);
                                    }
                                }
                                HashMap<String, Object> columnMap = new HashMap<String, Object>();
                                if (!ObjectUtils.isEmpty((Object)columns)) {
                                    Object table;
                                    table = columns.iterator();
                                    while (table.hasNext()) {
                                        Column column = (Column)table.next();
                                        columnMap.put(String.format("%1$s.%2$s", column.getRelation().getName(), column.getName()).toUpperCase(), column);
                                    }
                                }
                                snapshotControl.addType(Index.class, targetDatabase);
                                DiffResult diffResult = new DiffResult(databaseSnapshot, databaseSnapshot, new CompareControl(null, strTypes2));
                                for (IPSSysDBTable iPSSysDBTable : psSysDBTableList) {
                                    List psSysDBIndexList;
                                    List psSysDBColumnList = iPSSysDBTable.getAllPSSysDBColumns();
                                    if (ObjectUtils.isEmpty((Object)psSysDBColumnList)) continue;
                                    Table table = new Table(null, null, iPSSysDBTable.getName());
                                    table.setSnapshotId(SNAPSHOTID);
                                    ArrayList<Column> keyList = new ArrayList<Column>();
                                    for (IPSSysDBColumn iPSSysDBColumn : psSysDBColumnList) {
                                        int nStdDataType;
                                        String strTypeKey;
                                        String strType;
                                        Object column = new Column(iPSSysDBColumn.getName());
                                        column.setRelation((Relation)table);
                                        if (iPSSysDBColumn.isPKey() || !iPSSysDBColumn.isNullable()) {
                                            column.setNullable(Boolean.valueOf(false));
                                        }
                                        table.addColumn((Column)column);
                                        if (iPSSysDBColumn.isPKey()) {
                                            keyList.add((Column)column);
                                        }
                                        if (StringUtils.hasLength((String)(strType = iPSSysDBColumn.getDataType()))) {
                                            int nPos = strType.indexOf("(");
                                            if (nPos != -1) {
                                                strType = strType.substring(0, nPos);
                                            }
                                            if (StringUtils.hasLength((String)(strType = strType.trim()))) {
                                                column.setType(new DataType(strType));
                                                if (iPSSysDBColumn.getLength() > 0) {
                                                    column.getType().setColumnSize(Integer.valueOf(iPSSysDBColumn.getLength()));
                                                    if (iPSSysDBColumn.getPrecision() > 0) {
                                                        column.getType().setDecimalDigits(Integer.valueOf(iPSSysDBColumn.getPrecision()));
                                                    }
                                                }
                                                if (!iPSSysDBColumn.isPKey() || !iPSSysDBColumn.isAutoIncrement()) continue;
                                                column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                                                continue;
                                            }
                                        }
                                        if (dataTypeMap.containsKey(strTypeKey = String.format("%1$s.%2$s", strType = DataTypes.toString((int)(nStdDataType = iPSSysDBColumn.getStdDataType())), targetDatabase.getShortName()).toUpperCase())) {
                                            strType = dataTypeMap.get(strTypeKey);
                                        } else if (dataTypeMap.containsKey(strType)) {
                                            strType = dataTypeMap.get(strType);
                                        }
                                        column.setType(new DataType(strType));
                                        if (DataTypeUtils.isStringDataType((int)nStdDataType)) {
                                            if (DataTypeUtils.isLongStringDataType((int)nStdDataType) || iPSSysDBColumn.getLength() <= 0) continue;
                                            column.getType().setColumnSize(Integer.valueOf(iPSSysDBColumn.getLength()));
                                            continue;
                                        }
                                        if (DataTypeUtils.isDoubleDataType((int)nStdDataType)) {
                                            if (iPSSysDBColumn.getLength() > 0) {
                                                column.getType().setColumnSize(Integer.valueOf(iPSSysDBColumn.getLength()));
                                            }
                                            if (iPSSysDBColumn.getPrecision() <= 0) continue;
                                            if (iPSSysDBColumn.getLength() <= 0) {
                                                column.getType().setColumnSize(Integer.valueOf(10 + iPSSysDBColumn.getPrecision()));
                                            }
                                            column.getType().setDecimalDigits(Integer.valueOf(iPSSysDBColumn.getPrecision()));
                                            continue;
                                        }
                                        if (!DataTypeUtils.isIntDataType((int)nStdDataType)) continue;
                                        if (iPSSysDBColumn.isPKey() && iPSSysDBColumn.isAutoIncrement()) {
                                            column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                                        }
                                        if (iPSSysDBColumn.getLength() <= 0) continue;
                                        column.getType().setColumnSize(Integer.valueOf(iPSSysDBColumn.getLength()));
                                    }
                                    if (!tableMap.containsKey(table.getName().toUpperCase())) {
                                        diffResult.addMissingObject((DatabaseObject)table);
                                        PrimaryKey primaryKey = new PrimaryKey();
                                        primaryKey.setSnapshotId(SNAPSHOTID);
                                        for (int i = 0; i < keyList.size(); ++i) {
                                            primaryKey.addColumn(i, (Column)keyList.get(i));
                                        }
                                        primaryKey.setTable(table);
                                        diffResult.addMissingObject((DatabaseObject)primaryKey);
                                        tableMap.put(table.getName().toUpperCase(), table);
                                        List columnList = table.getColumns();
                                        if (!ObjectUtils.isEmpty((Object)columnList)) {
                                            for (Column column : columnList) {
                                                String strTag = String.format("%1$s.%2$s", column.getRelation().getName(), column.getName()).toUpperCase();
                                                if (columnMap.containsKey(strTag)) continue;
                                                columnMap.put(strTag, column);
                                            }
                                        }
                                    } else {
                                        List columnList = table.getColumns();
                                        if (!ObjectUtils.isEmpty((Object)columnList)) {
                                            for (Object column : columnList) {
                                                String strTag = String.format("%1$s.%2$s", column.getRelation().getName(), column.getName()).toUpperCase();
                                                if (columnMap.containsKey(strTag)) continue;
                                                diffResult.addMissingObject((DatabaseObject)column);
                                                columnMap.put(strTag, column);
                                            }
                                        }
                                    }
                                    if (ObjectUtils.isEmpty((Object)(psSysDBIndexList = iPSSysDBTable.getAllPSSysDBIndices()))) continue;
                                    for (IPSSysDBIndex iPSSysDBIndex : psSysDBIndexList) {
                                        Index index = new Index(iPSSysDBIndex.getCodeName());
                                        index.setSnapshotId(SNAPSHOTID);
                                        index.setRelation((Relation)table);
                                        List psSysDBIndexColumnList = iPSSysDBIndex.getAllPSSysDBIndexColumns();
                                        if (!ObjectUtils.isEmpty((Object)psSysDBIndexColumnList)) {
                                            for (IPSSysDBIndexColumn iPSSysDBIndexColumn : psSysDBIndexColumnList) {
                                                String strTag = String.format("%1$s.%2$s", table.getName(), iPSSysDBIndexColumn.getName()).toUpperCase();
                                                Column column = (Column)columnMap.get(strTag);
                                                if (column == null) {
                                                    log.error((Object)String.format("\u6570\u636e\u5217[%1$s.%2$s]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u52a0\u5165\u7d22\u5f15[%3$s]", table.getName(), iPSSysDBIndexColumn.getName(), iPSSysDBIndex.getCodeName()));
                                                    continue;
                                                }
                                                index.addColumn(column);
                                            }
                                        }
                                        if (iPSSysDBIndex.getRemoveFlag()) {
                                            diffResult.addUnexpectedObject((DatabaseObject)index);
                                            continue;
                                        }
                                        if (ObjectUtils.isEmpty((Object)index.getColumns())) continue;
                                        if (iSysDBSchemeRuntime.isDropIndexFirst()) {
                                            diffResult.addUnexpectedObject((DatabaseObject)index);
                                        }
                                        diffResult.addMissingObject((DatabaseObject)index);
                                    }
                                }
                                DiffToChangeLogEx diffToChangeLog = new DiffToChangeLogEx(diffResult, new DiffOutputControl());
                                diffToChangeLog.setChangeSetAuthor("iBiz-Cloud");
                                diffToChangeLog.setIdRoot(strModelTag3);
                                diffToChangeLog.print(strChangelogFile);
                            }
                            finally {
                                targetDatabase.setObjectQuotingStrategy(originalStrategy);
                            }
                        }
                        if (ObjectUtils.isEmpty((Object)(databaseChangeLog = liquibase.getDatabaseChangeLog())) || ObjectUtils.isEmpty((Object)databaseChangeLog.getChangeSets())) {
                            log.debug((Object)String.format("\u53d8\u66f4\u6587\u4ef6[%1$s]\u672a\u5305\u542b\u4efb\u4f55\u64cd\u4f5c\uff0c\u5ffd\u7565", strChangelogFile));
                            return;
                        }
                        ChangeSet changeSet = new ChangeSet(String.format("%1$s-empty", strModelTag3), "iBiz-Cloud", false, false, strChangelogFile, null, null, databaseChangeLog);
                        changeSet.addChange((Change)new EmptyChange());
                        databaseChangeLog.addChangeSet(changeSet);
                        liquibase.update("");
                        liquibase.tag(strModelTag3);
                        continue;
                    }
                    log.debug((Object)String.format("\u53d8\u66f4\u6587\u4ef6[%1$s]\u6807\u8bb0\u5df2\u64cd\u4f5c[%2$s]\uff0c\u5ffd\u7565", strChangelogFile, strModelTag3));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (liquibase == null) continue;
                    if (throwable != null) {
                        try {
                            liquibase.close();
                        }
                        catch (Throwable strTypes2) {
                            throwable.addSuppressed(strTypes2);
                        }
                        continue;
                    }
                    liquibase.close();
                }
            }
            catch (Throwable ex) {
                try {
                    if (file3.exists()) {
                        log.error((Object)String.format("\u540c\u6b65\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38\uff0c\u79fb\u9664\u53d8\u66f4\u6587\u4ef6[%1$s]", file3.getCanonicalPath()));
                        file3.delete();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                throw ex;
            }
        }
    }

    static {
        dataTypeMap.put("BIGDECIMAL", "DECIMAL");
        dataTypeMap.put("VARBINARY", "BLOB");
        dataTypeMap.put("VARBINARY.MYSQL", "MEDIUMBLOB");
    }
}

