/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.jgit.res;

import java.io.File;
import net.ibizsys.central.res.SysGitResourceRuntimeBase;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JGitSysGitResourceRuntimeBase
extends SysGitResourceRuntimeBase {
    private static final Log log = LogFactory.getLog(JGitSysGitResourceRuntimeBase.class);

    protected File onCheckout(Object target, IAction iAction) throws Throwable {
        Object ret;
        File file;
        block33: {
            file = this.getFile(target);
            String strPath = file.getCanonicalPath();
            String strGitPath = this.getResourceUri(target);
            String strBranch = this.getBranch(target);
            if (!StringUtils.hasLength((String)strBranch)) {
                strBranch = "master";
            }
            String strGitUserName = this.getClientId(target);
            String strGitPassword = this.getClientSecret(target);
            if (file.exists()) {
                try (FileRepository fr = new FileRepository(new File(String.format("%1$s%2$s.git", strPath, File.separator)));
                     Git git = new Git((Repository)fr);){
                    PullCommand pullCommand = git.pull().setRemoteBranchName(strBranch);
                    if (StringUtils.hasLength((String)strGitUserName)) {
                        if (StringUtils.hasLength((String)strGitPassword)) {
                            pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
                        } else {
                            pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, ""));
                        }
                    }
                    pullCommand.call();
                    break block33;
                }
            }
            file.mkdirs();
            CloneCommand cloneCommand = Git.cloneRepository().setURI(strGitPath).setDirectory(file).setBranch(strBranch);
            if (StringUtils.hasLength((String)strGitUserName)) {
                if (StringUtils.hasLength((String)strGitPassword)) {
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
                } else {
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, ""));
                }
            }
            cloneCommand.call();
        }
        if (iAction != null && (ret = iAction.execute(new Object[]{file})) instanceof Boolean && ((Boolean)ret).booleanValue()) {
            this.checkin(target);
        }
        return file;
    }

    protected void onCheckin(Object target) throws Throwable {
        File file = this.getFile(target);
        if (!file.exists()) {
            return;
        }
        String strPath = file.getCanonicalPath();
        String strGitUserName = this.getClientId(target);
        String strGitPassword = this.getClientSecret(target);
        try (FileRepository repository = new FileRepository(new File(String.format("%1$s%2$s.git", strPath, File.separator)));
             Git git = new Git((Repository)repository);){
            Status status = git.status().call();
            if (!(ObjectUtils.isEmpty((Object)status.getUntracked()) && ObjectUtils.isEmpty((Object)status.getModified()) && ObjectUtils.isEmpty((Object)status.getMissing()))) {
                if (!ObjectUtils.isEmpty((Object)status.getMissing())) {
                    for (String strRemoveFile : status.getMissing()) {
                        git.rm().addFilepattern(strRemoveFile).call();
                    }
                }
                if (!ObjectUtils.isEmpty((Object)status.getUntracked()) || !ObjectUtils.isEmpty((Object)status.getModified())) {
                    git.add().addFilepattern(".").call();
                }
                CommitCommand commitCommand = git.commit();
                PersonIdent committer = new PersonIdent(strGitUserName, "");
                RevCommit revCommit = commitCommand.setCommitter(committer).setMessage(String.format("\u7cfb\u7edf\u8d44\u6e90[%1$s]\u63d0\u4ea4", this.getName())).call();
                PushCommand pushCommand = git.push();
                if (StringUtils.hasLength((String)strGitUserName)) {
                    if (StringUtils.hasLength((String)strGitPassword)) {
                        pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
                    } else {
                        pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, ""));
                    }
                }
                pushCommand.call();
            }
        }
    }
}

