/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.es.util;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.plugin.es.ba.IESBDSchemeRuntimeBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

public class ESClientFactory
implements PooledObjectFactory<RestHighLevelClient> {
    private static final Log log = LogFactory.getLog(ESClientFactory.class);
    private IESBDSchemeRuntimeBase iESBDSchemeRuntimeBase = null;
    private Map<String, Object> params = new HashMap<String, Object>();

    public ESClientFactory(IESBDSchemeRuntimeBase iESBDSchemeRuntimeBase, Map<String, Object> params) throws Exception {
        this.iESBDSchemeRuntimeBase = iESBDSchemeRuntimeBase;
        if (params != null) {
            this.params.putAll(params);
        }
    }

    public PooledObject<RestHighLevelClient> makeObject() throws Exception {
        String strServiceUrl = this.iESBDSchemeRuntimeBase.getServiceUrl();
        RestHighLevelClient restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)strServiceUrl)}));
        return new DefaultPooledObject((Object)restHighLevelClient);
    }

    public void destroyObject(PooledObject<RestHighLevelClient> p) throws Exception {
        try {
            ((RestHighLevelClient)p.getObject()).close();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public boolean validateObject(PooledObject<RestHighLevelClient> p) {
        return p.getObject() != null;
    }

    public void activateObject(PooledObject<RestHighLevelClient> p) throws Exception {
    }

    public void passivateObject(PooledObject<RestHighLevelClient> p) throws Exception {
    }
}

