/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.es.search;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.plugin.es.search.ESSearchDocRuntime;
import net.ibizsys.central.plugin.es.search.IESSearchSchemeRuntime;
import net.ibizsys.central.plugin.es.util.ESClientFactory;
import net.ibizsys.central.plugin.es.util.ESClientPool;
import net.ibizsys.central.search.ISysSearchDocRuntime;
import net.ibizsys.central.search.ISysSearchSchemeRuntime;
import net.ibizsys.central.search.SysSearchSchemeRuntimeBase;
import net.ibizsys.central.search.SysSearchSchemeRuntimeException;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.search.IPSSysSearchDoc;
import net.ibizsys.model.search.IPSSysSearchField;
import net.ibizsys.runtime.util.EntityUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class ESSearchSchemeRuntimeBase
extends SysSearchSchemeRuntimeBase
implements IESSearchSchemeRuntime {
    private static final Log log = LogFactory.getLog(ESSearchSchemeRuntimeBase.class);
    private ESClientPool esClientPool = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getESClientPool(true) == null) {
            this.prepareESClientPool();
        }
    }

    @Override
    public ESClientPool getESClientPool() {
        return this.getESClientPool(false);
    }

    public ESClientPool getESClientPool(boolean bTryMode) {
        if (this.esClientPool != null || bTryMode) {
            return this.esClientPool;
        }
        throw new SysSearchSchemeRuntimeException((ISysSearchSchemeRuntime)this, String.format("ES\u8fde\u63a5\u6c60\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setESClientPool(ESClientPool esClientPool) {
        this.esClientPool = esClientPool;
    }

    protected void prepareESClientPool() throws Exception {
        if (!StringUtils.hasLength((String)this.getServiceUrl())) {
            throw new Exception("\u672a\u5b9a\u4e49\u670d\u52a1\u5730\u5740");
        }
        Map clientParams = this.getSystemRuntimeSetting().getParams(this.getConfigFolder() + ".clientparam", null);
        Map clientPoolParams = this.getSystemRuntimeSetting().getParams(this.getConfigFolder() + ".clientpool", null);
        GenericObjectPoolConfig esClientPoolConfig = new GenericObjectPoolConfig();
        if (clientPoolParams != null) {
            EntityUtils.copyTo((Map)clientPoolParams, (Object)esClientPoolConfig);
        }
        ESClientPool esClientPool = new ESClientPool(new ESClientFactory(this, clientParams), (GenericObjectPoolConfig<RestHighLevelClient>)new GenericObjectPoolConfig());
        this.setESClientPool(esClientPool);
    }

    protected void closeESClientPool() throws Exception {
        ESClientPool esClientPool = this.getESClientPool(true);
        if (esClientPool != null) {
            esClientPool.close();
            this.setESClientPool(null);
        }
    }

    protected ISysSearchDocRuntime createSysSearchDocRuntime(IPSSysSearchDoc iPSSysSearchDoc) {
        return new ESSearchDocRuntime();
    }

    protected void onUpdateSchema(IPSSysSearchDoc iPSSysSearchDoc) throws Exception {
        RestHighLevelClient httpESClient = null;
        try {
            httpESClient = (RestHighLevelClient)this.getESClientPool().borrowObject();
            String strRealIndexName = this.getRealDBObjName(iPSSysSearchDoc.getName());
            boolean bCreateMode = true;
            LinkedHashMap<String, IPSSysSearchField> psSysSearchFieldMap = new LinkedHashMap<String, IPSSysSearchField>();
            List psSysSearchFieldList = iPSSysSearchDoc.getAllPSSysSearchFields();
            if (!ObjectUtils.isEmpty((Object)psSysSearchFieldList)) {
                for (IPSSysSearchField iPSSysSearchField : psSysSearchFieldList) {
                    String strName = this.getRealDBObjName(iPSSysSearchField.getName());
                    psSysSearchFieldMap.put(strName, iPSSysSearchField);
                }
            }
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{strRealIndexName});
            if (httpESClient.indices().exists(getIndexRequest, RequestOptions.DEFAULT)) {
                Map sourceAsMap;
                GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
                getMappingsRequest.indices(new String[]{strRealIndexName});
                GetMappingsResponse getMappingsResponse = httpESClient.indices().getMapping(getMappingsRequest, RequestOptions.DEFAULT);
                Map mappings = getMappingsResponse.mappings();
                MappingMetadata mappingMetadata = (MappingMetadata)mappings.get(strRealIndexName);
                if (mappingMetadata != null && (sourceAsMap = mappingMetadata.sourceAsMap()).containsKey("properties")) {
                    Map propertiesMap = (Map)sourceAsMap.get("properties");
                    if (psSysSearchFieldMap.size() == propertiesMap.size()) {
                        for (Map.Entry entry : psSysSearchFieldMap.entrySet()) {
                            if (propertiesMap.containsKey(entry.getKey())) continue;
                            bCreateMode = false;
                            break;
                        }
                        if (bCreateMode) {
                            return;
                        }
                    }
                }
                bCreateMode = false;
            }
            XContentBuilder mappingBuilder = XContentFactory.jsonBuilder();
            mappingBuilder.startObject();
            mappingBuilder.startObject("properties");
            for (Map.Entry entry : psSysSearchFieldMap.entrySet()) {
                Map params;
                Object typeObj;
                IPSSysSearchField iPSSysSearchField = (IPSSysSearchField)entry.getValue();
                String strType = ((IPSSysSearchField)entry.getValue()).getFieldType();
                if (!StringUtils.hasLength((String)strType)) {
                    strType = PSModelEnums.SearchFieldDataType.TEXT.value;
                }
                mappingBuilder.startObject((String)entry.getKey());
                mappingBuilder.field("type", strType.toLowerCase());
                if (iPSSysSearchField.getFieldParams() != null && (typeObj = (params = JsonUtils.asMap((Object)iPSSysSearchField.getFieldParams())).get("type")) instanceof Map) {
                    Map typeParams = (Map)typeObj;
                    for (Map.Entry entry2 : typeParams.entrySet()) {
                        mappingBuilder.field((String)entry2.getKey(), entry2.getValue());
                    }
                }
                mappingBuilder.endObject();
            }
            mappingBuilder.endObject();
            mappingBuilder.endObject();
            if (bCreateMode) {
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(strRealIndexName);
                CreateIndexResponse createIndexResponse = httpESClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                if (!createIndexResponse.isAcknowledged()) {
                    throw new Exception(String.format("\u5efa\u7acb\u7d22\u5f15\u8fd4\u56de\u7ed3\u679c[%1$s]\u4e0d\u6b63\u786e", createIndexResponse.isAcknowledged()));
                }
            }
            PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{strRealIndexName});
            putMappingRequest.source(mappingBuilder);
            AcknowledgedResponse putMappingResponse = httpESClient.indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
            if (!putMappingResponse.isAcknowledged()) {
                throw new Exception(String.format("\u66f4\u65b0\u7d22\u5f15\u7ed3\u6784\u8fd4\u56de\u7ed3\u679c[%1$s]\u4e0d\u6b63\u786e", putMappingResponse.isAcknowledged()));
            }
        }
        catch (Exception ex) {
            throw new Exception(String.format("\u540c\u6b65\u7d22\u5f15\u7ed3\u6784\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        finally {
            if (httpESClient != null) {
                this.getESClientPool().returnObject(httpESClient);
            }
        }
    }

    protected void onShutdown() throws Exception {
        try {
            this.closeESClientPool();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u5173\u95ed\u8fde\u63a5\u6c60\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        super.onShutdown();
    }
}

