/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.es.ba;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntimeException;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.plugin.es.ba.IESBDSchemeRuntime;
import net.ibizsys.central.plugin.es.util.ESClientFactory;
import net.ibizsys.central.plugin.es.util.ESClientPool;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.util.EntityUtils;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ESBDSchemeRuntime
extends SysBDSchemeRuntime
implements IESBDSchemeRuntime {
    private static final Log log = LogFactory.getLog(ESBDSchemeRuntime.class);
    public static final String UNIQUEKEY = "id";
    private ESClientPool esClientPool = null;
    private String strIndexName = null;

    protected void onInit() throws Exception {
        super.onInit();
        this.setIndexName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".indexname", this.getRealDBObjName(this.getDBName())));
        if (this.getESClientPool(true) == null) {
            this.prepareESClientPool();
        }
        this.prepareIndex();
    }

    @Override
    public ESClientPool getESClientPool() {
        return this.getESClientPool(false);
    }

    public ESClientPool getESClientPool(boolean bTryMode) {
        if (this.esClientPool != null || bTryMode) {
            return this.esClientPool;
        }
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("ES\u8fde\u63a5\u6c60\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setESClientPool(ESClientPool esClientPool) {
        this.esClientPool = esClientPool;
    }

    protected void prepareESClientPool() throws Exception {
        if (!StringUtils.hasLength((String)this.getServiceUrl())) {
            throw new Exception("\u672a\u5b9a\u4e49\u670d\u52a1\u5730\u5740");
        }
        Map clientParams = this.getSystemRuntimeSetting().getParams(this.getConfigFolder() + ".clientparam", null);
        Map clientPoolParams = this.getSystemRuntimeSetting().getParams(this.getConfigFolder() + ".clientpool", null);
        GenericObjectPoolConfig esClientPoolConfig = new GenericObjectPoolConfig();
        if (clientPoolParams != null) {
            EntityUtils.copyTo((Map)clientPoolParams, (Object)esClientPoolConfig);
        }
        ESClientPool esClientPool = new ESClientPool(new ESClientFactory(this, clientParams), (GenericObjectPoolConfig<RestHighLevelClient>)new GenericObjectPoolConfig());
        this.setESClientPool(esClientPool);
    }

    protected void closeESClientPool() throws Exception {
        ESClientPool esClientPool = this.getESClientPool(true);
        if (esClientPool != null) {
            esClientPool.close();
            this.setESClientPool(null);
        }
    }

    protected String getIndexName(String strTableName) {
        if (StringUtils.hasLength((String)this.getIndexName())) {
            return this.getIndexName();
        }
        return strTableName;
    }

    public String getIndexName() {
        return this.strIndexName;
    }

    protected void setIndexName(String strIndexName) {
        this.strIndexName = strIndexName;
    }

    protected void prepareIndex() throws Exception {
    }

    protected Object onInsert(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        strTableName = this.getRealDBObjName(strTableName);
        arg = this.getRealMap(arg);
        extParamMap = this.getRealMap(extParamMap);
        String strId = null;
        Object objId = arg.get(this.getRealDBObjName(UNIQUEKEY));
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            strId = this.getAutoId();
        }
        RestHighLevelClient httpESClient = null;
        try {
            httpESClient = (RestHighLevelClient)this.getESClientPool().borrowObject();
            IndexRequest request = new IndexRequest(this.getIndexName(strTableName)).id(strId);
            HashMap<String, Object> document = new HashMap<String, Object>();
            if (arg != null) {
                this.addSourceFields(document, arg);
            }
            if (extParamMap != null) {
                this.addSourceFields(document, extParamMap);
            }
            request.source(document);
            this.setIndexRequestRefreshPolicy(request);
            IndexResponse indexResponse = httpESClient.index(request, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = indexResponse.getResult();
            if (result != DocWriteResponse.Result.CREATED && result != DocWriteResponse.Result.UPDATED) {
                throw new Exception(String.format("\u8fd4\u56de\u7ed3\u679c[%1$s]\u4e0d\u6b63\u786e", result));
            }
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5efa\u7acb\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (httpESClient != null) {
                this.getESClientPool().returnObject(httpESClient);
            }
        }
        return objId;
    }

    protected void addSourceFields(Map<String, Object> document, Map<String, Object> map) throws Throwable {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("srfkey".equals(entry.getKey())) continue;
            document.put(entry.getKey(), this.getFieldValue(entry.getValue()));
        }
    }

    protected Object getFieldValue(Object objValue) throws Throwable {
        if (objValue != null) {
            if (objValue instanceof BigInteger) {
                return ((BigInteger)objValue).longValue();
            }
            if (objValue instanceof BigDecimal) {
                return ((BigDecimal)objValue).doubleValue();
            }
            if (objValue instanceof Timestamp) {
                return new Date(((Timestamp)objValue).getTime());
            }
        }
        return objValue;
    }

    protected void setIndexRequestRefreshPolicy(IndexRequest request) {
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    protected void setUpdateRequestRefreshPolicy(UpdateRequest request) {
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    protected void setDeleteRequestRefreshPolicy(DeleteRequest request) {
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    protected Object onUpdate(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        if (!bAppendMode) {
            throw new Exception("\u4e0d\u652f\u6301\u975e\u9644\u52a0\u6a21\u5f0f");
        }
        strTableName = this.getRealDBObjName(strTableName);
        arg = this.getRealMap(arg);
        extParamMap = this.getRealMap(extParamMap);
        String strId = null;
        Object objId = arg.get(this.getRealDBObjName(UNIQUEKEY));
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u66f4\u65b0\u6570\u636e\u672a\u6307\u5b9a\u952e\u503c");
        }
        RestHighLevelClient httpESClient = null;
        try {
            httpESClient = (RestHighLevelClient)this.getESClientPool().borrowObject();
            HashMap<String, Object> document = new HashMap<String, Object>();
            if (arg != null) {
                this.addSourceFields(document, arg);
            }
            if (extParamMap != null) {
                this.addSourceFields(document, extParamMap);
            }
            UpdateRequest request = new UpdateRequest(this.getIndexName(strTableName), strId);
            this.setUpdateRequestRefreshPolicy(request);
            request.doc(document);
            request.upsert(document);
            UpdateResponse updateResponse = httpESClient.update(request, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = updateResponse.getResult();
            if (result != DocWriteResponse.Result.UPDATED && result != DocWriteResponse.Result.CREATED) {
                throw new Exception(String.format("\u8fd4\u56de\u7ed3\u679c[%1$s]\u4e0d\u6b63\u786e", result));
            }
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (httpESClient != null) {
                this.getESClientPool().returnObject(httpESClient);
            }
        }
        return 1;
    }

    protected Object onDelete(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        strTableName = this.getRealDBObjName(strTableName);
        arg = this.getRealMap(arg);
        extParamMap = this.getRealMap(extParamMap);
        String strId = null;
        Object objId = arg.get(this.getRealDBObjName(UNIQUEKEY));
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u5220\u9664\u6570\u636e\u672a\u6307\u5b9a\u952e\u503c");
        }
        RestHighLevelClient httpESClient = null;
        try {
            httpESClient = (RestHighLevelClient)this.getESClientPool().borrowObject();
            DeleteRequest deleteRequest = new DeleteRequest(this.getIndexName(strTableName), strId);
            this.setDeleteRequestRefreshPolicy(deleteRequest);
            DeleteResponse deleteResponse = httpESClient.delete(deleteRequest, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = deleteResponse.getResult();
            if (result == DocWriteResponse.Result.DELETED) {
                Integer n = 1;
                return n;
            }
            if (result == DocWriteResponse.Result.NOT_FOUND) {
                Integer n = 0;
                return n;
            }
            try {
                throw new Exception(String.format("\u8fd4\u56de\u7ed3\u679c[%1$s]\u4e0d\u6b63\u786e", result));
            }
            catch (Exception ex) {
                throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
        finally {
            if (httpESClient != null) {
                this.getESClientPool().returnObject(httpESClient);
            }
        }
    }

    protected List onQuery(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        QueryBuilder queryBuilder;
        List searchConds;
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        strTableName = this.getRealDBObjName(strTableName);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        ArrayList<QueryBuilder> filterQueryList = new ArrayList<QueryBuilder>();
        if (iSearchContext != null && (searchConds = iSearchContext.getSearchConds()) != null) {
            for (ISearchCond item : searchConds) {
                QueryBuilder queryBuilder2 = this.getQueryBuilder(item, iSearchContext, iDataEntityRuntime);
                if (queryBuilder2 == null) continue;
                filterQueryList.add(queryBuilder2);
            }
        }
        if (iDataEntityRuntime.isEnableLogicValid() && (queryBuilder = this.getQueryBuilder(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), "EQ", iDataEntityRuntime.getValidLogicValue(), iDataEntityRuntime)) != null) {
            filterQueryList.add(queryBuilder);
        }
        if (iPSDEDataQuery.getPSDEDQMain() != null && iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() != null && (queryBuilder = this.getQueryBuilder((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) != null) {
            filterQueryList.add(queryBuilder);
        }
        List selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
        ArrayList fieldList = new ArrayList();
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(t.getLowerCaseName()));
        }
        if (filterQueryList.size() > 0) {
            builder.query(this.getGroupQueryBuilder("AND", filterQueryList));
        }
        if (!ObjectUtils.isEmpty(fieldList)) {
            builder.fetchSource(fieldList.toArray(new String[fieldList.size()]), null);
        }
        RestHighLevelClient httpESClient = null;
        try {
            httpESClient = (RestHighLevelClient)this.getESClientPool().borrowObject();
            SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(strTableName)});
            searchRequest.source(builder);
            SearchResponse resp = httpESClient.search(searchRequest, RequestOptions.DEFAULT);
            ArrayList<Map> list = new ArrayList<Map>();
            SearchHit[] hits = resp.getHits().getHits();
            if (hits != null && hits.length > 0) {
                for (SearchHit searchHit : hits) {
                    list.add(searchHit.getSourceAsMap());
                }
            }
            ArrayList<Map> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (httpESClient != null) {
                this.getESClientPool().returnObject(httpESClient);
            }
        }
    }

    protected Page onFetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        QueryBuilder queryBuilder;
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        strTableName = this.getRealDBObjName(strTableName);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        ArrayList<QueryBuilder> filterQueryList = new ArrayList<QueryBuilder>();
        int nSkip = 0;
        int nLimit = 1000;
        if (iSearchContext != null) {
            List searchConds;
            Iterator orders;
            if (iSearchContext.getPageSort() != null && iSearchContext.getPageSort().isSorted() && (orders = iSearchContext.getPageSort().iterator()).hasNext()) {
                Sort.Order order = (Sort.Order)orders.next();
                builder.sort(order.getProperty(), order.isAscending() ? SortOrder.ASC : SortOrder.DESC);
            }
            if (iSearchContext.getPageable() != null && iSearchContext.getPageable().isPaged()) {
                nLimit = iSearchContext.getPageable().getPageSize();
                nSkip = (iSearchContext.getPageable().getPageNumber() - 0) * nLimit;
            }
            if ((searchConds = iSearchContext.getSearchConds()) != null) {
                for (ISearchCond item : searchConds) {
                    QueryBuilder queryBuilder2 = this.getQueryBuilder(item, iSearchContext, iDataEntityRuntime);
                    if (queryBuilder2 == null) continue;
                    filterQueryList.add(queryBuilder2);
                }
            }
        }
        if (iDataEntityRuntime.isEnableLogicValid() && (queryBuilder = this.getQueryBuilder(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName(), "EQ", iDataEntityRuntime.getValidLogicValue(), iDataEntityRuntime)) != null) {
            filterQueryList.add(queryBuilder);
        }
        List selectedPSDEFieldList = null;
        List psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
        if (!ObjectUtils.isEmpty((Object)psDEDataQueryList)) {
            ArrayList<QueryBuilder> orlist = new ArrayList<QueryBuilder>();
            for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
                QueryBuilder queryBuilder3;
                if (selectedPSDEFieldList == null) {
                    selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
                }
                if (iPSDEDataQuery.getPSDEDQMain() == null || iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() == null || (queryBuilder3 = this.getQueryBuilder((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) == null) continue;
                orlist.add(queryBuilder3);
            }
            if (!ObjectUtils.isEmpty(orlist)) {
                filterQueryList.add(this.getGroupQueryBuilder("OR", orlist));
            }
        }
        if (filterQueryList.size() > 0) {
            builder.query(this.getGroupQueryBuilder("AND", filterQueryList));
        }
        if (selectedPSDEFieldList == null) {
            selectedPSDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        }
        ArrayList fieldList = new ArrayList();
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(t.getLowerCaseName()));
        }
        if (!ObjectUtils.isEmpty(fieldList)) {
            builder.fetchSource(fieldList.toArray(new String[fieldList.size()]), null);
        }
        builder.from(nSkip);
        builder.size(nLimit);
        RestHighLevelClient httpESClient = null;
        try {
            long nTotal;
            httpESClient = (RestHighLevelClient)this.getESClientPool().borrowObject();
            SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(strTableName)});
            searchRequest.source(builder);
            SearchResponse resp = httpESClient.search(searchRequest, RequestOptions.DEFAULT);
            ArrayList<Map> list = new ArrayList<Map>();
            SearchHit[] hits = resp.getHits().getHits();
            if (hits != null && hits.length > 0) {
                for (SearchHit searchHit : hits) {
                    list.add(searchHit.getSourceAsMap());
                }
            }
            long l = nTotal = list == null ? 0L : (long)list.size();
            nTotal = resp.getHits().getTotalHits() != null ? resp.getHits().getTotalHits().value : (iSearchContext.isCount() ? (nTotal >= (long)nLimit ? (long)(nSkip + nLimit * 2) : (nTotal += (long)nSkip)) : (nTotal += (long)nSkip));
            PageImpl pageImpl = new PageImpl(list, iSearchContext != null ? iSearchContext.getPageable() : Pageable.unpaged(), nTotal);
            return pageImpl;
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u67e5\u8be2\u7ed3\u679c\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (httpESClient != null) {
                this.getESClientPool().returnObject(httpESClient);
            }
        }
    }

    protected QueryBuilder getQueryBuilder(IPSDEDQCondition iPSDEDQCondition, Map<String, Object> params, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
            ArrayList<QueryBuilder> queryBuilderList = new ArrayList<QueryBuilder>();
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            List psDEDQConditions = iPSDEDQGroupCondition.getPSDEDQConditions();
            if (psDEDQConditions != null) {
                for (IPSDEDQCondition item : psDEDQConditions) {
                    QueryBuilder queryBuilder = this.getQueryBuilder(item, params, iDataEntityRuntime);
                    if (queryBuilder == null) continue;
                    queryBuilderList.add(queryBuilder);
                }
            }
            if (queryBuilderList.size() > 0) {
                QueryBuilder groupQueryBuilder = this.getGroupQueryBuilder(iPSDEDQGroupCondition.getCondOp(), queryBuilderList);
                if (groupQueryBuilder == null) {
                    return null;
                }
                if (iPSDEDQGroupCondition.isNotMode()) {
                    return new BoolQueryBuilder().mustNot(groupQueryBuilder);
                }
                return groupQueryBuilder;
            }
            return null;
        }
        if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            String strVarType = iPSDEDQFieldCondition.getPSVARTypeId();
            if (StringUtils.hasLength((String)strVarType)) {
                Object objValue = null;
                if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getCondValue())) {
                    objValue = params == null ? null : params.get(iPSDEDQFieldCondition.getCondValue().toLowerCase());
                }
                return this.getQueryBuilder(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue, iDataEntityRuntime);
            }
            Object objValue = iPSDEDQFieldCondition.getCondValue();
            IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(iPSDEDQFieldCondition.getFieldName(), true);
            if (iPSDEField != null) {
                objValue = iDataEntityRuntime.convertValue(iPSDEField.getStdDataType(), (String)objValue);
            }
            return this.getQueryBuilder(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue, iDataEntityRuntime);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iPSDEDQCondition.getCondType()));
    }

    protected QueryBuilder getQueryBuilder(ISearchCond iSearchCond, ISearchContext iSearchContext, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (iSearchCond instanceof ISearchGroupCond) {
            ArrayList<QueryBuilder> queryBuilderList = new ArrayList<QueryBuilder>();
            ISearchGroupCond iSearchGroupCond = (ISearchGroupCond)iSearchCond;
            List searchConds = iSearchGroupCond.getSearchConds();
            if (searchConds != null) {
                for (ISearchCond item : searchConds) {
                    QueryBuilder queryBuilder = this.getQueryBuilder(item, iSearchContext, iDataEntityRuntime);
                    if (queryBuilder == null) continue;
                    queryBuilderList.add(queryBuilder);
                }
            }
            if (queryBuilderList.size() > 0) {
                QueryBuilder groupQueryBuilder = this.getGroupQueryBuilder(iSearchGroupCond.getCondOp(), queryBuilderList);
                if (groupQueryBuilder == null) {
                    return null;
                }
                if (iSearchGroupCond.isNotMode()) {
                    return new BoolQueryBuilder().mustNot(groupQueryBuilder);
                }
                return groupQueryBuilder;
            }
            return null;
        }
        if (iSearchCond instanceof ISearchFieldCond) {
            ISearchFieldCond iSearchFieldCond = (ISearchFieldCond)iSearchCond;
            Object objValue = iSearchFieldCond.getValue();
            if (objValue == null) {
                return null;
            }
            if (iSearchFieldCond.isParamMode()) {
                objValue = iSearchContext.get(objValue.toString());
            }
            return this.getQueryBuilder(iSearchFieldCond.getFieldName(), iSearchFieldCond.getCondOp(), objValue, iDataEntityRuntime);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iSearchCond.getCondType()));
    }

    protected QueryBuilder getQueryBuilder(String strFieldName, String strCondition, Object objValue, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        int nStdDataType = 25;
        if (StringUtils.hasLength((String)strFieldName)) {
            IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(strFieldName = strFieldName.toLowerCase(), true);
            if (iPSDEField != null) {
                nStdDataType = iPSDEField.getStdDataType();
                if (iPSDEField.isKeyDEField()) {
                    strFieldName = UNIQUEKEY;
                }
            }
        } else {
            throw new Exception("\u672a\u6307\u5b9a\u5c5e\u6027\u6807\u8bc6");
        }
        if ("EQ".equals(strCondition) || "ABSEQ".equals(strCondition)) {
            if (UNIQUEKEY.equals(strFieldName)) {
                if (ObjectUtils.isEmpty((Object)objValue)) {
                    return new IdsQueryBuilder().addIds(new String[]{""});
                }
                return new IdsQueryBuilder().addIds(new String[]{objValue.toString()});
            }
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return new TermQueryBuilder(strFieldName, "");
            }
            return new TermQueryBuilder(strFieldName, objValue);
        }
        if ("IN".equals(strCondition)) {
            if (UNIQUEKEY.equals(strFieldName)) {
                if (ObjectUtils.isEmpty((Object)objValue)) {
                    return new IdsQueryBuilder().addIds(new String[]{""});
                }
                return new IdsQueryBuilder().addIds(String.valueOf(objValue).split(",|;"));
            }
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return new TermQueryBuilder(strFieldName, "");
            }
            return new TermQueryBuilder(strFieldName, (Object)String.valueOf(objValue).split(",|;"));
        }
        if ("GT".equals(strCondition)) {
            return new RangeQueryBuilder(strFieldName).gt(objValue);
        }
        if ("GTANDEQ".equals(strCondition)) {
            return new RangeQueryBuilder(strFieldName).gte(objValue);
        }
        if ("LT".equals(strCondition)) {
            return new RangeQueryBuilder(strFieldName).lt(objValue);
        }
        if ("LTANDEQ".equals(strCondition)) {
            return new RangeQueryBuilder(strFieldName).lte(objValue);
        }
        if ("NOTEQ".equals(strCondition)) {
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return new BoolQueryBuilder().mustNot((QueryBuilder)new TermQueryBuilder(strFieldName, ""));
            }
            return new BoolQueryBuilder().mustNot((QueryBuilder)new TermQueryBuilder(strFieldName, objValue));
        }
        if ("ISNULL".equals(strCondition)) {
            return new TermQueryBuilder(strFieldName, null);
        }
        if ("ISNOTNULL".equals(strCondition)) {
            return new BoolQueryBuilder().mustNot((QueryBuilder)new TermQueryBuilder(strFieldName, null));
        }
        if ("LIKE".equals(strCondition)) {
            return new MatchQueryBuilder(strFieldName, objValue);
        }
        if ("LEFTLIKE".equals(strCondition)) {
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return new PrefixQueryBuilder(strFieldName, "");
            }
            return new PrefixQueryBuilder(strFieldName, objValue.toString());
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6761\u4ef6\u64cd\u4f5c[%1$s]", strCondition));
    }

    protected QueryBuilder getGroupQueryBuilder(String strCondition, List<QueryBuilder> queryBuilderList) throws Throwable {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        if ("AND".equalsIgnoreCase(strCondition)) {
            boolQueryBuilder.must().addAll(queryBuilderList);
        } else {
            boolQueryBuilder.should().addAll(queryBuilderList);
        }
        return boolQueryBuilder;
    }

    protected String getAutoId() {
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS%2$s", new Date(), KeyValueUtils.genUniqueId());
    }

    protected void onShutdown() throws Exception {
        try {
            this.closeESClientPool();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u5173\u95ed\u8fde\u63a5\u6c60\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        super.onShutdown();
    }
}

