/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.eai;

import java.util.List;
import net.ibizsys.central.cloud.core.eai.SysEAIAgentRuntimeBase;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MqttEAIAgentRuntime
extends SysEAIAgentRuntimeBase {
    private static final Log log = LogFactory.getLog(MqttEAIAgentRuntime.class);
    public static final String PARAM_QOS = "QOS";
    public static final String PARAM_RETAINED = "RETAINED";
    private MqttClient client;
    private int nQos = 1;
    private boolean bRetained = false;

    protected void onInit() throws Exception {
        String strSyncDir;
        this.setRetained(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".retained", DataTypeUtils.getBooleanValue((Object)this.getAgentParam(PARAM_RETAINED, null), (Boolean)this.isRetained()).booleanValue()));
        this.setQos(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".qos", DataTypeUtils.getIntegerValue((Object)this.getAgentParam(PARAM_QOS, null), (Integer)this.getQos()).intValue()));
        super.onInit();
        if (this.getClient(true) == null) {
            try {
                this.prepareClient();
            }
            catch (Exception ex) {
                throw new Exception(String.format("\u51c6\u5907\u5ba2\u6237\u7aef\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            if (this.getClient(true) == null) {
                throw new Exception(String.format("\u5ba2\u6237\u7aef\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            }
        }
        if ("INOUT".equals(strSyncDir = this.getPSSysDataSyncAgent().getSyncDir()) || "IN".equals(strSyncDir)) {
            try {
                this.prepareSubscribers();
            }
            catch (Exception ex) {
                throw new Exception(String.format("\u51c6\u5907\u6d88\u606f\u8ba2\u9605\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
    }

    protected MqttClient getClient() {
        return this.getClient(false);
    }

    protected MqttClient getClient(boolean bTryMode) {
        if (this.client != null || bTryMode) {
            return this.client;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u5bf9\u8c61");
    }

    protected void setClient(MqttClient client) {
        this.client = client;
    }

    protected void prepareClient() throws Exception {
        String strServiceUrl = this.getServiceUrl();
        if (!StringUtils.hasLength((String)strServiceUrl)) {
            throw new Exception("\u672a\u6307\u5b9a\u670d\u52a1\u5730\u5740");
        }
        MqttClient client = new MqttClient(strServiceUrl, this.getGroupId() + KeyValueUtils.genUniqueId(), (MqttClientPersistence)new MemoryPersistence());
        client.setCallback((MqttCallback)new MqttCallbackExtended(){

            public void connectionLost(Throwable cause) {
                MqttEAIAgentRuntime.this.onConnectionLost(cause);
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                MqttEAIAgentRuntime.this.onMessageArrived(topic, message);
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                MqttEAIAgentRuntime.this.onDeliveryComplete(token);
            }

            public void connectComplete(boolean reconnect, String serverURI) {
                MqttEAIAgentRuntime.this.onConnectComplete(reconnect, serverURI);
            }
        });
        client.connect(this.getMqttConnectOptions());
        this.setClient(client);
    }

    protected void closeClient() throws Exception {
        MqttClient client = this.getClient(true);
        if (client != null) {
            client.close(true);
            this.setClient(null);
        }
    }

    protected MqttConnectOptions getMqttConnectOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        options.setKeepAliveInterval(15);
        options.setConnectionTimeout(30);
        options.setAutomaticReconnect(true);
        if (StringUtils.hasLength((String)this.getClientId()) && StringUtils.hasLength((String)this.getClientSecret())) {
            options.setUserName(this.getClientId());
            options.setPassword(this.getClientSecret().toCharArray());
        }
        return options;
    }

    protected void prepareSubscribers() throws Exception {
        List list = this.getTopics();
        if (!ObjectUtils.isEmpty((Object)list)) {
            int[] qoses = new int[list.size()];
            for (int i = 0; i < qoses.length; ++i) {
                qoses[i] = this.getQos();
            }
            this.getClient().subscribe(list.toArray(new String[list.size()]), qoses);
        }
    }

    protected void onSend(String strTopic, String strData) throws Throwable {
        String strRealTopic = StringUtils.hasLength((String)strTopic) ? strTopic : this.getDefaultTopic();
        this.getClient().publish(strRealTopic, strData.getBytes("UTF-8"), this.getQos(), this.isRetained());
    }

    protected void onConnectionLost(Throwable cause) {
        log.error((Object)cause);
    }

    protected void onMessageArrived(String topic, MqttMessage message) throws Exception {
        this.recv(topic, new String(message.getPayload(), "UTF-8"));
    }

    protected void onDeliveryComplete(IMqttDeliveryToken token) {
        log.debug((Object)String.format("onDeliveryComplete", new Object[0]));
    }

    protected void onConnectComplete(boolean reconnect, String serverURI) {
        log.debug((Object)String.format("onConnectComplete", new Object[0]));
        String strSyncDir = this.getPSSysDataSyncAgent().getSyncDir();
        if ("INOUT".equals(strSyncDir) || "IN".equals(strSyncDir)) {
            try {
                this.prepareSubscribers();
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u51c6\u5907\u6d88\u606f\u8ba2\u9605\u8005\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public int getQos() {
        return this.nQos;
    }

    protected void setQos(int nQos) {
        this.nQos = nQos;
    }

    public boolean isRetained() {
        return this.bRetained;
    }

    protected void setRetained(boolean bRetained) {
        this.bRetained = bRetained;
    }

    protected void onShutdown() throws Exception {
        try {
            this.closeClient();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u5173\u95ed\u5ba2\u6237\u7aef\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        super.onShutdown();
    }
}

