/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.sysutil;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.Version;
import net.ibizsys.central.cloud.core.sysutil.CloudSysUtilRuntimeBase;
import net.ibizsys.central.cloud.core.sysutil.ISysDevOpsUtilRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.testing.IDETestCaseRuntime;
import net.ibizsys.central.testing.TestCaseRunResult;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.runtime.res.ISysSFPluginRuntime;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class SysDevOpsUtilRuntimeBase
extends CloudSysUtilRuntimeBase
implements ISysDevOpsUtilRuntime {
    private static final Log log = LogFactory.getLog(SysDevOpsUtilRuntimeBase.class);

    public Object executeAction(final String strAction, final Object objBody, final String strKey, final Object objTag) {
        return this.executeAction("\u6267\u884c\u64cd\u4f5c", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysDevOpsUtilRuntimeBase.this.onExecuteAction(strAction, objBody, strKey, objTag);
            }
        }, null);
    }

    protected Object onExecuteAction(String strAction, Object objBody, String strKey, Object objTag) throws Throwable {
        return this.onExecuteAction(this.getSystemRuntime(), strAction, objBody, strKey, objTag);
    }

    protected Object onExecuteAction(ISystemRuntime iSystemRuntime, String strAction, Object objBody, String strKey, Object objTag) throws Throwable {
        if (iSystemRuntime == null) {
            throw new Exception(String.format("\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
        }
        if ("RUNTESTPROJECT".equalsIgnoreCase(strAction)) {
            return this.onRunTestProject(iSystemRuntime, strAction, objBody, strKey, objTag);
        }
        if ("LISTPSSYSSFPLUGINS".equalsIgnoreCase(strAction)) {
            return this.onListPSSysSFPlugins(iSystemRuntime, strAction, objBody, strKey, objTag);
        }
        if ("GETSYSTEMINFO".equalsIgnoreCase(strAction)) {
            return this.onGetSystemInfo(iSystemRuntime, strAction, objBody, strKey, objTag);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684DevOps\u64cd\u4f5c[%1$s]", strAction));
    }

    protected Object onRunTestProject(ISystemRuntime iSystemRuntime, String strAction, Object objBody, String strKey, Object objTag) throws Throwable {
        List psDataEntityList = iSystemRuntime.getPSSystem().getAllPSDataEntities();
        if (ObjectUtils.isEmpty((Object)psDataEntityList)) {
            return null;
        }
        ArrayList<TestCaseRunResult> list = new ArrayList<TestCaseRunResult>();
        for (IPSDataEntity iPSDataEntity : psDataEntityList) {
            IDataEntityRuntime iDataEntityRuntime;
            List deTestCaseRuntimeList;
            if (ObjectUtils.isEmpty((Object)iPSDataEntity.getAllPSSysTestCases()) || ObjectUtils.isEmpty((Object)(deTestCaseRuntimeList = (iDataEntityRuntime = iSystemRuntime.getDataEntityRuntime(iPSDataEntity.getId())).getDETestCaseRuntimes()))) continue;
            for (IDETestCaseRuntime iDETestCaseRuntime : deTestCaseRuntimeList) {
                TestCaseRunResult testCaseRunResult = iDETestCaseRuntime.run();
                if (testCaseRunResult == null) continue;
                list.add(testCaseRunResult);
            }
        }
        return list;
    }

    protected Object onListPSSysSFPlugins(ISystemRuntime iSystemRuntime, String strAction, Object objBody, String strKey, Object objTag) throws Throwable {
        ArrayNode arrayNode = JsonUtils.createArrayNode();
        List psSysSFPluginList = iSystemRuntime.getPSSystem().getAllPSSysSFPlugins();
        if (!ObjectUtils.isEmpty((Object)psSysSFPluginList)) {
            for (IPSSysSFPlugin iPSSysSFPlugin : psSysSFPluginList) {
                if (!iPSSysSFPlugin.isRuntimeObject()) continue;
                ISysSFPluginRuntime iSysSFPluginRuntime = iSystemRuntime.getSysSFPluginRuntime(iPSSysSFPlugin.getId(), true);
                if (iSysSFPluginRuntime == null) {
                    log.warn((Object)String.format("\u672a\u83b7\u53d6\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s][%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", iPSSysSFPlugin.getName(), iPSSysSFPlugin.getId()));
                    continue;
                }
                ObjectNode objectNode = arrayNode.addObject();
                objectNode.put("id", iPSSysSFPlugin.getId());
                objectNode.put("name", iPSSysSFPlugin.getName());
                objectNode.put("rtobjectname", iSysSFPluginRuntime.getRTObjectName());
                objectNode.put("templcode", iSysSFPluginRuntime.getRTObjectCode());
                objectNode.put("groovyrtobject", iSysSFPluginRuntime.isGroovyRTObject());
            }
        }
        return arrayNode;
    }

    protected Object onGetSystemInfo(ISystemRuntime iSystemRuntime, String strAction, Object objBody, String strKey, Object objTag) throws Throwable {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("id", iSystemRuntime.getDeploySystemId());
        objectNode.put("name", iSystemRuntime.getName());
        objectNode.put("rtmodelenginever", Version.toVersionString());
        objectNode.put("psmodelenginever", iSystemRuntime.getPSModelEngineVer());
        objectNode.put("modeldigest", iSystemRuntime.getPSSystemService().getModelDigest());
        if (iSystemRuntime.getLoadedDate() != null) {
            objectNode.put("loadeddate", DateUtils.toDateTimeString((Date)iSystemRuntime.getLoadedDate()));
        }
        return objectNode;
    }
}

