/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.service.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class APIWebClientInvocationHandler
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(APIWebClientInvocationHandler.class);
    private final Object real;
    private final Object proxy;

    public APIWebClientInvocationHandler(Object real, Class<?> cls) {
        this.real = real;
        this.proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cls}, (InvocationHandler)this);
    }

    public Object getProxyObject() {
        return this.proxy;
    }

    private Object getRealObject() {
        return this.real;
    }

    @Override
    public Object invoke(Object arg0, Method method, Object[] arg2) throws Throwable {
        boolean lastDisabled = EmployeeContext.isCurrentDisabled();
        EmployeeContext.setCurrentDisabled((boolean)true);
        try {
            Object object = method.invoke(this.getRealObject(), arg2);
            return object;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            EmployeeContext.setCurrentDisabled((boolean)lastDisabled);
        }
    }
}

