/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.sysutil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.SysUtilRuntimeBase;
import net.ibizsys.central.plugin.cloud.service.client.APIWebClientInvocationHandler;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class SysCloudClientUtilRuntimeBase
extends SysUtilRuntimeBase
implements ISysCloudClientUtilRuntime {
    private static final Log log = LogFactory.getLog(SysCloudClientUtilRuntimeBase.class);
    private ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = null;
    private Map<String, String> serviceUrlMap = new ConcurrentHashMap<String, String>();
    private Map<String, IWebClient> rawServiceClientMap = new ConcurrentHashMap<String, IWebClient>();
    private Map<String, IWebClient> serviceClientMap = new ConcurrentHashMap<String, IWebClient>();
    private Map<String, APIWebClientInvocationHandler> apiServiceClientMap = new ConcurrentHashMap<String, APIWebClientInvocationHandler>();

    protected void onInit() throws Exception {
        super.onInit();
    }

    protected void prepareDefaultSetting() throws Exception {
        this.setServiceUrl("CONF", "lb://ibizcloud-conf");
        this.setServiceUrl("WF", "lb://ibizcloud-wf");
        this.setServiceUrl("UAA", "lb://ibizcloud-uaa");
        this.setServiceUrl("OSS", "lb://ibizcloud-oss");
        this.setServiceUrl("SAAS", "lb://ibizcloud-saas");
        this.setServiceUrl("OU", "lb://ibizcloud-ou");
        this.setServiceUrl("DEVOPS", "lb://ibizcloud-devops");
        this.setServiceUrl("LOG", "lb://ibizcloud-log");
        this.setServiceUrl("PORTAL", "lb://ibizcloud-portal");
        this.setServiceUrl("NOTIFY", "lb://ibizcloud-notify");
        this.setServiceUrl("TASK", "lb://ibizcloud-task");
        this.setServiceUrl("OPEN", "lb://ibizcloud-open");
        this.setServiceUrl("AI", "lb://ibizcloud-ai");
        this.setServiceUrl("KB", "lb://ibizcloud-kb");
        this.setServiceUrl("DATAFLOW", "lb://ibizcloud-dataflow");
        this.setServiceUrl("EXTENSION", "lb://extension-api");
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", null));
        if (StringUtils.hasLength((String)this.getServiceUrl())) {
            this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysUtil().getAuthClientId()));
            this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysUtil().getAuthClientSecret()));
            this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysUtil().getAuthMode()));
            this.setAccessTokenUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".accesstokenurl", null));
        } else {
            this.setServiceUrl(this.getSystemRuntimeSetting().getParam("cloudclientutil.serviceurl", null));
            this.setClientId(this.getSystemRuntimeSetting().getParam("cloudclientutil.clientid", this.getPSSysUtil().getAuthClientId()));
            this.setClientSecret(this.getSystemRuntimeSetting().getParam("cloudclientutil.clientsecret", this.getPSSysUtil().getAuthClientSecret()));
            this.setAuthMode(this.getSystemRuntimeSetting().getParam("cloudclientutil.authmode", this.getPSSysUtil().getAuthMode()));
            this.setAccessTokenUrl(this.getSystemRuntimeSetting().getParam("cloudclientutil.accesstokenurl", null));
        }
    }

    protected void onInstall() throws Exception {
        super.onInstall();
    }

    protected void setSubSysServiceAPIRuntime(ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime) {
        this.iSubSysServiceAPIRuntime = iSubSysServiceAPIRuntime;
    }

    public ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime() {
        return this.getSubSysServiceAPIRuntime(false);
    }

    protected ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime(boolean bTryMode) {
        if (this.iSubSysServiceAPIRuntime != null || bTryMode) {
            return this.iSubSysServiceAPIRuntime;
        }
        this.prepareSubSysServiceAPIRuntime();
        if (this.iSubSysServiceAPIRuntime != null) {
            return this.iSubSysServiceAPIRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u672a\u6307\u5b9aCloud\u670d\u52a1\u5ba2\u6237\u7aef\u5bf9\u8c61");
    }

    protected synchronized void prepareSubSysServiceAPIRuntime() {
        if (this.getSubSysServiceAPIRuntime(true) != null) {
            return;
        }
        this.executeAction("\u51c6\u5907Cloud\u670d\u52a1\u5ba2\u6237\u7aef", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                SysCloudClientUtilRuntimeBase.this.onPrepareSubSysServiceAPIRuntime();
                return true;
            }
        }, null, Boolean.class);
    }

    protected abstract void onPrepareSubSysServiceAPIRuntime() throws Throwable;

    public IWebClient getRawServiceClient(final String strServiceType) {
        IWebClient iWebClient = this.rawServiceClientMap.get(strServiceType);
        if (iWebClient == null) {
            final String strServiceUrl = this.getServiceUrl(strServiceType);
            iWebClient = (IWebClient)this.executeAction("\u51c6\u5907\u76f4\u63a5\u670d\u52a1\u5ba2\u6237\u7aef", new IAction(){

                public Object execute(Object[] args) throws Throwable {
                    return SysCloudClientUtilRuntimeBase.this.onGetRawServiceClient(strServiceType, strServiceUrl);
                }
            }, null, IWebClient.class);
            this.rawServiceClientMap.put(strServiceType, iWebClient);
        }
        return iWebClient;
    }

    protected IWebClient onGetRawServiceClient(String strServiceType, String strServiceUrl) throws Throwable {
        IWebClient iWebClient = this.getSystemRuntime().createWebClient((Object)strServiceUrl);
        iWebClient.init(this.getSystemRuntime(), strServiceUrl, null);
        return iWebClient;
    }

    public IWebClient getServiceClient(final String strServiceType) {
        IWebClient iWebClient = this.serviceClientMap.get(strServiceType);
        if (iWebClient == null) {
            final String strServiceUrl = this.getServiceUrl(strServiceType);
            iWebClient = (IWebClient)this.executeAction("\u51c6\u5907\u670d\u52a1\u5ba2\u6237\u7aef", new IAction(){

                public Object execute(Object[] args) throws Throwable {
                    return SysCloudClientUtilRuntimeBase.this.onGetServiceClient(strServiceType, strServiceUrl);
                }
            }, null, IWebClient.class);
            this.serviceClientMap.put(strServiceType, iWebClient);
            this.getSubSysServiceAPIRuntime().requestTokenIf(true);
        }
        return iWebClient;
    }

    protected IWebClient onGetServiceClient(String strServiceType, String strServiceUrl) throws Throwable {
        IWebClient iWebClient = this.getSystemRuntime().createWebClient((Object)strServiceUrl);
        iWebClient.init(this.getSubSysServiceAPIRuntime(), strServiceUrl);
        return iWebClient;
    }

    public <T> T getServiceClient(String strServiceType, Class<?> cls) {
        IWebClient iWebClient = this.getServiceClient(strServiceType);
        return (T)iWebClient.getProxyClient(cls);
    }

    public String getServiceUrl(String strServiceType) {
        String strServiceUrl = this.serviceUrlMap.get(strServiceType);
        if (StringUtils.hasLength((String)strServiceUrl)) {
            return strServiceUrl;
        }
        if (strServiceType.indexOf("http://") == 0 || strServiceType.indexOf("https://") == 0 || strServiceType.indexOf("lb://") == 0) {
            return strServiceType;
        }
        log.warn((Object)String.format("\u672a\u5b9a\u4e49Cloud\u670d\u52a1[%1$s]\u8def\u5f84\uff0c\u4f7f\u7528\u9ed8\u8ba4\u8def\u5f84", strServiceType));
        return this.getServiceUrl();
    }

    protected void setServiceUrl(String strServiceType, String strServiceUrl) {
        this.serviceUrlMap.put(strServiceType, strServiceUrl);
    }

    public <T> T getServiceClient(String strServiceType, Class<?> cls, boolean bAPIUserOnly) {
        IWebClient iWebClient = this.getServiceClient(strServiceType);
        Object t = iWebClient.getProxyClient(cls);
        if (bAPIUserOnly) {
            String strTag = String.format("%1$s|%2$s", strServiceType, cls.getName());
            APIWebClientInvocationHandler apiWebClientProxyObject = this.apiServiceClientMap.get(strTag);
            if (apiWebClientProxyObject == null) {
                apiWebClientProxyObject = new APIWebClientInvocationHandler(t, cls);
                this.apiServiceClientMap.put(strTag, apiWebClientProxyObject);
            }
            return (T)apiWebClientProxyObject.getProxyObject();
        }
        return (T)t;
    }
}

