/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.service;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.ISysUAAUtilRuntime;
import net.ibizsys.central.plugin.cloud.service.CloudServiceAIClientRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIDERuntime;
import net.ibizsys.central.service.SubSysServiceAPIRuntime;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.service.IPSSubSysServiceAPIDE;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class CloudServiceClientRuntime
extends SubSysServiceAPIRuntime {
    private static final Log log = LogFactory.getLog(CloudServiceClientRuntime.class);
    public static final String APITAG_CLOUDCLIENT = "CLOUDCLIENT";
    public static final String CLOUDSERVICE_AI = "_CLOUD_AI_";
    private IPSSubSysServiceAPI defaultPSSubSysServiceAPI = null;
    private ISysUAAUtilRuntime iSysUAAUtilRuntime = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getSysUAAUtilRuntime(true) == null) {
            this.prepareSysUAAUtilRuntime(!this.isPrepareSysUAAUtilRuntime());
        }
    }

    protected ISysUAAUtilRuntime getSysUAAUtilRuntime() {
        return this.getSysUAAUtilRuntime(false);
    }

    protected ISysUAAUtilRuntime getSysUAAUtilRuntime(boolean bTryMode) {
        if (this.iSysUAAUtilRuntime != null || bTryMode) {
            return this.iSysUAAUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u672a\u6307\u5b9a\u7cfb\u7edfUAA\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysUAAUtilRuntime(ISysUAAUtilRuntime iSysUAAUtilRuntime) {
        this.iSysUAAUtilRuntime = iSysUAAUtilRuntime;
    }

    protected void prepareSysUAAUtilRuntime(boolean bTryMode) throws Exception {
        this.setSysUAAUtilRuntime((ISysUAAUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysUAAUtilRuntime.class, bTryMode));
    }

    protected boolean isPrepareSysUAAUtilRuntime() {
        return true;
    }

    protected ISubSysServiceAPIDERuntime createSubSysServiceAPIDERuntime(IPSSubSysServiceAPIDE iPSSubSysServiceAPIDE) throws Exception {
        if (iPSSubSysServiceAPIDE.getPSSysSFPlugin() == null && StringUtils.hasLength((String)iPSSubSysServiceAPIDE.getName()) && iPSSubSysServiceAPIDE.getName().indexOf("_CLOUD_") == 0 && CLOUDSERVICE_AI.equalsIgnoreCase(iPSSubSysServiceAPIDE.getName())) {
            return new CloudServiceAIClientRuntime();
        }
        return super.createSubSysServiceAPIDERuntime(iPSSubSysServiceAPIDE);
    }

    protected IPSSubSysServiceAPI getDefaultPSSubSysServiceAPI() {
        if (this.defaultPSSubSysServiceAPI == null) {
            String strFullModelPath = "/sysmodel/cloudclient/PSSUBSYSSERVICEAPIS/CloudClient.json";
            try {
                ObjectNode objectNode = (ObjectNode)JsonUtils.MAPPER.readTree(((Object)((Object)this)).getClass().getResourceAsStream(strFullModelPath));
                this.defaultPSSubSysServiceAPI = (IPSSubSysServiceAPI)this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getSystemRuntime().getPSSystem(), IPSSubSysServiceAPI.class, objectNode);
            }
            catch (IOException ex) {
                throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u9ed8\u8ba4\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u6a21\u578b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
        return this.defaultPSSubSysServiceAPI;
    }

    public Map<String, ?> getHeaders() {
        String strTokenHeader;
        IEmployeeContext employeeContext = EmployeeContext.getCurrent();
        if (employeeContext == null) {
            return super.getHeaders();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        IAuthenticationUser authenticationUser = AuthenticationUser.getCurrent();
        if (authenticationUser != null && authenticationUser.getApiuser() == 0 && StringUtils.hasLength((String)authenticationUser.getToken()) && StringUtils.hasLength((String)authenticationUser.getUserid()) && StringUtils.hasLength((String)employeeContext.getUaauserid()) && authenticationUser.getUserid().equals(employeeContext.getUaauserid()) && StringUtils.hasLength((String)(strTokenHeader = this.getSysUAAUtilRuntime().getTokenHeader()))) {
            String strTokenPrefix = this.getSysUAAUtilRuntime().getTokenPrefix();
            if (StringUtils.hasLength((String)strTokenPrefix)) {
                map.put(strTokenHeader, String.format("%1$s%2$s", strTokenPrefix, authenticationUser.getToken()));
            } else {
                map.put(strTokenHeader, authenticationUser.getToken());
            }
            map.put("srfsystemid", employeeContext.getSystemid());
            if (StringUtils.hasLength((String)employeeContext.getOrgid())) {
                map.put("srforgid", employeeContext.getOrgid());
            }
            return map;
        }
        Map globalHeader = super.getHeaders();
        if (globalHeader != null) {
            map.putAll(globalHeader);
        }
        map.put("srfdcid", employeeContext.getTenant());
        map.put("srfdcsystemid", employeeContext.getDcsystemid());
        map.put("srfsystemid", employeeContext.getSystemid());
        if (StringUtils.hasLength((String)employeeContext.getOrgid())) {
            map.put("srforgid", employeeContext.getOrgid());
        }
        map.put("srfuserid", employeeContext.getUserid());
        if (StringUtils.hasLength((String)employeeContext.getUsername())) {
            try {
                map.put("srfusername", URLEncoder.encode(employeeContext.getUsername(), "UTF-8"));
            }
            catch (Exception ex) {
                log.error((Object)ex);
                map.put("srfusername", employeeContext.getUsername());
            }
        }
        if (StringUtils.hasLength((String)employeeContext.getUsercode())) {
            map.put("srfusercode", employeeContext.getUsercode());
        }
        if (StringUtils.hasLength((String)employeeContext.getOrgcode())) {
            map.put("srforgcode", employeeContext.getOrgcode());
        }
        if (StringUtils.hasLength((String)employeeContext.getDeptid())) {
            map.put("srfdeptid", employeeContext.getDeptid());
        }
        if (StringUtils.hasLength((String)employeeContext.getDeptcode())) {
            map.put("srfdeptcode", employeeContext.getDeptcode());
        }
        if (StringUtils.hasLength((String)employeeContext.getPorg())) {
            map.put("srfporgids", employeeContext.getPorg());
        }
        if (StringUtils.hasLength((String)employeeContext.getSorg())) {
            map.put("srfsorgids", employeeContext.getSorg());
        }
        if (StringUtils.hasLength((String)employeeContext.getPdept())) {
            map.put("srfpdeptids", employeeContext.getPdept());
        }
        if (StringUtils.hasLength((String)employeeContext.getSdept())) {
            map.put("srfsdeptids", employeeContext.getSdept());
        }
        return map;
    }

    protected String getMethodScriptCode() {
        String strMethodScriptCode = super.getMethodScriptCode();
        if (StringUtils.hasLength((String)strMethodScriptCode)) {
            return strMethodScriptCode;
        }
        return this.getDefaultPSSubSysServiceAPI().getMethodScriptCode();
    }

    protected String getAuthScriptCode() {
        String strAuthScriptCode = super.getAuthScriptCode();
        if (StringUtils.hasLength((String)strAuthScriptCode)) {
            return strAuthScriptCode;
        }
        return this.getDefaultPSSubSysServiceAPI().getAuthScriptCode();
    }

    public String getAccessTokenUrl() {
        String strAccessTokenUrl = super.getAccessTokenUrl();
        if (StringUtils.hasLength((String)strAccessTokenUrl)) {
            return strAccessTokenUrl;
        }
        return this.getSystemRuntimeSetting().getParam("cloudclientutil.accesstokenurl", null);
    }

    public String getClientId() {
        String strClientId = super.getClientId();
        if (StringUtils.hasLength((String)strClientId)) {
            return strClientId;
        }
        String strAccessTokenUrl = super.getAccessTokenUrl();
        if (StringUtils.hasLength((String)strAccessTokenUrl)) {
            return strClientId;
        }
        return this.getSystemRuntimeSetting().getParam("cloudclientutil.clientid", null);
    }

    public String getClientSecret() {
        String strClientSecret = super.getClientSecret();
        if (StringUtils.hasLength((String)strClientSecret)) {
            return strClientSecret;
        }
        String strAccessTokenUrl = super.getAccessTokenUrl();
        if (StringUtils.hasLength((String)strAccessTokenUrl)) {
            return strClientSecret;
        }
        return this.getSystemRuntimeSetting().getParam("cloudclientutil.clientsecret", null);
    }

    protected long getRenewTokenInterval() {
        return 600000L;
    }
}

