/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.sysutil;

import java.io.File;
import java.util.Map;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudOSSClient;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.central.sysutil.IObjectStorageServiceAdapter;
import net.ibizsys.central.sysutil.SysFileUtilRuntimeBase;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;

public class SysOSSUtilRuntime
extends SysFileUtilRuntimeBase
implements ISysOSSUtilRuntime {
    private static final Log log = LogFactory.getLog(SysOSSUtilRuntime.class);
    private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;
    private IObjectStorageServiceAdapter iObjectStorageServiceAdapter = null;
    private ICloudOSSClient iCloudOSSClient = null;

    protected void onInstall() throws Exception {
        super.onInstall();
        if (this.getSysCloudClientUtilRuntime(true) == null) {
            this.prepareSysCloudClientUtilRuntime();
        }
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
        return this.getSysCloudClientUtilRuntime(false);
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime(boolean bTryMode) {
        if (this.iSysCloudClientUtilRuntime != null || bTryMode) {
            return this.iSysCloudClientUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u672a\u6307\u5b9a\u4e91\u4f53\u7cfb\u5ba2\u6237\u7aef\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysCloudClientUtilRuntime(ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime) {
        this.iSysCloudClientUtilRuntime = iSysCloudClientUtilRuntime;
    }

    protected void prepareSysCloudClientUtilRuntime() throws Exception {
        this.setSysCloudClientUtilRuntime((ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false));
    }

    protected IObjectStorageServiceAdapter getObjectStorageServiceAdapter() {
        if (this.iObjectStorageServiceAdapter == null) {
            this.iObjectStorageServiceAdapter = this.getSysCloudClientUtilRuntime().getSubSysServiceAPIRuntime().getObjectStorageServiceAdapter();
            if (this.iObjectStorageServiceAdapter == null) {
                throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u5bf9\u8c61\u5b58\u50a8\u670d\u52a1\u63d2\u4ef6\u65e0\u6548");
            }
        }
        return this.iObjectStorageServiceAdapter;
    }

    protected ICloudOSSClient getCloudOSSClient() {
        if (this.iCloudOSSClient == null) {
            this.iCloudOSSClient = (ICloudOSSClient)this.getSysCloudClientUtilRuntime().getServiceClient("OSS", ICloudOSSClient.class);
            if (this.iCloudOSSClient == null) {
                throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "CloudOSS\u5ba2\u6237\u7aef\u5bf9\u8c61\u65e0\u6548");
            }
        }
        return this.iCloudOSSClient;
    }

    protected net.ibizsys.runtime.util.domain.File onGet(String strKey, boolean bTryMode) throws Throwable {
        return this.onGetOSSFile(strKey, null, bTryMode);
    }

    protected net.ibizsys.runtime.util.domain.File onGetOSSFile(String strKey, String strCat, boolean bTryMode) throws Throwable {
        try {
            File tempFile = File.createTempFile("oss", ".dat");
            net.ibizsys.runtime.util.domain.File file = this.getObjectStorageServiceAdapter().getFile(strKey, strCat, (Object)tempFile, null);
            file.setLocalPath(tempFile.getCanonicalPath());
            return file;
        }
        catch (Throwable ex) {
            if (bTryMode) {
                return null;
            }
            throw ex;
        }
    }

    protected net.ibizsys.runtime.util.domain.File onCreateOSSFile(File file, String strCat) throws Throwable {
        return this.getObjectStorageServiceAdapter().saveFile(null, strCat, (Object)file, null);
    }

    public String createObject(final String strDBName, final String strTableName, final Map<String, Object> data) {
        return (String)this.executeAction("\u5efa\u7acb\u5bf9\u8c61", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysOSSUtilRuntime.this.onCreateObject(strDBName, strTableName, data);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String onCreateObject(String strDBName, String strTableName, Map<String, Object> data) throws Throwable {
        boolean disabled = EmployeeContext.isCurrentDisabled();
        EmployeeContext.setCurrentDisabled((boolean)true);
        try {
            String string = this.getCloudOSSClient().createObject(strDBName, strTableName, data);
            return string;
        }
        finally {
            EmployeeContext.setCurrentDisabled((boolean)disabled);
        }
    }

    public int updateObject(final String strDBName, final String strTableName, final Map<String, Object> data, final boolean bAppendMode) {
        return (Integer)this.executeAction("\u66f4\u65b0\u5bf9\u8c61", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysOSSUtilRuntime.this.onUpdateObject(strDBName, strTableName, data, bAppendMode);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int onUpdateObject(String strDBName, String strTableName, Map<String, Object> data, boolean bAppendMode) throws Throwable {
        boolean disabled = EmployeeContext.isCurrentDisabled();
        EmployeeContext.setCurrentDisabled((boolean)true);
        try {
            int n = this.getCloudOSSClient().updateObject(strDBName, strTableName, (String)data.get("_id"), data);
            return n;
        }
        finally {
            EmployeeContext.setCurrentDisabled((boolean)disabled);
        }
    }

    public int deleteObject(final String strDBName, final String strTableName, final String key) {
        return (Integer)this.executeAction("\u5220\u9664\u5bf9\u8c61", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysOSSUtilRuntime.this.onDeleteObject(strDBName, strTableName, key);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int onDeleteObject(String strDBName, String strTableName, String key) throws Throwable {
        boolean disabled = EmployeeContext.isCurrentDisabled();
        EmployeeContext.setCurrentDisabled((boolean)true);
        try {
            int n = this.getCloudOSSClient().deleteObject(strDBName, strTableName, key);
            return n;
        }
        finally {
            EmployeeContext.setCurrentDisabled((boolean)disabled);
        }
    }

    public Page fetchObjects(final String strDBName, final String strTableName, final ISearchContext iSearchContext) {
        return (Page)this.executeAction("\u83b7\u53d6\u5bf9\u8c61\u6570\u636e\u96c6", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysOSSUtilRuntime.this.onFetchObjects(strDBName, strTableName, iSearchContext);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page onFetchObjects(String strDBName, String strTableName, ISearchContext iSearchContext) throws Throwable {
        boolean disabled = EmployeeContext.isCurrentDisabled();
        EmployeeContext.setCurrentDisabled((boolean)true);
        try {
            Page page = this.getCloudOSSClient().fetchObjects(strDBName, strTableName, iSearchContext);
            return page;
        }
        finally {
            EmployeeContext.setCurrentDisabled((boolean)disabled);
        }
    }

    public Map getObject(final String strDBName, final String strTableName, final String key) {
        return (Map)this.executeAction("\u83b7\u53d6\u5bf9\u8c61", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysOSSUtilRuntime.this.onGetObject(strDBName, strTableName, key);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map onGetObject(String strDBName, String strTableName, String key) throws Throwable {
        boolean disabled = EmployeeContext.isCurrentDisabled();
        EmployeeContext.setCurrentDisabled((boolean)true);
        try {
            Map map = this.getCloudOSSClient().getObject(strDBName, strTableName, key);
            return map;
        }
        finally {
            EmployeeContext.setCurrentDisabled((boolean)disabled);
        }
    }
}

