/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.sysutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ibizsys.central.ISystemLogListener;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.CloudSysUtilRuntimeBase;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudLogUtilRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.runtime.util.ConsoleUtils;
import net.ibizsys.runtime.util.domain.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SysCloudLogUtilRuntime
extends CloudSysUtilRuntimeBase
implements ISysCloudLogUtilRuntime,
ISystemLogListener {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(SysCloudLogUtilRuntime.class);
    private ConcurrentLinkedQueue<Log> logList = new ConcurrentLinkedQueue();

    protected void onInit() throws Exception {
        super.onInit();
        this.getSystemRuntime().registerSystemLogListener((ISystemLogListener)this);
    }

    protected void onInstall() throws Exception {
        super.onInstall();
        for (int i = 0; i < 10; ++i) {
            this.runLogTimer(i + "");
        }
    }

    protected void runLogTimer() {
        this.runLogTimer(false, "");
    }

    protected void runLogTimer(String timerTag) {
        this.runLogTimer(false, timerTag);
    }

    protected void runLogTimer(boolean bTimerOnly, final String timerTag) {
        if (!bTimerOnly) {
            try {
                this.onLogTimer();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("Cloud\u65e5\u5fd7[%1$s]\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            }
        }
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                SysCloudLogUtilRuntime.this.runLogTimer(false, timerTag);
            }
        }, System.currentTimeMillis() + 5000L, String.format("CloudLogTimer_%1$s_%2$s", this.getId(), timerTag));
    }

    protected void onLogTimer() {
        ArrayList<Log> list = new ArrayList<Log>();
        for (int nCount = 100; nCount > 0; --nCount) {
            Log log = this.logList.poll();
            if (log == null) break;
            list.add(log);
        }
        if (list.size() == 0) {
            return;
        }
        String strUrl = "/log";
        try {
            this.getWebClient().post(strUrl, null, null, null, list, null, String.class, null);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("Cloud\u65e5\u5fd7[%1$s]\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    public void log(Log log) {
        this.onLog(log);
    }

    protected void onLog(Log log) {
        this.logList.add(log);
    }

    protected IWebClient getWebClient() {
        return this.getSysCloudClientUtilRuntime().getServiceClient("LOG");
    }

    public void logs(final List<Log> list) {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrent();
        if (iEmployeeContext != null) {
            for (Log log : list) {
                log.set("dcsystemid", (Object)iEmployeeContext.getDcsystemid());
            }
        }
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                SysCloudLogUtilRuntime.this.onLog(list);
            }
        });
    }

    protected void onLog(List<Log> list) {
        String strUrl = "/log";
        try {
            this.getWebClient().post(strUrl, null, null, null, list, null, String.class, null);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("Cloud\u65e5\u5fd7[%1$s]\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    public void sendConsoleMessages(final List<Log> list) {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrent();
        if (iEmployeeContext != null) {
            for (Log log : list) {
                log.set("dcsystemid", (Object)iEmployeeContext.getDcsystemid());
            }
        }
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                SysCloudLogUtilRuntime.this.onSendConsoleMessages(list);
            }
        });
    }

    protected void onSendConsoleMessages(List<Log> list) {
        String strUrl = "/console";
        try {
            this.getWebClient().post(strUrl, null, null, null, list, null, String.class, null);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("Cloud\u65e5\u5fd7[%1$s]\u53d1\u9001\u63a7\u5236\u53f0\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    public void sendConsoleMessage(String strConsoleId, String strConsoleSender, String strLogInfo) {
        Log log = new Log();
        log.setConsoleId(strConsoleId);
        log.setConsoleSender(strConsoleSender);
        log.setConsoleInfo(strLogInfo);
        this.sendConsoleMessages(Arrays.asList(log));
    }

    public void sendConsoleMessage(String strConsoleId, String strConsoleSender, boolean bAppendTime, int nLogLevel, String strLogCat, String strLogInfo) {
        StringBuilder sb = new StringBuilder();
        if (bAppendTime) {
            sb.append(String.format("%1$tm-%1$td %1$tH:%1$tM:%1$tS ", new Date()));
        }
        switch (nLogLevel) {
            case 20000: {
                sb.append("INFO ");
                break;
            }
            case 10000: {
                sb.append("DEBUG ");
                break;
            }
            case 40000: {
                sb.append("ERROR ");
                break;
            }
            case 50000: {
                sb.append("FATAL ");
                break;
            }
            case 5000: {
                sb.append("TRACE ");
                break;
            }
            case 30000: {
                sb.append("WARN ");
            }
        }
        if (StringUtils.hasLength((String)strLogCat)) {
            sb.append(String.format("[%1$s] ", strLogCat));
        }
        if (StringUtils.hasLength((String)strLogInfo)) {
            sb.append(strLogInfo);
        }
        switch (nLogLevel) {
            case 40000: 
            case 50000: {
                this.sendConsoleMessage(strConsoleId, strConsoleSender, ConsoleUtils.getErrorContent((String)sb.toString()));
                break;
            }
            case 30000: {
                this.sendConsoleMessage(strConsoleId, strConsoleSender, ConsoleUtils.getWarnContent((String)sb.toString()));
                break;
            }
            default: {
                this.sendConsoleMessage(strConsoleId, strConsoleSender, sb.toString());
            }
        }
    }
}

