/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.sysutil;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import net.ibizsys.central.plugin.cloud.service.CloudServiceClientRuntime;
import net.ibizsys.central.plugin.cloud.sysutil.SysCloudClientUtilRuntimeBase;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SysCloudClientUtilRuntime
extends SysCloudClientUtilRuntimeBase {
    private static final Log log = LogFactory.getLog(SysCloudClientUtilRuntime.class);

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected void onInstall() throws Exception {
        super.onInstall();
    }

    @Override
    protected void onPrepareSubSysServiceAPIRuntime() throws Throwable {
        List psSubSysServiceAPIs = this.getSystemRuntime().getPSSystem().getAllPSSubSysServiceAPIs();
        IPSSubSysServiceAPI iPSSubSysServiceAPI = null;
        if (psSubSysServiceAPIs != null) {
            for (IPSSubSysServiceAPI item : psSubSysServiceAPIs) {
                if (!"CLOUDCLIENT".equalsIgnoreCase(item.getAPITag())) continue;
                iPSSubSysServiceAPI = item;
                break;
            }
            if (iPSSubSysServiceAPI == null) {
                for (IPSSubSysServiceAPI item : psSubSysServiceAPIs) {
                    if (!"CLOUDCLIENT".equalsIgnoreCase(item.getCodeName())) continue;
                    iPSSubSysServiceAPI = item;
                    break;
                }
            }
        }
        if (iPSSubSysServiceAPI == null) {
            if (!StringUtils.hasLength((String)this.getServiceUrl())) {
                throw new Exception(String.format("\u672a\u5b9a\u4e49Cloud\u670d\u52a1\u8def\u5f84", new Object[0]));
            }
            String strFullModelPath = "/sysmodel/cloudclient/PSSUBSYSSERVICEAPIS/CloudClient.json";
            ObjectNode objectNode = (ObjectNode)JsonUtils.MAPPER.readTree(((Object)((Object)this)).getClass().getResourceAsStream(strFullModelPath));
            objectNode.put("servicePath", this.getServiceUrl());
            objectNode.put("authClientId", this.getClientId());
            objectNode.put("authClientSecret", this.getClientSecret());
            objectNode.put("authMode", this.getAuthMode());
            objectNode.put("authAccessTokenUrl", this.getAccessTokenUrl());
            objectNode.put("aPITag", "CLOUDCLIENT");
            iPSSubSysServiceAPI = (IPSSubSysServiceAPI)this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getSystemRuntime().getPSSystem(), IPSSubSysServiceAPI.class, objectNode);
            CloudServiceClientRuntime subSysServiceAPIRuntime = new CloudServiceClientRuntime();
            subSysServiceAPIRuntime.init(this.getSystemRuntimeContext(), iPSSubSysServiceAPI);
            this.setSubSysServiceAPIRuntime((ISubSysServiceAPIRuntime)subSysServiceAPIRuntime);
        } else {
            this.setSubSysServiceAPIRuntime(this.getSystemRuntime().getSubSysServiceAPIRuntime(iPSSubSysServiceAPI));
        }
    }
}

