/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cloud.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudAIClient;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.plugin.cloud.service.CloudServicePredefinedClientRuntimeBase;
import net.ibizsys.model.service.IPSSubSysServiceAPIDEMethod;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CloudServiceAIClientRuntime
extends CloudServicePredefinedClientRuntimeBase {
    private static final Log log = LogFactory.getLog(CloudServiceAIClientRuntime.class);
    public static final String CONTEXT_AITYPE = "AITYPE";
    public static final String CONTEXT_AISESSION = "AISESSION";
    public static final String CONTEXT_AITYPE_DEFAULT = "DEFAULT";
    public static final String METHODCODENAME_CHATCOMPLETION = "CHATCOMPLETION";

    protected ICloudAIClient getCloudAIClient() {
        return (ICloudAIClient)this.getSysCloudClientUtilRuntime().getServiceClient("AI", ICloudAIClient.class);
    }

    protected Object onInvokeMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, Map<String, Object> context, Object[] args) throws Throwable {
        if (METHODCODENAME_CHATCOMPLETION.equalsIgnoreCase(iPSSubSysServiceAPIDEMethod.getCodeName())) {
            if (ObjectUtils.isEmpty((Object[])args)) {
                throw new Exception("\u672a\u4f20\u5165\u8c03\u7528\u53c2\u6570");
            }
            String strAIType = null;
            String strSessionId = null;
            if (context != null) {
                strAIType = (String)context.get(CONTEXT_AITYPE);
                strSessionId = (String)context.get(CONTEXT_AISESSION);
            }
            if (!StringUtils.hasLength(strAIType)) {
                strAIType = CONTEXT_AITYPE_DEFAULT;
            }
            if (!StringUtils.hasLength(strSessionId)) {
                strSessionId = EmployeeContext.getCurrent() != null ? String.format("%1$s_%2$s_%3$s", EmployeeContext.getCurrent().getTenant(), EmployeeContext.getCurrent().getSystemid(), EmployeeContext.getCurrent().getUaausername()) : (AuthenticationUser.getCurrent() != null ? String.format("%1$s", AuthenticationUser.getCurrent().getUsername()) : KeyValueUtils.genGuidEx());
            }
            Object arg = args[0];
            ChatCompletionRequest chatCompletionRequest = null;
            if (arg instanceof ChatCompletionRequest) {
                chatCompletionRequest = (ChatCompletionRequest)arg;
            } else {
                ArrayList<ChatMessage> list = new ArrayList<ChatMessage>();
                if (arg instanceof List) {
                    for (Object item : (List)arg) {
                        list.add(this.getChatMessage(item));
                    }
                } else {
                    list.add(this.getChatMessage(arg));
                }
                chatCompletionRequest = new ChatCompletionRequest();
                chatCompletionRequest.setSessionId(strSessionId);
                chatCompletionRequest.setMessages(list);
            }
            return this.getCloudAIClient().chatCompletion(strAIType, chatCompletionRequest);
        }
        return super.onInvokeMethod(iPSSubSysServiceAPIDEMethod, context, args);
    }

    protected ChatMessage getChatMessage(Object item) throws Throwable {
        if (item instanceof ChatMessage) {
            return (ChatMessage)item;
        }
        if (item instanceof IEntity) {
            ChatMessage chatMessage = new ChatMessage();
            ((IEntity)item).copyTo((IEntity)chatMessage);
            return chatMessage;
        }
        if (item instanceof Map) {
            ChatMessage chatMessage = new ChatMessage();
            Map map = (Map)item;
            for (Object key : map.keySet()) {
                if (ObjectUtils.isEmpty(key)) continue;
                chatMessage.set(key.toString(), map.get(key));
            }
            return chatMessage;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u5c06\u5bf9\u8c61[%1$s]\u8f6c\u6362\u81f3ChatMessage", item));
    }
}

