package net.ibizsys.central.plugin.cloud.sysutil;

import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.sysutil.IObjectStorageServiceAdapter;
import net.ibizsys.central.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.central.sysutil.SysFileUtilRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.domain.File;

/**
 * 系统对象存储（远程文件）功能组件基类
 * @author lionlau
 *
 */
public class SysOSSUtilRuntime extends SysFileUtilRuntimeBase implements ISysOSSUtilRuntime{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysOSSUtilRuntime.class);
	
	private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;
	private IObjectStorageServiceAdapter iObjectStorageServiceAdapter = null;
	
	
	@Override
	protected void onInstall() throws Exception {
		super.onInstall();
		
		//获取客户端组件
		if(this.getSysCloudClientUtilRuntime(true) == null) {
			this.prepareSysCloudClientUtilRuntime();
		}
	}
	
	protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
		return this.getSysCloudClientUtilRuntime(false);
	}
	
	protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime(boolean bTryMode) {
		if(this.iSysCloudClientUtilRuntime != null || bTryMode) {
			return this.iSysCloudClientUtilRuntime;
		}
		throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, "未指定云体系客户端功能组件");
	}
	
	protected void setSysCloudClientUtilRuntime(ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime) {
		this.iSysCloudClientUtilRuntime = iSysCloudClientUtilRuntime;
	}
	
	protected void prepareSysCloudClientUtilRuntime() throws Exception {
		this.setSysCloudClientUtilRuntime(this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false));
	}
	


	protected IObjectStorageServiceAdapter getObjectStorageServiceAdapter() {
		if(this.iObjectStorageServiceAdapter == null) {
			this.iObjectStorageServiceAdapter = this.getSysCloudClientUtilRuntime().getSubSysServiceAPIRuntime().getObjectStorageServiceAdapter();
			if(this.iObjectStorageServiceAdapter == null) {
				throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, "对象存储服务插件无效");
			}
		}
		return this.iObjectStorageServiceAdapter;
	}
	
	
	@Override
	protected File onGet(String strKey, boolean bTryMode) throws Throwable {
		return this.onGetOSSFile(strKey, null, bTryMode);
	}
	
	@Override
	protected File onGetOSSFile(String strKey, String strCat, boolean bTryMode) throws Throwable {
		try {
			java.io.File tempFile =	java.io.File.createTempFile("oss", ".dat");
			File file =  getObjectStorageServiceAdapter().getFile(strKey, strCat, tempFile, null);
			file.setLocalPath(tempFile.getCanonicalPath());
			return  file;
		}
		catch(Throwable ex) {
			if(bTryMode) {
				return null;
			}
			throw ex;
		}
	}
	
	@Override
	protected File onCreateOSSFile(java.io.File file, String strCat) throws Throwable {
		return this.getObjectStorageServiceAdapter().saveFile(null, strCat, file, null);
	}
}
