package net.ibizsys.central.plugin.cloud.sysutil;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.commons.logging.LogFactory;

import net.ibizsys.central.ISystemLogListener;
import net.ibizsys.central.cloud.core.cloudutil.ICloudUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudLogUtilRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.runtime.util.domain.Log;

/**
 * 系统日志侦听器组件运行时对象
 * @author lionlau
 *
 */
public class SysCloudLogUtilRuntime extends CloudSysUtilRuntimeBase implements ISysCloudLogUtilRuntime, ISystemLogListener {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(SysCloudLogUtilRuntime.class);
	
	private ConcurrentLinkedQueue<Log> logList = new ConcurrentLinkedQueue<Log>();
	
	
	@Override
	protected void onInit() throws Exception {
	
		super.onInit();
		
		this.getSystemRuntime().registerSystemLogListener(this);
		
	}
	
	@Override
	protected void onInstall() throws Exception {
		super.onInstall();
		for(int i =0;i<10;i++) {
			runLogTimer(i+"");
		}
	}

	protected void runLogTimer() {
		runLogTimer(false,"");
	}
	protected void runLogTimer(String timerTag) {
		runLogTimer(false,timerTag);
	}

	protected void runLogTimer(boolean bTimerOnly,String timerTag) {
		if(!bTimerOnly) {
			try {
				onLogTimer();
			} catch (Throwable ex) {
				log.error(String.format("Cloud日志[%1$s]定时器处理发生异常，%2$s", getName(), ex.getMessage()), ex);
				//getSystemRuntime().log(LogLevels.ERROR, "外部服务接口", String.format("外部服务接口[%1$s]认证定时器处理发生异常，%2$s", getName(), ex.getMessage()), ex);
			}
		}
		
		
		this.getSystemRuntime().threadRun(new Runnable() {
			@Override
			public void run() {
				runLogTimer(false,timerTag);
			}
		}, System.currentTimeMillis() + 5000, String.format("CloudLogTimer_%1$s_%2$s",this.getId(),timerTag));
	}
	
	
	protected void onLogTimer() {
		List<Log> list = new ArrayList<Log>();
		int nCount = 100;
		while(nCount>0) {
			nCount --;
			Log log = logList.poll();
			if(log == null) {
				break;
			}
			list.add(log);
		}
		if(list.size() == 0) {
			return;
		}
		String strUrl = "/log";
		try {
			this.getWebClient().post(strUrl, null, null, null, list, null, String.class, null);
		} catch (Throwable ex) {
			log.error(String.format("Cloud日志[%1$s]调用接口发生异常，%2$s", getName(), ex.getMessage()), ex);
		}
	}
	

	@Override
	public void log(Log log) {
		this.onLog(log);
	}
	
	protected void onLog(Log log) {
		logList.add(log);
	}
	
	protected IWebClient getWebClient() {
		//如果是单体模式可考虑优化获取自身Cloud功能
		return this.getSysCloudClientUtilRuntime().getServiceClient(ICloudUtilRuntime.CLOUDSERVICE_LOG);
	}
	
	
}
