package net.ibizsys.central.plugin.cs.metersphere.dataentity.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.central.plugin.cs.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.plugin.cs.metersphere.util.MSSearchContextDTO;
import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSSysTestPrjDTO;
import net.ibizsys.centralstudio.util.LogLevels;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.testing.IPSDEActionTestCase;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.model.testing.IPSSysTestCaseInput;
import net.ibizsys.model.testing.IPSSysTestPrj;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;

public class InitTestProjectsActionRuntime extends MeterSphereActionRuntimeBase {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(InitTestProjectsActionRuntime.class);
	/**
	 * 测试项目类型：单元测试
	 */
	public final static String TESTPRJTYPE_UNITTEST = "UNITTEST";

	/**
	 * 测试项目类型：模型测试
	 */
	public final static String TESTPRJTYPE_MODELTEST = "MODELTEST";
	
	
	/**
	 * 测试项目类型：工作流测试
	 */
	public final static String TESTPRJTYPE_WFTEST = "WFTEST";
	
	
	@Override
	protected Object onExportPSRTModel(IPSSystemService iPSSystemService, PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
		
		WorkspaceDTO workspaceDTO = this.getWorkspace(psDevSlnSysDTO, iPSSystemService);
		
		Map<String, ProjectDTO> projectDTOMap = this.getProjectMap(workspaceDTO, psDevSlnSysDTO, iPSSystemService);

		
		// 判断各项目
		if (true) {
			String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(psDevSlnSysDTO.getPSDevSlnSysId(), TESTPRJTYPE_UNITTEST, "DEFAULT");
			ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
			if (projectDTO == null) {
				projectDTO = new ProjectDTO();
				projectDTO.setWorkspaceId(workspaceDTO.getId());
				projectDTO.setName(String.format("%1$s[默认单元测试]", psDevSlnSysDTO.getPSDevSlnSysName()));
				projectDTO.setAzureDevopsId(strDefaultId);
				projectDTO = this.getMeterSphereClient().createProject(projectDTO);
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
			
			this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("开始初始化测试项目[%1$s]", projectDTO.getName()));
			
			initTestProject(projectDTO, TESTPRJTYPE_UNITTEST, null, psDevSlnSysDTO, iPSSystemService);
		}

		if (true) {
			String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(psDevSlnSysDTO.getPSDevSlnSysId(), TESTPRJTYPE_MODELTEST, "DEFAULT");
			ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
			if (projectDTO == null) {
				projectDTO = new ProjectDTO();
				projectDTO.setWorkspaceId(workspaceDTO.getId());
				projectDTO.setName(String.format("%1$s[默认模型测试]", psDevSlnSysDTO.getPSDevSlnSysName()));
				projectDTO.setAzureDevopsId(strDefaultId);
				projectDTO = this.getMeterSphereClient().createProject(projectDTO);
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
			
			this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("开始初始化测试项目[%1$s]", projectDTO.getName()));
			
			initTestProject(projectDTO, TESTPRJTYPE_MODELTEST, null, psDevSlnSysDTO, iPSSystemService);
		}
		
		if (true) {
			String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(psDevSlnSysDTO.getPSDevSlnSysId(), TESTPRJTYPE_WFTEST, "DEFAULT");
			ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
			if (projectDTO == null) {
				projectDTO = new ProjectDTO();
				projectDTO.setWorkspaceId(workspaceDTO.getId());
				projectDTO.setName(String.format("%1$s[默认工作流测试]", psDevSlnSysDTO.getPSDevSlnSysName()));
				projectDTO.setAzureDevopsId(strDefaultId);
				projectDTO = this.getMeterSphereClient().createProject(projectDTO);
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
			
			this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("开始初始化测试项目[%1$s]", projectDTO.getName()));
			
			initTestProject(projectDTO, TESTPRJTYPE_WFTEST, null, psDevSlnSysDTO, iPSSystemService);
		}
		
		
		java.util.List<IPSSysTestPrj> psSysTestPrjList = iPSSystemService.getPSSystem().getAllPSSysTestPrjs();
		if (!ObjectUtils.isEmpty(psSysTestPrjList)) {
			for (IPSSysTestPrj iPSSysTestPrj : psSysTestPrjList) {
				String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(psDevSlnSysDTO.getPSDevSlnSysId(), iPSSysTestPrj.getPrjType(), iPSSysTestPrj.getCodeName());
				ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
				if (projectDTO == null) {
					projectDTO = new ProjectDTO();
					projectDTO.setWorkspaceId(workspaceDTO.getId());
					projectDTO.setName(String.format("%1$s[%2$s(%3$s)]", psDevSlnSysDTO.getPSDevSlnSysName(), iPSSysTestPrj.getName(), iPSSysTestPrj.getCodeName()));
					projectDTO.setAzureDevopsId(strDefaultId);
					projectDTO = this.getMeterSphereClient().createProject(projectDTO);
					projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
				}
				// initTestProject(projectDTO, dcSystem, iPSSystemService);
			}
		}

		List<PSSysTestPrjDTO> list = new ArrayList<PSSysTestPrjDTO>();
		for (ProjectDTO projectDTO : projectDTOMap.values()) {
			PSSysTestPrjDTO psSysTestPrj = new PSSysTestPrjDTO();
			psSysTestPrj.setPSSysTestPrjId(projectDTO.getId());
			psSysTestPrj.setPSSysTestPrjName(projectDTO.getName());
			list.add(psSysTestPrj);
		}

		return list;
	}

	protected WorkspaceDTO getWorkspace(PSDevSlnSysDTO psDevSlnSysDTO, IPSSystemService iPSSystemService) throws Throwable {
		
		MSSearchContextDTO msSearchContextDTO = new MSSearchContextDTO();
		msSearchContextDTO.set("name", psDevSlnSysDTO.getPSDevSlnName());

		WorkspaceDTO workspaceDTO = null;
		Page<WorkspaceDTO> workspaceDTOPage = this.getMeterSphereClient().listWorkspace(msSearchContextDTO);
		if (!ObjectUtils.isEmpty(workspaceDTOPage.getContent())) {
			// 存在
			workspaceDTO = workspaceDTOPage.getContent().get(0);
		} else {
			// 新建
			workspaceDTO = new WorkspaceDTO();
			workspaceDTO.setName(psDevSlnSysDTO.getPSDevSlnName());
			workspaceDTO = this.getMeterSphereClient().createWorkspace(workspaceDTO);
		}

		return workspaceDTO;
	}
	
	
	protected Map<String, ProjectDTO> getProjectMap(WorkspaceDTO workspaceDTO, PSDevSlnSysDTO psDevSlnSysDTO, IPSSystemService iPSSystemService) throws Throwable {
		
		// 列出全部项目
		MSSearchContextDTO projectSearchContextDTO = new MSSearchContextDTO();
		projectSearchContextDTO.set(ProjectDTO.FIELD_WORKSPACEID, workspaceDTO.getId());
		Page<ProjectDTO> projectDTOPage = this.getMeterSphereClient().listProject(projectSearchContextDTO);

		Map<String, ProjectDTO> projectDTOMap = new HashMap<String, ProjectDTO>();

		if (!ObjectUtils.isEmpty(projectDTOPage.getContent())) {
			for (ProjectDTO projectDTO : projectDTOPage.getContent()) {
				if (!StringUtils.hasLength(projectDTO.getAzureDevopsId())) {
					continue;
				}
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
		}
		
		return projectDTOMap;
	}
	

	

	protected void initTestProject(ProjectDTO projectDTO, String strProjectType, Object projectData, PSDevSlnSysDTO psDevSlnSysDTO, IPSSystemService iPSSystemService) throws Throwable {

		

		// 列出全部节点
		MSSearchContextDTO testCaseNodeSearchContextDTO = new MSSearchContextDTO();
		testCaseNodeSearchContextDTO.set(TestCaseNodeDTO.FIELD_PROJECTID, projectDTO.getId());
		Page<TestCaseNodeDTO> testCaseNodeDTOPage = this.getMeterSphereClient().listTestCaseNode(testCaseNodeSearchContextDTO);

		// 列出全部用例
		MSSearchContextDTO testCaseSearchContextDTO = new MSSearchContextDTO();
		testCaseSearchContextDTO.set(TestCaseNodeDTO.FIELD_PROJECTID, projectDTO.getId());
		Page<TestCaseDTO> testCaseDTOPage = this.getMeterSphereClient().listTestCase(testCaseSearchContextDTO);

		Map<String, TestCaseDTO> testCaseDTOMap = new HashMap<String, TestCaseDTO>();

		if (!ObjectUtils.isEmpty(testCaseDTOPage.getContent())) {
			for (TestCaseDTO testCaseDTO : testCaseDTOPage.getContent()) {
				if (!StringUtils.hasLength(testCaseDTO.getTags())) {
					continue;
				}

				testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);

				ArrayNode tags = JsonUtils.toArrayNode(testCaseDTO.getTags());
				if (!ObjectUtils.isEmpty(tags)) {
					for (Object objTag : tags) {
						if (!(objTag instanceof JsonNode)) {
							continue;
						}
						String strTag = ((JsonNode) objTag).asText();
						if (ObjectUtils.isEmpty(strTag)) {
							continue;
						}
						if (strTag.toLowerCase().indexOf("ibiz-") == 0) {
							testCaseDTOMap.put(strTag.toLowerCase(), testCaseDTO);
							break;
						}
					}
				}
			}
		}

		if (TESTPRJTYPE_UNITTEST.equals(strProjectType)) {
			List<IPSDataEntity> psDataEntityList = iPSSystemService.getPSSystem().getAllPSDataEntities();
			if (ObjectUtils.isEmpty(psDataEntityList)) {
				return;
			}
			for (IPSDataEntity iPSDataEntity : psDataEntityList) {

				List<IPSSysTestCase> psSysTestCaseList = iPSDataEntity.getAllPSSysTestCases();
				if (ObjectUtils.isEmpty(psSysTestCaseList)) {
					continue;
				}

				// 判断目录是否存在
				TestCaseNodeDTO testCaseNodeDTO = null;
				if (!ObjectUtils.isEmpty(testCaseNodeDTOPage.getContent())) {
					String strName = String.format("(%1$s)", iPSDataEntity.getName());
					for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
						if (!StringUtils.hasLength(item.getName())) {
							continue;
						}
						if (item.getName().indexOf(strName) != -1) {
							testCaseNodeDTO = item;
							break;
						}
					}
				}

				if (testCaseNodeDTO == null) {
					testCaseNodeDTO = new TestCaseNodeDTO();
					testCaseNodeDTO.setProjectId(projectDTO.getId());
					testCaseNodeDTO.setName(String.format("%1$s(%2$s)", iPSDataEntity.getLogicName(), iPSDataEntity.getName()));
					testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
					testCaseNodeDTO.set("level", 1);

					testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
				}

				for (IPSSysTestCase iPSSysTestCase : psSysTestCaseList) {

					String strTag = String.format("ibiz-%1$s-%2$s", iPSDataEntity.getName(), iPSSysTestCase.getCodeName()).toLowerCase();
					TestCaseDTO testCaseDTO = testCaseDTOMap.get(strTag);
					if (testCaseDTO != null) {
						continue;
					}

					testCaseDTO = new TestCaseDTO();
					testCaseDTO.setName(iPSSysTestCase.getName());
					testCaseDTO.setNodeId(testCaseNodeDTO.getId());
					testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
					testCaseDTO.setPriority("P2");
					testCaseDTO.setProjectId(projectDTO.getId());
					testCaseDTO.setOrder(iPSSysTestCase.getOrderValue());
					testCaseDTO.setReviewStatus("Prepare");
					testCaseDTO.setStatus("Prepare");
					testCaseDTO.setType("functional");

					testCaseDTO.setStepModel("STEP");

					// 放入标记
					ArrayNode tags = JsonUtils.createArrayNode();
					tags.add(strTag);
					tags.add(iPSSysTestCase.getTestCaseType());
					if (iPSSysTestCase instanceof IPSDEActionTestCase) {
						IPSDEAction iPSDEAction = ((IPSDEActionTestCase) iPSSysTestCase).getPSDEAction();
						if (iPSDEAction != null) {
							tags.add(iPSDEAction.getName());
						}
					}
					testCaseDTO.setTags(tags.toString());

					// 放入步骤
					ArrayNode steps = JsonUtils.createArrayNode();
					// steps:
					// "[{\"num\":1,\"desc\":\"ddd\",\"result\":\"ddd\"}]"
					List<IPSSysTestCaseInput> inputs = iPSSysTestCase.getPSSysTestCaseInputs();
					if (!ObjectUtils.isEmpty(inputs)) {
						int nNum = 0;
						for (IPSSysTestCaseInput iPSSysTestCaseInput : inputs) {
							nNum++;
							ObjectNode step = steps.addObject();
							step.put("num", nNum);
							String strDesc = iPSSysTestCaseInput.getMemo();
							if (!StringUtils.hasLength(strDesc)) {
								strDesc = iPSSysTestCaseInput.getName();
							}
							step.put("desc", strDesc);
							String strResultList = "";
							if (!ObjectUtils.isEmpty(iPSSysTestCaseInput.getPSSysTestCaseAsserts())) {
								for (IPSSysTestCaseAssert iPSSysTestCaseAssert : iPSSysTestCaseInput.getPSSysTestCaseAsserts()) {
									String strResult = getExpectedResult(iPSSysTestCaseAssert);
									if (StringUtils.hasLength(strResultList)) {
										strResultList += "、";
									}
									strResultList += strResult;
								}
							}

							step.put("result", strResultList);
						}
					}

					testCaseDTO.setSteps(steps.toString());

					testCaseDTO.set("maintainer", this.getMeterSphereClient().getClientId());

					testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
					testCaseDTOMap.put(strTag, testCaseDTO);
					testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);

				}
			}
			return;
		}

		
		if (TESTPRJTYPE_WFTEST.equals(strProjectType)) {
			List<IPSWorkflow> psWorkflowList = iPSSystemService.getPSSystem().getAllPSWorkflows();
			if (ObjectUtils.isEmpty(psWorkflowList)) {
				return;
			}
			for (IPSWorkflow iPSWorkflow : psWorkflowList) {

				// 判断目录是否存在
				TestCaseNodeDTO testCaseNodeDTO = null;
				if (!ObjectUtils.isEmpty(testCaseNodeDTOPage.getContent())) {
					String strName = String.format("(%1$s)", iPSWorkflow.getCodeName());
					for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
						if (!StringUtils.hasLength(item.getName())) {
							continue;
						}
						if (item.getName().indexOf(strName) != -1) {
							testCaseNodeDTO = item;
							break;
						}
					}
				}

				if (testCaseNodeDTO == null) {
					testCaseNodeDTO = new TestCaseNodeDTO();
					testCaseNodeDTO.setProjectId(projectDTO.getId());
					testCaseNodeDTO.setName(String.format("%1$s(%2$s)", iPSWorkflow.getName(), iPSWorkflow.getCodeName()));
					testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
					testCaseNodeDTO.set("level", 1);

					testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
				}
			}
			
			return;
		}
		
		if (TESTPRJTYPE_MODELTEST.equals(strProjectType)) {
			
			//服务接口检查
			List<IPSSysServiceAPI> psSysServiceAPIList = iPSSystemService.getPSSystem().getAllPSSysServiceAPIs();
			if (!ObjectUtils.isEmpty(psSysServiceAPIList)) {
				for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
					String strName = String.format("服务接口[%1$s(%2$s)]", iPSSysServiceAPI.getName(), iPSSysServiceAPI.getCodeName());
					// 判断目录是否存在
					TestCaseNodeDTO testCaseNodeDTO = null;
					if (!ObjectUtils.isEmpty(testCaseNodeDTOPage.getContent())) {
						
						for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
							if (!StringUtils.hasLength(item.getName())) {
								continue;
							}
							if (item.getName().indexOf(strName) != -1) {
								testCaseNodeDTO = item;
								break;
							}
						}
					}

					if (testCaseNodeDTO == null) {
						testCaseNodeDTO = new TestCaseNodeDTO();
						testCaseNodeDTO.setProjectId(projectDTO.getId());
						testCaseNodeDTO.setName(strName);
						testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
						testCaseNodeDTO.set("level", 1);

						testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
					}
					
					//实体接口访问
					
					
					//实体接口关系
					List<IPSDEServiceAPIRS> psDEServiceAPIRSList = iPSSysServiceAPI.getPSDEServiceAPIRSs();
					if(!ObjectUtils.isEmpty(psDEServiceAPIRSList)) {
						String strTag = String.format("ibiz-%1$s-%2$s", "desars", iPSSysServiceAPI.getCodeName()).toLowerCase();
						TestCaseDTO testCaseDTO = testCaseDTOMap.get(strTag);
						if (testCaseDTO == null) {

							testCaseDTO = new TestCaseDTO();
							testCaseDTO.setName("实体接口关系合理性校验");
							testCaseDTO.setNodeId(testCaseNodeDTO.getId());
							testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
							testCaseDTO.setPriority("P2");
							testCaseDTO.setProjectId(projectDTO.getId());
							//testCaseDTO.setOrder(iPSSysTestCase.getOrderValue());
							testCaseDTO.setReviewStatus("Prepare");
							testCaseDTO.setStatus("Prepare");
							testCaseDTO.setType("functional");

							testCaseDTO.setStepModel("TEXT");
							testCaseDTO.setStepDescription("判断实体接口关系是否存在附属或控制关系");
							testCaseDTO.setExpectedResult("实体接口关系都存在附属或控制关系");

							// 放入标记
							ArrayNode tags = JsonUtils.createArrayNode();
							tags.add(strTag);
							
							testCaseDTO.setTags(tags.toString());

//							// 放入步骤
//							ArrayNode steps = JsonUtils.createArrayNode();
//							// steps:
//							int nNum = 0;
//							for (IPSDEServiceAPIRS iPSDEServiceAPIRS : psDEServiceAPIRSList) {
//								nNum++;
//								ObjectNode step = steps.addObject();
//								step.put("num", nNum);
//								String strDesc = iPSDEServiceAPIRS.getMemo();
//								if (!StringUtils.hasLength(strDesc)) {
//									strDesc = iPSDEServiceAPIRS.getName();
//								}
//								step.put("desc", strDesc);
//								step.put("name", iPSDEServiceAPIRS.getName());
//								
//
//								step.put("result", "存在附属、控制关系");
//							}
//
//							testCaseDTO.setSteps(steps.toString());

							testCaseDTO.set("maintainer", this.getMeterSphereClient().getClientId());

							testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
							testCaseDTOMap.put(strTag, testCaseDTO);
							testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
							

							
						}
					}
					
					
					
				}
			}
			
			
			return;
		}
		
	}
	
	
	
	
	
}
