/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.metersphere.dataentity.action;

import net.ibizsys.central.plugin.cs.core.dataentity.action.PSRTModelExportActionRuntimeBase;
import net.ibizsys.central.plugin.cs.metersphere.service.client.IMeterSphereClient;
import net.ibizsys.central.plugin.cs.metersphere.service.client.MeterSphereClient;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class MeterSphereActionRuntimeBase
extends PSRTModelExportActionRuntimeBase {
    private static final Log log = LogFactory.getLog(MeterSphereActionRuntimeBase.class);
    private IMeterSphereClient iMeterSphereClient = null;
    public static final String SETTING_PARAM_METERSPHERE_URL = "param.metersphere.url";
    public static final String SETTING_PARAM_METERSPHERE_USERNAME = "param.metersphere.username";
    public static final String SETTING_PARAM_METERSPHERE_PASSWORD = "param.metersphere.password";

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getMeterSphereClient(true) == null) {
            this.prepareMeterSphereClient();
        }
    }

    protected IMeterSphereClient getMeterSphereClient() {
        return this.getMeterSphereClient(false);
    }

    protected IMeterSphereClient getMeterSphereClient(boolean bTryMode) {
        if (this.iMeterSphereClient != null || bTryMode) {
            return this.iMeterSphereClient;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u672a\u6307\u5b9aMeterSphere\u5ba2\u6237\u7aef\u5bf9\u8c61", new Object[0]));
    }

    protected void setMeterSphereClient(IMeterSphereClient iMeterSphereClient) {
        this.iMeterSphereClient = iMeterSphereClient;
    }

    protected void prepareMeterSphereClient() {
        MeterSphereClient meterSphereClient = new MeterSphereClient(this.getSystemRuntime(), (IModelRuntime)this);
        meterSphereClient.setServiceUrl(this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_METERSPHERE_URL, null));
        meterSphereClient.setClientId(this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_METERSPHERE_USERNAME, null));
        meterSphereClient.setClientSecret(this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_METERSPHERE_PASSWORD, null));
        this.setMeterSphereClient(meterSphereClient);
    }

    protected String getExecuteStatus(String strResult) {
        if ("PASS".equals(strResult)) {
            return "Pass";
        }
        if ("FAILURE".equals(strResult)) {
            return "Failure";
        }
        if ("BLOCKING".equals(strResult)) {
            return "Blocking";
        }
        return null;
    }

    protected String getExpectedResult(IPSSysTestCaseAssert iPSSysTestCaseAssert) {
        String strResult = iPSSysTestCaseAssert.getMemo();
        if (StringUtils.hasLength((String)strResult)) {
            return strResult;
        }
        String strAssertType = iPSSysTestCaseAssert.getAssertType();
        if ("RESULT".equals(strAssertType)) {
            return String.format("[%1$s]\u9884\u671f\u7ed3\u679c", iPSSysTestCaseAssert.getName());
        }
        if ("EXCEPTION".equals(strAssertType)) {
            if (StringUtils.hasLength((String)iPSSysTestCaseAssert.getExceptionName())) {
                return String.format("[%1$s]\u9884\u671f\u5f02\u5e38(%2$s)", iPSSysTestCaseAssert.getName(), iPSSysTestCaseAssert.getExceptionName());
            }
            return String.format("[%1$s]\u9884\u671f\u5f02\u5e38", iPSSysTestCaseAssert.getName());
        }
        if ("NOEXCEPTION".equals(strAssertType)) {
            return String.format("[%1$s]\u9884\u671f\u65e0\u5f02\u5e38", iPSSysTestCaseAssert.getName());
        }
        if ("CUSTOMCODE".equals(strAssertType)) {
            return String.format("[%1$s]\u4ee3\u7801\u5224\u65ad", iPSSysTestCaseAssert.getName());
        }
        return String.format("[%1$s]%2$s", iPSSysTestCaseAssert.getName(), strAssertType);
    }
}

