/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.metersphere.dataentity.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.plugin.cs.metersphere.dataentity.action.MeterSphereActionRuntimeBase;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.plugin.cs.metersphere.util.MSSearchContextDTO;
import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSSysTestPrjDTO;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.testing.IPSDEActionTestCase;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.model.testing.IPSSysTestCaseInput;
import net.ibizsys.model.testing.IPSSysTestPrj;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class InitTestProjectsActionRuntime
extends MeterSphereActionRuntimeBase {
    private static final Log log = LogFactory.getLog(InitTestProjectsActionRuntime.class);
    public static final String TESTPRJTYPE_UNITTEST = "UNITTEST";
    public static final String TESTPRJTYPE_MODELTEST = "MODELTEST";
    public static final String TESTPRJTYPE_WFTEST = "WFTEST";

    protected Object onExportPSRTModel(IPSSystemService iPSSystemService, PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
        String strDefaultId;
        WorkspaceDTO workspaceDTO = this.getWorkspace(psDevSlnSysDTO, iPSSystemService);
        Map<String, ProjectDTO> projectDTOMap = this.getProjectMap(workspaceDTO, psDevSlnSysDTO, iPSSystemService);
        Object projectDTO = projectDTOMap.get(strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)psDevSlnSysDTO.getPSDevSlnSysId(), (Object)TESTPRJTYPE_UNITTEST, (Object)"DEFAULT"));
        if (projectDTO == null) {
            projectDTO = new ProjectDTO();
            projectDTO.setWorkspaceId(workspaceDTO.getId());
            projectDTO.setName(String.format("%1$s[\u9ed8\u8ba4\u5355\u5143\u6d4b\u8bd5]", psDevSlnSysDTO.getPSDevSlnSysName()));
            projectDTO.setAzureDevopsId(strDefaultId);
            projectDTO = this.getMeterSphereClient().createProject((ProjectDTO)((Object)projectDTO));
            projectDTOMap.put(projectDTO.getAzureDevopsId(), (ProjectDTO)((Object)projectDTO));
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u5f00\u59cb\u521d\u59cb\u5316\u6d4b\u8bd5\u9879\u76ee[%1$s]", projectDTO.getName()));
        this.initTestProject((ProjectDTO)((Object)projectDTO), TESTPRJTYPE_UNITTEST, null, psDevSlnSysDTO, iPSSystemService);
        strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)psDevSlnSysDTO.getPSDevSlnSysId(), (Object)TESTPRJTYPE_MODELTEST, (Object)"DEFAULT");
        projectDTO = projectDTOMap.get(strDefaultId);
        if (projectDTO == null) {
            projectDTO = new ProjectDTO();
            projectDTO.setWorkspaceId(workspaceDTO.getId());
            projectDTO.setName(String.format("%1$s[\u9ed8\u8ba4\u6a21\u578b\u6d4b\u8bd5]", psDevSlnSysDTO.getPSDevSlnSysName()));
            projectDTO.setAzureDevopsId(strDefaultId);
            projectDTO = this.getMeterSphereClient().createProject((ProjectDTO)((Object)projectDTO));
            projectDTOMap.put(projectDTO.getAzureDevopsId(), (ProjectDTO)((Object)projectDTO));
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u5f00\u59cb\u521d\u59cb\u5316\u6d4b\u8bd5\u9879\u76ee[%1$s]", projectDTO.getName()));
        this.initTestProject((ProjectDTO)((Object)projectDTO), TESTPRJTYPE_MODELTEST, null, psDevSlnSysDTO, iPSSystemService);
        strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)psDevSlnSysDTO.getPSDevSlnSysId(), (Object)TESTPRJTYPE_WFTEST, (Object)"DEFAULT");
        projectDTO = projectDTOMap.get(strDefaultId);
        if (projectDTO == null) {
            projectDTO = new ProjectDTO();
            projectDTO.setWorkspaceId(workspaceDTO.getId());
            projectDTO.setName(String.format("%1$s[\u9ed8\u8ba4\u5de5\u4f5c\u6d41\u6d4b\u8bd5]", psDevSlnSysDTO.getPSDevSlnSysName()));
            projectDTO.setAzureDevopsId(strDefaultId);
            projectDTO = this.getMeterSphereClient().createProject((ProjectDTO)((Object)projectDTO));
            projectDTOMap.put(projectDTO.getAzureDevopsId(), (ProjectDTO)((Object)projectDTO));
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u5f00\u59cb\u521d\u59cb\u5316\u6d4b\u8bd5\u9879\u76ee[%1$s]", projectDTO.getName()));
        this.initTestProject((ProjectDTO)((Object)projectDTO), TESTPRJTYPE_WFTEST, null, psDevSlnSysDTO, iPSSystemService);
        List psSysTestPrjList = iPSSystemService.getPSSystem().getAllPSSysTestPrjs();
        if (!ObjectUtils.isEmpty((Object)psSysTestPrjList)) {
            for (IPSSysTestPrj iPSSysTestPrj : psSysTestPrjList) {
                String strDefaultId2 = "ibiz-" + KeyValueUtils.genUniqueId((Object)psDevSlnSysDTO.getPSDevSlnSysId(), (Object)iPSSysTestPrj.getPrjType(), (Object)iPSSysTestPrj.getCodeName());
                ProjectDTO projectDTO2 = projectDTOMap.get(strDefaultId2);
                if (projectDTO2 != null) continue;
                projectDTO2 = new ProjectDTO();
                projectDTO2.setWorkspaceId(workspaceDTO.getId());
                projectDTO2.setName(String.format("%1$s[%2$s(%3$s)]", psDevSlnSysDTO.getPSDevSlnSysName(), iPSSysTestPrj.getName(), iPSSysTestPrj.getCodeName()));
                projectDTO2.setAzureDevopsId(strDefaultId2);
                projectDTO2 = this.getMeterSphereClient().createProject(projectDTO2);
                projectDTOMap.put(projectDTO2.getAzureDevopsId(), projectDTO2);
            }
        }
        ArrayList<PSSysTestPrjDTO> list = new ArrayList<PSSysTestPrjDTO>();
        for (ProjectDTO projectDTO3 : projectDTOMap.values()) {
            PSSysTestPrjDTO psSysTestPrj = new PSSysTestPrjDTO();
            psSysTestPrj.setPSSysTestPrjId(projectDTO3.getId());
            psSysTestPrj.setPSSysTestPrjName(projectDTO3.getName());
            list.add(psSysTestPrj);
        }
        return list;
    }

    protected WorkspaceDTO getWorkspace(PSDevSlnSysDTO psDevSlnSysDTO, IPSSystemService iPSSystemService) throws Throwable {
        MSSearchContextDTO msSearchContextDTO = new MSSearchContextDTO();
        msSearchContextDTO.set("name", psDevSlnSysDTO.getPSDevSlnName());
        WorkspaceDTO workspaceDTO = null;
        Page<WorkspaceDTO> workspaceDTOPage = this.getMeterSphereClient().listWorkspace(msSearchContextDTO);
        if (!ObjectUtils.isEmpty((Object)workspaceDTOPage.getContent())) {
            workspaceDTO = (WorkspaceDTO)((Object)workspaceDTOPage.getContent().get(0));
        } else {
            workspaceDTO = new WorkspaceDTO();
            workspaceDTO.setName(psDevSlnSysDTO.getPSDevSlnName());
            workspaceDTO = this.getMeterSphereClient().createWorkspace(workspaceDTO);
        }
        return workspaceDTO;
    }

    protected Map<String, ProjectDTO> getProjectMap(WorkspaceDTO workspaceDTO, PSDevSlnSysDTO psDevSlnSysDTO, IPSSystemService iPSSystemService) throws Throwable {
        MSSearchContextDTO projectSearchContextDTO = new MSSearchContextDTO();
        projectSearchContextDTO.set("workspaceId", workspaceDTO.getId());
        Page<ProjectDTO> projectDTOPage = this.getMeterSphereClient().listProject(projectSearchContextDTO);
        HashMap<String, ProjectDTO> projectDTOMap = new HashMap<String, ProjectDTO>();
        if (!ObjectUtils.isEmpty((Object)projectDTOPage.getContent())) {
            for (ProjectDTO projectDTO : projectDTOPage.getContent()) {
                if (!StringUtils.hasLength((String)projectDTO.getAzureDevopsId())) continue;
                projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
            }
        }
        return projectDTOMap;
    }

    protected void initTestProject(ProjectDTO projectDTO, String strProjectType, Object projectData, PSDevSlnSysDTO psDevSlnSysDTO, IPSSystemService iPSSystemService) throws Throwable {
        TestCaseNodeDTO testCaseNodeDTO;
        MSSearchContextDTO testCaseNodeSearchContextDTO = new MSSearchContextDTO();
        testCaseNodeSearchContextDTO.set("projectId", projectDTO.getId());
        Page<TestCaseNodeDTO> testCaseNodeDTOPage = this.getMeterSphereClient().listTestCaseNode(testCaseNodeSearchContextDTO);
        MSSearchContextDTO testCaseSearchContextDTO = new MSSearchContextDTO();
        testCaseSearchContextDTO.set("projectId", projectDTO.getId());
        Page<TestCaseDTO> testCaseDTOPage = this.getMeterSphereClient().listTestCase(testCaseSearchContextDTO);
        HashMap<String, TestCaseDTO> testCaseDTOMap = new HashMap<String, TestCaseDTO>();
        if (!ObjectUtils.isEmpty((Object)testCaseDTOPage.getContent())) {
            block0: for (TestCaseDTO testCaseDTO : testCaseDTOPage.getContent()) {
                if (!StringUtils.hasLength((String)testCaseDTO.getTags())) continue;
                testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
                ArrayNode tags = JsonUtils.toArrayNode((Object)testCaseDTO.getTags());
                if (ObjectUtils.isEmpty((Object)tags)) continue;
                for (Object objTag : tags) {
                    String strTag;
                    if (!(objTag instanceof JsonNode) || ObjectUtils.isEmpty((Object)(strTag = ((JsonNode)objTag).asText())) || strTag.toLowerCase().indexOf("ibiz-") != 0) continue;
                    testCaseDTOMap.put(strTag.toLowerCase(), testCaseDTO);
                    continue block0;
                }
            }
        }
        if (TESTPRJTYPE_UNITTEST.equals(strProjectType)) {
            List psDataEntityList = iPSSystemService.getPSSystem().getAllPSDataEntities();
            if (ObjectUtils.isEmpty((Object)psDataEntityList)) {
                return;
            }
            for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                List psSysTestCaseList = iPSDataEntity.getAllPSSysTestCases();
                if (ObjectUtils.isEmpty((Object)psSysTestCaseList)) continue;
                testCaseNodeDTO = null;
                if (!ObjectUtils.isEmpty((Object)testCaseNodeDTOPage.getContent())) {
                    Iterator strName = String.format("(%1$s)", iPSDataEntity.getName());
                    for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
                        if (!StringUtils.hasLength((String)item.getName()) || item.getName().indexOf((String)((Object)strName)) == -1) continue;
                        testCaseNodeDTO = item;
                        break;
                    }
                }
                if (testCaseNodeDTO == null) {
                    testCaseNodeDTO = new TestCaseNodeDTO();
                    testCaseNodeDTO.setProjectId(projectDTO.getId());
                    testCaseNodeDTO.setName(String.format("%1$s(%2$s)", iPSDataEntity.getLogicName(), iPSDataEntity.getName()));
                    testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
                    testCaseNodeDTO.set("level", 1);
                    testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
                }
                for (IPSSysTestCase iPSSysTestCase : psSysTestCaseList) {
                    IPSDEAction iPSDEAction;
                    String strTag = String.format("ibiz-%1$s-%2$s", iPSDataEntity.getName(), iPSSysTestCase.getCodeName()).toLowerCase();
                    TestCaseDTO testCaseDTO = (TestCaseDTO)((Object)testCaseDTOMap.get(strTag));
                    if (testCaseDTO != null) continue;
                    testCaseDTO = new TestCaseDTO();
                    testCaseDTO.setName(iPSSysTestCase.getName());
                    testCaseDTO.setNodeId(testCaseNodeDTO.getId());
                    testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
                    testCaseDTO.setPriority("P2");
                    testCaseDTO.setProjectId(projectDTO.getId());
                    testCaseDTO.setOrder(iPSSysTestCase.getOrderValue());
                    testCaseDTO.setReviewStatus("Prepare");
                    testCaseDTO.setStatus("Prepare");
                    testCaseDTO.setType("functional");
                    testCaseDTO.setStepModel("STEP");
                    ArrayNode tags = JsonUtils.createArrayNode();
                    tags.add(strTag);
                    tags.add(iPSSysTestCase.getTestCaseType());
                    if (iPSSysTestCase instanceof IPSDEActionTestCase && (iPSDEAction = ((IPSDEActionTestCase)iPSSysTestCase).getPSDEAction()) != null) {
                        tags.add(iPSDEAction.getName());
                    }
                    testCaseDTO.setTags(tags.toString());
                    ArrayNode steps = JsonUtils.createArrayNode();
                    List inputs = iPSSysTestCase.getPSSysTestCaseInputs();
                    if (!ObjectUtils.isEmpty((Object)inputs)) {
                        int nNum = 0;
                        for (IPSSysTestCaseInput iPSSysTestCaseInput : inputs) {
                            ObjectNode step = steps.addObject();
                            step.put("num", ++nNum);
                            String strDesc = iPSSysTestCaseInput.getMemo();
                            if (!StringUtils.hasLength((String)strDesc)) {
                                strDesc = iPSSysTestCaseInput.getName();
                            }
                            step.put("desc", strDesc);
                            String strResultList = "";
                            if (!ObjectUtils.isEmpty((Object)iPSSysTestCaseInput.getPSSysTestCaseAsserts())) {
                                for (IPSSysTestCaseAssert iPSSysTestCaseAssert : iPSSysTestCaseInput.getPSSysTestCaseAsserts()) {
                                    String strResult = this.getExpectedResult(iPSSysTestCaseAssert);
                                    if (StringUtils.hasLength((String)strResultList)) {
                                        strResultList = strResultList + "\u3001";
                                    }
                                    strResultList = strResultList + strResult;
                                }
                            }
                            step.put("result", strResultList);
                        }
                    }
                    testCaseDTO.setSteps(steps.toString());
                    testCaseDTO.set("maintainer", this.getMeterSphereClient().getClientId());
                    testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
                    testCaseDTOMap.put(strTag, testCaseDTO);
                    testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
                }
            }
            return;
        }
        if (TESTPRJTYPE_WFTEST.equals(strProjectType)) {
            List psWorkflowList = iPSSystemService.getPSSystem().getAllPSWorkflows();
            if (ObjectUtils.isEmpty((Object)psWorkflowList)) {
                return;
            }
            for (IPSWorkflow iPSWorkflow : psWorkflowList) {
                TestCaseNodeDTO testCaseNodeDTO2 = null;
                if (!ObjectUtils.isEmpty((Object)testCaseNodeDTOPage.getContent())) {
                    String strName = String.format("(%1$s)", iPSWorkflow.getCodeName());
                    for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
                        if (!StringUtils.hasLength((String)item.getName()) || item.getName().indexOf(strName) == -1) continue;
                        testCaseNodeDTO2 = item;
                        break;
                    }
                }
                if (testCaseNodeDTO2 != null) continue;
                testCaseNodeDTO2 = new TestCaseNodeDTO();
                testCaseNodeDTO2.setProjectId(projectDTO.getId());
                testCaseNodeDTO2.setName(String.format("%1$s(%2$s)", iPSWorkflow.getName(), iPSWorkflow.getCodeName()));
                testCaseNodeDTO2.set("label", testCaseNodeDTO2.getName());
                testCaseNodeDTO2.set("level", 1);
                testCaseNodeDTO2 = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO2);
            }
            return;
        }
        if (TESTPRJTYPE_MODELTEST.equals(strProjectType)) {
            List psSysServiceAPIList = iPSSystemService.getPSSystem().getAllPSSysServiceAPIs();
            if (!ObjectUtils.isEmpty((Object)psSysServiceAPIList)) {
                for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
                    String strTag;
                    TestCaseDTO testCaseDTO;
                    List psDEServiceAPIRSList;
                    String strName = String.format("\u670d\u52a1\u63a5\u53e3[%1$s(%2$s)]", iPSSysServiceAPI.getName(), iPSSysServiceAPI.getCodeName());
                    testCaseNodeDTO = null;
                    if (!ObjectUtils.isEmpty((Object)testCaseNodeDTOPage.getContent())) {
                        for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
                            if (!StringUtils.hasLength((String)item.getName()) || item.getName().indexOf(strName) == -1) continue;
                            testCaseNodeDTO = item;
                            break;
                        }
                    }
                    if (testCaseNodeDTO == null) {
                        testCaseNodeDTO = new TestCaseNodeDTO();
                        testCaseNodeDTO.setProjectId(projectDTO.getId());
                        testCaseNodeDTO.setName(strName);
                        testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
                        testCaseNodeDTO.set("level", 1);
                        testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
                    }
                    if (ObjectUtils.isEmpty((Object)(psDEServiceAPIRSList = iPSSysServiceAPI.getPSDEServiceAPIRSs())) || (testCaseDTO = (TestCaseDTO)((Object)testCaseDTOMap.get(strTag = String.format("ibiz-%1$s-%2$s", "desars", iPSSysServiceAPI.getCodeName()).toLowerCase()))) != null) continue;
                    testCaseDTO = new TestCaseDTO();
                    testCaseDTO.setName("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb\u5408\u7406\u6027\u6821\u9a8c");
                    testCaseDTO.setNodeId(testCaseNodeDTO.getId());
                    testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
                    testCaseDTO.setPriority("P2");
                    testCaseDTO.setProjectId(projectDTO.getId());
                    testCaseDTO.setReviewStatus("Prepare");
                    testCaseDTO.setStatus("Prepare");
                    testCaseDTO.setType("functional");
                    testCaseDTO.setStepModel("TEXT");
                    testCaseDTO.setStepDescription("\u5224\u65ad\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb\u662f\u5426\u5b58\u5728\u9644\u5c5e\u6216\u63a7\u5236\u5173\u7cfb");
                    testCaseDTO.setExpectedResult("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb\u90fd\u5b58\u5728\u9644\u5c5e\u6216\u63a7\u5236\u5173\u7cfb");
                    ArrayNode tags = JsonUtils.createArrayNode();
                    tags.add(strTag);
                    testCaseDTO.setTags(tags.toString());
                    testCaseDTO.set("maintainer", this.getMeterSphereClient().getClientId());
                    testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
                    testCaseDTOMap.put(strTag, testCaseDTO);
                    testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
                }
            }
            return;
        }
    }
}

