package net.ibizsys.central.plugin.cs.metersphere.util;

import com.fasterxml.jackson.annotation.JsonIgnore;

import net.ibizsys.central.util.EntityDTO;

public class MSEntityDTO extends EntityDTO {

	@Override
	@JsonIgnore
	protected boolean isLowerCaseName() {
		return false;
	}

	public final static String FIELD_ID = "id";

	public final static String FIELD_NAME = "name";

	public final static String FIELD_DESCRIPTION = "description";

	public final static String FIELD_REMARK = "remark";
	
	/**
	 * 设置「标识」
	 *
	 * @param val
	 */
	@JsonIgnore
	public void setId(String val) {
		this.set(FIELD_ID, val);
	}

	/**
	 * 获取「标识」值
	 *
	 */
	@JsonIgnore
	public String getId() {
		return (String) this.get(FIELD_ID);
	}

	/**
	 * 判断 「标识」是否有值
	 *
	 */
	@JsonIgnore
	public boolean containsPostId() {
		return this.contains(FIELD_ID);
	}

	/**
	 * 重置 「标识」
	 *
	 */
	@JsonIgnore
	public void resetId() {
		this.reset(FIELD_ID);

	}

	/**
	 * 设置「名称」
	 *
	 * @param val
	 */
	@JsonIgnore
	public void setName(String val) {
		this.set(FIELD_NAME, val);

	}

	/**
	 * 获取「名称」值
	 *
	 */
	@JsonIgnore
	public String getName() {
		return (String) this.get(FIELD_NAME);
	}

	/**
	 * 判断 「名称」是否有值
	 *
	 */
	@JsonIgnore
	public boolean containsPostName() {
		return this.contains(FIELD_NAME);
	}

	/**
	 * 重置 「名称」
	 *
	 */
	@JsonIgnore
	public void resetName() {
		this.reset(FIELD_NAME);

	}

	/**
	 * 设置「描述」
	 *
	 * @param val
	 */
	@JsonIgnore
	public void setDescription(String val) {
		this.set(FIELD_DESCRIPTION, val);

	}

	/**
	 * 获取「描述」值
	 *
	 */
	@JsonIgnore
	public String getDescription() {
		return (String) this.get(FIELD_DESCRIPTION);
	}

	/**
	 * 判断 「描述」是否有值
	 *
	 */
	@JsonIgnore
	public boolean containsDescription() {
		return this.contains(FIELD_DESCRIPTION);
	}

	/**
	 * 重置 「描述」
	 *
	 */
	@JsonIgnore
	public void resetDescription() {
		this.reset(FIELD_DESCRIPTION);

	}

	

	/**
	 * 设置「备注」
	 *
	 * @param val
	 */
	@JsonIgnore
	public void setRemark(String val) {
		this.set(FIELD_REMARK, val);

	}

	/**
	 * 获取「备注」值
	 *
	 */
	@JsonIgnore
	public String getRemark() {
		return (String) this.get(FIELD_REMARK);
	}

	/**
	 * 判断 「备注」是否有值
	 *
	 */
	@JsonIgnore
	public boolean containsRemark() {
		return this.contains(FIELD_REMARK);
	}

	/**
	 * 重置 「备注」
	 *
	 */
	@JsonIgnore
	public void resetRemark() {
		this.reset(FIELD_REMARK);

	}
}
