package net.ibizsys.central.plugin.cs.metersphere.service.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.central.ISystemRuntime;

import net.ibizsys.central.plugin.cs.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestPlanCaseDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestPlanDTO;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.plugin.cs.metersphere.util.MSSearchContextDTO;
import net.ibizsys.central.service.client.ITokenUtil;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.service.client.TokenUtilBase;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;

public class MeterSphereClient implements IMeterSphereClient {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(MeterSphereClient.class);
	private ISystemRuntime iSystemRuntime = null;
	private IModelRuntime iModelRuntime = null;
	
	private String strServiceUrl = null;
	
	private String strClientId = null;

	private String strClientSecret = null;
	
	private ITokenUtil iTokenUtil = null;
	
	public MeterSphereClient(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime) {
		Assert.notNull(iSystemRuntime, "传入系统运行时对象无效");
		Assert.notNull(iModelRuntime, "传入所属模型运行时对象无效");
		this.setSystemRuntime(iSystemRuntime);
		this.setModelRuntime(iModelRuntime);
	}
	
	protected ISystemRuntime getSystemRuntime() {
		return iSystemRuntime;
	}

	protected void setSystemRuntime(ISystemRuntime iSystemRuntime) {
		this.iSystemRuntime = iSystemRuntime;
	}
	
	
	
	protected IModelRuntime getModelRuntime() {
		return iModelRuntime;
	}

	protected void setModelRuntime(IModelRuntime iModelRuntime) {
		this.iModelRuntime = iModelRuntime;
	}

	public String getServiceUrl() {
		return strServiceUrl;
	}

	public void setServiceUrl(String strServiceUrl) {
		this.strServiceUrl = strServiceUrl;
	}

	public String getClientId() {
		return strClientId;
	}

	public void setClientId(String strClientId) {
		this.strClientId = strClientId;
	}

	public String getClientSecret() {
		return strClientSecret;
	}

	public void setClientSecret(String strClientSecret) {
		this.strClientSecret = strClientSecret;
	}
	
	protected String getToken() {
		return this.getTokenUtil().getToken();
	}

	protected  ITokenUtil getTokenUtil() {
		if(iTokenUtil != null) {
			return iTokenUtil;
		}
		
		synchronized (this) {
			if(iTokenUtil == null) {
				iTokenUtil = this.createTokenUtil();
			}
		}
		return iTokenUtil;
	}
	
	protected ITokenUtil createTokenUtil() {
		return  new TokenUtilBase(this.getSystemRuntime(), this.getModelRuntime()) {
			
			@Override
			protected String doRequestToken() throws Throwable {
				Map<String, String> map = new LinkedHashMap<String, String>();
				if(StringUtils.hasLength(getClientId())) {
					map.put("username", getClientId());
				}
				if(StringUtils.hasLength(getClientSecret())) {
					map.put("password", getClientSecret());
				}
				map.put("authenticate", "LDAP");

				String strUri = String.format("%1$s/ldap/signin", getServiceUrl());

				IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, null, null, map, null, Map.class, null);
				Map ret = rep.getBody();
				

				Object success = ret.get("success");
				if(!DataTypeUtils.getBooleanValue(success, false)) {
					throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
				}
				
				Object accessToken = null;
				Object data = ret.get("data");
				if(data instanceof Map) {
					accessToken = ((Map)data).get("csrfToken");
				}
				
				List<String> list = rep.getHeaderValues("Set-Cookie");
				if(!ObjectUtils.isEmpty(list)) {
					for(String strValue : list) {
						if(!StringUtils.hasLength(strValue)) {
							continue;
						}
						if(strValue.indexOf("MS_SESSION_ID=") == -1) {
							continue;
						}
						String[] items = strValue.split("[;]");
						for(String strItem : items) {
							if(strValue.indexOf("MS_SESSION_ID=") == 0) {
								accessToken += ";";
								accessToken += strItem;
								break;
							}
						}
					}
				}
				
				return (String) accessToken;
			}
		};
	}
	
	protected Map<String, String> getHeaders() {
		String strToken = this.getToken();
		String[] items = strToken.split("[;]");
		
		Map<String, String> headers = new HashMap<String, String>();
		headers.put("CSRF-TOKEN", items[0]);
		if(items.length > 1) {
			headers.put("Cookie", items[1]);
		}
		
		return headers;
	}
	
	@Override
	public Page<WorkspaceDTO> listWorkspace(MSSearchContextDTO msSearchContextDTO) throws Throwable {
	
		Map<String, Object> uriParams = new HashMap<String, Object>();
		uriParams.put("goPage", 1);
		uriParams.put("pageSize", 500);
		//if(msSearchContextDTO.getPageable()!=)
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/workspace/list/all/{goPage}/{pageSize}", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, msSearchContextDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			Object listObject = ((Map) data).get("listObject");
			
			List<WorkspaceDTO> list = JsonUtils.MAPPER.convertValue(listObject, new TypeReference<List<WorkspaceDTO>>(){});
			
			// "itemCount": 0,
			//  "pageCount": 0
			return new PageImpl<WorkspaceDTO>(list);
		}
		
		throw new Exception("无法识别的返回内容");
	}

	@Override
	public WorkspaceDTO createWorkspace(WorkspaceDTO workspaceDTO) throws Throwable {
		
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/workspace/add", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, workspaceDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			return JsonUtils.MAPPER.convertValue(data, WorkspaceDTO.class);
		}
		
		
		throw new Exception("无法识别的返回内容");
	}
	
	
	@Override
	public Page<ProjectDTO> listProject(MSSearchContextDTO msSearchContextDTO) throws Throwable {
	
		Map<String, Object> uriParams = new HashMap<String, Object>();
		uriParams.put("goPage", 1);
		uriParams.put("pageSize", 500);
		//if(msSearchContextDTO.getPageable()!=)
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/project/list/{goPage}/{pageSize}", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, msSearchContextDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			Object listObject = ((Map) data).get("listObject");
			
			List<ProjectDTO> list = JsonUtils.MAPPER.convertValue(listObject, new TypeReference<List<ProjectDTO>>(){});
			
			// "itemCount": 0,
			//  "pageCount": 0
			return new PageImpl<ProjectDTO>(list);
		}
		
		throw new Exception("无法识别的返回内容");
	}

	@Override
	public ProjectDTO createProject(ProjectDTO projectDTO) throws Throwable {
		
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/project/add", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, projectDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			return JsonUtils.MAPPER.convertValue(data, ProjectDTO.class);
		}
		
		
		throw new Exception("无法识别的返回内容");
	}
	
	
	@Override
	public Page<TestCaseNodeDTO> listTestCaseNode(MSSearchContextDTO msSearchContextDTO) throws Throwable {
	
		Map<String, Object> uriParams = new HashMap<String, Object>();
		uriParams.put("goPage", 1);
		uriParams.put("pageSize", 500);
		//if(msSearchContextDTO.getPageable()!=)
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/case/node/list/project", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, msSearchContextDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof List) {
			List<TestCaseNodeDTO> list = JsonUtils.MAPPER.convertValue(data, new TypeReference<List<TestCaseNodeDTO>>(){});
			
			// "itemCount": 0,
			//  "pageCount": 0
			return new PageImpl<TestCaseNodeDTO>(list);
		}
		
		throw new Exception("无法识别的返回内容");
	}

	@Override
	public TestCaseNodeDTO createTestCaseNode(TestCaseNodeDTO testCaseNodeDTO) throws Throwable {
		
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/case/node/add", getServiceUrl());

		IWebClientRep<String> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, testCaseNodeDTO, null, String.class, null);
		ObjectNode objectNode = JsonUtils.toObjectNode(rep.getBody());
		Map ret = JsonUtils.MAPPER.convertValue(objectNode, Map.class);
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			return JsonUtils.MAPPER.convertValue(data, TestCaseNodeDTO.class);
		}
		if(data instanceof String) {
			testCaseNodeDTO.setId((String)data);
			return testCaseNodeDTO;
		}
		
		throw new Exception("无法识别的返回内容");
	}
	
	
	@Override
	public Page<TestCaseDTO> listTestCase(MSSearchContextDTO msSearchContextDTO) throws Throwable {
	
		Map<String, Object> uriParams = new HashMap<String, Object>();
		uriParams.put("goPage", 1);
		uriParams.put("pageSize", 500);
		//if(msSearchContextDTO.getPageable()!=)
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/test/case/list/{goPage}/{pageSize}", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, msSearchContextDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			Object listObject = ((Map) data).get("listObject");
			
			List<TestCaseDTO> list = JsonUtils.MAPPER.convertValue(listObject, new TypeReference<List<TestCaseDTO>>(){});
			// "itemCount": 0,
			//  "pageCount": 0
			return new PageImpl<TestCaseDTO>(list);
		}
		
		throw new Exception("无法识别的返回内容");
	}

	@Override
	public TestCaseDTO createTestCase(TestCaseDTO testCaseDTO) throws Throwable {
		
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/test/case/save", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, testCaseDTO, null, Map.class, null);
		Map ret = rep.getBody();
		//Map ret = JsonUtils.MAPPER.convertValue(rep.getBody(), Map.class);
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			return JsonUtils.MAPPER.convertValue(data, TestCaseDTO.class);
		}
		
		
		throw new Exception("无法识别的返回内容");
	}
	
	
	@Override
	public Page<TestPlanDTO> listTestPlan(MSSearchContextDTO msSearchContextDTO) throws Throwable {
	
		Map<String, Object> uriParams = new HashMap<String, Object>();
		uriParams.put("goPage", 1);
		uriParams.put("pageSize", 500);
		//if(msSearchContextDTO.getPageable()!=)
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/test/plan/list/{goPage}/{pageSize}", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, msSearchContextDTO, null, Map.class, null);
		Map ret = rep.getBody();
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			Object listObject = ((Map) data).get("listObject");
			
			List<TestPlanDTO> list = JsonUtils.MAPPER.convertValue(listObject, new TypeReference<List<TestPlanDTO>>(){});
			// "itemCount": 0,
			//  "pageCount": 0
			return new PageImpl<TestPlanDTO>(list);
		}
		
		throw new Exception("无法识别的返回内容");
	}

	@Override
	public TestPlanDTO createTestPlan(TestPlanDTO testCaseDTO) throws Throwable {
		
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/test/plan/add", getServiceUrl());

		IWebClientRep<Map> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, testCaseDTO, null, Map.class, null);
		Map ret = rep.getBody();
		//Map ret = JsonUtils.MAPPER.convertValue(rep.getBody(), Map.class);
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof Map) {
			return JsonUtils.MAPPER.convertValue(data, TestPlanDTO.class);
		}
		
		
		throw new Exception("无法识别的返回内容");
	}

	@Override
	public void relevanceTestPlan(TestPlanDTO testPlanDTO, Collection<String> testCaseIds) throws Throwable {
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		data.put("ids", testCaseIds);
		data.put("planId", testPlanDTO.getId());
		data.put("checked", true);
		
		Map<String, String> headers = getHeaders();
		
		String strUri = String.format("%1$s/test/plan/relevance", getServiceUrl());

		IWebClientRep<String> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, data, null, String.class, null);
		ObjectNode objectNode = JsonUtils.toObjectNode(rep.getBody());
		Map ret = JsonUtils.MAPPER.convertValue(objectNode, Map.class);
		//Map ret = JsonUtils.MAPPER.convertValue(rep.getBody(), Map.class);
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
	}
	
	
	@Override
	public Page<TestPlanCaseDTO> listTestPlanCase(MSSearchContextDTO msSearchContextDTO) throws Throwable {
	
		Map<String, Object> uriParams = new HashMap<String, Object>();
		uriParams.put("goPage", 1);
		uriParams.put("pageSize", 500);
		//if(msSearchContextDTO.getPageable()!=)
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/test/plan/case/list/ids", getServiceUrl());

		IWebClientRep<String> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, msSearchContextDTO, null, String.class, null);
		ObjectNode objectNode = JsonUtils.toObjectNode(rep.getBody());
		Map ret = JsonUtils.MAPPER.convertValue(objectNode, Map.class);
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		Object data = ret.get("data");
		if(data instanceof List) {
			
			List<TestPlanCaseDTO> list = JsonUtils.MAPPER.convertValue(data, new TypeReference<List<TestPlanCaseDTO>>(){});
			// "itemCount": 0,
			//  "pageCount": 0
			return new PageImpl<TestPlanCaseDTO>(list);
		}
		
		throw new Exception("无法识别的返回内容");
	}
	
	
	@Override
	public void editTestPlanCase(TestPlanCaseDTO testPlanCaseDTO) throws Throwable {
		
		Map<String, String> headers = getHeaders();
		
		
		String strUri = String.format("%1$s/test/plan/case/edit", getServiceUrl());

		IWebClientRep<String> rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, testPlanCaseDTO, null, String.class, null);
		ObjectNode objectNode = JsonUtils.toObjectNode(rep.getBody());
		Map ret = JsonUtils.MAPPER.convertValue(objectNode, Map.class);
		//Map ret = JsonUtils.MAPPER.convertValue(rep.getBody(), Map.class);
		Object success = ret.get("success");
		if(!DataTypeUtils.getBooleanValue(success, false)) {
			throw new Exception(String.format("返回错误，%1$s", ret.get("message")));
		}
		
		
	}
}
