package net.ibizsys.central.plugin.cs.metersphere.dataentity.action;

import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

import net.ibizsys.central.plugin.cs.core.dataentity.action.PSRTModelExportActionRuntimeBase;
import net.ibizsys.central.plugin.cs.metersphere.service.client.IMeterSphereClient;
import net.ibizsys.central.plugin.cs.metersphere.service.client.MeterSphereClient;
import net.ibizsys.central.plugin.cs.metersphere.service.dto.TestPlanCaseDTO;
import net.ibizsys.central.testing.TestCaseAssertTypes;
import net.ibizsys.central.testing.TestCaseRunResult;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.runtime.SystemRuntimeException;

public abstract class MeterSphereActionRuntimeBase extends PSRTModelExportActionRuntimeBase {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(MeterSphereActionRuntimeBase.class);

	private IMeterSphereClient iMeterSphereClient = null;

	/**
	 * 系统设置：MeterSphere接口路径
	 */
	public final static String SETTING_PARAM_METERSPHERE_URL = "param.metersphere.url";
	
	/**
	 * 系统设置：MeterSphere 用户名
	 */
	public final static String SETTING_PARAM_METERSPHERE_USERNAME = "param.metersphere.username";
	
	/**
	 * 系统设置：MeterSphere 密码
	 */
	public final static String SETTING_PARAM_METERSPHERE_PASSWORD = "param.metersphere.password";
	
	
	@Override
	protected void onInit() throws Exception {
		super.onInit();

		if (this.getMeterSphereClient(true) == null) {
			this.prepareMeterSphereClient();
		}
	}

	protected IMeterSphereClient getMeterSphereClient() {
		return getMeterSphereClient(false);
	}

	protected IMeterSphereClient getMeterSphereClient(boolean bTryMode) {
		if (this.iMeterSphereClient != null || bTryMode) {
			return this.iMeterSphereClient;
		}
		throw new SystemRuntimeException(this.getSystemRuntime(), this, String.format("未指定MeterSphere客户端对象"));
	}

	protected void setMeterSphereClient(IMeterSphereClient iMeterSphereClient) {
		this.iMeterSphereClient = iMeterSphereClient;
	}

	protected void prepareMeterSphereClient() {
		MeterSphereClient meterSphereClient = new MeterSphereClient(this.getSystemRuntime(), this);
		meterSphereClient.setServiceUrl(this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_METERSPHERE_URL, null));
		meterSphereClient.setClientId(this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_METERSPHERE_USERNAME, null));
		meterSphereClient.setClientSecret(this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_METERSPHERE_PASSWORD, null));
		this.setMeterSphereClient(meterSphereClient);
	}
	
	
	
	
	
	protected String getExecuteStatus(String strResult) {
		
		if(TestCaseRunResult.STATUS_PASS.equals(strResult)) {
			return TestPlanCaseDTO.STATUS_PASS;
		}
		
		if(TestCaseRunResult.STATUS_FAILURE.equals(strResult)) {
			return TestPlanCaseDTO.STATUS_FAILURE;
		}
		
		if(TestCaseRunResult.STATUS_BLOCKING.equals(strResult)) {
			return TestPlanCaseDTO.STATUS_BLOCKING;
		}
		
		return null;
		
	}
	
	
	/**
	 * 获取传入断言的预期结果
	 * @param iPSSysTestCaseAssert
	 * @return
	 */
	protected String getExpectedResult(IPSSysTestCaseAssert iPSSysTestCaseAssert){
		
		String strResult = iPSSysTestCaseAssert.getMemo();
		if (StringUtils.hasLength(strResult)) {
			return strResult;
		}
		String strAssertType = iPSSysTestCaseAssert.getAssertType();
		if(TestCaseAssertTypes.RESULT.equals(strAssertType)) {
			return String.format("[%1$s]预期结果",iPSSysTestCaseAssert.getName());
		}
		
		if(TestCaseAssertTypes.EXCEPTION.equals(strAssertType)) {
			if(StringUtils.hasLength(iPSSysTestCaseAssert.getExceptionName())) {
				return String.format("[%1$s]预期异常(%2$s)", iPSSysTestCaseAssert.getName(), iPSSysTestCaseAssert.getExceptionName());
			}
			else {
				return String.format("[%1$s]预期异常", iPSSysTestCaseAssert.getName());
			}
		}
		
		if(TestCaseAssertTypes.NOEXCEPTION.equals(strAssertType)) {
			return String.format("[%1$s]预期无异常", iPSSysTestCaseAssert.getName());
		}
		
		if(TestCaseAssertTypes.CUSTOMCODE.equals(strAssertType)) {
			return String.format("[%1$s]代码判断",iPSSysTestCaseAssert.getName());
		}
		
		return String.format("[%1$s]%2$s",iPSSysTestCaseAssert.getName(), strAssertType);
	}
}
