package net.ibizsys.central.plugin.cs.core.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.centralstudio.dto.PSCodeItemDTO;
import net.ibizsys.centralstudio.dto.PSCodeListDTO;
import net.ibizsys.centralstudio.dto.PSDEActionDTO;
import net.ibizsys.centralstudio.dto.PSDEDataSetDTO;
import net.ibizsys.centralstudio.dto.PSDEFieldDTO;
import net.ibizsys.centralstudio.dto.PSDEOPPrivDTO;
import net.ibizsys.centralstudio.dto.PSDERDTO;
import net.ibizsys.centralstudio.dto.PSDESADetailDTO;
import net.ibizsys.centralstudio.dto.PSDESARSDTO;
import net.ibizsys.centralstudio.dto.PSDEServiceAPIDTO;
import net.ibizsys.centralstudio.dto.PSDataEntityDTO;
import net.ibizsys.centralstudio.dto.PSModuleDTO;
import net.ibizsys.centralstudio.dto.PSSubSysServiceAPIDTO;
import net.ibizsys.centralstudio.dto.PSSysModelGroupDTO;
import net.ibizsys.centralstudio.dto.PSSysServiceAPIDTO;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.EntityBase;
import net.ibizsys.centralstudio.util.LogLevels;
import net.ibizsys.centralstudio.util.PSModelServiceSession;
import net.ibizsys.centralstudio.util.PSModelServiceUtils;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums.CodeListType;
import net.ibizsys.model.PSModelEnums.DEActionType;
import net.ibizsys.model.PSModelEnums.DEFDataType;
import net.ibizsys.model.PSModelEnums.DEFType;
import net.ibizsys.model.PSModelEnums.DER1NRemoveActionType;
import net.ibizsys.model.PSModelEnums.DEStorageType;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2ManyDataDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2OneDataDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.priv.IPSDEOPPriv;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.util.IEntity;

public class PSRTAPIModelImportLogicRuntime extends PSRTModelExportLogicRuntimeBase{

	private static final Log log = LogFactory.getLog(PSRTAPIModelImportLogicRuntime.class);
	
	private ThreadLocal<Map<String, PSModuleDTO>> psModuleDTOMapThreadLocal = new ThreadLocal<Map<String,PSModuleDTO>>() {
		protected java.util.Map<String,PSModuleDTO> initialValue() {
			return new HashMap<String, PSModuleDTO>();
		}
	};
	
	private ThreadLocal<Map<String, PSCodeListDTO>> psCodeListDTOMapThreadLocal = new ThreadLocal<Map<String,PSCodeListDTO>>(){
		protected java.util.Map<String,PSCodeListDTO> initialValue() {
			return new HashMap<String, PSCodeListDTO>();
		} 
	};
	private ThreadLocal<Map<String, PSDataEntityDTO>> psDataEntityDTOMapThreadLocal = new ThreadLocal<Map<String, PSDataEntityDTO>>() {
		protected java.util.Map<String,PSDataEntityDTO> initialValue() {
			return new HashMap<String, PSDataEntityDTO>();
		}
	};
	
	private ThreadLocal<Map<String, PSDERDTO>> psDERDTOMapThreadLocal = new ThreadLocal<Map<String, PSDERDTO>>(){
		protected java.util.Map<String,PSDERDTO> initialValue() {
			return new HashMap<String, PSDERDTO>();
		}
	};
	
	private ThreadLocal<Map<String, PSDEFieldDTO>> psDEFieldDTOMapThreadLocal = new ThreadLocal<Map<String, PSDEFieldDTO>>(){
		protected java.util.Map<String,PSDEFieldDTO> initialValue() {
			return new HashMap<String, PSDEFieldDTO>();
		}
	};
	
	
	private ThreadLocal<Map<String, PSDEDataSetDTO>> psDEDataSetDTOMapThreadLocal = new ThreadLocal<Map<String, PSDEDataSetDTO>>(){
		protected java.util.Map<String,PSDEDataSetDTO> initialValue() {
			return new HashMap<String, PSDEDataSetDTO>();
		}
	};
	private ThreadLocal<Map<String, PSDEActionDTO>> psDEActionDTOMapThreadLocal = new ThreadLocal<Map<String, PSDEActionDTO>>(){
		protected java.util.Map<String,PSDEActionDTO> initialValue() {
			return new HashMap<String, PSDEActionDTO>();
		}
	};
	private ThreadLocal<Map<String, PSDEServiceAPIDTO>> psDEServiceAPIDTOMapThreadLocal = new ThreadLocal<Map<String, PSDEServiceAPIDTO>>(){
		protected java.util.Map<String,PSDEServiceAPIDTO> initialValue() {
			return new HashMap<String, PSDEServiceAPIDTO>();
		}
	};
	private ThreadLocal<Map<String, PSDESARSDTO>> psDESARSDTOMapThreadLocal = new ThreadLocal<Map<String, PSDESARSDTO>>(){
		protected java.util.Map<String,PSDESARSDTO> initialValue() {
			return new HashMap<String, PSDESARSDTO>();
		}
	};

	private ThreadLocal<PSSysModelGroupDTO> psSysModelGroupDTOThreadLocal = new ThreadLocal<PSSysModelGroupDTO>();
	private ThreadLocal<PSSysServiceAPIDTO> psSysServiceAPIDTOThreadLocal = new ThreadLocal<PSSysServiceAPIDTO>();
	private ThreadLocal<PSSubSysServiceAPIDTO> psSubSysServiceAPIDTOThreadLocal = new ThreadLocal<PSSubSysServiceAPIDTO>();

	protected void resetSessionParams() {
		onResetSessionParams();
	}
	
	protected void onResetSessionParams() {
		psModuleDTOMapThreadLocal.remove();
		psCodeListDTOMapThreadLocal.remove();
		psDataEntityDTOMapThreadLocal.remove();
		psDERDTOMapThreadLocal.remove();
		psDEFieldDTOMapThreadLocal.remove();
		psDEDataSetDTOMapThreadLocal.remove();
		psDEActionDTOMapThreadLocal.remove();
		psDEServiceAPIDTOMapThreadLocal.remove();
		psDESARSDTOMapThreadLocal.remove();
		psSysModelGroupDTOThreadLocal.remove();
		psSysServiceAPIDTOThreadLocal.remove();
		psSubSysServiceAPIDTOThreadLocal.remove();
	}
	
	@Override
	protected Object onExecute(Object[] args, Object logicParam, Object logicParam2) throws Throwable {
		resetSessionParams();
		try {
			return super.onExecute(args, logicParam, logicParam2);
		}
		finally {
			resetSessionParams();
		}
	}
	
	@Override
	protected boolean isImportMode() {
		return true;
	}
	

	@Override
	protected PSModelServiceSession openPSModelServiceSession(Map psmodelapiMap) throws Exception {
		psmodelapiMap.put(PSModelServiceSession.PARAM_IMPORTMODE, true);

		return super.openPSModelServiceSession(psmodelapiMap);
	}

	@Override
	protected String onGetPSSysDevBKTaskName(IEntity paramMap) {
		return "系统运行时接口模型导入";
	}
	
	
	@Override
	protected Object onImportPSModel(IEntity psDevSlnSys, IEntity impParam, Object[] args) throws Throwable {

		if(impParam == null) {
			throw new Exception("未指定导入运行时模型参数");
		}
		
		String strModelTag = DataTypeUtils.getStringValue(impParam.get("modeltag"), null);
		if (!StringUtils.hasLength(strModelTag)) {
			throw new Exception("未指定运行时模型标记");
		}
		
		IEntity psSysModelGroup = null;
		if(args.length >=3) {
			if(args[2] instanceof IEntity) {
				psSysModelGroup = (IEntity)args[2];
			}
		}
		if(psSysModelGroup == null) {
			//psSysModelGroup = new Entity();
			this.updateCurrentPSSysDevBKTask(LogLevels.WARN, String.format("未获取模型组配置，使用无模型组模式导入，可能会出现导入模型的标识冲突"));
		}

		Map<String, Object> psrtmodelMap = this.getPSRTModelParams(impParam);
		
		IPSSystemService iPSSystemService =	this.getPSRTModelService(psrtmodelMap);

		IPSSysServiceAPI iPSSysServiceAPI = iPSSystemService.getPSSysServiceAPI(strModelTag, false); // 从系统模型服务中获取服务接口

		if (psSysModelGroup != null) {
			PSSysModelGroupDTO psSysModelGroupDTO = new PSSysModelGroupDTO();

			try {
				String strPSSysModelGroupCodeName = DataTypeUtils.getStringValue(psSysModelGroup.get("codename"),
						iPSSysServiceAPI.getCodeName());
				psSysModelGroupDTO.setCodeName(strPSSysModelGroupCodeName);
				psSysModelGroupDTO.setPSSysModelGroupName(String.format("导入服务接口[%1$s]模型组", iPSSysServiceAPI.getName()));
				psSysModelGroupDTO = this.getPSSysModelGroupDTO(psSysModelGroupDTO);
				this.setPSSysModelGroupDTO(psSysModelGroupDTO);
			} catch (Throwable ex) {
				throw new Exception(String.format("建立模型组发生异常，%1$s", ex.getMessage()), ex);
			}
		}

		// 建立默认系统模块
		try {
			PSModuleDTO psModuleDTO = new PSModuleDTO();
			if (this.getPSSysModelGroupDTO() != null) {
				psModuleDTO.setPSSysModelGroupId(this.getPSSysModelGroupDTO().getPSSysModelGroupId());
			}

			psModuleDTO.setCodeName("Common");
			psModuleDTO.setPSModuleName("模型组默认模块");
			psModuleDTO = this.getPSModuleDTO(psModuleDTO);
			this.getPSModuleDTOMap().put("", psModuleDTO);
		} catch (Throwable ex) {
			throw new Exception(String.format("建立默认系统模块发生异常，%1$s", ex.getMessage()), ex);
		}

		// 构建外部服务接口
		this.setPSSubSysServiceAPIDTO(syncPSSubSysServiceAPI(iPSSysServiceAPI));

		// 构建服务接口
		this.setPSSysServiceAPIDTO(syncPSSysServiceAPI(iPSSysServiceAPI));

		// 循环接口
		List<IPSDEServiceAPI> psDEServiceAPIList = iPSSysServiceAPI.getPSDEServiceAPIs();
		if (!ObjectUtils.isEmpty(psDEServiceAPIList)) {
			for (IPSDEServiceAPI iPSDEServiceAPI : psDEServiceAPIList) {
				IPSDataEntity iPSDataEntity = iPSDEServiceAPI.getPSDataEntityMust();

				PSDataEntityDTO psDataEntityDTO = syncPSDataEntity(iPSDataEntity);

				// 同步基础属性
				this.syncPSDEFields(iPSDataEntity);

				// 同步行为
				this.syncPSDEActions(iPSDataEntity);

				// 同步数据集
				this.syncPSDEDataSets(iPSDataEntity);
			}
		}

		this.syncPSDEServiceAPIs(iPSSysServiceAPI);

		this.syncPSDESARSs(iPSSysServiceAPI);

		this.syncPSDESADetails(iPSSysServiceAPI);
		
		return null;
	}
	
	
//	@Override
//	protected void onRun(IPSSystemService iPSSystemService, Map sysMap, Map paramMap, Map argMap) throws Throwable {
//
//		Map psrtmodelMap = (Map)sysMap.get(SYSPARAM_PSRTMODEL);
//		String strModelTag = DataTypeUtils.getStringValue(psrtmodelMap.get("modeltag"), null);
//		if (!StringUtils.hasLength(strModelTag)) {
//			throw new Exception("未指定运行时模型标记");
//		}
//		
//		
//		// 检索模型组
//		Object pssysmodelgroup = paramMap.get("pssysmodelgroup");
//		Map pssysmodelgroupMap = null;
//		if (pssysmodelgroup instanceof Map) {
//			pssysmodelgroupMap = (Map) pssysmodelgroup;
//		}
//		else {
//			this.updateCurrentPSSysDevBKTask(LogLevels.WARN, String.format("未获取模型组配置，使用无模型组模式导入，可能会出现导入模型的标识冲突"));
//		}
//
////				if(pssysmodelgroupMap == null) {
////					throw new Exception("未指定导入的系统模型组参数");
////				}
//
//
//
//		IPSSysServiceAPI iPSSysServiceAPI = iPSSystemService.getPSSysServiceAPI(strModelTag, false); // 从系统模型服务中获取服务接口
//
//		if (pssysmodelgroupMap != null) {
//			psSysModelGroupDTO = new PSSysModelGroupDTO();
//
//			try {
//				String strPSSysModelGroupCodeName = DataTypeUtils.getStringValue(pssysmodelgroupMap.get("codename"),
//						iPSSysServiceAPI.getCodeName());
//				psSysModelGroupDTO.setCodeName(strPSSysModelGroupCodeName);
//				psSysModelGroupDTO.setPSSysModelGroupName(String.format("导入服务接口[%1$s]模型组", iPSSysServiceAPI.getName()));
//				psSysModelGroupDTO = this.getPSSysModelGroupDTO(psSysModelGroupDTO);
//			} catch (Throwable ex) {
//				throw new Exception(String.format("建立模型组发生异常，%1$s", ex.getMessage()), ex);
//			}
//		}
//
//		// 建立默认系统模块
//		try {
//			PSModuleDTO psModuleDTO = new PSModuleDTO();
//			if (this.getPSSysModelGroupDTO() != null) {
//				psModuleDTO.setPSSysModelGroupId(this.getPSSysModelGroupDTO().getPSSysModelGroupId());
//			}
//
//			psModuleDTO.setCodeName("Common");
//			psModuleDTO.setPSModuleName("模型组默认模块");
//			psModuleDTO = this.getPSModuleDTO(psModuleDTO);
//			psModuleDTOMap.put("", psModuleDTO);
//		} catch (Throwable ex) {
//			throw new Exception(String.format("建立默认系统模块发生异常，%1$s", ex.getMessage()), ex);
//		}
//
//		// 构建外部服务接口
//		this.psSubSysServiceAPIDTO = syncPSSubSysServiceAPI(iPSSysServiceAPI);
//
//		// 构建服务接口
//		this.psSysServiceAPIDTO = syncPSSysServiceAPI(iPSSysServiceAPI);
//
//		// 循环接口
//		List<IPSDEServiceAPI> psDEServiceAPIList = iPSSysServiceAPI.getPSDEServiceAPIs();
//		if (!ObjectUtils.isEmpty(psDEServiceAPIList)) {
//			for (IPSDEServiceAPI iPSDEServiceAPI : psDEServiceAPIList) {
//				IPSDataEntity iPSDataEntity = iPSDEServiceAPI.getPSDataEntityMust();
//
//				PSDataEntityDTO psDataEntityDTO = syncPSDataEntity(iPSDataEntity);
//
//				// 同步基础属性
//				this.syncPSDEFields(iPSDataEntity);
//
//				// 同步行为
//				this.syncPSDEActions(iPSDataEntity);
//
//				// 同步数据集
//				this.syncPSDEDataSets(iPSDataEntity);
//			}
//		}
//
//		this.syncPSDEServiceAPIs(iPSSysServiceAPI);
//
//		this.syncPSDESARSs(iPSSysServiceAPI);
//
//		this.syncPSDESADetails(iPSSysServiceAPI);
//	}
//
//	@Override
//	protected void onRun(Map sysMap, Map paramMap, Map argMap) throws Exception {
//
//		Object psrtmodel = paramMap.get("psrtmodel");
//		Map psrtmodelMap = null;
//		if (psrtmodel instanceof Map) {
//			psrtmodelMap = (Map) psrtmodel;
//		}
//
//		if (psrtmodelMap == null) {
//			throw new Exception("未指定运行时模型参数");
//		}
//
//		String strRTModelUrl = DataTypeUtils.getStringValue(psrtmodelMap.get("url"), null);
//		String strBranch = DataTypeUtils.getStringValue(psrtmodelMap.get("branch"), "master");
//		String strGitUserName = DataTypeUtils.getStringValue(psrtmodelMap.get("username"), null);
//		String strGitPassword = DataTypeUtils.getStringValue(psrtmodelMap.get("password"), null);
//		String strModelTag = DataTypeUtils.getStringValue(psrtmodelMap.get("modeltag"), null);
//
//		if (!StringUtils.hasLength(strRTModelUrl)) {
//			throw new Exception("未指定运行时模型仓库路径");
//		}
//
//		if (!StringUtils.hasLength(strModelTag)) {
//			throw new Exception("未指定运行时模型标记");
//		}
//
//		// 签出文件
//
//		String strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(),
//				File.separator, KeyValueUtils.genUniqueId());
//		File folder = new File(strPath);
//		folder.mkdirs();
//		try {
//			CloneCommand cloneCommand = Git.cloneRepository().setURI(strRTModelUrl).setDirectory(folder)
//					.setBranch(strBranch);
//			// if (StringUtils.hasLength(strGitUserName) &&
//			// StringUtils.hasLength(strGitPassword)) {
//			if (StringUtils.hasLength(strGitUserName)) {
//				if (StringUtils.hasLength(strGitPassword)) {
//					cloneCommand.setCredentialsProvider(
//							new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
//				} else {
//					cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, ""));
//				}
//			}
//			cloneCommand.call();
//		} catch (Throwable ex) {
//			throw new Exception(String.format("获取运行时模型发生异常，%1$s", ex.getMessage()), ex);
//		}
//
//		String strModelPath = "";
//		File modelFile = new File(String.format("%1$s%2$sibizmodel.yaml", strPath, File.separator));
//		if (modelFile.exists()) {
//			// 从配置文件中提取目录
//			try {
//				Yaml yaml = new Yaml();
//				Map config = yaml.loadAs(new FileInputStream(modelFile), Map.class);
//				if (config != null) {
//					String strModelFolder = (String) config.get("modelfolder");
//					if (StringUtils.hasLength(strModelFolder)) {
//						strModelPath = strPath + File.separator + strModelFolder;
//					}
//				}
//			} catch (Throwable ex) {
//				throw new Exception(String.format("加载运行时模型配置发生异常，%1$s", ex.getMessage()), ex);
//			}
//		}
//		if (!StringUtils.hasLength(strModelPath)) {
//			// 未指定直接使用根目录
//			strModelPath = strPath;
//		}
//
//		IPSSystemService iPSSystemService = null;
//		try {
//			iPSSystemService = this.getPSSystemService(strModelPath);
//		} catch (Throwable ex) {
//			throw new Exception(String.format("加载运行时模型发生异常，%1$s", ex.getMessage()), ex);
//		}
//
//	}

	protected List<PSDEServiceAPIDTO> syncPSDEServiceAPIs(IPSSysServiceAPI iPSSysServiceAPI) throws Exception {

		List<PSDEServiceAPIDTO> psDEServiceAPIDTOList = new ArrayList<PSDEServiceAPIDTO>();

		List<IPSDEServiceAPI> psDEServiceAPIList = iPSSysServiceAPI.getPSDEServiceAPIs();
		if (!ObjectUtils.isEmpty(psDEServiceAPIList)) {
			for (IPSDEServiceAPI iPSDEServiceAPI : psDEServiceAPIList) {

				PSDEServiceAPIDTO psDEServiceAPIDTO = new PSDEServiceAPIDTO();

				psDEServiceAPIDTO.setPSDEServiceAPIName(iPSDEServiceAPI.getName());
				psDEServiceAPIDTO.setCodeName(iPSDEServiceAPI.getCodeName());
				psDEServiceAPIDTO.setCodeName2(iPSDEServiceAPI.getCodeName2());
				psDEServiceAPIDTO.setMajorFlag(iPSDEServiceAPI.getAPIMode());
				psDEServiceAPIDTO.setPSSysServiceAPIId(this.getPSSysServiceAPIDTO().getPSSysServiceAPIId());
				psDEServiceAPIDTO.setPSSysServiceAPIName(this.getPSSysServiceAPIDTO().getPSSysServiceAPIName());

				psDEServiceAPIDTO.setEnableDataExport(iPSDEServiceAPI.isEnableDataExport() ? 1 : 0);
				psDEServiceAPIDTO.setEnableDataImport(iPSDEServiceAPI.isEnableDataImport() ? 1 : 0);

				// 关闭默认开启功能
				psDEServiceAPIDTO.setEnableDEAction(0);
				psDEServiceAPIDTO.setEnableDEDataSet(0);
				psDEServiceAPIDTO.setEnableSelect(0);

				PSDataEntityDTO psDataEntityDTO = this.getPSDataEntityDTOMap().get(iPSDEServiceAPI.getPSDataEntityMust().getId());
				psDEServiceAPIDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
				psDEServiceAPIDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());

				if (StringUtils.hasLength(iPSDEServiceAPI.getLogicName())) {
					if (!iPSDEServiceAPI.getLogicName().equals(psDataEntityDTO.getLogicName())) {
						psDEServiceAPIDTO.setLogicName(iPSDEServiceAPI.getLogicName());
					}
				}
				psDEServiceAPIDTOList.add(psDEServiceAPIDTO);

			}

			try {
				psDEServiceAPIDTOList = this.getPSDEServiceAPIDTOs(this.getPSSysServiceAPIDTO(), psDEServiceAPIDTOList);
				for (PSDEServiceAPIDTO psDEServiceAPIDTO : psDEServiceAPIDTOList) {
					this.getPSDEServiceAPIDTOMap().put(String.format("%1$s|%2$s", iPSSysServiceAPI.getId(),
							psDEServiceAPIDTO.getPSDEServiceAPIName().toUpperCase()), psDEServiceAPIDTO);
				}
			} catch (Throwable ex) {
				throw new Exception(
						String.format("建立服务接口[%1$s]实体服务对象发生异常，%2$s", iPSSysServiceAPI.getName(), ex.getMessage()), ex);
			}
		}

		return psDEServiceAPIDTOList;
	}

		protected List<PSDESARSDTO> syncPSDESARSs(IPSSysServiceAPI iPSSysServiceAPI) throws Exception {

		List<PSDESARSDTO> psDESARSDTOList = new ArrayList<PSDESARSDTO>();

		List<IPSDEServiceAPIRS> psDESARSList = iPSSysServiceAPI.getPSDEServiceAPIRSs();
		if (!ObjectUtils.isEmpty(psDESARSList)) {
			for (IPSDEServiceAPIRS iPSDESARS : psDESARSList) {

				PSDESARSDTO psDESARSDTO = new PSDESARSDTO();

				psDESARSDTO.setPSDESARSName(iPSDESARS.getName());
				psDESARSDTO.setCodeName(iPSDESARS.getCodeName());
				psDESARSDTO.setCodeName2(iPSDESARS.getCodeName2());
				psDESARSDTO.setChildFilter(iPSDESARS.getParentFilter());

				psDESARSDTO.setOrderValue(iPSDESARS.getOrderValue());

				psDESARSDTO.setPSSysServiceAPIId(this.getPSSysServiceAPIDTO().getPSSysServiceAPIId());
				psDESARSDTO.setPSSysServiceAPIName(this.getPSSysServiceAPIDTO().getPSSysServiceAPIName());

				psDESARSDTO.setEnableDataExport(iPSDESARS.isEnableDataExport() ? 1 : 0);
				psDESARSDTO.setEnableDataImport(iPSDESARS.isEnableDataImport() ? 1 : 0);

				// 关闭默认开启功能
				psDESARSDTO.setEnableDEAction(0);
				psDESARSDTO.setEnableDEDataSet(0);
				psDESARSDTO.setEnableSelect(0);

				PSDEServiceAPIDTO pPSDEServiceAPIDTO = this.getPSDEServiceAPIDTOMap().get(String.format("%1$s|%2$s",
						iPSSysServiceAPI.getId(), iPSDESARS.getMajorPSDEServiceAPIMust().getName().toUpperCase()));
				PSDEServiceAPIDTO cPSDEServiceAPIDTO = this.getPSDEServiceAPIDTOMap().get(String.format("%1$s|%2$s",
						iPSSysServiceAPI.getId(), iPSDESARS.getMinorPSDEServiceAPIMust().getName().toUpperCase()));

				psDESARSDTO.setPPSDEServiceAPIId(pPSDEServiceAPIDTO.getPSDEServiceAPIId());
				psDESARSDTO.setPPSDEServiceAPIName(pPSDEServiceAPIDTO.getPSDEServiceAPIName());

				psDESARSDTO.setCPSDEServiceAPIId(cPSDEServiceAPIDTO.getPSDEServiceAPIId());
				psDESARSDTO.setCPSDEServiceAPIName(cPSDEServiceAPIDTO.getPSDEServiceAPIName());

				if (iPSDESARS.getOrderValue() != DEFAULTORDERVALUE) {
					psDESARSDTO.setOrderValue(iPSDESARS.getOrderValue());
				}

				psDESARSDTO.setTypeFilter(iPSDESARS.getParentTypeFilter());
				psDESARSDTO.setChildFilter(iPSDESARS.getParentFilter());

//				if(iPSDESARS.getParentTypePSDEField() != null) {
//				}
//				
//				if(iPSDESARS.getParentIdPSDEField() != null) {
//					
//				}

				IPSDERBase iPSDERBase = iPSDESARS.getPSDER();
				if (iPSDERBase != null) {
					PSDERDTO psDERDTO = this.syncPSDER(iPSDERBase);
					psDESARSDTO.setPSDERId(psDERDTO.getPSDERId());
					psDESARSDTO.setPSDERName(psDERDTO.getPSDERName());
				}

				// 关系仿真
				psDESARSDTOList.add(psDESARSDTO);

			}

			try {
				psDESARSDTOList = this.getPSDESARSDTOs(this.getPSSysServiceAPIDTO(), psDESARSDTOList);
				for (PSDESARSDTO psDESARSDTO : psDESARSDTOList) {
					this.getPSDESARSDTOMap().put(String.format("%1$s|%2$s|%3$s", iPSSysServiceAPI.getId(),
							psDESARSDTO.getPPSDEServiceAPIName().toUpperCase(),
							psDESARSDTO.getCPSDEServiceAPIName().toUpperCase()), psDESARSDTO);
				}
			} catch (Throwable ex) {
				throw new Exception(
						String.format("建立服务接口[%1$s]实体服务对象关系发生异常，%2$s", iPSSysServiceAPI.getName(), ex.getMessage()),
						ex);
			}

		}

		return psDESARSDTOList;
	}

	protected List<PSDESADetailDTO> syncPSDESADetails(IPSSysServiceAPI iPSSysServiceAPI) throws Exception {

		List<PSDESADetailDTO> psDESADetailDTOList = new ArrayList<PSDESADetailDTO>();

		List<IPSDEServiceAPI> psDEServiceAPIList = iPSSysServiceAPI.getPSDEServiceAPIs();
		if (!ObjectUtils.isEmpty(psDEServiceAPIList)) {
			for (IPSDEServiceAPI iPSDEServiceAPI : psDEServiceAPIList) {

				PSDEServiceAPIDTO psDEServiceAPIDTO = this.getPSDEServiceAPIDTO(iPSSysServiceAPI, iPSDEServiceAPI);

				IPSDataEntity iPSDataEntity = iPSDEServiceAPI.getPSDataEntityMust();

				List<IPSDEServiceAPIMethod> psDEServiceAPIMethodList = iPSDEServiceAPI.getPSDEServiceAPIMethods();
				if (!ObjectUtils.isEmpty(psDEServiceAPIMethodList)) {
					for (IPSDEServiceAPIMethod iPSDEServiceAPIMethod : psDEServiceAPIMethodList) {

						PSDESADetailDTO psDESADetailDTO = new PSDESADetailDTO();
						psDESADetailDTO.setPSDEServiceAPIId(psDEServiceAPIDTO.getPSDEServiceAPIId());
						psDESADetailDTO.setPSDEServiceAPIName(psDEServiceAPIDTO.getPSDEServiceAPIName());
						psDESADetailDTO.setPSDESADetailName(iPSDEServiceAPIMethod.getName());
						psDESADetailDTO.setCodeName(iPSDEServiceAPIMethod.getCodeName());
						psDESADetailDTO.setCodeName2(iPSDEServiceAPIMethod.getCodeName2());
						psDESADetailDTO.setRequestMethod(iPSDEServiceAPIMethod.getRequestMethod());
						psDESADetailDTO.setRequestField(iPSDEServiceAPIMethod.getRequestField());
						psDESADetailDTO.setRequestParamType(iPSDEServiceAPIMethod.getRequestParamType());
						psDESADetailDTO.setDetailType(iPSDEServiceAPIMethod.getMethodType());
						psDESADetailDTO.setParentKeyMode(iPSDEServiceAPIMethod.getParentKeyMode());
						psDESADetailDTO.setNoServiceCodeName(iPSDEServiceAPIMethod.isNoServiceCodeName() ? 1 : 0);

						if (iPSDEServiceAPIMethod.getPSDEAction() != null) {
							PSDEActionDTO psDEActionDTO = this.getPSDEActionDTO(iPSDataEntity,
									iPSDEServiceAPIMethod.getPSDEAction());
							psDESADetailDTO.setPSDEActionId(psDEActionDTO.getPSDEActionId());
							psDESADetailDTO.setPSDEActionName(psDEActionDTO.getPSDEActionName());
						}

						if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
							PSDEDataSetDTO psDEDataSetDTO = this.getPSDEDataSetDTO(iPSDataEntity,
									iPSDEServiceAPIMethod.getPSDEDataSet());
							psDESADetailDTO.setPSDEDSId(psDEDataSetDTO.getPSDEDataSetId());
							psDESADetailDTO.setPSDEDSName(psDEDataSetDTO.getPSDEDataSetName());
						}

						psDESADetailDTOList.add(psDESADetailDTO);

					}
				}

				List<IPSDEServiceAPIRS> psDESARSList = iPSSysServiceAPI.getPSDEServiceAPIRSs();
				if (!ObjectUtils.isEmpty(psDESARSList)) {
					for (IPSDEServiceAPIRS iPSDESARS : psDESARSList) {

						if (!iPSDEServiceAPI.getId().equals(iPSDESARS.getMinorPSDEServiceAPIMust().getId())) {
							continue;
						}

						PSDESARSDTO psDESARSDTO = getPSDESARSDTO(iPSSysServiceAPI, iPSDESARS);

						psDEServiceAPIMethodList = iPSDESARS.getPSDEServiceAPIMethods();
						if (!ObjectUtils.isEmpty(psDEServiceAPIMethodList)) {
							for (IPSDEServiceAPIMethod iPSDEServiceAPIMethod : psDEServiceAPIMethodList) {

								PSDESADetailDTO psDESADetailDTO = new PSDESADetailDTO();
								psDESADetailDTO.setPSDEServiceAPIId(psDEServiceAPIDTO.getPSDEServiceAPIId());
								psDESADetailDTO.setPSDEServiceAPIName(psDEServiceAPIDTO.getPSDEServiceAPIName());
								psDESADetailDTO.setPSDESARSId(psDESARSDTO.getPSDESARSId());
								psDESADetailDTO.setPSDESARSName(psDESARSDTO.getPSDESARSName());

								psDESADetailDTO.setPSDESADetailName(iPSDEServiceAPIMethod.getName());
								psDESADetailDTO.setCodeName(iPSDEServiceAPIMethod.getCodeName());
								psDESADetailDTO.setCodeName2(iPSDEServiceAPIMethod.getCodeName2());
								psDESADetailDTO.setRequestMethod(iPSDEServiceAPIMethod.getRequestMethod());
								psDESADetailDTO.setRequestField(iPSDEServiceAPIMethod.getRequestField());
								psDESADetailDTO.setRequestParamType(iPSDEServiceAPIMethod.getRequestParamType());
								psDESADetailDTO.setDetailType(iPSDEServiceAPIMethod.getMethodType());
								psDESADetailDTO.setParentKeyMode(iPSDEServiceAPIMethod.getParentKeyMode());
								psDESADetailDTO
										.setNoServiceCodeName(iPSDEServiceAPIMethod.isNoServiceCodeName() ? 1 : 0);

								if (iPSDEServiceAPIMethod.getPSDEAction() != null) {
									PSDEActionDTO psDEActionDTO = this.getPSDEActionDTO(iPSDataEntity,
											iPSDEServiceAPIMethod.getPSDEAction());
									psDESADetailDTO.setPSDEActionId(psDEActionDTO.getPSDEActionId());
									psDESADetailDTO.setPSDEActionName(psDEActionDTO.getPSDEActionName());
								}

								if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
									PSDEDataSetDTO psDEDataSetDTO = this.getPSDEDataSetDTO(iPSDataEntity,
											iPSDEServiceAPIMethod.getPSDEDataSet());
									psDESADetailDTO.setPSDEDSId(psDEDataSetDTO.getPSDEDataSetId());
									psDESADetailDTO.setPSDEDSName(psDEDataSetDTO.getPSDEDataSetName());
								}

								psDESADetailDTOList.add(psDESADetailDTO);
							}
						}
					}
				}
			}
		}

		try {
			psDESADetailDTOList = this.getPSDESADetailDTOs(this.getPSSysServiceAPIDTO(), psDESADetailDTOList);
//			for(PSDESARSDTO psDESARSDTO:psDESADetailDTOList) {
//				psDESARSDTOMap.put(String.format("%1$s|%2$s|%3$s", iPSSysServiceAPI.getId(), psDESARSDTO.getPPSDEServiceAPIName().toUpperCase(), psDESARSDTO.getCPSDEServiceAPIName().toUpperCase()), psDESARSDTO);
//			}
		} catch (Throwable ex) {
			throw new Exception(
					String.format("建立服务接口[%1$s]实体服务成员对象关系发生异常，%2$s", iPSSysServiceAPI.getName(), ex.getMessage()), ex);
		}

		return psDESADetailDTOList;
	}

	protected PSModuleDTO syncPSModule(IPSSystemModule iPSSystemModule) throws Exception {

		if (iPSSystemModule == null) {
			return this.getPSModuleDTOMap().get("");
		} else {
			PSModuleDTO psModuleDTO = this.getPSModuleDTOMap().get(iPSSystemModule.getId());
			if (psModuleDTO == null) {

				psModuleDTO = new PSModuleDTO();
				if (getPSSysModelGroupDTO() != null) {
					psModuleDTO.setPSSysModelGroupId(getPSSysModelGroupDTO().getPSSysModelGroupId());
				}

				psModuleDTO.setCodeName(iPSSystemModule.getCodeName());
				psModuleDTO.setPSModuleName(iPSSystemModule.getName());
				try {
					psModuleDTO = this.getPSModuleDTO(psModuleDTO);
					this.getPSModuleDTOMap().put(iPSSystemModule.getId(), psModuleDTO);
				} catch (Throwable ex) {
					throw new Exception(
							String.format("建立系统模块[%1$s]发生异常，%2$s", iPSSystemModule.getCodeName(), ex.getMessage()), ex);
				}
			}
			return psModuleDTO;
		}
	}

	protected PSSysServiceAPIDTO syncPSSysServiceAPI(IPSSysServiceAPI iPSSysServiceAPI) throws Exception {

		IPSSystemModule iPSSystemModule = iPSSysServiceAPI.getPSSystemModule();
		PSModuleDTO psModuleDTO = null;
		if (iPSSystemModule != null) {
			psModuleDTO = syncPSModule(iPSSystemModule);
		} else {
			psModuleDTO = this.getPSModuleDTOMap().get("");
		}

		PSSysServiceAPIDTO psSysServiceAPIDTO = new PSSysServiceAPIDTO();
		psSysServiceAPIDTO.setPSModuleId(psModuleDTO.getPSModuleId());
		psSysServiceAPIDTO.setPSModuleName(psModuleDTO.getPSModuleName());
		psSysServiceAPIDTO.setPSSysServiceAPIName(iPSSysServiceAPI.getName());
		psSysServiceAPIDTO.setCodeName(iPSSysServiceAPI.getCodeName());
		psSysServiceAPIDTO.setAPIType(iPSSysServiceAPI.getAPIType());
		psSysServiceAPIDTO.setAPILevel(iPSSysServiceAPI.getAPILevel());
		psSysServiceAPIDTO.setVer(iPSSysServiceAPI.getAPIVersion());

		try {
			psSysServiceAPIDTO = this.getPSSysServiceAPIDTO(psSysServiceAPIDTO);
		} catch (Throwable ex) {
			throw new Exception(String.format("建立服务接口[%1$s]发生异常，%2$s", iPSSysServiceAPI.getCodeName(), ex.getMessage()),
					ex);
		}

		return psSysServiceAPIDTO;

	}

	protected PSSubSysServiceAPIDTO syncPSSubSysServiceAPI(IPSSysServiceAPI iPSSysServiceAPI) throws Exception {

		IPSSystemModule iPSSystemModule = iPSSysServiceAPI.getPSSystemModule();
		PSModuleDTO psModuleDTO = null;
		if (iPSSystemModule != null) {
			psModuleDTO = syncPSModule(iPSSystemModule);
		} else {
			psModuleDTO = this.getPSModuleDTOMap().get("");
		}

		PSSubSysServiceAPIDTO psSubSysServiceAPIDTO = new PSSubSysServiceAPIDTO();
		psSubSysServiceAPIDTO.setPSModuleId(psModuleDTO.getPSModuleId());
		psSubSysServiceAPIDTO.setPSModuleName(psModuleDTO.getPSModuleName());
		psSubSysServiceAPIDTO.setPSSubSysServiceAPIName(iPSSysServiceAPI.getName());
		psSubSysServiceAPIDTO.setCodeName(iPSSysServiceAPI.getCodeName());
		psSubSysServiceAPIDTO.setAPIType(iPSSysServiceAPI.getAPIType());

		try {
			psSubSysServiceAPIDTO = this.getPSSubSysServiceAPIDTO(psSubSysServiceAPIDTO);
		} catch (Throwable ex) {
			throw new Exception(
					String.format("建立外部服务接口[%1$s]发生异常，%2$s", iPSSysServiceAPI.getCodeName(), ex.getMessage()), ex);
		}

		return psSubSysServiceAPIDTO;

	}

	protected PSCodeListDTO syncPSCodeList(IPSCodeList iPSCodeList) throws Exception {

		PSCodeListDTO psCodeListDTO = this.getPSCodeListDTOMap().get(iPSCodeList.getId());
		if (psCodeListDTO != null) {
			return psCodeListDTO;
		}

		IPSSystemModule iPSSystemModule = iPSCodeList.getPSSystemModule();
		PSModuleDTO psModuleDTO = null;
		if (iPSSystemModule != null) {
			psModuleDTO = syncPSModule(iPSSystemModule);
		} else {
			psModuleDTO = this.getPSModuleDTOMap().get("");
		}

		psCodeListDTO = new PSCodeListDTO();
		psCodeListDTO.setPSModuleId(psModuleDTO.getPSModuleId());
		psCodeListDTO.setPSModuleName(psModuleDTO.getPSModuleName());
		psCodeListDTO.setPSCodeListName(iPSCodeList.getName());
		psCodeListDTO.setCodeName(iPSCodeList.getCodeName());
		psCodeListDTO.setCLType(iPSCodeList.getCodeListType());
		if (StringUtils.hasLength(iPSCodeList.getPredefinedType())) {
			psCodeListDTO.cltype(CodeListType.PREDEFINED);
			psCodeListDTO.setPredefinedType(iPSCodeList.getCodeListType());
		}
		psCodeListDTO.setOrMode(iPSCodeList.getOrMode());
		if (StringUtils.hasLength(iPSCodeList.getOrMode())) {
			psCodeListDTO.setValueSeperator(iPSCodeList.getValueSeparator());
			psCodeListDTO.setSeperator(iPSCodeList.getTextSeparator());
		}
		psCodeListDTO.setNumberItem(iPSCodeList.isCodeItemValueNumber() ? 1 : 0);
		// psCodeListDTO.setCodeListSN(iPSCodeList.get);

		List<IPSCodeItem> psCodeItemList = iPSCodeList.getPSCodeItems();
		if (!ObjectUtils.isEmpty(psCodeItemList)) {
			List<PSCodeItemDTO> psCodeItemDTOList = new ArrayList<PSCodeItemDTO>();
			int nOrderValue = 0;
			for (IPSCodeItem iPSCodeItem : psCodeItemList) {

				nOrderValue += 100;

				PSCodeItemDTO psCodeItemDTO = new PSCodeItemDTO();
				psCodeItemDTO.setValidFlag(1);
				psCodeItemDTO.setPSCodeItemName(iPSCodeItem.getText());
				psCodeItemDTO.setCodeItemValue(iPSCodeItem.getValue());
				psCodeItemDTO.setCodeName(iPSCodeItem.getCodeName());
				psCodeItemDTO.setOrderValue(nOrderValue);
				psCodeItemDTO.setColor(iPSCodeItem.getColor());
				psCodeItemDTO.setBKColor(iPSCodeItem.getBKColor());
				psCodeItemDTO.setDefaultFlag(iPSCodeItem.isDefault() ? 1 : 0);
				psCodeItemDTO.setDisableSelect(iPSCodeItem.isDisableSelect() ? 1 : 0);
				psCodeItemDTO.setData(iPSCodeItem.getData());
				psCodeItemDTO.setUserData(iPSCodeItem.getUserData());
				psCodeItemDTO.setUserData2(iPSCodeItem.getUserData2());

				psCodeItemDTOList.add(psCodeItemDTO);
			}

			psCodeListDTO.setPSCodeItems(psCodeItemDTOList);
		}

		try {
			psCodeListDTO = this.getPSCodeListDTO(psCodeListDTO);
			this.getPSCodeListDTOMap().put(iPSCodeList.getId(), psCodeListDTO);
		} catch (Throwable ex) {
			throw new Exception(String.format("建立代码表[%1$s]发生异常，%2$s", iPSCodeList.getCodeName(), ex.getMessage()), ex);
		}

		return psCodeListDTO;

	}

	protected PSDataEntityDTO syncPSDataEntity(IPSDataEntity iPSDataEntity) throws Exception {

		IPSSystemModule iPSSystemModule = iPSDataEntity.getPSSystemModuleMust();
		PSModuleDTO psModuleDTO = syncPSModule(iPSSystemModule);

		PSDataEntityDTO psDataEntityDTO = new PSDataEntityDTO();
		psDataEntityDTO.setPSDataEntityName(iPSDataEntity.getName());
		psDataEntityDTO.setCodeName(iPSDataEntity.getCodeName());
		psDataEntityDTO.setLogicName(iPSDataEntity.getLogicName());
		psDataEntityDTO.setPSModuleId(psModuleDTO.getPSModuleId());
		psDataEntityDTO.setPSModuleName(psModuleDTO.getPSModuleName());
		if (this.getPSSysModelGroupDTO() != null) {
			psDataEntityDTO.setPSSysModelGroupId(this.getPSSysModelGroupDTO().getPSSysModelGroupId());
			psDataEntityDTO.setPSSysModelGroupName(this.getPSSysModelGroupDTO().getPSSysModelGroupName());
		}

		psDataEntityDTO.storagemode(DEStorageType.SERVICEAPI);
		psDataEntityDTO.setPSSubSysServiceAPIId(this.getPSSubSysServiceAPIDTO().getPSSubSysServiceAPIId());
		psDataEntityDTO.setPSSubSysServiceAPIName(this.getPSSubSysServiceAPIDTO().getPSSubSysServiceAPIName());
		psDataEntityDTO.setDEType(iPSDataEntity.getDEType());

		try {
			psDataEntityDTO = this.getPSDataEntityDTO(psDataEntityDTO);
			this.getPSDataEntityDTOMap().put(iPSDataEntity.getId(), psDataEntityDTO);
		} catch (Throwable ex) {
			throw new Exception(String.format("建立实体[%1$s]发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()), ex);
		}

		return psDataEntityDTO;
	}

	protected List<PSDEFieldDTO> syncPSDEFields(IPSDataEntity iPSDataEntity) throws Exception {

		List<PSDEFieldDTO> psDEFieldDTOList = new ArrayList<PSDEFieldDTO>();

		PSDataEntityDTO psDataEntityDTO = this.getPSDataEntityDTOMap().get(iPSDataEntity.getId());

		List<IPSDEField> psDEFieldList = iPSDataEntity.getAllPSDEFields();
		if (!ObjectUtils.isEmpty(psDEFieldList)) {

			for (IPSDEField iPSDEField : psDEFieldList) {

				PSDEFieldDTO psDEFieldDTO = new PSDEFieldDTO();

				if (iPSDEField.isKeyDEField()) {
					psDEFieldDTO.setPKey(1);
				} else if (iPSDEField.isUniTagField()) {
					psDEFieldDTO.setPKey(2);
				} else
					psDEFieldDTO.setPKey(0);

				psDEFieldDTO.setMajorField(iPSDEField.isMajorDEField() ? 1 : 0);
				psDEFieldDTO.setAllowEmpty(iPSDEField.isAllowEmpty() ? 1 : 0);

				psDEFieldDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
				psDEFieldDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
				psDEFieldDTO.setPSDEFieldName(iPSDEField.getName());
				psDEFieldDTO.setCodeName(iPSDEField.getCodeName());
				psDEFieldDTO.setLogicName(iPSDEField.getLogicName());
				if (iPSDEField.getDEFType() == DEFType.PHISICAL.value) {
					psDEFieldDTO.deftype(DEFType.PHISICAL);
				} else {
					// 其它类型调整为应用界面属性
					psDEFieldDTO.deftype(DEFType.UI);
				}

				if ((iPSDEField instanceof IPSLinkDEField) || (iPSDEField instanceof IPSOne2OneDataDEField)
						|| (iPSDEField instanceof IPSOne2ManyDataDEField)) {

					// 判断类型
					if (DataTypeUtils.isLongStringDataType(iPSDEField.getStdDataType())) {
						psDEFieldDTO.setPSDataTypeId(DEFDataType.LONGTEXT.value);
					} else if (DataTypeUtils.isBigDecimalDataType(iPSDEField.getStdDataType())) {
						psDEFieldDTO.setPSDataTypeId(DEFDataType.BIGDECIMAL.value);
					} else if (DataTypeUtils.isBigIntDataType(iPSDEField.getStdDataType())) {
						psDEFieldDTO.setPSDataTypeId(DEFDataType.BIGINT.value);
					} else if (DataTypeUtils.isIntDataType(iPSDEField.getStdDataType())) {
						psDEFieldDTO.setPSDataTypeId(DEFDataType.INT.value);
					} else if (DataTypeUtils.isDateTimeDataType(iPSDEField.getStdDataType())) {
						psDEFieldDTO.setPSDataTypeId(DEFDataType.DATETIME.value);
					} else if (DataTypeUtils.isNumberDataType(iPSDEField.getStdDataType())) {
						psDEFieldDTO.setPSDataTypeId(DEFDataType.FLOAT.value);
					} else
//											if(DataTypeUtils(iPSDEField.getStdDataType())) {
//												psDEFieldDTO.setPSDataTypeId(DEFDataTypes.FLOAT);
//											}else
					{
						psDEFieldDTO.setPSDataTypeId(DEFDataType.TEXT.value);
					}

				} else {
					psDEFieldDTO.setPSDataTypeId(iPSDEField.getDataType());
				}

				if (iPSDEField.getLength() > 0) {
					psDEFieldDTO.setLength(iPSDEField.getLength());
				}
				if (iPSDEField.getPrecision() > 0) {
					psDEFieldDTO.setPrecision(iPSDEField.getPrecision());
				}

				psDEFieldDTO.setPredefinedType(iPSDEField.getPredefinedType());

				IPSCodeList iPSCodeList = iPSDEField.getPSCodeList();
				if (iPSCodeList != null) {
					PSCodeListDTO psCodeListDTO = this.syncPSCodeList(iPSCodeList);
					psDEFieldDTO.setPSCodeListId(psCodeListDTO.getPSCodeListId());
					psDEFieldDTO.setPSCodeListName(psCodeListDTO.getPSCodeListName());
				}

				if (iPSDEField.getMinStringLength() > 0) {
					psDEFieldDTO.setMinStrLength(iPSDEField.getMinStringLength());
				}

				if (StringUtils.hasLength(iPSDEField.getMaxValueString())) {
					psDEFieldDTO.setMaxValue(iPSDEField.getMaxValueString());
				}

				if (StringUtils.hasLength(iPSDEField.getMinValueString())) {
					psDEFieldDTO.setMinValue(iPSDEField.getMinValueString());
				}

				// 建立属性
				psDEFieldDTOList.add(psDEFieldDTO);

			}

			try {
				psDEFieldDTOList = this.getPSDEFieldDTOs(psDataEntityDTO, psDEFieldDTOList);
				for (PSDEFieldDTO psDEFieldDTO : psDEFieldDTOList) {
					this.getPSDEFieldDTOMap().put(String.format("%1$s|%2$s", iPSDataEntity.getId(),
							psDEFieldDTO.getPSDEFieldName().toUpperCase()), psDEFieldDTO);
				}
			} catch (Throwable ex) {
				throw new Exception(String.format("建立实体[%1$s]属性发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()),
						ex);
			}

		}

		return psDEFieldDTOList;
	}

	protected List<PSDEDataSetDTO> syncPSDEDataSets(IPSDataEntity iPSDataEntity) throws Exception {

		List<PSDEDataSetDTO> psDEDataSetDTOList = new ArrayList<PSDEDataSetDTO>();

		PSDataEntityDTO psDataEntityDTO = this.getPSDataEntityDTOMap().get(iPSDataEntity.getId());

		List<IPSDEDataSet> psDEDataSetList = iPSDataEntity.getAllPSDEDataSets();
		if (!ObjectUtils.isEmpty(psDEDataSetList)) {

			for (IPSDEDataSet iPSDEDataSet : psDEDataSetList) {

				if (!iPSDEDataSet.isEnableBackend()) {
					continue;
				}

				PSDEDataSetDTO psDEDataSetDTO = new PSDEDataSetDTO();

				psDEDataSetDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
				psDEDataSetDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
				psDEDataSetDTO.setPSDEDataSetName(iPSDEDataSet.getName());
				psDEDataSetDTO.setCodeName(iPSDEDataSet.getCodeName());
				psDEDataSetDTO.setLogicName(iPSDEDataSet.getLogicName());
				psDEDataSetDTO.setDefaultMode(iPSDEDataSet.isDefaultMode() ? 1 : 0);

				// 操作权限

				// 关闭自动展开服务
				psDEDataSetDTO.setPubMode(0);

				// 建立数据集
				psDEDataSetDTOList.add(psDEDataSetDTO);

			}

			try {
				psDEDataSetDTOList = this.getPSDEDataSetDTOs(psDataEntityDTO, psDEDataSetDTOList);
				for (PSDEDataSetDTO psDEDataSetDTO : psDEDataSetDTOList) {
					this.getPSDEDataSetDTOMap().put(String.format("%1$s|%2$s", iPSDataEntity.getId(),
							psDEDataSetDTO.getPSDEDataSetName().toUpperCase()), psDEDataSetDTO);
				}
			} catch (Throwable ex) {
				throw new Exception(String.format("建立实体[%1$s]数据集发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()),
						ex);
			}

		}

		return psDEDataSetDTOList;
	}

	protected List<PSDEActionDTO> syncPSDEActions(IPSDataEntity iPSDataEntity) throws Exception {

		List<PSDEActionDTO> psDEActionDTOList = new ArrayList<PSDEActionDTO>();

		PSDataEntityDTO psDataEntityDTO = this.getPSDataEntityDTOMap().get(iPSDataEntity.getId());

		List<IPSDEAction> psDEActionList = iPSDataEntity.getAllPSDEActions();
		if (!ObjectUtils.isEmpty(psDEActionList)) {

			for (IPSDEAction iPSDEAction : psDEActionList) {

				if (!iPSDEAction.isEnableBackend()) {
					continue;
				}

				PSDEActionDTO psDEActionDTO = new PSDEActionDTO();

				psDEActionDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
				psDEActionDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
				psDEActionDTO.setPSDEActionName(iPSDEAction.getName());
				psDEActionDTO.setCodeName(iPSDEAction.getCodeName());
				psDEActionDTO.setLogicName(iPSDEAction.getLogicName());
				psDEActionDTO.setActionMode(iPSDEAction.getActionMode());
				String strActionType = iPSDEAction.getActionType();
				if (DEActionType.BUILTIN.value.equalsIgnoreCase(strActionType)) {
					psDEActionDTO.actiontype(DEActionType.BUILTIN);
				} else {
					psDEActionDTO.actiontype(DEActionType.USERCUSTOM);
				}

				// 关闭自动展开服务
				psDEActionDTO.setPubMode(0);

				// 建立行为
				psDEActionDTOList.add(psDEActionDTO);

			}

			try {
				psDEActionDTOList = this.getPSDEActionDTOs(psDataEntityDTO, psDEActionDTOList);
				for (PSDEActionDTO psDEActionDTO : psDEActionDTOList) {
					this.getPSDEActionDTOMap().put(String.format("%1$s|%2$s", iPSDataEntity.getId(),
							psDEActionDTO.getPSDEActionName().toUpperCase()), psDEActionDTO);
				}
			} catch (Throwable ex) {
				throw new Exception(String.format("建立实体[%1$s]行为发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()),
						ex);
			}

		}

		return psDEActionDTOList;
	}
	
	protected List<PSDEOPPrivDTO> syncPSDEOPPrivs(IPSDataEntity iPSDataEntity) throws Exception {

		List<PSDEOPPrivDTO> psDEOPPrivDTOList = new ArrayList<PSDEOPPrivDTO>();

		PSDataEntityDTO psDataEntityDTO = this.getPSDataEntityDTOMap().get(iPSDataEntity.getId());

		List<IPSDEOPPriv> psDEOPPrivList = iPSDataEntity.getAllPSDEOPPrivs();
		
		if (!ObjectUtils.isEmpty(psDEOPPrivList)) {

			Map<String, IPSDEOPPriv> psDEOPPrivMap = new HashMap<String, IPSDEOPPriv>();
			for (IPSDEOPPriv iPSDEOPPriv : psDEOPPrivList) {
				psDEOPPrivMap.put(iPSDEOPPriv.getName(), iPSDEOPPriv);
			}
			
			for (IPSDEOPPriv iPSDEOPPriv : psDEOPPrivMap.values()) {

				PSDEOPPrivDTO psDEOPPrivDTO = new PSDEOPPrivDTO();

				psDEOPPrivDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
				psDEOPPrivDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
				psDEOPPrivDTO.setPSDEOPPrivName(iPSDEOPPriv.getName());
				psDEOPPrivDTO.setLogicName(iPSDEOPPriv.getLogicName());
				

				// 建立操作标识
				psDEOPPrivDTOList.add(psDEOPPrivDTO);

			}

			try {
				psDEOPPrivDTOList = this.getPSDEOPPrivDTOs(psDataEntityDTO, psDEOPPrivDTOList);
//				for (PSDEOPPrivDTO psDEOPPrivDTO : psDEOPPrivDTOList) {
//					psDEOPPrivDTOMap.put(String.format("%1$s|%2$s", iPSDataEntity.getId(),
//							psDEOPPrivDTO.getPSDEOPPrivName().toUpperCase()), psDEOPPrivDTO);
//				}
			} catch (Throwable ex) {
				throw new Exception(String.format("建立实体[%1$s]操作标识发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()),
						ex);
			}

		}

		return psDEOPPrivDTOList;
	}

	

	protected PSDERDTO syncPSDER(IPSDERBase iPSDERBase) throws Exception {

		PSDERDTO psDERDTO = this.getPSDERDTOMap().get(iPSDERBase.getId());
		if (psDERDTO != null) {
			return psDERDTO;
		}

		IPSDataEntity majorPSDataEntity = iPSDERBase.getMajorPSDataEntityMust();
		IPSDataEntity minorPSDataEntity = iPSDERBase.getMinorPSDataEntityMust();

		PSDataEntityDTO majorPSDataEntityDTO = this.getPSDataEntityDTOMap().get(majorPSDataEntity.getId());
		PSDataEntityDTO minorPSDataEntityDTO = this.getPSDataEntityDTOMap().get(minorPSDataEntity.getId());

		psDERDTO = new PSDERDTO();
		psDERDTO.setPSDERName(iPSDERBase.getName());
		psDERDTO.setMajorPSDEId(majorPSDataEntityDTO.getPSDataEntityId());
		psDERDTO.setMajorPSDEName(majorPSDataEntityDTO.getPSDataEntityName());
		psDERDTO.setMinorPSDEId(minorPSDataEntityDTO.getPSDataEntityId());
		psDERDTO.setMinorPSDEName(minorPSDataEntityDTO.getPSDataEntityName());
		psDERDTO.setCodeName(iPSDERBase.getCodeName());
		psDERDTO.setMinorCodeName(iPSDERBase.getMinorCodeName());
		psDERDTO.setDERType(iPSDERBase.getDERType());
		psDERDTO.setOrderValue(iPSDERBase.getOrderValue());

		IPSDEDataSet nestedPSDEDataSet = null;
		IPSDEDataSet refPSDEDataSet = null;

		if (iPSDERBase instanceof IPSDER1N) {
			IPSDER1N iPSDER1N = (IPSDER1N) iPSDERBase;
			psDERDTO.setDERFieldName(iPSDER1N.getPSPickupDEFieldMust().getName());
			psDERDTO.setDERFieldLName(iPSDER1N.getPSPickupDEFieldMust().getLogicName());
			psDERDTO.setMasterRS(iPSDER1N.getMasterRS());
			psDERDTO.setMasterOrderValue(iPSDER1N.getMasterOrder());
			psDERDTO.setForeignKey(0);
			// 删除做无处理
			psDERDTO.removeactiontype(DER1NRemoveActionType.NONE);

			// if(iPSDER1N.get)
			nestedPSDEDataSet = iPSDER1N.getNestedPSDEDataSet();
			refPSDEDataSet = iPSDER1N.getRefPSDEDataSet();
		} else if (iPSDERBase instanceof IPSDERCustom) {
			IPSDERCustom iPSDERCustom = (IPSDERCustom) iPSDERBase;
			psDERDTO.setDERSubType(iPSDERCustom.getDERSubType());
			IPSDEField iPSDEField = iPSDERCustom.getPickupPSDEField();
			if (iPSDEField != null) {
				psDERDTO.setDERFieldName(iPSDEField.getName());
				psDERDTO.setDERFieldLName(iPSDEField.getLogicName());
			}
			psDERDTO.setMasterRS(iPSDERCustom.getMasterRS());

			nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
			
		}

		if (nestedPSDEDataSet != null) {
			PSDEDataSetDTO psDEDataSetDTO = this.getPSDEDataSetDTOMap().get(
					String.format("%1$s|%2$s", minorPSDataEntity.getId(), nestedPSDEDataSet.getName().toUpperCase()));
			if(psDEDataSetDTO != null) {
				psDERDTO.setMinorPSDEDSId(psDEDataSetDTO.getPSDEDataSetId());
				psDERDTO.setMinorPSDEDSName(psDEDataSetDTO.getPSDEDataSetName());
			}
			else {
				this.updateCurrentPSSysDevBKTask(LogLevels.WARN, String.format("无法获取实体[%1$s]数据集对象[%2$s]", minorPSDataEntity.getName(), nestedPSDEDataSet.getName()));
			}
		}
		
		if(refPSDEDataSet != null) {
			PSDEDataSetDTO psDEDataSetDTO = this.getPSDEDataSetDTOMap().get(
					String.format("%1$s|%2$s", majorPSDataEntity.getId(), refPSDEDataSet.getName().toUpperCase()));
			if(psDEDataSetDTO != null) {
				psDERDTO.setPSDEDataSetId(psDEDataSetDTO.getPSDEDataSetId());
				psDERDTO.setPSDEDataSetName(psDEDataSetDTO.getPSDEDataSetName());
			}
			else {
				this.updateCurrentPSSysDevBKTask(LogLevels.WARN, String.format("无法获取实体[%1$s]数据集对象[%2$s]", majorPSDataEntity.getName(), refPSDEDataSet.getName()));
			}
		}

		try {
			EntityBase.setIgnoreCheck(psDERDTO, true);
			EntityBase.setIgnoreCheckKey(psDERDTO, true);
			psDERDTO = this.getPSDERDTO(psDERDTO);
			this.getPSDERDTOMap().put(iPSDERBase.getId(), psDERDTO);
		} catch (Throwable ex) {
			throw new Exception(String.format("建立实体关系[%1$s]发生异常，%2$s", iPSDERBase.getName(), ex.getMessage()), ex);
		}

		// 修正关系属性类型
		List<IPSDEField> psDEFields = minorPSDataEntity.getAllPSDEFields();
		if (!ObjectUtils.isEmpty(psDEFields)) {
			for (IPSDEField iPSDEField : psDEFields) {
				if (iPSDEField instanceof IPSLinkDEField) {

					IPSLinkDEField iPSLinkDEField = (IPSLinkDEField) iPSDEField;

					if (!iPSLinkDEField.getPSDERMust().getId().equals(iPSDERBase.getId())) {
						continue;
					}

					PSDEFieldDTO psDEFieldDTO = this.getPSDEFieldDTOMap().get(
							String.format("%1$s|%2$s", minorPSDataEntity.getId(), iPSDEField.getName().toUpperCase()));
					if (!psDEFieldDTO.getPSDataTypeId().equals(iPSDEField.getDataType())) {
						// 类型不一致，进行修正
						psDEFieldDTO.setDEFType(iPSLinkDEField.getDEFType());
						psDEFieldDTO.setPSDataTypeName(null);
						psDEFieldDTO.setPSDataTypeId(iPSDEField.getDataType());
						psDEFieldDTO.setPSDERId(psDERDTO.getPSDERId());
						psDEFieldDTO.setPSDERName(psDERDTO.getPSDERName());

						PSDEFieldDTO psDEFieldDTO2 = this.getPSDEFieldDTOMap().get(String.format("%1$s|%2$s", iPSLinkDEField.getRelatedPSDataEntityMust().getId(),
										iPSLinkDEField.getRelatedPSDEFieldMust().getName().toUpperCase()));

						psDEFieldDTO.setDERPSDEFId(psDEFieldDTO2.getPSDEFieldId());
						psDEFieldDTO.setDERPSDEFName(psDEFieldDTO2.getPSDEFieldName());

						// 更新
						try {
							EntityBase.setIgnoreCheck(psDEFieldDTO, true);
							EntityBase.setIgnoreCheckKey(psDEFieldDTO, true);

							PSModelServiceUtils.getInstance().updatePSDEField(psDEFieldDTO);

							this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("更新实体属性[%1$s][%2$s]",
									psDEFieldDTO.getPSDEFieldName(), psDEFieldDTO.getCodeName()));
						} catch (Throwable ex) {
							throw new Exception(String.format("建立实体属性[%1$s]发生异常，%2$s", psDEFieldDTO.getPSDEFieldName(),
									ex.getMessage()), ex);
						}
					}
				}
			}
		}

		return psDERDTO;
	}

	protected PSDataEntityDTO getPSDataEntityDTO(IPSDataEntity iPSDataEntity) throws Exception {
		PSDataEntityDTO psDataEntityDTO = this.getPSDataEntityDTOMap().get(iPSDataEntity.getId());
		if (psDataEntityDTO == null) {
			throw new Exception(String.format("无法获取实体[%1$s]对应数据对象", iPSDataEntity.getId()));
		}
		return psDataEntityDTO;
	}

	protected PSDEServiceAPIDTO getPSDEServiceAPIDTO(IPSSysServiceAPI iPSSysServiceAPI, IPSDEServiceAPI iPSDEServiceAPI)
			throws Exception {
		PSDEServiceAPIDTO psDEServiceAPIDTO = this.getPSDEServiceAPIDTOMap().get(String.format("%1$s|%2$s", iPSSysServiceAPI.getId(), iPSDEServiceAPI.getName().toUpperCase()));
		if (psDEServiceAPIDTO == null) {
			throw new Exception(
					String.format("无法获取实体服务接口[%1$s|%2$s]对应数据对象", iPSSysServiceAPI.getId(), iPSDEServiceAPI.getId()));
		}
		return psDEServiceAPIDTO;
	}

	protected PSDESARSDTO getPSDESARSDTO(IPSSysServiceAPI iPSSysServiceAPI, IPSDEServiceAPIRS iPSDEServiceAPIRS)
			throws Exception {
		PSDESARSDTO psDESARSDTO = this.getPSDESARSDTOMap().get(String.format("%1$s|%2$s|%3$s", iPSSysServiceAPI.getId(),
				iPSDEServiceAPIRS.getMajorPSDEServiceAPIMust().getName().toUpperCase(),
				iPSDEServiceAPIRS.getMinorPSDEServiceAPIMust().getName().toUpperCase()));
		if (psDESARSDTO == null) {
			throw new Exception(String.format("无法获取实体服务接口关系[%1$s|%2$s|%3$s]对应数据对象", iPSSysServiceAPI.getId(),
					iPSDEServiceAPIRS.getMajorPSDEServiceAPIMust().getId(),
					iPSDEServiceAPIRS.getMinorPSDEServiceAPIMust().getId()));
		}
		return psDESARSDTO;
	}

	protected PSDEActionDTO getPSDEActionDTO(IPSDataEntity iPSDataEntity, IPSDEAction iPSDEAction) throws Exception {
		PSDEActionDTO psDEActionDTO = this.getPSDEActionDTOMap().get(String.format("%1$s|%2$s", iPSDataEntity.getId(), iPSDEAction.getName().toUpperCase()));
		if (psDEActionDTO == null) {
			throw new Exception(String.format("无法获取实体行为[%1$s|%2$s]对应数据对象", iPSDataEntity.getId(), iPSDEAction.getId()));
		}
		return psDEActionDTO;
	}

	protected PSDEDataSetDTO getPSDEDataSetDTO(IPSDataEntity iPSDataEntity, IPSDEDataSet iPSDEDataSet)
			throws Exception {
		PSDEDataSetDTO psDEDataSetDTO = this.getPSDEDataSetDTOMap().get(String.format("%1$s|%2$s", iPSDataEntity.getId(), iPSDEDataSet.getName().toUpperCase()));
		if (psDEDataSetDTO == null) {
			throw new Exception(
					String.format("无法获取实体数据集[%1$s|%2$s]对应数据对象", iPSDataEntity.getId(), iPSDEDataSet.getId()));
		}
		return psDEDataSetDTO;
	}

	protected PSSysModelGroupDTO getPSSysModelGroupDTO() {
		return this.psSysModelGroupDTOThreadLocal.get();
	}
	
	protected void setPSSysModelGroupDTO(PSSysModelGroupDTO psSysModelGroupDTO) {
		this.psSysModelGroupDTOThreadLocal.set(psSysModelGroupDTO);
	}

	protected PSSysServiceAPIDTO getPSSysServiceAPIDTO() {
		return this.psSysServiceAPIDTOThreadLocal.get();
	}
	
	protected void setPSSysServiceAPIDTO(PSSysServiceAPIDTO psSysServiceAPIDTO) {
		this.psSysServiceAPIDTOThreadLocal.set(psSysServiceAPIDTO);
	}

	protected PSSubSysServiceAPIDTO getPSSubSysServiceAPIDTO() {
		return this.psSubSysServiceAPIDTOThreadLocal.get();
	}

	protected void setPSSubSysServiceAPIDTO(PSSubSysServiceAPIDTO psSubSysServiceAPIDTO) {
		this.psSubSysServiceAPIDTOThreadLocal.set(psSubSysServiceAPIDTO);
	}
	
	
	protected Map<String, PSModuleDTO> getPSModuleDTOMap() {
		return this.psModuleDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSCodeListDTO> getPSCodeListDTOMap() {
		return this.psCodeListDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDataEntityDTO> getPSDataEntityDTOMap() {
		return this.psDataEntityDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDERDTO> getPSDERDTOMap() {
		return this.psDERDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDEFieldDTO> getPSDEFieldDTOMap() {
		return this.psDEFieldDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDEDataSetDTO> getPSDEDataSetDTOMap() {
		return this.psDEDataSetDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDEActionDTO> getPSDEActionDTOMap() {
		return this.psDEActionDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDEServiceAPIDTO> getPSDEServiceAPIDTOMap() {
		return this.psDEServiceAPIDTOMapThreadLocal.get();
	}
	
	protected Map<String, PSDESARSDTO> getPSDESARSDTOMap() {
		return this.psDESARSDTOMapThreadLocal.get();
	}
	
}
