package net.ibizsys.central.plugin.cs.core.dataentity.action;

import java.io.File;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.StringUtils;

import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSStudioPluginDataDTO;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.KeyValueUtils;
import net.ibizsys.centralstudio.util.LogLevels;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.runtime.util.ZipUtils;

public abstract class CodeGenActionRuntimeBase extends PSRTModelExportActionRuntimeBase{

	private static final Log log = LogFactory.getLog(CodeGenActionRuntimeBase.class);
	
	/**
	 * 系统参数：模板配置
	 */
	public final static String PLUGINPARAM_TEMPLATE = "template";
	
	/**
	 * 模板源类型：zip文件
	 */
	public final static String TEMPLATE_TYPE_ZIP = "ZIP";
	
	
	/**
	 * 模板源类型：git 仓库
	 */
	public final static String TEMPLATE_TYPE_GIT = "GIT";
	
	public final static String TEMPLATE_URL = "url";
	
	public final static String TEMPLATE_TYPE = "type";
	
	public final static String TEMPLATE_BRANCH = "branch";
	
	public final static String TEMPLATE_USERNAME = "username";
	
	public final static String TEMPLATE_PASSWORD = "password";
	
	private ThreadLocal<String> templatePathThreadLocal = new ThreadLocal<String>();
	
	@Override
	protected Object onExecute(PSStudioPluginDataDTO psStudioPluginDataDTO) throws Throwable {
		resetSessionParams();
		try {
			return super.onExecute(psStudioPluginDataDTO);
		} finally {
			resetSessionParams();
		}
	}
	
	protected void resetSessionParams() {
		onResetSessionParams();
	}

	protected void onResetSessionParams() {
		this.templatePathThreadLocal.remove();
	}
	
	@Override
	protected Object onExportPSRTModel(IPSSystemService iPSSystemService, PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
		
		if(!StringUtils.hasLength(this.getTemplatePath())) {
			Object templateParams = paramMap.get(PLUGINPARAM_TEMPLATE);
			if(templateParams instanceof Map) {
				Map templateMap = (Map)templateParams;
				this.setTemplatePath(this.getTemplatePath(templateMap));
			}
			else {
				throw new Exception(String.format("未指定模板参数"));
			}
		}
		
		return super.onExportPSRTModel(iPSSystemService, psDevSlnSysDTO, paramMap);
	}
	
	protected void prepareTemplatePath(PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
		
		
	}
	
	protected String getTemplatePath(Map templateMap) throws Exception {

		String strTemplateUrl = DataTypeUtils.getStringValue(templateMap.get("url"), null);
		String strType = DataTypeUtils.getStringValue(templateMap.get("type"), "zip");
		String strBranch = DataTypeUtils.getStringValue(templateMap.get("branch"), "master");
		String strGitUserName = DataTypeUtils.getStringValue(templateMap.get("username"), null);
		String strGitPassword = DataTypeUtils.getStringValue(templateMap.get("password"), null);

		if (!StringUtils.hasLength(strTemplateUrl)) {
			throw new Exception("未指定模板路径");
		}

		// 签出文件
		this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("开始下载模板文件[%1$s]", strTemplateUrl));
		
		String strPath = null;
		if(TEMPLATE_TYPE_GIT.equals(strType)) {
			strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(), File.separator, KeyValueUtils.genUniqueId());
			File folder = new File(strPath);
			folder.mkdirs();
			try {
				CloneCommand cloneCommand = Git.cloneRepository().setURI(strTemplateUrl).setDirectory(folder).setBranch(strBranch);
				if (StringUtils.hasLength(strGitUserName)) {
					if (StringUtils.hasLength(strGitPassword)) {
						cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
					} else {
						cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, ""));
					}
				}
				cloneCommand.call();
			} catch (Throwable ex) {
				throw new Exception(String.format("获取模板文件发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		else
			if(TEMPLATE_TYPE_ZIP.equals(strType)) {
				String[] items = strTemplateUrl.split("[#]");
				String url = items[0];
				File tempFile = File.createTempFile("resource", ".zip");
				try {
					this.getSystemRuntime().getDefaultWebClient().download(url, tempFile);
				}
				catch (Throwable ex) {
					throw new Exception(String.format("下载文件发生异常，%1$s", ex.getMessage()), ex);
				}
				
				String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
				File folder = new File(folderPath);
				ZipUtils.unzip(tempFile, folder);
				
				if(items.length == 2 && StringUtils.hasLength(items[1])) {
					folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
				}
				strPath = folder.getAbsolutePath();
			}
			else {
				throw new Exception(String.format("无法识别的模板文件类型[%1$s]", strType));
			}
		
		this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("结束下载模板文件"));
		
		return strPath;
	}

	
	
	protected String getTemplatePath() {
		return this.templatePathThreadLocal.get();
	}
	
	protected void setTemplatePath(String templatePath) {
		this.templatePathThreadLocal.set(templatePath);
	}
}
