/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.core.logic;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.plugin.cs.core.logic.IPSRTModelExportLogicRuntime;
import net.ibizsys.central.plugin.cs.core.logic.PSModelImportLogicRuntimeBase;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.KeyValueUtils;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.ZipUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public abstract class PSRTModelExportLogicRuntimeBase
extends PSModelImportLogicRuntimeBase
implements IPSRTModelExportLogicRuntime {
    private static final Log log = LogFactory.getLog(PSRTModelExportLogicRuntimeBase.class);

    protected boolean isImportMode() {
        return false;
    }

    @Override
    protected Object onExecute(Object[] args, Object logicParam, Object logicParam2) throws Throwable {
        if (this.isImportMode()) {
            return super.onExecute(args, logicParam, logicParam2);
        }
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected Map<String, Object> getPSRTModelParams(IEntity iEntity) throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", iEntity.get("url"));
        params.put("type", iEntity.get("type"));
        params.put("branch", iEntity.get("branch"));
        params.put("username", iEntity.get("username"));
        params.put("password", iEntity.get("password"));
        return params;
    }

    protected IPSSystemService getPSRTModelService(Map psrtmodelMap) throws Exception {
        String strRTModelUrl = DataTypeUtils.getStringValue(psrtmodelMap.get("url"), null);
        String strType = DataTypeUtils.getStringValue(psrtmodelMap.get("type"), (String)"zip");
        String strBranch = DataTypeUtils.getStringValue(psrtmodelMap.get("branch"), (String)"master");
        String strGitUserName = DataTypeUtils.getStringValue(psrtmodelMap.get("username"), null);
        String strGitPassword = DataTypeUtils.getStringValue(psrtmodelMap.get("password"), null);
        if (!StringUtils.hasLength((String)strRTModelUrl)) {
            throw new Exception("\u672a\u6307\u5b9a\u8fd0\u884c\u65f6\u6a21\u578b\u8def\u5f84");
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u5f00\u59cb\u4e0b\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b[%1$s]", strRTModelUrl));
        String strPath = null;
        if ("GIT".equals(strType)) {
            strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(), File.separator, KeyValueUtils.genUniqueId());
            File folder = new File(strPath);
            folder.mkdirs();
            try {
                CloneCommand cloneCommand = Git.cloneRepository().setURI(strRTModelUrl).setDirectory(folder).setBranch(strBranch);
                if (StringUtils.hasLength((String)strGitUserName)) {
                    if (StringUtils.hasLength((String)strGitPassword)) {
                        cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
                    } else {
                        cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, ""));
                    }
                }
                cloneCommand.call();
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u83b7\u53d6\u8fd0\u884c\u65f6\u6a21\u578b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if ("ZIP".equals(strType)) {
            String[] items = strRTModelUrl.split("[#]");
            String url = items[0];
            File tempFile = File.createTempFile("resource", ".zip");
            try {
                this.getSystemRuntime().getDefaultWebClient().download(url, (Object)tempFile);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
            File folder = new File(folderPath);
            ZipUtils.unzip((File)tempFile, (File)folder);
            if (items.length == 2 && StringUtils.hasLength((String)items[1])) {
                folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
            }
            strPath = folder.getAbsolutePath();
        } else {
            throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd0\u884c\u65f6\u6a21\u578b\u7c7b\u578b[%1$s]", strType));
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u7ed3\u675f\u4e0b\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b", new Object[0]));
        String strModelPath = "";
        File modelFile = new File(String.format("%1$s%2$sibizmodel.yaml", strPath, File.separator));
        if (modelFile.exists()) {
            try {
                String strModelFolder;
                Yaml yaml = new Yaml();
                Map config = (Map)yaml.loadAs((InputStream)new FileInputStream(modelFile), Map.class);
                if (config != null && StringUtils.hasLength((String)(strModelFolder = (String)config.get("modelfolder")))) {
                    strModelPath = strPath + File.separator + strModelFolder;
                }
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u52a0\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b\u914d\u7f6e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if (!StringUtils.hasLength((String)strModelPath)) {
            strModelPath = strPath;
        }
        IPSSystemService iPSSystemService = null;
        try {
            iPSSystemService = this.getPSSystemService(strModelPath);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u52a0\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        return iPSSystemService;
    }

    @Override
    protected IPSSystemService getPSSystemService(String strModelPath) throws Throwable {
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strModelPath);
        psModelServiceImpl.getPSSystem();
        return psModelServiceImpl;
    }
}

