/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.core.dataentity.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import net.ibizsys.central.plugin.cs.core.dataentity.action.PSModelImportActionRuntimeBase;
import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSSysDBColumnDTO;
import net.ibizsys.centralstudio.dto.PSSysDBSchemeDTO;
import net.ibizsys.centralstudio.dto.PSSysDBTableDTO;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DBSchemaImportActionRuntime
extends PSModelImportActionRuntimeBase {
    private static final Log log = LogFactory.getLog(DBSchemaImportActionRuntime.class);
    protected static Map<String, Integer> str2intMap = new HashMap<String, Integer>();
    private PSSysDBSchemeDTO psSysDBSchemeDTO = null;
    private Map<String, PSSysDBTableDTO> psSysDBTableDTOMap = new HashMap<String, PSSysDBTableDTO>();

    @Override
    protected Object onImportPSModel(PSDevSlnSysDTO psDevSlnSys, Map<String, Object> paramMap) throws Throwable {
        if (paramMap == null) {
            throw new Exception("\u672a\u6307\u5b9a\u5bfc\u5165\u6570\u636e\u6e90\u53c2\u6570");
        }
        Map datasourceMap = null;
        Object datasource = paramMap.get("datasource");
        if (datasource instanceof Map) {
            datasourceMap = (Map)datasource;
        }
        if (datasourceMap == null) {
            throw new Exception("\u672a\u6307\u5b9a\u6570\u636e\u6e90\u914d\u7f6e");
        }
        HashMap psSysDBSchemaMap = null;
        Object pssysdbschema = paramMap.get("pssysdbschema");
        if (pssysdbschema == null) {
            pssysdbschema = paramMap.get("pssysdbscheme");
        }
        psSysDBSchemaMap = pssysdbschema instanceof Map ? (HashMap)pssysdbschema : new HashMap();
        Set tables = null;
        String strUrl = DataTypeUtils.getStringValue(datasourceMap.get("url"), null);
        String strUserName = DataTypeUtils.getStringValue(datasourceMap.get("username"), null);
        String strPassword = DataTypeUtils.getStringValue(datasourceMap.get("password"), null);
        String strDriverClassName = DataTypeUtils.getStringValue(datasourceMap.get("driverclassname"), null);
        FileSystemResourceAccessor resourceAccessor = new FileSystemResourceAccessor();
        Database targetDatabase = CommandLineUtils.createDatabaseObject((ResourceAccessor)resourceAccessor, (String)strUrl, (String)strUserName, (String)strPassword, (String)strDriverClassName, (String)"", (String)"", (boolean)false, (boolean)false, null, null, null, null, null, null, null);
        String strTypes = "Column,Table,PrimaryKey";
        SnapshotControl snapshotControl = new SnapshotControl(targetDatabase, strTypes);
        try {
            targetDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            DatabaseSnapshot databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(CatalogAndSchema.DEFAULT, targetDatabase, snapshotControl);
            tables = databaseSnapshot.get(Table.class);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u83b7\u53d6\u6570\u636e\u5e93\u6a21\u578b\u5207\u7247\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        finally {
            if (targetDatabase != null) {
                try {
                    targetDatabase.close();
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        }
        String strDSLink = DataTypeUtils.getStringValue(psSysDBSchemaMap.get("dslink"), (String)"DEFAULT");
        String strPSSysDBSchemaName = DataTypeUtils.getStringValue(psSysDBSchemaMap.get("name"), (String)"\u6570\u636e\u6e90");
        PSSysDBSchemeDTO psSysDBSchemeDTO = new PSSysDBSchemeDTO();
        psSysDBSchemeDTO.setExistingModel(Integer.valueOf(1));
        psSysDBSchemeDTO.setDSLink(strDSLink);
        psSysDBSchemeDTO.setPSSysDBSchemeName(strPSSysDBSchemaName);
        try {
            this.psSysDBSchemeDTO = this.getPSSysDBSchemeDTO(psSysDBSchemeDTO);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u5efa\u7acb\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strDSLink, ex.getMessage()), ex);
        }
        if (ObjectUtils.isEmpty((Object)tables)) {
            this.updateCurrentPSSysDevBKTask(20000, String.format("\u6307\u5b9a\u6570\u636e\u6e90\u672a\u5305\u542b\u4efb\u4f55\u6570\u636e\u8868\u5bf9\u8c61", new Object[0]));
            return null;
        }
        this.syncPSSysDBTableDTOs(tables);
        this.syncPSSysDBColumnDTOs(tables);
        return null;
    }

    protected List<PSSysDBTableDTO> syncPSSysDBTableDTOs(Set<Table> tables) throws Exception {
        List<PSSysDBTableDTO> psSysDBTableDTOList = new ArrayList<PSSysDBTableDTO>();
        for (Table table : tables) {
            PSSysDBTableDTO psSysDBTableDTO = new PSSysDBTableDTO();
            psSysDBTableDTO.setPSSysDBSchemeId(this.getPSSysDBSchemeDTO().getPSSysDBSchemeId());
            psSysDBTableDTO.setPSSysDBSchemeName(this.getPSSysDBSchemeDTO().getPSSysDBSchemeName());
            psSysDBTableDTO.setTableType("TABLE");
            psSysDBTableDTO.setPSSysDBTableName(table.getName().toUpperCase());
            psSysDBTableDTO.setCodeName(table.getName());
            psSysDBTableDTOList.add(psSysDBTableDTO);
        }
        try {
            psSysDBTableDTOList = this.getPSSysDBTableDTOs(this.getPSSysDBSchemeDTO(), psSysDBTableDTOList);
            for (PSSysDBTableDTO psSysDBTableDTO : psSysDBTableDTOList) {
                this.psSysDBTableDTOMap.put(psSysDBTableDTO.getPSSysDBTableName().toUpperCase(), psSysDBTableDTO);
            }
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u5efa\u7acb\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u6570\u636e\u8868\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getPSSysDBSchemeDTO().getDSLink(), ex.getMessage()), ex);
        }
        return psSysDBTableDTOList;
    }

    protected List<PSSysDBColumnDTO> syncPSSysDBColumnDTOs(Set<Table> tables) throws Exception {
        List<PSSysDBColumnDTO> psSysDBColumnDTOList = new ArrayList<PSSysDBColumnDTO>();
        for (Table table : tables) {
            PSSysDBTableDTO psSysDBTableDTO = this.getPSSysDBTableDTO(table.getName().toUpperCase());
            List columns = table.getColumns();
            if (ObjectUtils.isEmpty((Object)columns)) continue;
            HashMap<String, Column> pkeyMap = new HashMap<String, Column>();
            if (table.getPrimaryKey() != null && !ObjectUtils.isEmpty((Object)table.getPrimaryKey().getColumns())) {
                for (Column column : table.getPrimaryKey().getColumns()) {
                    pkeyMap.put(column.getName().toUpperCase(), column);
                }
            }
            for (Column column : columns) {
                PSSysDBColumnDTO psSysDBColumnDTO = new PSSysDBColumnDTO();
                psSysDBColumnDTO.setPSSysDBTableId(psSysDBTableDTO.getPSSysDBTableId());
                psSysDBColumnDTO.setPSSysDBTableName(psSysDBTableDTO.getPSSysDBTableName());
                psSysDBColumnDTO.setPSSysDBColumnName(column.getName().toUpperCase());
                psSysDBColumnDTO.setCodeName(column.getName());
                psSysDBColumnDTO.setOrderValue(column.getOrder());
                psSysDBColumnDTO.setDataType(column.getType().toString());
                psSysDBColumnDTO.setAllowEmpty(Integer.valueOf(1));
                if (pkeyMap.containsKey(column.getName().toUpperCase())) {
                    psSysDBColumnDTO.setPKey(Integer.valueOf(1));
                    psSysDBColumnDTO.setAllowEmpty(Integer.valueOf(0));
                } else {
                    psSysDBColumnDTO.setAllowEmpty(Integer.valueOf(column.isNullable() != false ? 1 : 0));
                }
                String strType = column.getType().toString();
                Integer nLength = null;
                Integer nPrecision = null;
                int nPos = strType.indexOf("(");
                if (nPos != -1) {
                    strType = strType.replace(")", "");
                    strType = strType.replace("(", "|");
                    String[] items = strType.split("[|]");
                    strType = items[0];
                    String strLength = items[1];
                    if (StringUtils.hasLength((String)strLength)) {
                        items = strLength.split("[,]");
                        strLength = items[0];
                        String[] items2 = strLength.trim().split("[ ]");
                        nLength = Integer.parseInt(items2[0]);
                        if (items.length == 2) {
                            nPrecision = Integer.parseInt(items[1].trim());
                        }
                    }
                    if (nLength != null && nLength < 0) {
                        nLength = null;
                    }
                    if (nLength != null) {
                        if (nPrecision != null && nPrecision < 0) {
                            nPrecision = null;
                        }
                    } else {
                        nPrecision = null;
                    }
                }
                psSysDBColumnDTO.setDataType(strType.toUpperCase());
                psSysDBColumnDTO.setLength(nLength);
                psSysDBColumnDTO.setPrecision2(nPrecision);
                if (!str2intMap.containsKey(strType.toUpperCase())) {
                    log.warn((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b[%1$s]", column.getType().toString()));
                    this.updateCurrentPSSysDevBKTask(30000, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u5217[%1$s %2$s][%3$s]", psSysDBColumnDTO.getPSSysDBColumnName(), column.getType().toString(), psSysDBColumnDTO.getPSSysDBTableName()));
                    continue;
                }
                int nStdDataType = str2intMap.get(strType.toUpperCase());
                psSysDBColumnDTO.setStdDataType(Integer.valueOf(nStdDataType));
                psSysDBColumnDTOList.add(psSysDBColumnDTO);
            }
        }
        try {
            psSysDBColumnDTOList = this.getPSSysDBColumnDTOs(this.getPSSysDBSchemeDTO(), psSysDBColumnDTOList);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u5efa\u7acb\u6570\u636e\u5e93\u4f53\u7cfb[%1$s]\u6570\u636e\u5217\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getPSSysDBSchemeDTO().getDSLink(), ex.getMessage()), ex);
        }
        return psSysDBColumnDTOList;
    }

    protected PSSysDBSchemeDTO getPSSysDBSchemeDTO() {
        return this.psSysDBSchemeDTO;
    }

    protected PSSysDBTableDTO getPSSysDBTableDTO(String strTableName) throws Exception {
        PSSysDBTableDTO psSysDBTableDTO = this.psSysDBTableDTOMap.get(strTableName.toUpperCase());
        if (psSysDBTableDTO == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u8868[%1$s]\u5bf9\u5e94\u6570\u636e\u5bf9\u8c61", strTableName));
        }
        return psSysDBTableDTO;
    }

    static {
        str2intMap.put("BIGINT", 1);
        str2intMap.put("BINARY", 2);
        str2intMap.put("BIT", 3);
        str2intMap.put("CHAR", 4);
        str2intMap.put("DATETIME", 5);
        str2intMap.put("DECIMAL", 6);
        str2intMap.put("BIGDECIMAL", 29);
        str2intMap.put("FLOAT", 7);
        str2intMap.put("IMAGE", 8);
        str2intMap.put("INT", 9);
        str2intMap.put("MONEY", 10);
        str2intMap.put("NCHAR", 11);
        str2intMap.put("NTEXT", 12);
        str2intMap.put("NVARCHAR", 13);
        str2intMap.put("NUMERIC", 14);
        str2intMap.put("REAL", 15);
        str2intMap.put("SMALLDATETIME", 16);
        str2intMap.put("SMALLINT", 17);
        str2intMap.put("SMALLMONEY", 18);
        str2intMap.put("SQL_VARIANT", 19);
        str2intMap.put("SYSNAME", 20);
        str2intMap.put("TEXT", 21);
        str2intMap.put("TIMESTAMP", 22);
        str2intMap.put("TINYINT", 23);
        str2intMap.put("VARBINARY", 24);
        str2intMap.put("VARCHAR", 25);
        str2intMap.put("UNIQUEIDENTIFIER", 26);
        str2intMap.put("DATE", 27);
        str2intMap.put("TIME", 28);
        str2intMap.put("VARCHAR2", 25);
        str2intMap.put("NUMBER", 6);
        str2intMap.put("BLOB", 24);
        str2intMap.put("CLOB", 21);
        str2intMap.put("MEDIUMTEXT", 21);
        str2intMap.put("DOUBLE", 6);
    }
}

