/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.core.dataentity.action;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.plugin.cs.core.dataentity.action.PSModelImportActionRuntimeBase;
import net.ibizsys.centralstudio.dto.PSDEFieldDTO;
import net.ibizsys.centralstudio.dto.PSDataEntityDTO;
import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSModuleDTO;
import net.ibizsys.centralstudio.dto.PSStudioPluginDataDTO;
import net.ibizsys.centralstudio.dto.PSSysDBColumnDTO;
import net.ibizsys.centralstudio.dto.PSSysDBSchemeDTO;
import net.ibizsys.centralstudio.dto.PSSysDBTableDTO;
import net.ibizsys.centralstudio.dto.PSSysModelGroupDTO;
import net.ibizsys.centralstudio.filter.PSDEFieldFilter;
import net.ibizsys.centralstudio.filter.PSDataEntityFilter;
import net.ibizsys.centralstudio.filter.PSSysDBColumnFilter;
import net.ibizsys.centralstudio.filter.PSSysDBSchemeFilter;
import net.ibizsys.centralstudio.filter.PSSysDBTableFilter;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.DataTypes;
import net.ibizsys.centralstudio.util.IPSModelDTO;
import net.ibizsys.centralstudio.util.PSModelServiceUtils;
import net.ibizsys.model.PSModelEnums;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DataEntityFromDBSchemaActionRuntime
extends PSModelImportActionRuntimeBase {
    private static final Log log = LogFactory.getLog(DataEntityFromDBSchemaActionRuntime.class);
    private ThreadLocal<PSSysDBSchemeDTO> psSysDBSchemeDTOThreadLocal = new ThreadLocal();
    private ThreadLocal<PSSysModelGroupDTO> psSysModelGroupDTOThreadLocal = new ThreadLocal();
    private ThreadLocal<PSModuleDTO> psModuleDTOThreadLocal = new ThreadLocal();

    protected void resetSessionParams() {
        this.onResetSessionParams();
    }

    protected void onResetSessionParams() {
        this.psSysModelGroupDTOThreadLocal.remove();
        this.psSysDBSchemeDTOThreadLocal.remove();
        this.psModuleDTOThreadLocal.remove();
    }

    @Override
    protected Object onExecute(PSStudioPluginDataDTO psStudioPluginDataDTO) throws Throwable {
        this.resetSessionParams();
        try {
            Object object = super.onExecute(psStudioPluginDataDTO);
            return object;
        }
        finally {
            this.resetSessionParams();
        }
    }

    @Override
    protected String onGetPSSysDevBKTaskName(Map<String, Object> paramMap) {
        return "\u4ece\u6570\u636e\u5e93\u4f53\u7cfb\u6a21\u578b\u6784\u5efa\u5b9e\u4f53";
    }

    @Override
    protected Object onImportPSModel(PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
        String strDSLink;
        HashMap psdataentityMap;
        HashMap psmoduleMap;
        Map pssysmodelgroupMap;
        block43: {
            if (paramMap == null) {
                throw new Exception("\u672a\u6307\u5b9a\u5bfc\u5165\u53c2\u6570");
            }
            Object pssysdbschema = paramMap.get("pssysdbschema");
            if (pssysdbschema == null) {
                pssysdbschema = paramMap.get("pssysdbscheme");
            }
            Map pssysdbschemaMap = null;
            if (pssysdbschema instanceof Map) {
                pssysdbschemaMap = (Map)pssysdbschema;
            }
            if (pssysdbschemaMap == null) {
                throw new Exception("\u672a\u6307\u5b9a\u6570\u636e\u5e93\u4f53\u7cfb");
            }
            Object pssysmodelgroup = paramMap.get("pssysmodelgroup");
            pssysmodelgroupMap = null;
            if (pssysmodelgroup instanceof Map) {
                pssysmodelgroupMap = (Map)pssysmodelgroup;
            }
            Object psmodule = paramMap.get("psmodule");
            psmoduleMap = null;
            psmoduleMap = psmodule instanceof Map ? (HashMap)psmodule : new HashMap();
            Object psdataentity = paramMap.get("psdataentity");
            psdataentityMap = null;
            psdataentityMap = psdataentity instanceof Map ? (HashMap)psdataentity : new HashMap();
            strDSLink = DataTypeUtils.getStringValue(pssysdbschemaMap.get("dslink"), (String)PSModelEnums.DataSourceLink.DEFAULT.value);
            try {
                List list = PSModelServiceUtils.getInstance().searchAllPSSysDBSchemes(new PSSysDBSchemeFilter());
                if (ObjectUtils.isEmpty((Object)list)) break block43;
                for (PSSysDBSchemeDTO psSysDBSchemeDTO : list) {
                    if (StringUtils.hasLength((String)psSysDBSchemeDTO.getPSSysModelGroupId()) || !strDSLink.equalsIgnoreCase(psSysDBSchemeDTO.getDSLink())) continue;
                    this.setPSSysDBSchemeDTO(psSysDBSchemeDTO);
                    break;
                }
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u67e5\u8be2\u6307\u5b9a\u6570\u636e\u5e93\u4f53\u7cfb\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            }
        }
        if (this.getPSSysDBSchemeDTO() == null) {
            throw new Exception(String.format("\u6307\u5b9a\u6570\u636e\u6e90[%1$s]\u6570\u636e\u5e93\u4f53\u7cfb\u4e0d\u5b58\u5728", strDSLink));
        }
        if (pssysmodelgroupMap != null) {
            try {
                String strPSSysModelGroupCodeName = DataTypeUtils.getStringValue(pssysmodelgroupMap.get("codename"), (String)String.format("DBSchema_%1$s", strDSLink.toLowerCase()));
                PSSysModelGroupDTO psSysModelGroupDTO = new PSSysModelGroupDTO();
                psSysModelGroupDTO.setCodeName(strPSSysModelGroupCodeName);
                psSysModelGroupDTO.setPSSysModelGroupName(String.format("\u6a21\u578b\u7ec4[%1$s]", strPSSysModelGroupCodeName));
                this.setPSSysModelGroupDTO(this.getPSSysModelGroupDTO(psSysModelGroupDTO));
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u5efa\u7acb\u6a21\u578b\u7ec4\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        try {
            String strPSModuleCodeName = DataTypeUtils.getStringValue(psmoduleMap.get("codename"), (String)String.format("DBSchema_%1$s", strDSLink.toLowerCase()));
            PSModuleDTO psModuleDTO = new PSModuleDTO();
            if (this.getPSSysModelGroupDTO() != null) {
                psModuleDTO.pssysmodelgroupid(this.getPSSysModelGroupDTO());
            }
            psModuleDTO.setCodeName(strPSModuleCodeName);
            psModuleDTO.setPSModuleName(String.format("\u6a21\u5757[%1$s]", strPSModuleCodeName));
            this.setPSModuleDTO(this.getPSModuleDTO(psModuleDTO));
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u5efa\u7acb\u7cfb\u7edf\u6a21\u5757\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        HashMap<String, PSSysDBTableDTO> psSysDBTableDTOMap = new HashMap<String, PSSysDBTableDTO>();
        try {
            PSSysDBTableFilter psSysDBTableFilter = new PSSysDBTableFilter().pssysdbschemeid__eq(this.getPSSysDBSchemeDTO().getPSSysDBSchemeId());
            List list = PSModelServiceUtils.getInstance().searchAllPSSysDBTables(psSysDBTableFilter);
            if (!ObjectUtils.isEmpty((Object)list)) {
                for (Object item : list) {
                    psSysDBTableDTOMap.put(item.getPSSysDBTableName().toUpperCase(), (PSSysDBTableDTO)item);
                }
            }
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u67e5\u8be2\u6570\u636e\u5e93\u4f53\u7cfb\u6570\u636e\u8868\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (ObjectUtils.isEmpty(psSysDBTableDTOMap)) {
            this.updateCurrentPSSysDevBKTask(20000, String.format("\u6307\u5b9a\u6570\u636e\u5e93\u4f53\u7cfb\u4e2d\u672a\u5b9a\u4e49\u6570\u636e\u8868\uff0c\u5ffd\u7565\u64cd\u4f5c", new Object[0]));
            return null;
        }
        HashMap<String, ArrayList<PSSysDBColumnDTO>> psSysDBColumnDTOListMap = new HashMap<String, ArrayList<PSSysDBColumnDTO>>();
        try {
            PSSysDBColumnFilter psSysDBColumnFilter = new PSSysDBColumnFilter().pssysdbschemeid__eq(this.getPSSysDBSchemeDTO().getPSSysDBSchemeId());
            List list = PSModelServiceUtils.getInstance().searchAllPSSysDBColumns(psSysDBColumnFilter);
            if (!ObjectUtils.isEmpty((Object)list)) {
                for (PSSysDBColumnDTO item : list) {
                    ArrayList<PSSysDBColumnDTO> psSysDBColumnDTOList = (ArrayList<PSSysDBColumnDTO>)psSysDBColumnDTOListMap.get(item.getPSSysDBTableId());
                    if (psSysDBColumnDTOList == null) {
                        psSysDBColumnDTOList = new ArrayList<PSSysDBColumnDTO>();
                        psSysDBColumnDTOListMap.put(item.getPSSysDBTableId(), psSysDBColumnDTOList);
                    }
                    psSysDBColumnDTOList.add(item);
                }
            }
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u67e5\u8be2\u6570\u636e\u5e93\u4f53\u7cfb\u6570\u636e\u5217\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        HashMap<String, PSDataEntityDTO> psDataEntityDTOMap = new HashMap<String, PSDataEntityDTO>();
        try {
            PSDataEntityFilter psDataEntityFilter = new PSDataEntityFilter();
            psDataEntityFilter.storagemode__eq(Integer.valueOf(PSModelEnums.DEStorageType.SQL.value));
            List list = PSModelServiceUtils.getInstance().searchAllPSDataEntities(psDataEntityFilter);
            if (!ObjectUtils.isEmpty((Object)list)) {
                for (PSDataEntityDTO item : list) {
                    if (this.getPSSysModelGroupDTO() != null ? !StringUtils.hasLength((String)item.getPSSysModelGroupId()) || !this.getPSSysModelGroupDTO().getPSSysModelGroupId().equals(item.getPSSysModelGroupId()) : StringUtils.hasLength((String)item.getPSSysModelGroupId())) continue;
                    psDataEntityDTOMap.put(item.getPSDataEntityName().toUpperCase(), item);
                }
            }
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u67e5\u8be2\u5168\u90e8\u5b9e\u4f53\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        String strDENameRep = DataTypeUtils.getStringValue(psdataentityMap.get("namerep"), (String)"");
        String strDENameRegEx = DataTypeUtils.getStringValue(psdataentityMap.get("nameregex"), (String)"");
        for (PSSysDBTableDTO psSysDBTableDTO : psSysDBTableDTOMap.values()) {
            PSDataEntityDTO psDataEntityDTO;
            String strDEName = psSysDBTableDTO.getPSSysDBTableName().toUpperCase();
            if (StringUtils.hasLength((String)strDENameRegEx)) {
                strDEName = strDEName.replaceAll(strDENameRegEx, strDENameRep);
            }
            if ((psDataEntityDTO = (PSDataEntityDTO)psDataEntityDTOMap.get(strDEName)) == null) {
                psDataEntityDTO = new PSDataEntityDTO().psdataentityname(strDEName).detype(PSModelEnums.DEType.MAJOR).logicname(StringUtils.hasLength((String)psSysDBTableDTO.getLogicName()) ? psSysDBTableDTO.getLogicName() : strDEName).existingmodel(Boolean.valueOf(true)).codename(this.toUpperCamel(strDEName)).noviewmode(Boolean.valueOf(true)).tablename(psSysDBTableDTO.getPSSysDBTableName()).storagemode(PSModelEnums.DEStorageType.SQL).psmoduleid(this.getPSModuleDTO()).dslink(this.getPSSysDBSchemeDTO().getDSLink());
                try {
                    psDataEntityDTO = this.getPSDataEntityDTO(psDataEntityDTO);
                    psDataEntityDTOMap.put(strDEName, psDataEntityDTO);
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5efa\u7acb\u5b9e\u4f53[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", psDataEntityDTO.getPSDataEntityName(), ex.getMessage()), ex);
                }
            }
            boolean bHasPKey = false;
            HashMap<String, PSDEFieldDTO> psDEFieldDTOMap = new HashMap<String, PSDEFieldDTO>();
            try {
                List list = PSModelServiceUtils.getInstance().searchAllPSDEFields(new PSDEFieldFilter().psdeid__eq(psDataEntityDTO.getPSDataEntityId()));
                if (!ObjectUtils.isEmpty((Object)list)) {
                    for (PSDEFieldDTO item : list) {
                        psDEFieldDTOMap.put(item.getPSDEFieldName().toUpperCase(), item);
                        if (DataTypeUtils.getIntegerValue((Object)item.getPKey(), (Integer)0) != 1) continue;
                        bHasPKey = true;
                    }
                }
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u67e5\u8be2\u5b9e\u4f53[%1$s]\u5c5e\u6027\u96c6\u5408\u53d1\u751f\u5f02\u5e38\uff0c%2$s", psDataEntityDTO.getPSDataEntityName(), ex.getMessage()), ex);
            }
            List psSysDBColumnDTOList = (List)psSysDBColumnDTOListMap.get(psSysDBTableDTO.getPSSysDBTableId());
            if (ObjectUtils.isEmpty((Object)psSysDBColumnDTOList)) continue;
            for (PSSysDBColumnDTO psSysDBColumnDTO : psSysDBColumnDTOList) {
                PSDEFieldDTO psDEFieldDTO = (PSDEFieldDTO)psDEFieldDTOMap.get(psSysDBColumnDTO.getPSSysDBColumnName().toUpperCase());
                if (psDEFieldDTO != null) continue;
                Integer nStdDataType = psSysDBColumnDTO.getStdDataType();
                if (nStdDataType == null || nStdDataType == 0) {
                    this.updateCurrentPSSysDevBKTask(30000, String.format("\u6570\u636e\u5217[%1$s][%2$s]\u6807\u51c6\u7c7b\u578b[%3$s]\u4e0d\u652f\u6301\uff0c\u5ffd\u7565\u540c\u6b65", psSysDBColumnDTO.getPSSysDBColumnName(), psSysDBColumnDTO.getPSSysDBTableName(), psSysDBColumnDTO.getStdDataType()));
                    continue;
                }
                psDEFieldDTO = new PSDEFieldDTO().psdefieldname(psSysDBColumnDTO.getPSSysDBColumnName()).deftype(PSModelEnums.DEFType.PHISICAL).logicname(StringUtils.hasLength((String)psSysDBColumnDTO.getLogicName()) ? psSysDBColumnDTO.getLogicName() : psSysDBColumnDTO.getPSSysDBColumnName()).codename(this.toUpperCamel(psSysDBColumnDTO.getPSSysDBColumnName())).psdeid(psDataEntityDTO).allowempty(Boolean.valueOf(true));
                int nLength = DataTypeUtils.getIntegerValue((Object)psSysDBColumnDTO.getLength(), (Integer)-1);
                int nPrecision = DataTypeUtils.getIntegerValue((Object)psSysDBColumnDTO.getPrecision2(), (Integer)-1);
                this.fillPSDEField(psDEFieldDTO, nStdDataType, nLength, nPrecision);
                if (!bHasPKey && DataTypeUtils.getIntegerValue((Object)psSysDBColumnDTO.getPKey(), (Integer)0) == 1) {
                    psDEFieldDTO.setPKey(Integer.valueOf(1));
                    psDEFieldDTO.allowempty(Boolean.valueOf(false));
                    bHasPKey = true;
                }
                try {
                    this.fillPSModelDTO((IPSModelDTO)psDEFieldDTO, true);
                    PSModelServiceUtils.getInstance().createPSDEField(psDEFieldDTO);
                    psDEFieldDTOMap.put(psDEFieldDTO.getPSDEFieldName().toUpperCase(), psDEFieldDTO);
                    this.updateCurrentPSSysDevBKTask(20000, String.format("\u65b0\u5efa\u5b9e\u4f53\u5c5e\u6027[%1$s][%2$s]", psDEFieldDTO.getPSDEFieldName(), psDEFieldDTO.getPSDEName()));
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u67e5\u8be2\u5b9e\u4f53\u5c5e\u6027[%1$s][%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", psDEFieldDTO.getPSDEFieldName(), psDEFieldDTO.getPSDEName(), ex.getMessage()), ex);
                }
            }
        }
        return null;
    }

    protected PSSysDBSchemeDTO getPSSysDBSchemeDTO() {
        return this.psSysDBSchemeDTOThreadLocal.get();
    }

    protected void setPSSysDBSchemeDTO(PSSysDBSchemeDTO psSysDBSchemeDTO) {
        this.psSysDBSchemeDTOThreadLocal.set(psSysDBSchemeDTO);
    }

    protected PSSysModelGroupDTO getPSSysModelGroupDTO() {
        return this.psSysModelGroupDTOThreadLocal.get();
    }

    protected void setPSSysModelGroupDTO(PSSysModelGroupDTO psSysModelGroupDTO) {
        this.psSysModelGroupDTOThreadLocal.set(psSysModelGroupDTO);
    }

    protected PSModuleDTO getPSModuleDTO() {
        return this.psModuleDTOThreadLocal.get();
    }

    protected void setPSModuleDTO(PSModuleDTO psModuleDTO) {
        this.psModuleDTOThreadLocal.set(psModuleDTO);
    }

    protected String toUpperCamel(String strCodeName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, strCodeName.toUpperCase());
    }

    protected void fillPSDEField(PSDEFieldDTO psDEField, int nStdDataType, int nLength, int nPrecision) throws Exception {
        switch (nStdDataType) {
            case 1: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.BIGINT.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.BIGINT.text);
                if (nLength <= 0) break;
                psDEField.setLength(Integer.valueOf(nLength));
                break;
            }
            case 3: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.YESNO.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.YESNO.text);
                break;
            }
            case 4: 
            case 11: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.TEXT.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.TEXT.text);
                psDEField.setLength(Integer.valueOf(1));
                break;
            }
            case 5: 
            case 16: 
            case 22: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.DATETIME.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.DATETIME.text);
                break;
            }
            case 27: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.DATE.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.DATE.text);
                break;
            }
            case 28: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.TIME.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.TIME.text);
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 29: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.BIGDECIMAL.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.BIGDECIMAL.text);
                if (nLength >= 0) {
                    psDEField.setLength(Integer.valueOf(nLength));
                }
                if (nPrecision < 0) break;
                psDEField.setPrecision(Integer.valueOf(nPrecision));
                break;
            }
            case 7: 
            case 18: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.FLOAT.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.FLOAT.text);
                if (nLength >= 0) {
                    psDEField.setLength(Integer.valueOf(nLength));
                }
                if (nPrecision < 0) break;
                psDEField.setPrecision(Integer.valueOf(nPrecision));
                break;
            }
            case 9: 
            case 17: 
            case 23: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.INT.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.INT.text);
                if (nLength <= 0) break;
                psDEField.setLength(Integer.valueOf(nLength));
                break;
            }
            case 12: 
            case 21: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.LONGTEXT.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.LONGTEXT.text);
                if (nLength <= 0) break;
                psDEField.setLength(Integer.valueOf(nLength));
                break;
            }
            case 13: 
            case 20: 
            case 25: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.TEXT.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.TEXT.text);
                if (nLength <= 0) break;
                psDEField.setLength(Integer.valueOf(nLength));
                break;
            }
            case 26: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.GUID.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.GUID.text);
                if (nLength <= 0) break;
                psDEField.setLength(Integer.valueOf(nLength));
                break;
            }
            case 2: 
            case 8: 
            case 24: {
                psDEField.setPSDataTypeId(PSModelEnums.DEFDataType.VARBINARY.value);
                psDEField.setPSDataTypeName(PSModelEnums.DEFDataType.VARBINARY.text);
                if (nLength <= 0) break;
                psDEField.setLength(Integer.valueOf(nLength));
                break;
            }
            case 0: 
            case 19: {
                throw new Exception(String.format("\u65e0\u6cd5\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b[%1$s]", DataTypes.toString((int)nStdDataType)));
            }
        }
    }
}

