package net.ibizsys.central.plugin.cs.core.logic;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.KeyValueUtils;
import net.ibizsys.centralstudio.util.LogLevels;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.ZipUtils;

public abstract class PSRTModelExportLogicRuntimeBase extends PSModelImportLogicRuntimeBase implements IPSRTModelExportLogicRuntime{

	private static final Log log = LogFactory.getLog(PSRTModelExportLogicRuntimeBase.class);
	
	
	protected boolean isImportMode() {
		return false;
	}
	
	@Override
	protected Object onExecute(Object[] args, Object logicParam, Object logicParam2) throws Throwable {
		if(isImportMode()) {
			return super.onExecute(args, logicParam, logicParam2);
		}
		throw new Exception("没有实现");
	}
	
	protected Map<String, Object> getPSRTModelParams(IEntity iEntity) throws Throwable {
		
		Map<String, Object> params = new HashMap<String, Object>();
		
		params.put("url",iEntity.get("url"));
		params.put("type",iEntity.get("type"));
		params.put("branch",iEntity.get("branch"));
		params.put("username",iEntity.get("username"));
		params.put("password",iEntity.get("password"));
		
		return params;
	}
	
	
	protected IPSSystemService getPSRTModelService(Map psrtmodelMap) throws Exception {

		String strRTModelUrl = DataTypeUtils.getStringValue(psrtmodelMap.get("url"), null);
		String strType = DataTypeUtils.getStringValue(psrtmodelMap.get("type"), "zip");
		String strBranch = DataTypeUtils.getStringValue(psrtmodelMap.get("branch"), "master");
		String strGitUserName = DataTypeUtils.getStringValue(psrtmodelMap.get("username"), null);
		String strGitPassword = DataTypeUtils.getStringValue(psrtmodelMap.get("password"), null);

		if (!StringUtils.hasLength(strRTModelUrl)) {
			throw new Exception("未指定运行时模型路径");
		}

		// 签出文件
		this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("开始下载运行时模型[%1$s]", strRTModelUrl));
		
		String strPath = null;
		if(RTMODEL_GIT.equals(strType)) {
			strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(), File.separator, KeyValueUtils.genUniqueId());
			File folder = new File(strPath);
			folder.mkdirs();
			try {
				CloneCommand cloneCommand = Git.cloneRepository().setURI(strRTModelUrl).setDirectory(folder).setBranch(strBranch);
				if (StringUtils.hasLength(strGitUserName)) {
					if (StringUtils.hasLength(strGitPassword)) {
						cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
					} else {
						cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, ""));
					}
				}
				cloneCommand.call();
			} catch (Throwable ex) {
				throw new Exception(String.format("获取运行时模型发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		else
			if(RTMODEL_ZIP.equals(strType)) {
				String[] items = strRTModelUrl.split("[#]");
				String url = items[0];
				File tempFile = File.createTempFile("resource", ".zip");
				try {
					this.getSystemRuntime().getDefaultWebClient().download(url, tempFile);
				}
				catch (Throwable ex) {
					throw new Exception(String.format("下载文件发生异常，%1$s", ex.getMessage()), ex);
				}
				
				String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
				File folder = new File(folderPath);
				ZipUtils.unzip(tempFile, folder);
				
				if(items.length == 2 && StringUtils.hasLength(items[1])) {
					folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
				}
				strPath = folder.getAbsolutePath();
			}
			else {
				throw new Exception(String.format("无法识别的运行时模型类型[%1$s]", strType));
			}
		

		
		
		this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("结束下载运行时模型"));
		
		String strModelPath = "";
		File modelFile = new File(String.format("%1$s%2$sibizmodel.yaml", strPath, File.separator));
		if(modelFile.exists()) {
			//从配置文件中提取目录
			try {
				Yaml yaml = new Yaml();
				Map config = yaml.loadAs(new FileInputStream(modelFile) , Map.class);
				if(config != null) {
					String strModelFolder = (String)config.get("modelfolder");
					if(StringUtils.hasLength(strModelFolder)) {
						strModelPath = strPath + File.separator + strModelFolder;
					}
				}
			}
			catch (Throwable ex) {
				throw new Exception(String.format("加载运行时模型配置发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		if(!StringUtils.hasLength(strModelPath)) {
			//未指定直接使用根目录
			strModelPath = strPath;
		}
		
		IPSSystemService iPSSystemService = null;
		try {
			iPSSystemService = this.getPSSystemService(strModelPath);
		}
		catch (Throwable ex) {
			throw new Exception(String.format("加载运行时模型发生异常，%1$s", ex.getMessage()), ex);
		}
		
		return iPSSystemService;
	}
	
	protected IPSSystemService getPSSystemService(String strModelPath) throws Throwable {
		PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
		psModelServiceImpl.setPSModelFolderPath(strModelPath);
		psModelServiceImpl.getPSSystem();
		return psModelServiceImpl;
	}
	
}
