package net.ibizsys.central.plugin.cs.core.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.google.common.base.CaseFormat;

import net.ibizsys.centralstudio.dto.PSDEFieldDTO;
import net.ibizsys.centralstudio.dto.PSDataEntityDTO;
import net.ibizsys.centralstudio.dto.PSModuleDTO;
import net.ibizsys.centralstudio.dto.PSSysDBColumnDTO;
import net.ibizsys.centralstudio.dto.PSSysDBSchemeDTO;
import net.ibizsys.centralstudio.dto.PSSysDBTableDTO;
import net.ibizsys.centralstudio.dto.PSSysModelGroupDTO;
import net.ibizsys.centralstudio.filter.PSDEFieldFilter;
import net.ibizsys.centralstudio.filter.PSDataEntityFilter;
import net.ibizsys.centralstudio.filter.PSSysDBColumnFilter;
import net.ibizsys.centralstudio.filter.PSSysDBSchemeFilter;
import net.ibizsys.centralstudio.filter.PSSysDBTableFilter;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.DataTypes;
import net.ibizsys.centralstudio.util.LogLevels;
import net.ibizsys.centralstudio.util.PSModelServiceUtils;
import net.ibizsys.model.PSModelEnums.DEFDataType;
import net.ibizsys.model.PSModelEnums.DEFType;
import net.ibizsys.model.PSModelEnums.DEStorageType;
import net.ibizsys.model.PSModelEnums.DEType;
import net.ibizsys.model.PSModelEnums.DataSourceLink;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IEntity;

public class DataEntityFromDBSchemaLogicRuntime extends PSModelImportLogicRuntimeBase {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(DataEntityFromDBSchemaLogicRuntime.class);
	
	private ThreadLocal<PSSysDBSchemeDTO> psSysDBSchemeDTOThreadLocal = new ThreadLocal<PSSysDBSchemeDTO>();
	private ThreadLocal<PSSysModelGroupDTO> psSysModelGroupDTOThreadLocal = new ThreadLocal<PSSysModelGroupDTO>();
	private ThreadLocal<PSModuleDTO> psModuleDTOThreadLocal = new ThreadLocal<PSModuleDTO>();

	protected void resetSessionParams() {
		onResetSessionParams();
	}
	
	protected void onResetSessionParams() {
		psSysModelGroupDTOThreadLocal.remove();
		psSysDBSchemeDTOThreadLocal.remove();
		psModuleDTOThreadLocal.remove();
	}
	
	@Override
	protected Object onExecute(Object[] args, Object logicParam, Object logicParam2) throws Throwable {
		resetSessionParams();
		try {
			return super.onExecute(args, logicParam, logicParam2);
		}
		finally {
			resetSessionParams();
		}
	}
	

	@Override
	protected String getPSSysDevBKTaskName(IEntity impParam) {
		return "从数据库体系模型构建实体";
	}
	
	@Override
	protected Object onImportPSModel(IEntity psDevSlnSys, IEntity impParam, Object[] args) throws Throwable {

		if(impParam == null) {
			throw new Exception("未指定数据库体系");
		}

		IEntity psSysDBSchema = impParam;
		
		Map<String, IEntity> paramMap = new HashMap<String, IEntity>();
		for(int i=2; i<args.length; i++) {
			Object item = args[i];
			if(!(item instanceof IEntity)){
				continue;
			}
			
			IEntity iEntity = (IEntity)item;
			
			
			String strType = DataTypeUtils.getStringValue(iEntity.get("_type"), null);
			if(!StringUtils.hasLength(strType)) {
				continue;
			}
			
			paramMap.put(strType.toLowerCase(), iEntity);
		}
		
		
		//导入模型组
		IEntity pssysmodelgroup = paramMap.get("pssysmodelgroup");
		IEntity psmodule = paramMap.get("psmodule");
		IEntity psdataentity = paramMap.get("psdataentity");
		
		if(psmodule == null) {
			psmodule = new Entity();
		}
		
		if(psdataentity == null) {
			psdataentity = new Entity();
		}
		
		String strDSLink = DataTypeUtils.getStringValue(psSysDBSchema.get("dslink"), DataSourceLink.DEFAULT.value);
		
		try {
			List<PSSysDBSchemeDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysDBSchemes(new PSSysDBSchemeFilter());
			if (!ObjectUtils.isEmpty(list)) {
				for (PSSysDBSchemeDTO psSysDBSchemeDTO : list) {
					if(StringUtils.hasLength(psSysDBSchemeDTO.getPSSysModelGroupId())) {
						continue;
					}
					
					if(strDSLink.equalsIgnoreCase(psSysDBSchemeDTO.getDSLink())) {
						this.setPSSysDBSchemeDTO(psSysDBSchemeDTO);
						break;
					}
				}
			}
		}
		catch (Throwable ex) {
			throw new Exception(String.format("查询指定数据库体系发生异常，%1$s", ex.getMessage()));
		}
		
		if(this.getPSSysDBSchemeDTO() == null) {
			throw new Exception(String.format("指定数据源[%1$s]数据库体系不存在", strDSLink));
		}
		
		if(pssysmodelgroup != null) {
			try {
				String strPSSysModelGroupCodeName =  DataTypeUtils.getStringValue(pssysmodelgroup.get("codename"), String.format("DBSchema_%1$s", strDSLink.toLowerCase()));
				PSSysModelGroupDTO psSysModelGroupDTO = new PSSysModelGroupDTO();
				psSysModelGroupDTO.setCodeName(strPSSysModelGroupCodeName);
				psSysModelGroupDTO.setPSSysModelGroupName(String.format("模型组[%1$s]", strPSSysModelGroupCodeName));
				this.setPSSysModelGroupDTO(this.getPSSysModelGroupDTO(psSysModelGroupDTO));
			}
			catch (Throwable ex) {
				throw new Exception(String.format("建立模型组发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		
		//建立系统模块
		try {
			String strPSModuleCodeName =  DataTypeUtils.getStringValue(psmodule.get("codename"), String.format("DBSchema_%1$s", strDSLink.toLowerCase()));
			
			PSModuleDTO psModuleDTO = new PSModuleDTO();
			if(this.getPSSysModelGroupDTO() != null) {
				psModuleDTO.pssysmodelgroupid(this.getPSSysModelGroupDTO());
			}
			psModuleDTO.setCodeName(strPSModuleCodeName);
			psModuleDTO.setPSModuleName(String.format("模块[%1$s]", strPSModuleCodeName));
			this.setPSModuleDTO(this.getPSModuleDTO(psModuleDTO));
		}
		catch (Throwable ex) {
			throw new Exception(String.format("建立系统模块发生异常，%1$s", ex.getMessage()), ex);
		}
		
		//查出数据表
		Map<String, PSSysDBTableDTO> psSysDBTableDTOMap = new HashMap<String, PSSysDBTableDTO>();
		try {
			PSSysDBTableFilter psSysDBTableFilter = new PSSysDBTableFilter()
					.pssysdbschemeid__eq(this.getPSSysDBSchemeDTO().getPSSysDBSchemeId());
			List<PSSysDBTableDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysDBTables(psSysDBTableFilter);
			if(!ObjectUtils.isEmpty(list)) {
				for(PSSysDBTableDTO item : list) {
					psSysDBTableDTOMap.put(item.getPSSysDBTableName().toUpperCase(), item);
				}
			}
		}
		catch (Throwable ex) {
			throw new Exception(String.format("查询数据库体系数据表发生异常，%1$s", ex.getMessage()), ex);
		}
		
		if(ObjectUtils.isEmpty(psSysDBTableDTOMap)) {
			this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("指定数据库体系中未定义数据表，忽略操作"));
			return null;
		}
		
		//查询数据列
		Map<String, List<PSSysDBColumnDTO>> psSysDBColumnDTOListMap = new HashMap<String, List<PSSysDBColumnDTO>>();
		try {
			PSSysDBColumnFilter psSysDBColumnFilter = new PSSysDBColumnFilter()
					.pssysdbschemeid__eq(this.getPSSysDBSchemeDTO().getPSSysDBSchemeId());
			List<PSSysDBColumnDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysDBColumns(psSysDBColumnFilter);
			if(!ObjectUtils.isEmpty(list)) {
				for(PSSysDBColumnDTO item : list) {
					
					List<PSSysDBColumnDTO> psSysDBColumnDTOList = psSysDBColumnDTOListMap.get(item.getPSSysDBTableId());
					if(psSysDBColumnDTOList == null) {
						psSysDBColumnDTOList = new ArrayList<PSSysDBColumnDTO>();
						psSysDBColumnDTOListMap.put(item.getPSSysDBTableId(), psSysDBColumnDTOList);
					}
					
					psSysDBColumnDTOList.add(item);
				}
			}
		}
		catch (Throwable ex) {
			throw new Exception(String.format("查询数据库体系数据列发生异常，%1$s", ex.getMessage()), ex);
		}
		
		
		//查询实体
		Map<String, PSDataEntityDTO> psDataEntityDTOMap = new HashMap<String, PSDataEntityDTO>();
		try {
			PSDataEntityFilter psDataEntityFilter = new PSDataEntityFilter();
			psDataEntityFilter.storagemode__eq(DEStorageType.SQL.value);
			List<PSDataEntityDTO> list = PSModelServiceUtils.getInstance().searchAllPSDataEntities(psDataEntityFilter);
			if(!ObjectUtils.isEmpty(list)) {
				for(PSDataEntityDTO item : list) {
					if(this.getPSSysModelGroupDTO() != null) {
						if(!StringUtils.hasLength(item.getPSSysModelGroupId())) {
							continue;
						}
						
						if(!this.getPSSysModelGroupDTO().getPSSysModelGroupId().equals(item.getPSSysModelGroupId())) {
							continue;
						}
					}
					else {
						if(StringUtils.hasLength(item.getPSSysModelGroupId())) {
							continue;
						}
					}
					
					psDataEntityDTOMap.put(item.getPSDataEntityName().toUpperCase(), item);
				}
			}
		}
		catch (Throwable ex) {
			throw new Exception(String.format("查询全部实体发生异常，%1$s", ex.getMessage()), ex);
		}
		
		//获取实体名称替换格式（正则式）
		String strDENameRep = DataTypeUtils.getStringValue(psdataentity.get("namerep"), "");
		String strDENameRegEx = DataTypeUtils.getStringValue(psdataentity.get("nameregex"), "");
		for(PSSysDBTableDTO psSysDBTableDTO : psSysDBTableDTOMap.values()) {
			
			String strDEName = psSysDBTableDTO.getPSSysDBTableName().toUpperCase();
			if(StringUtils.hasLength(strDENameRegEx)) {
				strDEName = strDEName.replaceAll(strDENameRegEx, strDENameRep);
			}
			
			//判断指定实体是否存在
			PSDataEntityDTO psDataEntityDTO = psDataEntityDTOMap.get(strDEName);
			if(psDataEntityDTO == null) {
				
				psDataEntityDTO = new PSDataEntityDTO()
						.psdataentityname(strDEName)
						.detype(DEType.MAJOR)
						.logicname(StringUtils.hasLength(psSysDBTableDTO.getLogicName())?psSysDBTableDTO.getLogicName():strDEName)
						.existingmodel(true)
						.codename(toUpperCamel(strDEName))
						.noviewmode(true)
						.tablename(psSysDBTableDTO.getPSSysDBTableName())
						.storagemode(DEStorageType.SQL)
						.psmoduleid(getPSModuleDTO())
						.dslink(this.getPSSysDBSchemeDTO().getDSLink());
						
				try {
					psDataEntityDTO = this.getPSDataEntityDTO(psDataEntityDTO);
					psDataEntityDTOMap.put(strDEName, psDataEntityDTO);
				}
				catch (Throwable ex) {
					throw new Exception(String.format("建立实体[%1$s]发生异常，%2$s", psDataEntityDTO.getPSDataEntityName(), ex.getMessage()), ex);
				}
			}
			
			boolean bHasPKey = false;
			//查询实体属性
			Map<String, PSDEFieldDTO> psDEFieldDTOMap = new HashMap<String, PSDEFieldDTO>();
			try {
				List<PSDEFieldDTO> list = PSModelServiceUtils.getInstance().searchAllPSDEFields(new PSDEFieldFilter().psdeid__eq(psDataEntityDTO.getPSDataEntityId()));
				if(!ObjectUtils.isEmpty(list)) {
					for(PSDEFieldDTO item : list ) {
						psDEFieldDTOMap.put(item.getPSDEFieldName().toUpperCase(), item);
						if(DataTypeUtils.getIntegerValue(item.getPKey(), 0) == 1) {
							bHasPKey = true;
						}
					}
				}
			}
			catch (Throwable ex) {
				throw new Exception(String.format("查询实体[%1$s]属性集合发生异常，%2$s", psDataEntityDTO.getPSDataEntityName(), ex.getMessage()), ex);
			}
			
			List<PSSysDBColumnDTO> psSysDBColumnDTOList = psSysDBColumnDTOListMap.get(psSysDBTableDTO.getPSSysDBTableId());
			if(!ObjectUtils.isEmpty(psSysDBColumnDTOList)) {
				for(PSSysDBColumnDTO psSysDBColumnDTO : psSysDBColumnDTOList) {
					PSDEFieldDTO psDEFieldDTO = psDEFieldDTOMap.get(psSysDBColumnDTO.getPSSysDBColumnName().toUpperCase());
					if(psDEFieldDTO != null) {
						continue;
					}
					
					Integer nStdDataType = psSysDBColumnDTO.getStdDataType();
		    		if(nStdDataType == null || nStdDataType == 0) {
		    			this.updateCurrentPSSysDevBKTask(LogLevels.WARN, String.format("数据列[%1$s][%2$s]标准类型[%3$s]不支持，忽略同步", psSysDBColumnDTO.getPSSysDBColumnName(), psSysDBColumnDTO.getPSSysDBTableName(), psSysDBColumnDTO.getStdDataType()));
		    			continue;
		    		}
		    		
		    		
					psDEFieldDTO = new PSDEFieldDTO()
							.psdefieldname(psSysDBColumnDTO.getPSSysDBColumnName())
							.deftype(DEFType.PHISICAL)
							.logicname(StringUtils.hasLength(psSysDBColumnDTO.getLogicName())?psSysDBColumnDTO.getLogicName():psSysDBColumnDTO.getPSSysDBColumnName())
							.codename(toUpperCamel(psSysDBColumnDTO.getPSSysDBColumnName()))
							.psdeid(psDataEntityDTO)
							.allowempty(true);
					
					
					int nLength = DataTypeUtils.getIntegerValue(psSysDBColumnDTO.getLength(), -1);
		    		int nPrecision = DataTypeUtils.getIntegerValue(psSysDBColumnDTO.getPrecision2(), -1);
		    		
		    		fillPSDEField(psDEFieldDTO, nStdDataType, nLength, nPrecision);
		    		if(!bHasPKey && (DataTypeUtils.getIntegerValue(psSysDBColumnDTO.getPKey(),0)==1)) {
		    			psDEFieldDTO.setPKey(1);
		    			psDEFieldDTO.allowempty(false);
		    			bHasPKey = true;
		    		}
					
		    		try {
		    			this.fillPSModelDTO(psDEFieldDTO, true);
		    			PSModelServiceUtils.getInstance().createPSDEField(psDEFieldDTO);
		    			psDEFieldDTOMap.put(psDEFieldDTO.getPSDEFieldName().toUpperCase(), psDEFieldDTO);
		    			
		    			this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("新建实体属性[%1$s][%2$s]", psDEFieldDTO.getPSDEFieldName(), psDEFieldDTO.getPSDEName()));
					}
					catch (Throwable ex) {
						throw new Exception(String.format("查询实体属性[%1$s][%2$s]发生异常，%3$s", psDEFieldDTO.getPSDEFieldName(), psDEFieldDTO.getPSDEName(), ex.getMessage()), ex);
					}	
				}
			}
			
		}
		

		return null;
	}
	
	
	protected PSSysDBSchemeDTO getPSSysDBSchemeDTO() {
		return this.psSysDBSchemeDTOThreadLocal.get();
	}
	
	protected void setPSSysDBSchemeDTO(PSSysDBSchemeDTO psSysDBSchemeDTO) {
		this.psSysDBSchemeDTOThreadLocal.set(psSysDBSchemeDTO);
	}
	
	protected PSSysModelGroupDTO getPSSysModelGroupDTO() {
		return this.psSysModelGroupDTOThreadLocal.get();
	}
	
	protected void setPSSysModelGroupDTO(PSSysModelGroupDTO psSysModelGroupDTO) {
		this.psSysModelGroupDTOThreadLocal.set(psSysModelGroupDTO);
	}
	
	protected PSModuleDTO getPSModuleDTO() {
		return this.psModuleDTOThreadLocal.get();
	}
	
	protected void setPSModuleDTO(PSModuleDTO psModuleDTO) {
		this.psModuleDTOThreadLocal.set(psModuleDTO);
	}
	
	protected String toUpperCamel(String strCodeName) {
		return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, strCodeName.toUpperCase());
	}
	
	/**
	 * 填充属性类型
	 * @param psDEField
	 * @param nStdDataType
	 * @param nLength
	 * @param nPrecision
	 * @throws Exception
	 */
	protected void fillPSDEField(PSDEFieldDTO psDEField,int nStdDataType,int nLength,int nPrecision) throws Exception{
		switch(nStdDataType) {
		case DataTypes.BIGINT:
			psDEField.setPSDataTypeId(DEFDataType.BIGINT.value);
			psDEField.setPSDataTypeName(DEFDataType.BIGINT.text);
			if(nLength>0) {
				psDEField.setLength(nLength);
			}
			break;
		case DataTypes.BIT:
			psDEField.setPSDataTypeId(DEFDataType.YESNO.value);
			psDEField.setPSDataTypeName(DEFDataType.YESNO.text);
			break;
		case DataTypes.CHAR:
		case DataTypes.NCHAR:
			psDEField.setPSDataTypeId(DEFDataType.TEXT.value);
			psDEField.setPSDataTypeName(DEFDataType.TEXT.text);
			psDEField.setLength(1);
			break;
		case DataTypes.DATETIME:
		case DataTypes.SMALLDATETIME:
		case DataTypes.TIMESTAMP:
			psDEField.setPSDataTypeId(DEFDataType.DATETIME.value);
			psDEField.setPSDataTypeName(DEFDataType.DATETIME.text);
			break;
		case DataTypes.DATE:
			psDEField.setPSDataTypeId(DEFDataType.DATE.value);
			psDEField.setPSDataTypeName(DEFDataType.DATE.text);
			break;
		case DataTypes.TIME:
			psDEField.setPSDataTypeId(DEFDataType.TIME.value);
			psDEField.setPSDataTypeName(DEFDataType.TIME.text);
			break;
		case DataTypes.BIGDECIMAL:
		case DataTypes.MONEY:
		case DataTypes.DECIMAL:
		case DataTypes.NUMERIC:
		case DataTypes.REAL:
			psDEField.setPSDataTypeId(DEFDataType.BIGDECIMAL.value);
			psDEField.setPSDataTypeName(DEFDataType.BIGDECIMAL.text);
			if(nLength>=0) {
				psDEField.setLength(nLength);
			}
			if(nPrecision>=0) {
				psDEField.setPrecision(nPrecision);
			}
			break;
		case DataTypes.FLOAT:
		case DataTypes.SMALLMONEY:
			psDEField.setPSDataTypeId(DEFDataType.FLOAT.value);
			psDEField.setPSDataTypeName(DEFDataType.FLOAT.text);
			if(nLength>=0) {
				psDEField.setLength(nLength);
			}
			if(nPrecision>=0) {
				psDEField.setPrecision(nPrecision);
			}
			break;
	
		case DataTypes.INT:
		case DataTypes.SMALLINT:
		case DataTypes.TINYINT:
			psDEField.setPSDataTypeId(DEFDataType.INT.value);
			psDEField.setPSDataTypeName(DEFDataType.INT.text);
			if(nLength>0) {
				psDEField.setLength(nLength);
			}
			break;
		case DataTypes.TEXT:
		case DataTypes.NTEXT:
			psDEField.setPSDataTypeId(DEFDataType.LONGTEXT.value);
			psDEField.setPSDataTypeName(DEFDataType.LONGTEXT.text);
			if(nLength>0) {
				psDEField.setLength(nLength);
			}
			break;
		case DataTypes.VARCHAR:
		case DataTypes.SYSNAME:
		case DataTypes.NVARCHAR:
			psDEField.setPSDataTypeId(DEFDataType.TEXT.value);
			psDEField.setPSDataTypeName(DEFDataType.TEXT.text);
			if(nLength>0) {
				psDEField.setLength(nLength);
			}
			break;	
		case DataTypes.UNIQUEIDENTIFIER:
			psDEField.setPSDataTypeId(DEFDataType.GUID.value);
			psDEField.setPSDataTypeName(DEFDataType.GUID.text);
			if(nLength>0) {
				psDEField.setLength(nLength);
			}
			break;
		case DataTypes.IMAGE:
		case DataTypes.VARBINARY:
		case DataTypes.BINARY:
			psDEField.setPSDataTypeId(DEFDataType.VARBINARY.value);
			psDEField.setPSDataTypeName(DEFDataType.VARBINARY.text);
			if(nLength>0) {
				psDEField.setLength(nLength);
			}
			break;
		case DataTypes.UNKNOWN:
		case DataTypes.SQL_VARIANT:
			throw new Exception(String.format("无法支持的数据类型[%1$s]",DataTypes.toString(nStdDataType)));

		}
		//psDEField.setPSDataTypeName(getName(psDEField.getPSDataTypeId()));
	}
	
}
