package net.ibizsys.central.plugin.cs.core.dataentity.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.centralstudio.dto.PSStudioPluginDataDTO;
import net.ibizsys.centralstudio.util.CentralEnums;
import net.ibizsys.centralstudio.util.CentralServiceUtils;
import net.ibizsys.centralstudio.util.DataTypeUtils;

/**
 * 工具插件数据实体插件行为运行时对象接口基类
 * @author lionlau
 *
 */
public abstract class PSStudioPluginDataPluginActionRuntimeBase extends CentralServiceActionRuntimeBase {

	private static final Log log = LogFactory.getLog(PSStudioPluginDataPluginActionRuntimeBase.class);
	
	@Override
	protected Object onExecute(IEntityDTO iEntityDTO) throws Throwable {
		// TODO Auto-generated method stub
		Object key = iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getName());
		if(ObjectUtils.isEmpty(key)) {
			throw new Exception(String.format("未传入数据主键"));
		}
		PSStudioPluginDataDTO psStudioPluginDataDTO = null;
		try {
			psStudioPluginDataDTO = CentralServiceUtils.getInstance().getPSStudioPluginDataService().get(key.toString());
		}
		catch (Throwable ex) {
			throw new Exception(String.format("获取插件数据发生异常，%1$s", ex.getMessage()), ex);
		}
		
		//判断数据状态
		int nActionState = DataTypeUtils.getIntegerValue(psStudioPluginDataDTO.getActionState(), CentralEnums.BackendActionState.NOTCREATED.value);
		if(nActionState != CentralEnums.BackendActionState.CREATING.value) {
			throw new Exception(String.format("插件数据状态不正确，无法执行"));
		}
		
		return onExecute(psStudioPluginDataDTO);
	}
	
	protected Object onExecute(PSStudioPluginDataDTO psStudioPluginDataDTO) throws Throwable {
		throw new Exception("没有实现");
	}
}
