package net.ibizsys.central.plugin.cs.core.dataentity.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.dataentity.action.DEActionRuntimeBase;
import net.ibizsys.centralstudio.util.CentralServiceSession;

public abstract class CentralServiceActionRuntimeBase extends DEActionRuntimeBase {

	private static final Log log = LogFactory.getLog(CentralServiceActionRuntimeBase.class);
	
	/**
	 * 系统设置：Central 服务路径
	 */
	public final static String SETTING_PARAM_CENTRALSERVICE_URL = "param.centralservice.url";
	
	/**
	 * 系统设置：Central 服务 Bearer
	 */
	public final static String SETTING_PARAM_CENTRALSERVICE_BEARER = "param.centralservice.bearer";
	
	/**
	 * 系统设置：Central 服务 SystemId
	 */
	public final static String SETTING_PARAM_CENTRALSERVICE_SYSTEMID = "param.centralservice.systemid";
	
	/**
	 * 系统设置：Central 服务OrgId
	 */
	public final static String SETTING_PARAM_CENTRALSERVICE_ORGID = "param.centralservice.orgid";
	
	
	private String strCentralServiceUrl = null;
	
	private String strCentralServiceBearer = null;
	
	private String strCentralServiceSystemId = null;
	
	private String strCentralServiceOrgId = null;
	
	
	@Override
	protected void onInit() throws Exception {
		
		if(!StringUtils.hasLength(this.getCentralServiceUrl())) {
			String strCentralServiceUrl = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_URL, null);
			if (!StringUtils.hasLength(strCentralServiceUrl)) {
				throw new Exception("未指定CentralStudio服务路径");
			}
			this.setCentralServiceUrl(strCentralServiceUrl);
		}
		
		if(!StringUtils.hasLength(this.getCentralServiceBearer())) {
			String strCentralServiceBearer = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_BEARER, null);
			this.setCentralServiceBearer(strCentralServiceBearer);
		}
		
		if(!StringUtils.hasLength(this.getCentralServiceSystemId())) {
			String strCentralServiceSystemId = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_SYSTEMID, null);
			this.setCentralServiceSystemId(strCentralServiceSystemId);
		}
		
		if(!StringUtils.hasLength(this.getCentralServiceOrgId())) {
			String strCentralServiceOrgId = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_ORGID, null);
			this.setCentralServiceOrgId(strCentralServiceOrgId);
		}
		
		
		
		super.onInit();
	}
	
	protected String getCentralServiceUrl() {
		return this.strCentralServiceUrl;
	}
	
	protected void setCentralServiceUrl(String strCentralServiceUrl) {
		this.strCentralServiceUrl = strCentralServiceUrl;
	}
	
	protected String getCentralServiceBearer() {
		return this.strCentralServiceBearer;
	}
	
	protected void setCentralServiceBearer(String strCentralServiceBearer) {
		this.strCentralServiceBearer = strCentralServiceBearer;
	}
	
	protected String getCentralServiceSystemId() {
		return this.strCentralServiceSystemId;
	}
	
	protected void setCentralServiceSystemId(String strCentralServiceSystemId) {
		this.strCentralServiceSystemId = strCentralServiceSystemId;
	}
	
	protected String getCentralServiceOrgId() {
		return this.strCentralServiceOrgId;
	}
	
	protected void setCentralServiceOrgId(String strCentralServiceOrgId) {
		this.strCentralServiceOrgId = strCentralServiceOrgId;
	}
	
	@Override
	protected Object onExecute(Object[] args) throws Throwable {
		boolean bOpenSession = false;
		boolean bOommitFlag = true;
		try {
			CentralServiceSession centralServiceSession = CentralServiceSession.getCurrent(true);
			if(centralServiceSession == null) {
				centralServiceSession = openCentralServiceSession();
				bOpenSession = true;
			}
			return super.onExecute(args);
		}
		catch (Throwable ex) {
			bOommitFlag = false;
			throw ex;
		}
		finally {
			if(bOpenSession) {
				CentralServiceSession.close(bOommitFlag);
			}
		}
		
	}
	
	protected CentralServiceSession openCentralServiceSession() throws Exception {
		CentralServiceSession centralServiceSession = CentralServiceSession.open(true);
		centralServiceSession.setServiceUrl(this.getCentralServiceUrl());
		if(StringUtils.hasLength(this.getCentralServiceBearer())) {
			centralServiceSession.setBearer(this.getCentralServiceBearer());
		}
		else {
			centralServiceSession.setBearer(AuthenticationUser.getCurrentMust().getToken());
		}
		if(StringUtils.hasLength(this.getCentralServiceSystemId())) {
			centralServiceSession.setSystemId(this.getCentralServiceSystemId());
		}
		else {
			centralServiceSession.setSystemId(EmployeeContext.getCurrentMust().getSystemid());
		}
		if(StringUtils.hasLength(this.getCentralServiceOrgId())) {
			centralServiceSession.setOrgId(this.getCentralServiceOrgId());
		}
		else {
			centralServiceSession.setOrgId(EmployeeContext.getCurrentMust().getOrgid());
		}
		
		return centralServiceSession;
	}
}
